/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.vmware.identity.websso.client.AuthnData;
import com.vmware.identity.websso.client.LogonProcessorEx;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.RequestCache;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.w3c.dom.Element;

public class LogonProcessorImpl
implements LogonProcessorEx {
    private static final Log _logger = LogFactory.getLog(LogonProcessorImpl.class);
    private final SsoService _ssoService;
    private final SsoServiceManager _ssoServiceManager;
    private final RequestCache _requestCache;
    private final MetadataGenerator _metadataGenerator;
    @Nullable
    private final SsoConfigurationProvider _ssoConfigProvider;
    private String _targetUrl;
    private boolean _useRedirect = false;

    @Autowired
    public LogonProcessorImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, RequestCache requestCache, MetadataGenerator metadataGenerator, SsoConfigurationProvider ssoConfigurationProvider) {
        this._ssoService = ssoService;
        this._ssoServiceManager = ssoServiceManager;
        this._requestCache = requestCache;
        this._metadataGenerator = metadataGenerator;
        this._ssoConfigProvider = ssoConfigurationProvider;
    }

    public String getTargetUrl() {
        return this._targetUrl;
    }

    public void setTargetUrl(String string) {
        this._targetUrl = string;
    }

    public boolean getUseRedirect() {
        return this._useRedirect;
    }

    public void setUseRedirect(boolean bl) {
        this._useRedirect = bl;
    }

    public void authenticationError(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.authenticationError(message, null, null, httpServletRequest, httpServletResponse);
    }

    public void authenticationError(Message message, Locale locale, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = null;
        if (message == null || message.getValidationResult() == null) {
            string2 = Util.getLocalizedString("websso.unknownError", new String[0]);
            this.handleError(httpServletResponse, string2);
            return;
        }
        WebssoUtil.logMessageDetails(message, "authenticationError");
        if (message.getValidationResult().getResponseCode() == 400 && "No authentication request found matching InResponseTo attribute of SAML Response from IDP.".equals(message.getValidationResult().getSubstatus())) {
            string2 = Util.getLocalizedString("websso.inResponseToError", new String[0]);
            httpServletResponse.setHeader("Refresh", "0; URL=/ui/logout");
            this.handleError(httpServletResponse, string2);
            return;
        }
        ValidationResult validationResult = message.getValidationResult();
        if (validationResult.getResponseCode() == 200) {
            string2 = String.format(Util.getLocalizedString("websso.messageServerError", new String[0]), message.getStatus(), message.getSubstatus());
        } else {
            if (WebssoUtil.handleSpecialValidationCases(validationResult, httpServletRequest, _logger)) {
                return;
            }
            string2 = String.format(Util.getLocalizedString("websso.messageDetail", new String[0]), validationResult.getResponseCode(), validationResult.getStatus(), validationResult.getSubstatus());
        }
        _logger.error((Object)string2);
        this.handleError(httpServletResponse, string2);
    }

    public void authenticationSuccess(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.authenticationSuccess(message, null, null, httpServletRequest, httpServletResponse);
    }

    public void authenticationSuccess(Message message, Locale locale, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            ConfigurationManagementService configurationManagementService;
            Object object;
            long l;
            _logger.info((Object)"Websso authentication successful.");
            AuthnData authnData = (AuthnData)message.getMessageData();
            String string2 = message.getSessionIndex();
            String string3 = authnData.getSubjectData().getSubject();
            WebssoUtil.setSessionCookies(httpServletResponse, string3, string2);
            WebssoUtil.setSessionIndex(httpServletRequest, string2);
            String string4 = message.getRelayState();
            if (!StringUtil.isNullOrEmpty((String)string4)) {
                DefaultSavedRequest defaultSavedRequest = this._requestCache.getRequestMap().remove(string4);
                httpServletRequest.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST", (Object)defaultSavedRequest);
            }
            if (this._ssoConfigProvider != null) {
                l = this._ssoConfigProvider.getClockToleranceInSeconds();
            } else {
                object = this._ssoServiceManager.getAdminService(null, SsoDomain.getLocal());
                configurationManagementService = object.getConfigurationManagementService();
                long l2 = configurationManagementService.getClockTolerance();
                l = TimeUnit.MILLISECONDS.toSeconds(l2);
            }
            _logger.info((Object)"Parsing the XML token");
            object = authnData.getToken();
            configurationManagementService = SsoDomain.getLocal();
            SamlToken samlToken = DefaultTokenFactory.createTokenFromDom((Element)object.getDocumentElement(), (X509Certificate[])this._ssoService.getStsCertificates((SsoDomain)configurationManagementService), (long)l);
            httpServletRequest.getSession().setAttribute("webSsoToken", (Object)samlToken);
            String string5 = !StringUtil.isNullOrEmpty((String)this._targetUrl) ? this._targetUrl : "/ngc_spring_security_check";
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string5);
            if (!this._useRedirect && requestDispatcher != null) {
                _logger.info((Object)("Websso handshake done, forwarding to " + string5));
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                String string6 = this._metadataGenerator.getSsoUri();
                String string7 = message.getTarget().replace(string6, string5);
                _logger.info((Object)("Websso handshake done, redirecting to " + string7));
                httpServletResponse.sendRedirect(string7);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when processing the success websso authn message", (Throwable)exception);
            Throwable throwable = ExceptionUtil.unwrap((Throwable)exception);
            this.handleError(httpServletResponse, throwable.getMessage());
        }
    }

    public void internalError(Exception exception, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.internalError(exception, null, null, httpServletRequest, httpServletResponse);
    }

    public void internalError(Exception exception, Locale locale, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        _logger.error((Object)"An internal error occurred when processing response for websso login.", (Throwable)exception);
        this.handleError(httpServletResponse, exception.getMessage(), 500);
    }

    private void handleError(HttpServletResponse httpServletResponse, String string) {
        this.handleError(httpServletResponse, string, 400);
    }

    private void handleError(HttpServletResponse httpServletResponse, String string, int n) {
        try {
            String string2 = String.format(Util.getLocalizedString("websso.assertionError", new String[0]), string);
            httpServletResponse.sendError(n, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

