/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.google.common.base.Preconditions;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.endpoint.SloListener;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.HttpRequestHandler;

public class WebssoLogoutResponseHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(WebssoLogoutResponseHandler.class);
    private final SloListener _sloResponseListener;
    private final MetadataSettings _metadataSettings;
    private final MetadataGenerator _metadataGenerator;

    @Autowired
    public WebssoLogoutResponseHandler(@Nonnull SloListener sloListener, @Nonnull MetadataSettings metadataSettings, @Nonnull MetadataGenerator metadataGenerator) {
        Preconditions.checkArgument((sloListener != null ? 1 : 0) != 0, (Object)"sloResponseListener is null");
        Preconditions.checkArgument((metadataSettings != null ? 1 : 0) != 0, (Object)"metadataSettings is null");
        Preconditions.checkArgument((metadataGenerator != null ? 1 : 0) != 0, (Object)"metadataGenerator is null");
        this._sloResponseListener = sloListener;
        this._metadataSettings = metadataSettings;
        this._metadataGenerator = metadataGenerator;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            boolean bl;
            _logger.info((Object)"Received logout response from WebSSO");
            this._metadataGenerator.processMetadata((ServletRequest)httpServletRequest);
            do {
                String string = WebssoUtil.getSPAlias(httpServletRequest);
                this._sloResponseListener.slo(string, httpServletRequest, httpServletResponse);
                WebssoUtil.WebssoAction webssoAction = WebssoUtil.WebssoAction.getFromRequest(httpServletRequest);
                if (webssoAction == WebssoUtil.WebssoAction.REFRESH_METADATA_AND_RETRY) {
                    _logger.info((Object)"Will refresh the metadata and will retry processing the WebSSO logout response");
                    this._metadataSettings.clear();
                    this._metadataGenerator.processMetadata((ServletRequest)httpServletRequest);
                    WebssoUtil.WebssoAction.REFRESHED_METADATA_AND_RETRYING.setInRequest(httpServletRequest);
                    bl = false;
                    continue;
                }
                bl = true;
            } while (!bl);
        }
        catch (Exception exception) {
            _logger.error((Object)"The handling of the WebSSO logout response failed", (Throwable)exception);
        }
    }
}

