/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.impl.ParamFormatter;
import com.vmware.vim.sso.http.impl.ParamValue;

final class ChunkBuilder {
    private static final char SP = ' ';
    private static final char COMMA = ',';
    private final int maxLength;
    private final StringBuilder sb = new StringBuilder();
    private boolean firstParam = true;

    ChunkBuilder(int maxLength, String prefix) {
        assert (maxLength > 0);
        this.maxLength = maxLength;
        if (prefix != null) {
            this.sb.append(prefix);
        }
    }

    ChunkBuilder(int maxLength) {
        this(maxLength, null);
    }

    ParamValue append(ParamValue param) {
        int valueLength;
        assert (param != null);
        assert (this.sb.length() <= this.maxLength);
        int maxParamLength = this.maxLength - this.sb.length() - (this.firstParam ? 0 : 2);
        int n = valueLength = maxParamLength < 0 ? 0 : ParamFormatter.valueLength(param, maxParamLength);
        assert (valueLength >= 0);
        ParamValue toAppend = param.first(valueLength);
        assert (valueLength != 0 ? toAppend.value().length() == valueLength : toAppend == null);
        if (toAppend != null) {
            if (!this.firstParam) {
                this.sb.append(',');
                this.sb.append(' ');
            }
            ParamFormatter.format(toAppend, this.sb);
        }
        this.firstParam = false;
        return param.ltrim(valueLength);
    }

    String value() {
        return this.sb.toString();
    }
}

