/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.impl.TokenFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class GZipJ2SECompress
implements TokenFormatter.Compress {
    private static final int AVERAGE_COMPRESSION_FACTOR = 2;

    GZipJ2SECompress() {
    }

    @Override
    public byte[] compress(byte[] rawData) {
        assert (rawData != null);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(rawData.length / 2);
        try {
            this.compressInt(rawData, buf);
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)("Problem compressing data: " + e));
        }
        return buf.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] comressedData) {
        assert (comressedData != null);
        ByteArrayInputStream buf = new ByteArrayInputStream(comressedData);
        try {
            return this.decompressInt(comressedData, buf);
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)("Problem decompressing data: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressInt(byte[] rawData, ByteArrayOutputStream buf) throws IOException {
        GZIPOutputStream compressedOut = new GZIPOutputStream(buf);
        try {
            ((OutputStream)compressedOut).write(rawData);
        }
        finally {
            ((OutputStream)compressedOut).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decompressInt(byte[] comressedData, ByteArrayInputStream buf) throws IOException {
        byte[] result = new byte[comressedData.length * 2];
        GZIPInputStream decompressedIn = new GZIPInputStream(buf);
        try {
            int offset = 0;
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)decompressedIn).read(result, offset, result.length - offset)) != -1) {
                if ((offset += bytesRead) != result.length) continue;
                result = Arrays.copyOf(result, result.length << 1);
            }
            result = Arrays.copyOf(result, offset);
        }
        finally {
            ((InputStream)decompressedIn).close();
        }
        return result;
    }
}

