/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.http.AuthException;
import com.vmware.vim.sso.http.impl.Nonce;
import com.vmware.vim.sso.http.impl.PrincipalIdComparator;
import java.util.Comparator;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

final class Requests {
    private final long _clockToleranceMs;
    private final long _maxRequestAgeMs;
    private final SortedSet<RequestId> _lastIds;
    private final Comparator<PrincipalId> _principalIdComparator = new PrincipalIdComparator();

    Requests(int clockToleranceSec, int maxRequestAgeSec) {
        assert (clockToleranceSec >= 0);
        assert (maxRequestAgeSec >= 0);
        this._clockToleranceMs = Requests.toMillis(clockToleranceSec);
        this._maxRequestAgeMs = Requests.toMillis(maxRequestAgeSec);
        this._lastIds = new TreeSet<RequestId>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNewRequest(PrincipalId principalId, Nonce nonce) {
        assert (nonce != null);
        assert (principalId != null);
        RequestId reqId = new RequestId(principalId, nonce);
        RequestId notPreviousThan = this.firstAt(new Date(System.currentTimeMillis() - this._maxRequestAgeMs - this._clockToleranceMs));
        if (reqId.compareTo(notPreviousThan) < 0) {
            throw new AuthException("The request is quite old!");
        }
        SortedSet<RequestId> sortedSet = this._lastIds;
        synchronized (sortedSet) {
            this.purgeOlder(notPreviousThan);
            if (this._lastIds.contains(reqId)) {
                throw new AuthException("The nonce value is not unique for this principal! This might indicate for an replay attack!");
            }
            this._lastIds.add(reqId);
        }
    }

    private void purgeOlder(RequestId notPreviousThan) {
        SortedSet<RequestId> old = this._lastIds.headSet(notPreviousThan);
        old.clear();
    }

    private RequestId firstAt(Date createdOn) {
        Nonce notOlderThan = Nonce.firstAt(createdOn);
        return new RequestId(notOlderThan);
    }

    private static long toMillis(int secs) {
        return TimeUnit.SECONDS.toMillis(secs);
    }

    final class RequestId
    implements Comparable<RequestId> {
        private final PrincipalId _principalId;
        private final Nonce _nonce;

        RequestId(PrincipalId principalId, Nonce nonce) {
            assert (nonce != null);
            this._principalId = principalId;
            this._nonce = nonce;
        }

        RequestId(Nonce nonce) {
            this(null, nonce);
        }

        @Override
        public int compareTo(RequestId o) {
            int nonceResult = this._nonce.compareTo(o._nonce);
            return nonceResult != 0 ? nonceResult : (this._principalId == null ? (o._principalId == null ? 0 : -1) : (o._principalId == null ? 1 : Requests.this._principalIdComparator.compare(this._principalId, o._principalId)));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            boolean result = false;
            if (obj instanceof RequestId) {
                RequestId o = (RequestId)obj;
                result = this._nonce.equals(o._nonce) && (this._principalId != null ? this._principalId.equals((Object)o._principalId) : o._principalId == null);
            }
            return result;
        }

        public int hashCode() {
            return (this._principalId != null ? this._principalId.hashCode() * 31 : 0) + this._nonce.hashCode();
        }
    }
}

