/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client;

import com.vmware.cis.license.common.domain.FeatureUtil;
import com.vmware.cis.license.common.domain.RestrictionUtil;
import com.vmware.cis.license.common.domain.SubscriptionUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.CostUnit;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.Feature;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseProductCapability;
import com.vmware.vim.binding.cis.license.LicenseProductRestriction;
import com.vmware.vim.binding.cis.license.Product;
import com.vmware.vim.binding.cis.license.management.AssetUpdateSpec;
import com.vmware.vim.binding.cis.license.management.FeatureUsage;
import com.vmware.vim.binding.impl.cis.license.CostUnitImpl;
import com.vmware.vim.binding.impl.cis.license.CostUnitUsageImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetUpdateSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.FeatureUsageImpl;
import java.util.Calendar;
import java.util.Date;

public class LicenseUtil {
    public static final String ASSET_MNGMT_SVC_MO_REF_TYPE = "CisLicenseManagementAssetManagementService";
    public static final String ASSET_MNGMT_SVC_MO_REF_ID = "cis.license.management.AssetManagementService";
    public static final String SYSTEM_MNGMT_SVC_MO_REF_TYPE = "CisLicenseManagementSystemManagementService";
    public static final String SYSTEM_MNGMT_SVC_MO_REF_ID = "cis.license.management.SystemManagementService";
    public static final String REPORT_SVC_MO_REF_TYPE = "CisLicenseReportReportService";
    public static final String REPORT_SVC_MO_REF_ID = "cis.license.report.ReportService";
    public static final String SESSION_MNGMT_SVC_MO_REF_TYPE = "CisLicenseSessionManagementService";
    public static final String SESSION_MNGMT_SVC_MO_REF_ID = "cis.license.SessionManagementService";

    public static boolean isFeatureAvailable(Asset asset, Feature feature) {
        return LicenseUtil.isFeatureAvailable(asset, feature.getId());
    }

    public static boolean isFeatureAvailable(Asset asset, String featureId) {
        if (asset == null) {
            return false;
        }
        LicenseProductCapability assetProductCapability = LicenseUtil.getLicenseProductCapability(asset);
        if (assetProductCapability == null) {
            return false;
        }
        if (LicenseUtil.hasExpired(asset) && !SubscriptionUtil.isSubscriptionLicenseAssignedToAsset((Asset)asset)) {
            return false;
        }
        return FeatureUtil.isFeatureSupported((String)featureId, (String[])FeatureUtil.getFeatureIds((Feature[])assetProductCapability.getFeatures()));
    }

    public static Feature[] getAllAvailableFeatures(Asset asset) {
        Feature[] emptyFeatures = new Feature[]{};
        if (asset == null) {
            return emptyFeatures;
        }
        LicenseProductCapability assetProductCapability = LicenseUtil.getLicenseProductCapability(asset);
        if (assetProductCapability == null) {
            return emptyFeatures;
        }
        Feature[] originalFeatures = assetProductCapability.getFeatures();
        if (originalFeatures == null) {
            return emptyFeatures;
        }
        if (LicenseUtil.hasExpired(asset) && !SubscriptionUtil.isSubscriptionLicenseAssignedToAsset((Asset)asset)) {
            return emptyFeatures;
        }
        return (Feature[])originalFeatures.clone();
    }

    public static boolean isAssetAssignedLicense(Asset asset) {
        if (asset == null) {
            return false;
        }
        return asset.getInfo().getLicense() != null;
    }

    public static boolean isAssetAssignedEvalLicense(Asset asset) {
        if (asset == null) {
            return false;
        }
        return asset.getInfo().isInEvaluation();
    }

    public static String getLicenseEdition(Asset asset) {
        if (asset == null) {
            return null;
        }
        Product assetProduct = asset.getInfo().getProduct();
        if (assetProduct == null) {
            return null;
        }
        return assetProduct.getEditionKey();
    }

    public static Calendar getLicenseExpiration(Asset asset) {
        assert (LicenseUtil.isAssetAssignedLicense(asset));
        License assetLicense = asset.getInfo().getLicense();
        Calendar licenseExpiration = assetLicense.getInfo().getExpiration();
        if (licenseExpiration == null) {
            return null;
        }
        return (Calendar)licenseExpiration.clone();
    }

    public static CostUnitLimit[] getCostUnitLimits(Asset asset) {
        if (asset == null) {
            return null;
        }
        LicenseProductRestriction assetLicenseRestriction = LicenseUtil.getLicenseProductRestriction(asset);
        if (assetLicenseRestriction == null) {
            return null;
        }
        CostUnitLimit[] originalLimit = assetLicenseRestriction.getCostUnitsLimit();
        if (originalLimit == null) {
            return null;
        }
        return (CostUnitLimit[])originalLimit.clone();
    }

    public static boolean isLicenseRestrictedCostUnit(Asset asset, String costUnitId) {
        if (asset == null) {
            return false;
        }
        CostUnitLimit[] costUnits = LicenseUtil.getCostUnitLimits(asset);
        if (costUnits != null) {
            for (CostUnitLimit costUnit : costUnits) {
                if (!costUnit.getUnit().getId().equals(costUnitId)) continue;
                return true;
            }
        }
        return false;
    }

    public static LicenseProductRestriction getLicenseProductRestriction(Asset asset) {
        return RestrictionUtil.getLicenseProductRestriction((Asset)asset);
    }

    public static LicenseProductCapability getLicenseProductCapability(Asset asset) {
        return RestrictionUtil.getLicenseProductCapability((Asset)asset);
    }

    public static AssetUpdateSpec buildSpecToSetFeaturesInUse(String ... featureIds) {
        Feature[] features = null;
        if (featureIds != null) {
            features = new Feature[featureIds.length];
            for (int i = 0; i < featureIds.length; ++i) {
                features[i] = FeatureUtil.buildFeature((String)featureIds[i]);
            }
        }
        return LicenseUtil.buildSpecToSetFeaturesInUse(features);
    }

    public static AssetUpdateSpec buildSpecToSetFeaturesInUse(Feature ... features) {
        AssetUpdateSpecImpl spec = new AssetUpdateSpecImpl();
        if (features == null || features.length == 0) {
            spec.setClearFeaturesInUse(Boolean.valueOf(true));
        } else {
            FeatureUsageImpl[] featuresUsage = new FeatureUsageImpl[features.length];
            for (int i = 0; i < features.length; ++i) {
                featuresUsage[i] = new FeatureUsageImpl(features[i], true);
            }
            spec.setFeaturesUsage((FeatureUsage[])featuresUsage);
        }
        return spec;
    }

    public static AssetUpdateSpec buildSpecToClearAllFeaturesInUse() {
        AssetUpdateSpecImpl spec = new AssetUpdateSpecImpl();
        spec.setClearFeaturesInUse(Boolean.valueOf(true));
        return spec;
    }

    public static AssetUpdateSpec buildSpecToUpdateCostUnitUsage(String costUnitId, long usage) {
        return LicenseUtil.buildSpecToUpdateCostUnitUsage((CostUnit)new CostUnitImpl(costUnitId), usage);
    }

    public static AssetUpdateSpec buildSpecToUpdateCostUnitUsage(CostUnit costUnit, long usage) {
        return LicenseUtil.buildSpecToUpdateCostUnitsUsage(new CostUnitUsage[]{new CostUnitUsageImpl(costUnit, usage)});
    }

    public static AssetUpdateSpec buildSpecToUpdateCostUnitsUsage(CostUnitUsage ... usage) {
        AssetUpdateSpecImpl spec = new AssetUpdateSpecImpl();
        spec.setCostUnitsUsage(usage);
        return spec;
    }

    private static boolean hasExpired(Asset asset) {
        if (asset == null) {
            return false;
        }
        Calendar expiryDate = LicenseUtil.getLicenseExpiration(asset);
        if (expiryDate != null) {
            Date today = new Date();
            return expiryDate.getTime().before(today);
        }
        return false;
    }
}

