/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.cis.license.client.impl.LicenseClientImpl;
import com.vmware.cis.license.client.vmomi.VmodlContextLoader;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import java.net.URI;
import java.util.concurrent.Executor;

public class LicenseClientFactoryImpl
implements LicenseClientFactory {
    private final Class<?> _versionClass;
    private final String _vmodlPackage;
    private final Executor _threadPool;
    private LicenseClientFactory.LicenseClientAutomaticAuthenticator _clientAuthenticator;
    private InvocationInterceptor _invocationInterceptor;
    private ResultInterceptor _resultInterceptor;

    public LicenseClientFactoryImpl(Class<?> versionClass, String vmodlPackage, Executor threadPool) {
        this._versionClass = versionClass;
        this._vmodlPackage = vmodlPackage;
        this._threadPool = threadPool;
    }

    public void setClientAuthenticator(LicenseClientFactory.LicenseClientAutomaticAuthenticator clientAuthenticator) {
        this._clientAuthenticator = clientAuthenticator;
    }

    public void setInvocationInterceptor(InvocationInterceptor invocationInterceptor) {
        this._invocationInterceptor = invocationInterceptor;
    }

    public void setResultInterceptor(ResultInterceptor resultInterceptor) {
        this._resultInterceptor = resultInterceptor;
    }

    public void initVmodl() {
        VmodlContextLoader.initContext(new String[]{this._vmodlPackage});
    }

    @Override
    public final LicenseClient createClient(URI licenseUri, HttpConfiguration httpConfig) {
        LicenseClientImpl client = new LicenseClientImpl(this._versionClass, this._threadPool, licenseUri, httpConfig, this._clientAuthenticator, this._invocationInterceptor, this._resultInterceptor);
        return client;
    }

    @Override
    public LicenseClient createClient(ServerEndpointProvider licenseUriProvider, HttpConfiguration httpConfig) {
        LicenseClientImpl client = new LicenseClientImpl(this._versionClass, this._threadPool, licenseUriProvider, httpConfig, this._clientAuthenticator, this._invocationInterceptor, this._resultInterceptor);
        return client;
    }
}

