/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item.downloadsession;

import com.vmware.content.library.item.FileTypes;
import com.vmware.content.library.item.TransferEndpoint;
import com.vmware.content.library.item.downloadsession.FileDefinitions;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.std.LocalizableMessage;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public interface FileTypes {

    public static final class Info
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String name;
        private Long size;
        private long bytesTransferred;
        private PrepareStatus status;
        private TransferEndpoint downloadEndpoint;
        private FileTypes.ChecksumInfo checksumInfo;
        private LocalizableMessage errorMessage;
        protected final StructValue __dynamicStructureFields;

        public Info() {
            this(Info.createEmptyStructValue());
        }

        protected Info(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long l) {
            this.size = l;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public void setBytesTransferred(long l) {
            this.bytesTransferred = l;
        }

        public PrepareStatus getStatus() {
            return this.status;
        }

        public void setStatus(PrepareStatus prepareStatus) {
            this.status = prepareStatus;
        }

        public TransferEndpoint getDownloadEndpoint() {
            return this.downloadEndpoint;
        }

        public void setDownloadEndpoint(TransferEndpoint transferEndpoint) {
            this.downloadEndpoint = transferEndpoint;
        }

        public FileTypes.ChecksumInfo getChecksumInfo() {
            return this.checksumInfo;
        }

        public void setChecksumInfo(FileTypes.ChecksumInfo checksumInfo) {
            this.checksumInfo = checksumInfo;
        }

        public LocalizableMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(LocalizableMessage localizableMessage) {
            this.errorMessage = localizableMessage;
        }

        public StructType _getType() {
            return FileDefinitions.info;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("name", BindingsUtil.toDataValue((Object)this.name, (Type)this._getType().getField("name")));
            structValue.setField("size", BindingsUtil.toDataValue((Object)this.size, (Type)this._getType().getField("size")));
            structValue.setField("bytes_transferred", BindingsUtil.toDataValue((Object)this.bytesTransferred, (Type)this._getType().getField("bytes_transferred")));
            structValue.setField("status", BindingsUtil.toDataValue((Object)((Object)this.status), (Type)this._getType().getField("status")));
            structValue.setField("download_endpoint", BindingsUtil.toDataValue((Object)this.downloadEndpoint, (Type)this._getType().getField("download_endpoint")));
            structValue.setField("checksum_info", BindingsUtil.toDataValue((Object)this.checksumInfo, (Type)this._getType().getField("checksum_info")));
            structValue.setField("error_message", BindingsUtil.toDataValue((Object)this.errorMessage, (Type)this._getType().getField("error_message")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return FileDefinitions.info;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return Info._getClassType().getName();
        }

        public static Info _newInstance(StructValue structValue) {
            return new Info(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(FileDefinitions.info.getName());
        }

        public static final class Builder {
            private String name;
            private Long size;
            private long bytesTransferred;
            private PrepareStatus status;
            private TransferEndpoint downloadEndpoint;
            private FileTypes.ChecksumInfo checksumInfo;
            private LocalizableMessage errorMessage;

            public Builder(String string, long l, PrepareStatus prepareStatus) {
                this.name = string;
                this.bytesTransferred = l;
                this.status = prepareStatus;
            }

            public Builder setSize(Long l) {
                this.size = l;
                return this;
            }

            public Builder setDownloadEndpoint(TransferEndpoint transferEndpoint) {
                this.downloadEndpoint = transferEndpoint;
                return this;
            }

            public Builder setChecksumInfo(FileTypes.ChecksumInfo checksumInfo) {
                this.checksumInfo = checksumInfo;
                return this;
            }

            public Builder setErrorMessage(LocalizableMessage localizableMessage) {
                this.errorMessage = localizableMessage;
                return this;
            }

            public Info build() {
                Info info = new Info();
                info.setName(this.name);
                info.setSize(this.size);
                info.setBytesTransferred(this.bytesTransferred);
                info.setStatus(this.status);
                info.setDownloadEndpoint(this.downloadEndpoint);
                info.setChecksumInfo(this.checksumInfo);
                info.setErrorMessage(this.errorMessage);
                return info;
            }
        }
    }

    public static final class EndpointType
    extends ApiEnumeration<EndpointType> {
        public static final EndpointType HTTPS = new EndpointType("HTTPS");
        public static final EndpointType DIRECT = new EndpointType("DIRECT");
        private static final long serialVersionUID = 1L;
        private static final EndpointType[] $VALUES = new EndpointType[]{HTTPS, DIRECT};
        private static final Map<String, EndpointType> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private EndpointType() {
            super(Values._UNKNOWN.name());
        }

        private EndpointType(String string) {
            super(string);
        }

        public static EndpointType[] values() {
            return (EndpointType[])$VALUES.clone();
        }

        public static EndpointType valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            EndpointType endpointType = $NAME_TO_VALUE_MAP.get(string);
            if (endpointType != null) {
                return endpointType;
            }
            return new EndpointType(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return EndpointType.valueOf(this.name());
        }

        public static enum Values {
            HTTPS,
            DIRECT,
            _UNKNOWN;

        }
    }

    public static final class PrepareStatus
    extends ApiEnumeration<PrepareStatus> {
        public static final PrepareStatus UNPREPARED = new PrepareStatus("UNPREPARED");
        public static final PrepareStatus PREPARE_REQUESTED = new PrepareStatus("PREPARE_REQUESTED");
        public static final PrepareStatus PREPARING = new PrepareStatus("PREPARING");
        public static final PrepareStatus PREPARED = new PrepareStatus("PREPARED");
        public static final PrepareStatus ERROR = new PrepareStatus("ERROR");
        private static final long serialVersionUID = 1L;
        private static final PrepareStatus[] $VALUES = new PrepareStatus[]{UNPREPARED, PREPARE_REQUESTED, PREPARING, PREPARED, ERROR};
        private static final Map<String, PrepareStatus> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

        private PrepareStatus() {
            super(Values._UNKNOWN.name());
        }

        private PrepareStatus(String string) {
            super(string);
        }

        public static PrepareStatus[] values() {
            return (PrepareStatus[])$VALUES.clone();
        }

        public static PrepareStatus valueOf(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            PrepareStatus prepareStatus = $NAME_TO_VALUE_MAP.get(string);
            if (prepareStatus != null) {
                return prepareStatus;
            }
            return new PrepareStatus(string);
        }

        public boolean isUnknown() {
            return this.getEnumValue() == Values._UNKNOWN;
        }

        public Values getEnumValue() {
            try {
                return Values.valueOf(this.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Values._UNKNOWN;
            }
        }

        private Object readResolve() {
            return PrepareStatus.valueOf(this.name());
        }

        public static enum Values {
            UNPREPARED,
            PREPARE_REQUESTED,
            PREPARING,
            PREPARED,
            ERROR,
            _UNKNOWN;

        }
    }
}

