/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.ImportSpec;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.ResourceConfigOption;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.ConcurrentAccess;
import com.vmware.vim.binding.vim.fault.DuplicateName;
import com.vmware.vim.binding.vim.fault.FileFault;
import com.vmware.vim.binding.vim.fault.InsufficientResourcesFault;
import com.vmware.vim.binding.vim.fault.InvalidDatastore;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.fault.OutOfBounds;
import com.vmware.vim.binding.vim.fault.VmConfigFault;
import com.vmware.vim.binding.vim.vApp.VAppConfigSpec;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version6;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.silent;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="ResourcePool")
public interface ResourcePool
extends ManagedEntity {
    @readonly
    @name(value="summary")
    @versionClass(value=version2.class)
    public void getSummary(Future<Summary> var1);

    @name(value="summary")
    public Summary getSummary();

    @readonly
    @name(value="runtime")
    @versionClass(value=version2.class)
    public void getRuntime(Future<RuntimeInfo> var1);

    @name(value="runtime")
    public RuntimeInfo getRuntime();

    @readonly
    @name(value="owner")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @managedObjectType(value="com.vmware.vim.binding.vim.ComputeResource")
    public void getOwner(@managedObjectType(value="com.vmware.vim.binding.vim.ComputeResource") Future<ManagedObjectReference> var1);

    @name(value="owner")
    public ManagedObjectReference getOwner();

    @readonly
    @name(value="resourcePool")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool")
    @map
    public void getResourcePool(@optional @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") Future<ManagedObjectReference[]> var1);

    @name(value="resourcePool")
    public ManagedObjectReference[] getResourcePool();

    @readonly
    @name(value="vm")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine")
    @map
    public void getVm(@optional @managedObjectType(value="com.vmware.vim.binding.vim.VirtualMachine") Future<ManagedObjectReference[]> var1);

    @name(value="vm")
    public ManagedObjectReference[] getVm();

    @readonly
    @name(value="config")
    @versionClass(value=version2.class)
    public void getConfig(Future<ResourceConfigSpec> var1);

    @name(value="config")
    public ResourceConfigSpec getConfig();

    @readonly
    @name(value="childConfiguration")
    @versionClass(value=version2.class)
    @optional
    @list
    public void getChildConfiguration(@optional Future<ResourceConfigSpec[]> var1);

    @name(value="childConfiguration")
    public ResourceConfigSpec[] getChildConfiguration();

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateConfig")
    @privilege(value="dynamic")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault", "ConcurrentAccess"})
    public void updateConfig(@name(value="name") @versionClass(value=version2.class) @optional String var1, @name(value="config") @versionClass(value=version2.class) @optional ResourceConfigSpec var2, Future<Void> var3);

    @wsdlName(value="UpdateConfig")
    public void updateConfig(String var1, ResourceConfigSpec var2) throws InvalidName, DuplicateName, InsufficientResourcesFault, ConcurrentAccess;

    @versionClass(value=version2.class)
    @wsdlName(value="MoveIntoResourcePool")
    @privilege(value="dynamic")
    @faults(value={"DuplicateName", "InsufficientResourcesFault"})
    public void moveInto(@name(value="list") @versionClass(value=version2.class) @managedObjectType(value="com.vmware.vim.binding.vim.ManagedEntity") @map ManagedObjectReference[] var1, Future<Void> var2);

    @wsdlName(value="MoveIntoResourcePool")
    public void moveInto(ManagedObjectReference[] var1) throws DuplicateName, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateChildResourceConfiguration")
    @privilege(value="dynamic")
    @faults(value={"InvalidState", "InsufficientResourcesFault"})
    public void updateChildResourceConfiguration(@name(value="spec") @versionClass(value=version2.class) @list ResourceConfigSpec[] var1, Future<Void> var2);

    @wsdlName(value="UpdateChildResourceConfiguration")
    public void updateChildResourceConfiguration(ResourceConfigSpec[] var1) throws InvalidState, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="CreateResourcePool")
    @privilege(value="Resource.CreatePool")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault"})
    public void createResourcePool(@name(value="name") @versionClass(value=version2.class) String var1, @name(value="spec") @versionClass(value=version2.class) ResourceConfigSpec var2, @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool") Future<ManagedObjectReference> var3);

    @wsdlName(value="CreateResourcePool")
    @managedObjectType(value="com.vmware.vim.binding.vim.ResourcePool")
    public ManagedObjectReference createResourcePool(String var1, ResourceConfigSpec var2) throws InvalidName, DuplicateName, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="DestroyChildren")
    @privilege(value="dynamic")
    public void destroyChildren(Future<Void> var1);

    @wsdlName(value="DestroyChildren")
    public void destroyChildren();

    @versionClass(value=version5.class)
    @wsdlName(value="CreateVApp")
    @privilege(value="VApp.Create")
    @faults(value={"InvalidName", "DuplicateName", "InsufficientResourcesFault", "InvalidState", "VmConfigFault"})
    public void createVApp(@name(value="name") @versionClass(value=version5.class) String var1, @name(value="resSpec") @versionClass(value=version5.class) ResourceConfigSpec var2, @name(value="configSpec") @versionClass(value=version5.class) VAppConfigSpec var3, @name(value="vmFolder") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Folder") ManagedObjectReference var4, @managedObjectType(value="com.vmware.vim.binding.vim.VirtualApp") Future<ManagedObjectReference> var5);

    @wsdlName(value="CreateVApp")
    @managedObjectType(value="com.vmware.vim.binding.vim.VirtualApp")
    public ManagedObjectReference createVApp(String var1, ResourceConfigSpec var2, VAppConfigSpec var3, ManagedObjectReference var4) throws InvalidName, DuplicateName, InsufficientResourcesFault, InvalidState, VmConfigFault;

    @versionClass(value=version5.class)
    @wsdlName(value="CreateChildVM_Task")
    @privilege(value="VirtualMachine.Inventory.Create")
    @task
    @faults(value={"VmConfigFault", "FileFault", "OutOfBounds", "InvalidName", "InvalidDatastore", "InsufficientResourcesFault"})
    public void createVm(@name(value="config") @versionClass(value=version5.class) ConfigSpec var1, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @wsdlName(value="CreateChildVM_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference createVm(ConfigSpec var1, ManagedObjectReference var2) throws VmConfigFault, FileFault, OutOfBounds, InvalidName, InvalidDatastore, InsufficientResourcesFault;

    @versionClass(value=version5.class)
    @wsdlName(value="RegisterChildVM_Task")
    @privilege(value="VirtualMachine.Inventory.Register")
    @task
    @faults(value={"OutOfBounds", "AlreadyExists", "InvalidDatastore", "NotFound", "InvalidName", "VmConfigFault", "InsufficientResourcesFault", "FileFault"})
    public void registerVm(@name(value="path") @versionClass(value=version5.class) String var1, @name(value="name") @versionClass(value=version5.class) @optional String var2, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var4);

    @wsdlName(value="RegisterChildVM_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference registerVm(String var1, String var2, ManagedObjectReference var3) throws OutOfBounds, AlreadyExists, InvalidDatastore, NotFound, InvalidName, VmConfigFault, InsufficientResourcesFault, FileFault;

    @versionClass(value=version5.class)
    @wsdlName(value="ImportVApp")
    @privilege(value="VApp.Import")
    @faults(value={"VmConfigFault", "FileFault", "OutOfBounds", "DuplicateName", "InvalidName", "InvalidDatastore", "InsufficientResourcesFault"})
    public void importVApp(@name(value="spec") @versionClass(value=version5.class) ImportSpec var1, @name(value="folder") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Folder") @privilege(value="VApp.Import") ManagedObjectReference var2, @name(value="host") @versionClass(value=version5.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var3, @managedObjectType(value="com.vmware.vim.binding.vim.HttpNfcLease") Future<ManagedObjectReference> var4);

    @wsdlName(value="ImportVApp")
    @managedObjectType(value="com.vmware.vim.binding.vim.HttpNfcLease")
    public ManagedObjectReference importVApp(ImportSpec var1, ManagedObjectReference var2, ManagedObjectReference var3) throws VmConfigFault, FileFault, OutOfBounds, DuplicateName, InvalidName, InvalidDatastore, InsufficientResourcesFault;

    @versionClass(value=version6.class)
    @wsdlName(value="QueryResourceConfigOption")
    @privilege(value="Resource.EditPool")
    @Deprecated
    public void queryResourceConfigOption(Future<ResourceConfigOption> var1);

    @wsdlName(value="QueryResourceConfigOption")
    @Deprecated
    public ResourceConfigOption queryResourceConfigOption();

    @versionClass(value=version6.class)
    @wsdlName(value="RefreshRuntime")
    @privilege(value="System.View")
    public void refreshRuntime(Future<Void> var1);

    @wsdlName(value="RefreshRuntime")
    public void refreshRuntime();

    @versionClass(value=version2.class)
    @wsdlName(value="ResourcePoolSummary")
    @data
    @propertyOrder(value={"name", "config", "runtime", "quickStats", "configuredMemoryMB"})
    public static class Summary
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public ResourceConfigSpec config;
        public RuntimeInfo runtime;
        public QuickStats quickStats;
        public Integer configuredMemoryMB;

        public Summary() {
        }

        public Summary(String string, ResourceConfigSpec resourceConfigSpec, RuntimeInfo runtimeInfo, QuickStats quickStats, Integer n) {
            this.name = string;
            this.config = resourceConfigSpec;
            this.runtime = runtimeInfo;
            this.quickStats = quickStats;
            this.configuredMemoryMB = n;
        }

        @versionClass(value=version2.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version2.class)
        public void setName(String string) {
            this.name = string;
        }

        @versionClass(value=version2.class)
        public ResourceConfigSpec getConfig() {
            return this.config;
        }

        @versionClass(value=version2.class)
        public void setConfig(ResourceConfigSpec resourceConfigSpec) {
            this.config = resourceConfigSpec;
        }

        @versionClass(value=version2.class)
        public RuntimeInfo getRuntime() {
            return this.runtime;
        }

        @versionClass(value=version2.class)
        public void setRuntime(RuntimeInfo runtimeInfo) {
            this.runtime = runtimeInfo;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public QuickStats getQuickStats() {
            return this.quickStats;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public void setQuickStats(QuickStats quickStats) {
            this.quickStats = quickStats;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public Integer getConfiguredMemoryMB() {
            return this.configuredMemoryMB;
        }

        @optional
        @versionClass(value=version5.class)
        @silent
        public void setConfiguredMemoryMB(Integer n) {
            this.configuredMemoryMB = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("(vim.Summary) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("name = ");
            stringBuilder.append(this.getName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("config = ");
            if (this.getConfig() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getConfig())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("runtime = ");
            if (this.getRuntime() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getRuntime())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("quickStats = ");
            if (this.getQuickStats() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getQuickStats())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("configuredMemoryMB = ");
            stringBuilder.append(this.getConfiguredMemoryMB());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version5.class)
        @wsdlName(value="ResourcePoolQuickStats")
        @data
        @propertyOrder(value={"overallCpuUsage", "overallCpuDemand", "guestMemoryUsage", "hostMemoryUsage", "distributedCpuEntitlement", "distributedMemoryEntitlement", "staticCpuEntitlement", "staticMemoryEntitlement", "privateMemory", "sharedMemory", "swappedMemory", "balloonedMemory", "overheadMemory", "consumedOverheadMemory", "compressedMemory"})
        public static class QuickStats
        extends DynamicDataImpl {
            private static final long serialVersionUID = 1L;
            public Long overallCpuUsage;
            public Long overallCpuDemand;
            public Long guestMemoryUsage;
            public Long hostMemoryUsage;
            public Long distributedCpuEntitlement;
            public Long distributedMemoryEntitlement;
            public Integer staticCpuEntitlement;
            public Integer staticMemoryEntitlement;
            public Long privateMemory;
            public Long sharedMemory;
            public Long swappedMemory;
            public Long balloonedMemory;
            public Long overheadMemory;
            public Long consumedOverheadMemory;
            public Long compressedMemory;

            public QuickStats() {
            }

            public QuickStats(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Integer n, Integer n2, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13) {
                this.overallCpuUsage = l;
                this.overallCpuDemand = l2;
                this.guestMemoryUsage = l3;
                this.hostMemoryUsage = l4;
                this.distributedCpuEntitlement = l5;
                this.distributedMemoryEntitlement = l6;
                this.staticCpuEntitlement = n;
                this.staticMemoryEntitlement = n2;
                this.privateMemory = l7;
                this.sharedMemory = l8;
                this.swappedMemory = l9;
                this.balloonedMemory = l10;
                this.overheadMemory = l11;
                this.consumedOverheadMemory = l12;
                this.compressedMemory = l13;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverallCpuUsage() {
                return this.overallCpuUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverallCpuUsage(Long l) {
                this.overallCpuUsage = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverallCpuDemand() {
                return this.overallCpuDemand;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverallCpuDemand(Long l) {
                this.overallCpuDemand = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getGuestMemoryUsage() {
                return this.guestMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setGuestMemoryUsage(Long l) {
                this.guestMemoryUsage = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getHostMemoryUsage() {
                return this.hostMemoryUsage;
            }

            @optional
            @versionClass(value=version5.class)
            public void setHostMemoryUsage(Long l) {
                this.hostMemoryUsage = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getDistributedCpuEntitlement() {
                return this.distributedCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setDistributedCpuEntitlement(Long l) {
                this.distributedCpuEntitlement = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getDistributedMemoryEntitlement() {
                return this.distributedMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setDistributedMemoryEntitlement(Long l) {
                this.distributedMemoryEntitlement = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Integer getStaticCpuEntitlement() {
                return this.staticCpuEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setStaticCpuEntitlement(Integer n) {
                this.staticCpuEntitlement = n;
            }

            @optional
            @versionClass(value=version5.class)
            public Integer getStaticMemoryEntitlement() {
                return this.staticMemoryEntitlement;
            }

            @optional
            @versionClass(value=version5.class)
            public void setStaticMemoryEntitlement(Integer n) {
                this.staticMemoryEntitlement = n;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getPrivateMemory() {
                return this.privateMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setPrivateMemory(Long l) {
                this.privateMemory = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getSharedMemory() {
                return this.sharedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setSharedMemory(Long l) {
                this.sharedMemory = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getSwappedMemory() {
                return this.swappedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setSwappedMemory(Long l) {
                this.swappedMemory = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getBalloonedMemory() {
                return this.balloonedMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setBalloonedMemory(Long l) {
                this.balloonedMemory = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getOverheadMemory() {
                return this.overheadMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setOverheadMemory(Long l) {
                this.overheadMemory = l;
            }

            @optional
            @versionClass(value=version5.class)
            public Long getConsumedOverheadMemory() {
                return this.consumedOverheadMemory;
            }

            @optional
            @versionClass(value=version5.class)
            public void setConsumedOverheadMemory(Long l) {
                this.consumedOverheadMemory = l;
            }

            @optional
            @versionClass(value=version6.class)
            public Long getCompressedMemory() {
                return this.compressedMemory;
            }

            @optional
            @versionClass(value=version6.class)
            public void setCompressedMemory(Long l) {
                this.compressedMemory = l;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(680);
                stringBuilder.append("(vim.QuickStats) {\n");
                stringBuilder.append("   ");
                stringBuilder.append("dynamicType = ");
                stringBuilder.append(this.getDynamicType());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("dynamicProperty = ");
                if (this.getDynamicProperty() == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append("(vmodl.DynamicProperty) [\n");
                    for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                        stringBuilder.append("      ");
                        stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                        if (i < this.getDynamicProperty().length - 1) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("   ");
                    stringBuilder.append("]");
                }
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("overallCpuUsage = ");
                stringBuilder.append(this.getOverallCpuUsage());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("overallCpuDemand = ");
                stringBuilder.append(this.getOverallCpuDemand());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("guestMemoryUsage = ");
                stringBuilder.append(this.getGuestMemoryUsage());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("hostMemoryUsage = ");
                stringBuilder.append(this.getHostMemoryUsage());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("distributedCpuEntitlement = ");
                stringBuilder.append(this.getDistributedCpuEntitlement());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("distributedMemoryEntitlement = ");
                stringBuilder.append(this.getDistributedMemoryEntitlement());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("staticCpuEntitlement = ");
                stringBuilder.append(this.getStaticCpuEntitlement());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("staticMemoryEntitlement = ");
                stringBuilder.append(this.getStaticMemoryEntitlement());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("privateMemory = ");
                stringBuilder.append(this.getPrivateMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("sharedMemory = ");
                stringBuilder.append(this.getSharedMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("swappedMemory = ");
                stringBuilder.append(this.getSwappedMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("balloonedMemory = ");
                stringBuilder.append(this.getBalloonedMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("overheadMemory = ");
                stringBuilder.append(this.getOverheadMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("consumedOverheadMemory = ");
                stringBuilder.append(this.getConsumedOverheadMemory());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("compressedMemory = ");
                stringBuilder.append(this.getCompressedMemory());
                stringBuilder.append("\n}");
                return stringBuilder.toString();
            }
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="ResourcePoolRuntimeInfo")
    @data
    @propertyOrder(value={"memory", "cpu", "overallStatus"})
    public static class RuntimeInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ResourceUsage memory;
        public ResourceUsage cpu;
        public ManagedEntity.Status overallStatus;

        public RuntimeInfo() {
        }

        public RuntimeInfo(ResourceUsage resourceUsage, ResourceUsage resourceUsage2, ManagedEntity.Status status) {
            this.memory = resourceUsage;
            this.cpu = resourceUsage2;
            this.overallStatus = status;
        }

        @versionClass(value=version2.class)
        @silent
        public ResourceUsage getMemory() {
            return this.memory;
        }

        @versionClass(value=version2.class)
        @silent
        public void setMemory(ResourceUsage resourceUsage) {
            this.memory = resourceUsage;
        }

        @versionClass(value=version2.class)
        @silent
        public ResourceUsage getCpu() {
            return this.cpu;
        }

        @versionClass(value=version2.class)
        @silent
        public void setCpu(ResourceUsage resourceUsage) {
            this.cpu = resourceUsage;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public ManagedEntity.Status getOverallStatus() {
            return this.overallStatus;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setOverallStatus(ManagedEntity.Status status) {
            this.overallStatus = status;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.RuntimeInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("memory = ");
            if (this.getMemory() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getMemory())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("cpu = ");
            if (this.getCpu() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getCpu())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("overallStatus = ");
            stringBuilder.append((Object)this.getOverallStatus());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="ResourcePoolResourceUsage")
    @data
    @propertyOrder(value={"reservationUsed", "reservationUsedForVm", "unreservedForPool", "unreservedForVm", "overallUsage", "maxUsage"})
    public static class ResourceUsage
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public long reservationUsed;
        public long reservationUsedForVm;
        public long unreservedForPool;
        public long unreservedForVm;
        public long overallUsage;
        public long maxUsage;

        public ResourceUsage() {
        }

        public ResourceUsage(long l, long l2, long l3, long l4, long l5, long l6) {
            this.reservationUsed = l;
            this.reservationUsedForVm = l2;
            this.unreservedForPool = l3;
            this.unreservedForVm = l4;
            this.overallUsage = l5;
            this.maxUsage = l6;
        }

        @versionClass(value=version2.class)
        public long getReservationUsed() {
            return this.reservationUsed;
        }

        @versionClass(value=version2.class)
        public void setReservationUsed(long l) {
            this.reservationUsed = l;
        }

        @versionClass(value=version2.class)
        public long getReservationUsedForVm() {
            return this.reservationUsedForVm;
        }

        @versionClass(value=version2.class)
        public void setReservationUsedForVm(long l) {
            this.reservationUsedForVm = l;
        }

        @versionClass(value=version2.class)
        public long getUnreservedForPool() {
            return this.unreservedForPool;
        }

        @versionClass(value=version2.class)
        public void setUnreservedForPool(long l) {
            this.unreservedForPool = l;
        }

        @versionClass(value=version2.class)
        public long getUnreservedForVm() {
            return this.unreservedForVm;
        }

        @versionClass(value=version2.class)
        public void setUnreservedForVm(long l) {
            this.unreservedForVm = l;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public long getOverallUsage() {
            return this.overallUsage;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setOverallUsage(long l) {
            this.overallUsage = l;
        }

        @versionClass(value=version2.class)
        public long getMaxUsage() {
            return this.maxUsage;
        }

        @versionClass(value=version2.class)
        public void setMaxUsage(long l) {
            this.maxUsage = l;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(320);
            stringBuilder.append("(vim.ResourceUsage) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("reservationUsed = ");
            stringBuilder.append(this.getReservationUsed());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("reservationUsedForVm = ");
            stringBuilder.append(this.getReservationUsedForVm());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("unreservedForPool = ");
            stringBuilder.append(this.getUnreservedForPool());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("unreservedForVm = ");
            stringBuilder.append(this.getUnreservedForVm());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("overallUsage = ");
            stringBuilder.append(this.getOverallUsage());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("maxUsage = ");
            stringBuilder.append(this.getMaxUsage());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }
}

