/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.DatastoreNotWritableOnHost;
import com.vmware.vim.binding.vim.fault.DuplicateName;
import com.vmware.vim.binding.vim.fault.FileNotFound;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.InaccessibleDatastore;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.fault.ResourceInUse;
import com.vmware.vim.binding.vim.fault.VmfsAmbiguousMount;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsResignatureSpec;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsVolume;
import com.vmware.vim.binding.vim.host.VmfsDatastoreCreateSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExtendSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VvolDatastoreSpecInternal;
import com.vmware.vim.binding.vim.version.version10;
import com.vmware.vim.binding.vim.version.version11;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vim.version.version9;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="HostDatastoreSystem")
public interface DatastoreSystem
extends ManagedObject {
    @readonly
    @name(value="datastore")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    @map
    public void getDatastore(@optional @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference[]> var1);

    @name(value="datastore")
    public ManagedObjectReference[] getDatastore();

    @readonly
    @name(value="capabilities")
    @versionClass(value=version2.class)
    public void getCapabilities(Future<Capabilities> var1);

    @name(value="capabilities")
    public Capabilities getCapabilities();

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateLocalSwapDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"InaccessibleDatastore", "DatastoreNotWritableOnHost"})
    public void updateLocalSwapDatastore(@name(value="datastore") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, Future<Void> var2);

    @wsdlName(value="UpdateLocalSwapDatastore")
    public void updateLocalSwapDatastore(ManagedObjectReference var1) throws InaccessibleDatastore, DatastoreNotWritableOnHost;

    @versionClass(value=version2.class)
    @wsdlName(value="QueryAvailableDisksForVmfs")
    @privilege(value="Host.Config.Storage")
    @list
    @faults(value={"NotFound", "HostConfigFault"})
    public void queryAvailableDisksForVmfs(@name(value="datastore") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, @optional @list Future<ScsiDisk[]> var2);

    @wsdlName(value="QueryAvailableDisksForVmfs")
    @optional
    public ScsiDisk[] queryAvailableDisksForVmfs(ManagedObjectReference var1) throws NotFound, HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="QueryVmfsDatastoreCreateOptions")
    @privilege(value="Host.Config.Storage")
    @list
    @faults(value={"NotFound", "HostConfigFault"})
    public void queryVmfsDatastoreCreateOptions(@name(value="devicePath") @versionClass(value=version2.class) String var1, @name(value="vmfsMajorVersion") @versionClass(value=version7.class) @optional Integer var2, @optional @list Future<VmfsDatastoreOption[]> var3);

    @wsdlName(value="QueryVmfsDatastoreCreateOptions")
    @optional
    public VmfsDatastoreOption[] queryVmfsDatastoreCreateOptions(String var1, Integer var2) throws NotFound, HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="CreateVmfsDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"DuplicateName", "HostConfigFault"})
    public void createVmfsDatastore(@name(value="spec") @versionClass(value=version2.class) VmfsDatastoreCreateSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateVmfsDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference createVmfsDatastore(VmfsDatastoreCreateSpec var1) throws DuplicateName, HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="QueryVmfsDatastoreExtendOptions")
    @privilege(value="Host.Config.Storage")
    @list
    @faults(value={"NotFound", "HostConfigFault"})
    public void queryVmfsDatastoreExtendOptions(@name(value="datastore") @versionClass(value=version2.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, @name(value="devicePath") @versionClass(value=version2.class) String var2, @name(value="suppressExpandCandidates") @versionClass(value=version5.class) @optional Boolean var3, @optional @list Future<VmfsDatastoreOption[]> var4);

    @wsdlName(value="QueryVmfsDatastoreExtendOptions")
    @optional
    public VmfsDatastoreOption[] queryVmfsDatastoreExtendOptions(ManagedObjectReference var1, String var2, Boolean var3) throws NotFound, HostConfigFault;

    @versionClass(value=version5.class)
    @wsdlName(value="QueryVmfsDatastoreExpandOptions")
    @privilege(value="Host.Config.Storage")
    @list
    @faults(value={"NotFound", "HostConfigFault"})
    public void queryVmfsDatastoreExpandOptions(@name(value="datastore") @versionClass(value=version5.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, @optional @list Future<VmfsDatastoreOption[]> var2);

    @wsdlName(value="QueryVmfsDatastoreExpandOptions")
    @optional
    public VmfsDatastoreOption[] queryVmfsDatastoreExpandOptions(ManagedObjectReference var1) throws NotFound, HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="ExtendVmfsDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"NotFound", "HostConfigFault"})
    public void extendVmfsDatastore(@name(value="datastore") @versionClass(value=version2.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, @name(value="spec") @versionClass(value=version2.class) VmfsDatastoreExtendSpec var2, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var3);

    @wsdlName(value="ExtendVmfsDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference extendVmfsDatastore(ManagedObjectReference var1, VmfsDatastoreExtendSpec var2) throws NotFound, HostConfigFault;

    @versionClass(value=version5.class)
    @wsdlName(value="ExpandVmfsDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"NotFound", "HostConfigFault"})
    public void expandVmfsDatastore(@name(value="datastore") @versionClass(value=version5.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, @name(value="spec") @versionClass(value=version5.class) VmfsDatastoreExpandSpec var2, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var3);

    @wsdlName(value="ExpandVmfsDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference expandVmfsDatastore(ManagedObjectReference var1, VmfsDatastoreExpandSpec var2) throws NotFound, HostConfigFault;

    @versionClass(value=version11.class)
    @wsdlName(value="ProcessVmfsDatastoreUpdate")
    @privilege(value="Host.Config.Storage")
    @internal
    public void processVmfsDatastoreUpdate(@name(value="uuid") @versionClass(value=version11.class) String var1, @name(value="operation") @versionClass(value=version11.class) VmfsEventType var2, Future<Void> var3);

    @wsdlName(value="ProcessVmfsDatastoreUpdate")
    public void processVmfsDatastoreUpdate(String var1, VmfsEventType var2);

    @versionClass(value=version2.class)
    @wsdlName(value="CreateNasDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"DuplicateName", "AlreadyExists", "HostConfigFault"})
    public void createNasDatastore(@name(value="spec") @versionClass(value=version2.class) NasVolume.Specification var1, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateNasDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference createNasDatastore(NasVolume.Specification var1) throws DuplicateName, AlreadyExists, HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="CreateLocalDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"DuplicateName", "HostConfigFault", "FileNotFound", "InvalidName"})
    public void createLocalDatastore(@name(value="name") @versionClass(value=version2.class) String var1, @name(value="path") @versionClass(value=version2.class) String var2, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var3);

    @wsdlName(value="CreateLocalDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference createLocalDatastore(String var1, String var2) throws DuplicateName, HostConfigFault, FileNotFound, InvalidName;

    @versionClass(value=version10.class)
    @wsdlName(value="UpdateVvolDatastoreInternal")
    @privilege(value="Host.Config.Storage")
    @internal
    @faults(value={"HostConfigFault", "NotFound"})
    public void UpdateVvolDatastoreInternal(@name(value="spec") @versionClass(value=version10.class) VvolDatastoreSpecInternal var1, Future<Void> var2);

    @wsdlName(value="UpdateVvolDatastoreInternal")
    public void UpdateVvolDatastoreInternal(VvolDatastoreSpecInternal var1) throws HostConfigFault, NotFound;

    @versionClass(value=version10.class)
    @wsdlName(value="CreateVvolDatastoreInternal")
    @privilege(value="Host.Config.Storage")
    @internal
    @faults(value={"DuplicateName", "HostConfigFault", "FileNotFound", "InvalidName"})
    public void createVvolDatastoreInternal(@name(value="spec") @versionClass(value=version10.class) VvolDatastoreSpecInternal var1, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateVvolDatastoreInternal")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference createVvolDatastoreInternal(VvolDatastoreSpecInternal var1) throws DuplicateName, HostConfigFault, FileNotFound, InvalidName;

    @versionClass(value=version10.class)
    @wsdlName(value="CreateVvolDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"NotFound", "DuplicateName", "HostConfigFault", "InvalidName"})
    public void createVvolDatastore(@name(value="spec") @versionClass(value=version10.class) VvolDatastoreSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateVvolDatastore")
    @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
    public ManagedObjectReference createVvolDatastore(VvolDatastoreSpec var1) throws NotFound, DuplicateName, HostConfigFault, InvalidName;

    @versionClass(value=version2.class)
    @wsdlName(value="RemoveDatastore")
    @privilege(value="Host.Config.Storage")
    @faults(value={"NotFound", "HostConfigFault", "ResourceInUse"})
    public void removeDatastore(@name(value="datastore") @versionClass(value=version2.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") ManagedObjectReference var1, Future<Void> var2);

    @wsdlName(value="RemoveDatastore")
    public void removeDatastore(ManagedObjectReference var1) throws NotFound, HostConfigFault, ResourceInUse;

    @versionClass(value=version10.class)
    @wsdlName(value="RemoveDatastoreEx_Task")
    @privilege(value="Host.Config.Storage")
    @task
    @map
    @faults(value={"HostConfigFault"})
    public void removeDatastoreEx(@name(value="datastore") @versionClass(value=version10.class) @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") @map ManagedObjectReference[] var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="RemoveDatastoreEx_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference removeDatastoreEx(ManagedObjectReference[] var1) throws HostConfigFault;

    @versionClass(value=version2.class)
    @wsdlName(value="ConfigureDatastorePrincipal")
    @privilege(value="Host.Config.Maintenance")
    @faults(value={"InvalidState", "HostConfigFault"})
    public void configureDatastorePrincipal(@name(value="userName") @versionClass(value=version2.class) String var1, @name(value="password") @versionClass(value=version2.class) @optional @secret String var2, Future<Void> var3);

    @wsdlName(value="ConfigureDatastorePrincipal")
    public void configureDatastorePrincipal(String var1, String var2) throws InvalidState, HostConfigFault;

    @versionClass(value=version5.class)
    @wsdlName(value="QueryUnresolvedVmfsVolumes")
    @privilege(value="System.Read")
    @list
    public void queryUnresolvedVmfsVolumes(@optional @list Future<UnresolvedVmfsVolume[]> var1);

    @wsdlName(value="QueryUnresolvedVmfsVolumes")
    @optional
    public UnresolvedVmfsVolume[] queryUnresolvedVmfsVolumes();

    @versionClass(value=version5.class)
    @wsdlName(value="ResignatureUnresolvedVmfsVolume_Task")
    @privilege(value="Host.Config.Storage")
    @task
    @faults(value={"VmfsAmbiguousMount", "HostConfigFault"})
    public void resignatureUnresolvedVmfsVolume(@name(value="resolutionSpec") @versionClass(value=version5.class) UnresolvedVmfsResignatureSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="ResignatureUnresolvedVmfsVolume_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference resignatureUnresolvedVmfsVolume(UnresolvedVmfsResignatureSpec var1) throws VmfsAmbiguousMount, HostConfigFault;

    @versionClass(value=version10.class)
    @wsdlName(value="NotifyDatastore")
    @privilege(value="Host.Config.Storage")
    @internal
    public void NotifyDatastore(@name(value="eventType") @versionClass(value=version10.class) String var1, @name(value="datastore") @versionClass(value=version10.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.Datastore") @map ManagedObjectReference[] var2, Future<Void> var3);

    @wsdlName(value="NotifyDatastore")
    public void NotifyDatastore(String var1, ManagedObjectReference[] var2);

    @versionClass(value=version9.class)
    @wsdlName(value="CheckVmFileAccessibility")
    @privilege(value="System.Read")
    @internal
    @list
    public void checkVmFileAccessibility(@name(value="vmIds") @versionClass(value=version9.class) @map String[] var1, @list Future<VmFileAccessibilityResult[]> var2);

    @wsdlName(value="CheckVmFileAccessibility")
    public VmFileAccessibilityResult[] checkVmFileAccessibility(String[] var1);

    @versionClass(value=version9.class)
    @wsdlName(value="HostDatastoreSystemVmFileAccessibilityResult")
    @data
    @propertyOrder(value={"vmId", "accessible", "error"})
    public static class VmFileAccessibilityResult
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String vmId;
        public boolean accessible;
        public Exception error;

        public VmFileAccessibilityResult() {
        }

        public VmFileAccessibilityResult(String string, boolean bl, Exception exception) {
            this.vmId = string;
            this.accessible = bl;
            this.error = exception;
        }

        @versionClass(value=version9.class)
        public String getVmId() {
            return this.vmId;
        }

        @versionClass(value=version9.class)
        public void setVmId(String string) {
            this.vmId = string;
        }

        @versionClass(value=version9.class)
        public boolean isAccessible() {
            return this.accessible;
        }

        @versionClass(value=version9.class)
        public void setAccessible(boolean bl) {
            this.accessible = bl;
        }

        @optional
        @versionClass(value=version9.class)
        public Exception getError() {
            return this.error;
        }

        @optional
        @versionClass(value=version9.class)
        public void setError(Exception exception) {
            this.error = exception;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.host.VmFileAccessibilityResult) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("vmId = ");
            stringBuilder.append(this.getVmId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("accessible = ");
            stringBuilder.append(this.isAccessible());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("error = ");
            if (this.getError() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + this.getError()), (boolean)false));
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version10.class)
    @wsdlName(value="HostDatastoreSystemDatastoreEventType")
    public static enum DatastoreEventType {
        VvolFastPolling,
        PreUnmount,
        FailedUnmount;

    }

    @versionClass(value=version10.class)
    @wsdlName(value="HostDatastoreSystemDatastoreResult")
    @data
    @propertyOrder(value={"key", "fault"})
    public static class DatastoreResult
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference key;
        public Exception fault;

        public DatastoreResult() {
        }

        public DatastoreResult(ManagedObjectReference managedObjectReference, Exception exception) {
            this.key = managedObjectReference;
            this.fault = exception;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
        @versionClass(value=version10.class)
        public ManagedObjectReference getKey() {
            return this.key;
        }

        @managedObjectType(value="com.vmware.vim.binding.vim.Datastore")
        @versionClass(value=version10.class)
        public void setKey(ManagedObjectReference managedObjectReference) {
            this.key = managedObjectReference;
        }

        @optional
        @versionClass(value=version10.class)
        public Exception getFault() {
            return this.fault;
        }

        @optional
        @versionClass(value=version10.class)
        public void setFault(Exception exception) {
            this.fault = exception;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(160);
            stringBuilder.append("(vim.host.DatastoreResult) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("key = ");
            if (this.getKey() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + this.getKey()), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("fault = ");
            if (this.getFault() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + this.getFault()), (boolean)false));
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version11.class)
    @wsdlName(value="HostDatastoreSystemVmfsEventType")
    public static enum VmfsEventType {
        Create,
        Expand,
        Extend,
        Remove,
        Upgrade;

    }

    @versionClass(value=version10.class)
    @wsdlName(value="HostDatastoreSystemVvolDatastoreSpec")
    @data
    @propertyOrder(value={"name", "scId"})
    public static class VvolDatastoreSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;
        public String scId;

        public VvolDatastoreSpec() {
        }

        public VvolDatastoreSpec(String string, String string2) {
            this.name = string;
            this.scId = string2;
        }

        @versionClass(value=version10.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version10.class)
        public void setName(String string) {
            this.name = string;
        }

        @versionClass(value=version10.class)
        public String getScId() {
            return this.scId;
        }

        @versionClass(value=version10.class)
        public void setScId(String string) {
            this.scId = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(160);
            stringBuilder.append("(vim.host.VvolDatastoreSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("name = ");
            stringBuilder.append(this.getName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("scId = ");
            stringBuilder.append(this.getScId());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="HostDatastoreSystemCapabilities")
    @data
    @propertyOrder(value={"nfsMountCreationRequired", "nfsMountCreationSupported", "localDatastoreSupported", "vmfsExtentExpansionSupported"})
    public static class Capabilities
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public boolean nfsMountCreationRequired;
        public boolean nfsMountCreationSupported;
        public boolean localDatastoreSupported;
        public Boolean vmfsExtentExpansionSupported;

        public Capabilities() {
        }

        public Capabilities(boolean bl, boolean bl2, boolean bl3, Boolean bl4) {
            this.nfsMountCreationRequired = bl;
            this.nfsMountCreationSupported = bl2;
            this.localDatastoreSupported = bl3;
            this.vmfsExtentExpansionSupported = bl4;
        }

        @versionClass(value=version2.class)
        public boolean isNfsMountCreationRequired() {
            return this.nfsMountCreationRequired;
        }

        @versionClass(value=version2.class)
        public void setNfsMountCreationRequired(boolean bl) {
            this.nfsMountCreationRequired = bl;
        }

        @versionClass(value=version2.class)
        public boolean isNfsMountCreationSupported() {
            return this.nfsMountCreationSupported;
        }

        @versionClass(value=version2.class)
        public void setNfsMountCreationSupported(boolean bl) {
            this.nfsMountCreationSupported = bl;
        }

        @versionClass(value=version2.class)
        public boolean isLocalDatastoreSupported() {
            return this.localDatastoreSupported;
        }

        @versionClass(value=version2.class)
        public void setLocalDatastoreSupported(boolean bl) {
            this.localDatastoreSupported = bl;
        }

        @optional
        @versionClass(value=version5.class)
        @Deprecated
        public Boolean isVmfsExtentExpansionSupported() {
            return this.vmfsExtentExpansionSupported;
        }

        @optional
        @versionClass(value=version5.class)
        public Boolean getVmfsExtentExpansionSupported() {
            return this.vmfsExtentExpansionSupported;
        }

        @optional
        @versionClass(value=version5.class)
        public void setVmfsExtentExpansionSupported(Boolean bl) {
            this.vmfsExtentExpansionSupported = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(240);
            stringBuilder.append("(vim.host.Capabilities) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("nfsMountCreationRequired = ");
            stringBuilder.append(this.isNfsMountCreationRequired());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("nfsMountCreationSupported = ");
            stringBuilder.append(this.isNfsMountCreationSupported());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("localDatastoreSupported = ");
            stringBuilder.append(this.isLocalDatastoreSupported());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("vmfsExtentExpansionSupported = ");
            stringBuilder.append(this.isVmfsExtentExpansionSupported());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }
}

