/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.InvalidHostState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.version.version12;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.localizable;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version12.class)
@wsdlName(value="HostNvdimmSystem")
public interface NvdimmSystem
extends ManagedObject {
    @readonly
    @name(value="nvdimmSystemInfo")
    @privilege(value="Host.Config.Nvdimm")
    @versionClass(value=version12.class)
    public void getNvdimmSystemInfo(Future<NvdimmSystemInfo> var1);

    @name(value="nvdimmSystemInfo")
    public NvdimmSystemInfo getNvdimmSystemInfo();

    @versionClass(value=version12.class)
    @wsdlName(value="CreateNvdimmNamespace_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"InvalidHostState", "AlreadyExists", "HostConfigFault"})
    public void createNamespace(@name(value="createSpec") @versionClass(value=version12.class) NamespaceCreateSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateNvdimmNamespace_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference createNamespace(NamespaceCreateSpec var1) throws InvalidHostState, AlreadyExists, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="DeleteNvdimmNamespace_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"NotFound", "InvalidHostState", "HostConfigFault"})
    public void deleteNamespace(@name(value="deleteSpec") @versionClass(value=version12.class) NamespaceDeleteSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="DeleteNvdimmNamespace_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference deleteNamespace(NamespaceDeleteSpec var1) throws NotFound, InvalidHostState, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="DeleteNvdimmBlockNamespaces_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"NotFound", "InvalidHostState", "HostConfigFault"})
    public void deleteBlockNamespaces(@managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @wsdlName(value="DeleteNvdimmBlockNamespaces_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference deleteBlockNamespaces() throws NotFound, InvalidHostState, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmSystemInfo")
    @data
    @propertyOrder(value={"summary", "dimms", "dimmInfo", "interleaveSet", "iSetInfo", "namespace", "nsInfo"})
    public static class NvdimmSystemInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Summary summary;
        public int[] dimms;
        public DimmInfo[] dimmInfo;
        public int[] interleaveSet;
        public InterleaveSetInfo[] iSetInfo;
        public Guid[] namespace;
        public NamespaceInfo[] nsInfo;

        public NvdimmSystemInfo() {
        }

        public NvdimmSystemInfo(Summary summary, int[] nArray, DimmInfo[] dimmInfoArray, int[] nArray2, InterleaveSetInfo[] interleaveSetInfoArray, Guid[] guidArray, NamespaceInfo[] namespaceInfoArray) {
            this.summary = summary;
            this.dimms = nArray;
            this.dimmInfo = dimmInfoArray;
            this.interleaveSet = nArray2;
            this.iSetInfo = interleaveSetInfoArray;
            this.namespace = guidArray;
            this.nsInfo = namespaceInfoArray;
        }

        @optional
        @versionClass(value=version12.class)
        public Summary getSummary() {
            return this.summary;
        }

        @optional
        @versionClass(value=version12.class)
        public void setSummary(Summary summary) {
            this.summary = summary;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getDimms() {
            return this.dimms;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setDimms(int[] nArray) {
            this.dimms = nArray;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public DimmInfo[] getDimmInfo() {
            return this.dimmInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setDimmInfo(DimmInfo[] dimmInfoArray) {
            this.dimmInfo = dimmInfoArray;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getInterleaveSet() {
            return this.interleaveSet;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setInterleaveSet(int[] nArray) {
            this.interleaveSet = nArray;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public InterleaveSetInfo[] getISetInfo() {
            return this.iSetInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setISetInfo(InterleaveSetInfo[] interleaveSetInfoArray) {
            this.iSetInfo = interleaveSetInfoArray;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public Guid[] getNamespace() {
            return this.namespace;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setNamespace(Guid[] guidArray) {
            this.namespace = guidArray;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public NamespaceInfo[] getNsInfo() {
            return this.nsInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setNsInfo(NamespaceInfo[] namespaceInfoArray) {
            this.nsInfo = namespaceInfoArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(360);
            stringBuilder.append("(vim.host.NvdimmSystemInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("summary = ");
            if (this.getSummary() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getSummary())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimms = ");
            if (this.getDimms() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(INT) [\n");
                for (n = 0; n < this.getDimms().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getDimms()[n]);
                    if (n < this.getDimms().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimmInfo = ");
            if (this.getDimmInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.DimmInfo) [\n");
                for (n = 0; n < this.getDimmInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getDimmInfo()[n])), (boolean)true));
                    if (n < this.getDimmInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("interleaveSet = ");
            if (this.getInterleaveSet() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(INT) [\n");
                for (n = 0; n < this.getInterleaveSet().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getInterleaveSet()[n]);
                    if (n < this.getInterleaveSet().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("iSetInfo = ");
            if (this.getISetInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.InterleaveSetInfo) [\n");
                for (n = 0; n < this.getISetInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getISetInfo()[n])), (boolean)true));
                    if (n < this.getISetInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("namespace = ");
            if (this.getNamespace() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.Guid) [\n");
                for (n = 0; n < this.getNamespace().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getNamespace()[n])), (boolean)true));
                    if (n < this.getNamespace().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("nsInfo = ");
            if (this.getNsInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.NamespaceInfo) [\n");
                for (n = 0; n < this.getNsInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getNsInfo()[n])), (boolean)true));
                    if (n < this.getNsInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceDeleteSpec")
    @data
    @propertyOrder(value={"uuid"})
    public static class NamespaceDeleteSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;

        public NamespaceDeleteSpec() {
        }

        public NamespaceDeleteSpec(String string) {
            this.uuid = string;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String string) {
            this.uuid = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.host.NamespaceDeleteSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("uuid = ");
            stringBuilder.append(this.getUuid());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceCreateSpec")
    @data
    @propertyOrder(value={"friendlyName", "blockSize", "blockCount", "type", "locationID"})
    public static class NamespaceCreateSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String friendlyName;
        public long blockSize;
        public long blockCount;
        public String type;
        public int locationID;

        public NamespaceCreateSpec() {
        }

        public NamespaceCreateSpec(String string, long l, long l2, String string2, int n) {
            this.friendlyName = string;
            this.blockSize = l;
            this.blockCount = l2;
            this.type = string2;
            this.locationID = n;
        }

        @optional
        @versionClass(value=version12.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @optional
        @versionClass(value=version12.class)
        public void setFriendlyName(String string) {
            this.friendlyName = string;
        }

        @versionClass(value=version12.class)
        public long getBlockSize() {
            return this.blockSize;
        }

        @versionClass(value=version12.class)
        public void setBlockSize(long l) {
            this.blockSize = l;
        }

        @versionClass(value=version12.class)
        public long getBlockCount() {
            return this.blockCount;
        }

        @versionClass(value=version12.class)
        public void setBlockCount(long l) {
            this.blockCount = l;
        }

        @versionClass(value=version12.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version12.class)
        public void setType(String string) {
            this.type = string;
        }

        @versionClass(value=version12.class)
        public int getLocationID() {
            return this.locationID;
        }

        @versionClass(value=version12.class)
        public void setLocationID(int n) {
            this.locationID = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("(vim.host.NamespaceCreateSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("friendlyName = ");
            stringBuilder.append(this.getFriendlyName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockSize = ");
            stringBuilder.append(this.getBlockSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockCount = ");
            stringBuilder.append(this.getBlockCount());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("type = ");
            stringBuilder.append(this.getType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("locationID = ");
            stringBuilder.append(this.getLocationID());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceInfo")
    @data
    @propertyOrder(value={"uuid", "friendlyName", "blockSize", "blockCount", "type", "namespaceHealthStatus", "locationID", "state"})
    public static class NamespaceInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;
        public String friendlyName;
        public long blockSize;
        public long blockCount;
        public String type;
        public String namespaceHealthStatus;
        public int locationID;
        public String state;

        public NamespaceInfo() {
        }

        public NamespaceInfo(String string, String string2, long l, long l2, String string3, String string4, int n, String string5) {
            this.uuid = string;
            this.friendlyName = string2;
            this.blockSize = l;
            this.blockCount = l2;
            this.type = string3;
            this.namespaceHealthStatus = string4;
            this.locationID = n;
            this.state = string5;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String string) {
            this.uuid = string;
        }

        @versionClass(value=version12.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @versionClass(value=version12.class)
        public void setFriendlyName(String string) {
            this.friendlyName = string;
        }

        @versionClass(value=version12.class)
        public long getBlockSize() {
            return this.blockSize;
        }

        @versionClass(value=version12.class)
        public void setBlockSize(long l) {
            this.blockSize = l;
        }

        @versionClass(value=version12.class)
        public long getBlockCount() {
            return this.blockCount;
        }

        @versionClass(value=version12.class)
        public void setBlockCount(long l) {
            this.blockCount = l;
        }

        @versionClass(value=version12.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version12.class)
        public void setType(String string) {
            this.type = string;
        }

        @versionClass(value=version12.class)
        public String getNamespaceHealthStatus() {
            return this.namespaceHealthStatus;
        }

        @versionClass(value=version12.class)
        public void setNamespaceHealthStatus(String string) {
            this.namespaceHealthStatus = string;
        }

        @versionClass(value=version12.class)
        public int getLocationID() {
            return this.locationID;
        }

        @versionClass(value=version12.class)
        public void setLocationID(int n) {
            this.locationID = n;
        }

        @versionClass(value=version12.class)
        public String getState() {
            return this.state;
        }

        @versionClass(value=version12.class)
        public void setState(String string) {
            this.state = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(400);
            stringBuilder.append("(vim.host.NamespaceInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("uuid = ");
            stringBuilder.append(this.getUuid());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("friendlyName = ");
            stringBuilder.append(this.getFriendlyName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockSize = ");
            stringBuilder.append(this.getBlockSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockCount = ");
            stringBuilder.append(this.getBlockCount());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("type = ");
            stringBuilder.append(this.getType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("namespaceHealthStatus = ");
            stringBuilder.append(this.getNamespaceHealthStatus());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("locationID = ");
            stringBuilder.append(this.getLocationID());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("state = ");
            stringBuilder.append(this.getState());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNamespaceState")
        public static enum NamespaceState {
            invalid,
            notInUse,
            inUse;

        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNamespaceHealthStatus")
        public static enum NamespaceHealthStatus {
            normal,
            missing,
            labelMissing,
            interleaveBroken,
            labelInconsistent,
            bttCorrupt,
            badBlockSize;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmGuid")
    @data
    @propertyOrder(value={"uuid"})
    public static class Guid
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;

        public Guid() {
        }

        public Guid(String string) {
            this.uuid = string;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String string) {
            this.uuid = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.host.Guid) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("uuid = ");
            stringBuilder.append(this.getUuid());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmInterleaveSetInfo")
    @data
    @propertyOrder(value={"setId", "rangeType", "baseAddress", "size", "availableSize", "deviceList", "state"})
    public static class InterleaveSetInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int setId;
        public String rangeType;
        public long baseAddress;
        public long size;
        public long availableSize;
        public int[] deviceList;
        public String state;

        public InterleaveSetInfo() {
        }

        public InterleaveSetInfo(int n, String string, long l, long l2, long l3, int[] nArray, String string2) {
            this.setId = n;
            this.rangeType = string;
            this.baseAddress = l;
            this.size = l2;
            this.availableSize = l3;
            this.deviceList = nArray;
            this.state = string2;
        }

        @versionClass(value=version12.class)
        public int getSetId() {
            return this.setId;
        }

        @versionClass(value=version12.class)
        public void setSetId(int n) {
            this.setId = n;
        }

        @versionClass(value=version12.class)
        public String getRangeType() {
            return this.rangeType;
        }

        @versionClass(value=version12.class)
        public void setRangeType(String string) {
            this.rangeType = string;
        }

        @versionClass(value=version12.class)
        public long getBaseAddress() {
            return this.baseAddress;
        }

        @versionClass(value=version12.class)
        public void setBaseAddress(long l) {
            this.baseAddress = l;
        }

        @versionClass(value=version12.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version12.class)
        public void setSize(long l) {
            this.size = l;
        }

        @versionClass(value=version12.class)
        public long getAvailableSize() {
            return this.availableSize;
        }

        @versionClass(value=version12.class)
        public void setAvailableSize(long l) {
            this.availableSize = l;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getDeviceList() {
            return this.deviceList;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setDeviceList(int[] nArray) {
            this.deviceList = nArray;
        }

        @versionClass(value=version12.class)
        public String getState() {
            return this.state;
        }

        @versionClass(value=version12.class)
        public void setState(String string) {
            this.state = string;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(360);
            stringBuilder.append("(vim.host.InterleaveSetInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("setId = ");
            stringBuilder.append(this.getSetId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("rangeType = ");
            stringBuilder.append(this.getRangeType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("baseAddress = ");
            stringBuilder.append(this.getBaseAddress());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("size = ");
            stringBuilder.append(this.getSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("availableSize = ");
            stringBuilder.append(this.getAvailableSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("deviceList = ");
            if (this.getDeviceList() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(INT) [\n");
                for (n = 0; n < this.getDeviceList().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getDeviceList()[n]);
                    if (n < this.getDeviceList().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("state = ");
            stringBuilder.append(this.getState());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmInterleaveSetState")
        public static enum InterleaveSetState {
            invalid,
            active;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmDimmInfo")
    @data
    @propertyOrder(value={"dimmHandle", "healthInfo", "totalCapacity", "persistentCapacity", "availablePersistentCapacity", "volatileCapacity", "availableVolatileCapacity", "blockCapacity", "regionInfo", "representationString"})
    public static class DimmInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int dimmHandle;
        public HealthInfo healthInfo;
        public long totalCapacity;
        public long persistentCapacity;
        public long availablePersistentCapacity;
        public long volatileCapacity;
        public long availableVolatileCapacity;
        public long blockCapacity;
        public RegionInfo[] regionInfo;
        public String representationString;

        public DimmInfo() {
        }

        public DimmInfo(int n, HealthInfo healthInfo, long l, long l2, long l3, long l4, long l5, long l6, RegionInfo[] regionInfoArray, String string) {
            this.dimmHandle = n;
            this.healthInfo = healthInfo;
            this.totalCapacity = l;
            this.persistentCapacity = l2;
            this.availablePersistentCapacity = l3;
            this.volatileCapacity = l4;
            this.availableVolatileCapacity = l5;
            this.blockCapacity = l6;
            this.regionInfo = regionInfoArray;
            this.representationString = string;
        }

        @versionClass(value=version12.class)
        public int getDimmHandle() {
            return this.dimmHandle;
        }

        @versionClass(value=version12.class)
        public void setDimmHandle(int n) {
            this.dimmHandle = n;
        }

        @versionClass(value=version12.class)
        public HealthInfo getHealthInfo() {
            return this.healthInfo;
        }

        @versionClass(value=version12.class)
        public void setHealthInfo(HealthInfo healthInfo) {
            this.healthInfo = healthInfo;
        }

        @versionClass(value=version12.class)
        public long getTotalCapacity() {
            return this.totalCapacity;
        }

        @versionClass(value=version12.class)
        public void setTotalCapacity(long l) {
            this.totalCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getPersistentCapacity() {
            return this.persistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setPersistentCapacity(long l) {
            this.persistentCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getAvailablePersistentCapacity() {
            return this.availablePersistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailablePersistentCapacity(long l) {
            this.availablePersistentCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getVolatileCapacity() {
            return this.volatileCapacity;
        }

        @versionClass(value=version12.class)
        public void setVolatileCapacity(long l) {
            this.volatileCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getAvailableVolatileCapacity() {
            return this.availableVolatileCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailableVolatileCapacity(long l) {
            this.availableVolatileCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getBlockCapacity() {
            return this.blockCapacity;
        }

        @versionClass(value=version12.class)
        public void setBlockCapacity(long l) {
            this.blockCapacity = l;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public RegionInfo[] getRegionInfo() {
            return this.regionInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setRegionInfo(RegionInfo[] regionInfoArray) {
            this.regionInfo = regionInfoArray;
        }

        @versionClass(value=version12.class)
        public String getRepresentationString() {
            return this.representationString;
        }

        @versionClass(value=version12.class)
        public void setRepresentationString(String string) {
            this.representationString = string;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(480);
            stringBuilder.append("(vim.host.DimmInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimmHandle = ");
            stringBuilder.append(this.getDimmHandle());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("healthInfo = ");
            if (this.getHealthInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getHealthInfo())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("totalCapacity = ");
            stringBuilder.append(this.getTotalCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("persistentCapacity = ");
            stringBuilder.append(this.getPersistentCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("availablePersistentCapacity = ");
            stringBuilder.append(this.getAvailablePersistentCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("volatileCapacity = ");
            stringBuilder.append(this.getVolatileCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("availableVolatileCapacity = ");
            stringBuilder.append(this.getAvailableVolatileCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockCapacity = ");
            stringBuilder.append(this.getBlockCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("regionInfo = ");
            if (this.getRegionInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.RegionInfo) [\n");
                for (n = 0; n < this.getRegionInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getRegionInfo()[n])), (boolean)true));
                    if (n < this.getRegionInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("representationString = ");
            stringBuilder.append(this.getRepresentationString());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmSummary")
    @data
    @propertyOrder(value={"numDimms", "healthStatus", "totalCapacity", "persistentCapacity", "blockCapacity", "availableCapacity", "numInterleavesets", "numNamespaces"})
    public static class Summary
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int numDimms;
        public String healthStatus;
        public long totalCapacity;
        public long persistentCapacity;
        public long blockCapacity;
        public long availableCapacity;
        public int numInterleavesets;
        public int numNamespaces;

        public Summary() {
        }

        public Summary(int n, String string, long l, long l2, long l3, long l4, int n2, int n3) {
            this.numDimms = n;
            this.healthStatus = string;
            this.totalCapacity = l;
            this.persistentCapacity = l2;
            this.blockCapacity = l3;
            this.availableCapacity = l4;
            this.numInterleavesets = n2;
            this.numNamespaces = n3;
        }

        @versionClass(value=version12.class)
        public int getNumDimms() {
            return this.numDimms;
        }

        @versionClass(value=version12.class)
        public void setNumDimms(int n) {
            this.numDimms = n;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthStatus() {
            return this.healthStatus;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthStatus(String string) {
            this.healthStatus = string;
        }

        @versionClass(value=version12.class)
        public long getTotalCapacity() {
            return this.totalCapacity;
        }

        @versionClass(value=version12.class)
        public void setTotalCapacity(long l) {
            this.totalCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getPersistentCapacity() {
            return this.persistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setPersistentCapacity(long l) {
            this.persistentCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getBlockCapacity() {
            return this.blockCapacity;
        }

        @versionClass(value=version12.class)
        public void setBlockCapacity(long l) {
            this.blockCapacity = l;
        }

        @versionClass(value=version12.class)
        public long getAvailableCapacity() {
            return this.availableCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailableCapacity(long l) {
            this.availableCapacity = l;
        }

        @versionClass(value=version12.class)
        public int getNumInterleavesets() {
            return this.numInterleavesets;
        }

        @versionClass(value=version12.class)
        public void setNumInterleavesets(int n) {
            this.numInterleavesets = n;
        }

        @versionClass(value=version12.class)
        public int getNumNamespaces() {
            return this.numNamespaces;
        }

        @versionClass(value=version12.class)
        public void setNumNamespaces(int n) {
            this.numNamespaces = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(400);
            stringBuilder.append("(vim.host.Summary) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("numDimms = ");
            stringBuilder.append(this.getNumDimms());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("healthStatus = ");
            stringBuilder.append(this.getHealthStatus());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("totalCapacity = ");
            stringBuilder.append(this.getTotalCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("persistentCapacity = ");
            stringBuilder.append(this.getPersistentCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("blockCapacity = ");
            stringBuilder.append(this.getBlockCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("availableCapacity = ");
            stringBuilder.append(this.getAvailableCapacity());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("numInterleavesets = ");
            stringBuilder.append(this.getNumInterleavesets());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("numNamespaces = ");
            stringBuilder.append(this.getNumNamespaces());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmRegionInfo")
    @data
    @propertyOrder(value={"regionId", "setId", "rangeType", "startAddr", "size", "offset"})
    public static class RegionInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int regionId;
        public int setId;
        public String rangeType;
        public long startAddr;
        public long size;
        public long offset;

        public RegionInfo() {
        }

        public RegionInfo(int n, int n2, String string, long l, long l2, long l3) {
            this.regionId = n;
            this.setId = n2;
            this.rangeType = string;
            this.startAddr = l;
            this.size = l2;
            this.offset = l3;
        }

        @versionClass(value=version12.class)
        public int getRegionId() {
            return this.regionId;
        }

        @versionClass(value=version12.class)
        public void setRegionId(int n) {
            this.regionId = n;
        }

        @versionClass(value=version12.class)
        public int getSetId() {
            return this.setId;
        }

        @versionClass(value=version12.class)
        public void setSetId(int n) {
            this.setId = n;
        }

        @versionClass(value=version12.class)
        public String getRangeType() {
            return this.rangeType;
        }

        @versionClass(value=version12.class)
        public void setRangeType(String string) {
            this.rangeType = string;
        }

        @versionClass(value=version12.class)
        public long getStartAddr() {
            return this.startAddr;
        }

        @versionClass(value=version12.class)
        public void setStartAddr(long l) {
            this.startAddr = l;
        }

        @versionClass(value=version12.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version12.class)
        public void setSize(long l) {
            this.size = l;
        }

        @versionClass(value=version12.class)
        public long getOffset() {
            return this.offset;
        }

        @versionClass(value=version12.class)
        public void setOffset(long l) {
            this.offset = l;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(320);
            stringBuilder.append("(vim.host.RegionInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("regionId = ");
            stringBuilder.append(this.getRegionId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("setId = ");
            stringBuilder.append(this.getSetId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("rangeType = ");
            stringBuilder.append(this.getRangeType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("startAddr = ");
            stringBuilder.append(this.getStartAddr());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("size = ");
            stringBuilder.append(this.getSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("offset = ");
            stringBuilder.append(this.getOffset());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmHealthInfo")
    @data
    @propertyOrder(value={"healthStatus", "healthInformation", "stateFlagInfo", "dimmTemperature", "dimmTemperatureThreshold", "spareBlocksPercentage", "spareBlockThreshold", "dimmLifespanPercentage", "esTemperature", "esTemperatureThreshold", "esLifespanPercentage"})
    public static class HealthInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String healthStatus;
        public String healthInformation;
        public String[] stateFlagInfo;
        public int dimmTemperature;
        public int dimmTemperatureThreshold;
        public int spareBlocksPercentage;
        public int spareBlockThreshold;
        public int dimmLifespanPercentage;
        public Integer esTemperature;
        public Integer esTemperatureThreshold;
        public Integer esLifespanPercentage;

        public HealthInfo() {
        }

        public HealthInfo(String string, String string2, String[] stringArray, int n, int n2, int n3, int n4, int n5, Integer n6, Integer n7, Integer n8) {
            this.healthStatus = string;
            this.healthInformation = string2;
            this.stateFlagInfo = stringArray;
            this.dimmTemperature = n;
            this.dimmTemperatureThreshold = n2;
            this.spareBlocksPercentage = n3;
            this.spareBlockThreshold = n4;
            this.dimmLifespanPercentage = n5;
            this.esTemperature = n6;
            this.esTemperatureThreshold = n7;
            this.esLifespanPercentage = n8;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthStatus() {
            return this.healthStatus;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthStatus(String string) {
            this.healthStatus = string;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthInformation() {
            return this.healthInformation;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthInformation(String string) {
            this.healthInformation = string;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public String[] getStateFlagInfo() {
            return this.stateFlagInfo;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setStateFlagInfo(String[] stringArray) {
            this.stateFlagInfo = stringArray;
        }

        @versionClass(value=version12.class)
        public int getDimmTemperature() {
            return this.dimmTemperature;
        }

        @versionClass(value=version12.class)
        public void setDimmTemperature(int n) {
            this.dimmTemperature = n;
        }

        @versionClass(value=version12.class)
        public int getDimmTemperatureThreshold() {
            return this.dimmTemperatureThreshold;
        }

        @versionClass(value=version12.class)
        public void setDimmTemperatureThreshold(int n) {
            this.dimmTemperatureThreshold = n;
        }

        @versionClass(value=version12.class)
        public int getSpareBlocksPercentage() {
            return this.spareBlocksPercentage;
        }

        @versionClass(value=version12.class)
        public void setSpareBlocksPercentage(int n) {
            this.spareBlocksPercentage = n;
        }

        @versionClass(value=version12.class)
        public int getSpareBlockThreshold() {
            return this.spareBlockThreshold;
        }

        @versionClass(value=version12.class)
        public void setSpareBlockThreshold(int n) {
            this.spareBlockThreshold = n;
        }

        @versionClass(value=version12.class)
        public int getDimmLifespanPercentage() {
            return this.dimmLifespanPercentage;
        }

        @versionClass(value=version12.class)
        public void setDimmLifespanPercentage(int n) {
            this.dimmLifespanPercentage = n;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsTemperature() {
            return this.esTemperature;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsTemperature(Integer n) {
            this.esTemperature = n;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsTemperatureThreshold() {
            return this.esTemperatureThreshold;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsTemperatureThreshold(Integer n) {
            this.esTemperatureThreshold = n;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsLifespanPercentage() {
            return this.esLifespanPercentage;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsLifespanPercentage(Integer n) {
            this.esLifespanPercentage = n;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(520);
            stringBuilder.append("(vim.host.HealthInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("healthStatus = ");
            stringBuilder.append(this.getHealthStatus());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("healthInformation = ");
            stringBuilder.append(this.getHealthInformation());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("stateFlagInfo = ");
            if (this.getStateFlagInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(STRING) [\n");
                for (n = 0; n < this.getStateFlagInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getStateFlagInfo()[n]);
                    if (n < this.getStateFlagInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimmTemperature = ");
            stringBuilder.append(this.getDimmTemperature());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimmTemperatureThreshold = ");
            stringBuilder.append(this.getDimmTemperatureThreshold());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("spareBlocksPercentage = ");
            stringBuilder.append(this.getSpareBlocksPercentage());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("spareBlockThreshold = ");
            stringBuilder.append(this.getSpareBlockThreshold());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dimmLifespanPercentage = ");
            stringBuilder.append(this.getDimmLifespanPercentage());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("esTemperature = ");
            stringBuilder.append(this.getEsTemperature());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("esTemperatureThreshold = ");
            stringBuilder.append(this.getEsTemperatureThreshold());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("esLifespanPercentage = ");
            stringBuilder.append(this.getEsLifespanPercentage());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNvdimmHealthInfoState")
        public static enum StateFlag {
            normal,
            error;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceType")
    public static enum NamespaceType {
        blockNamespace,
        persistentNamespace;

    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmRangeType")
    public static enum RangeType {
        volatileRange,
        persistentRange,
        controlRange,
        blockRange,
        volatileVirtualDiskRange,
        volatileVirtualCDRange,
        persistentVirtualDiskRange,
        persistentVirtualCDRange;

    }
}

