/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.InsufficientResourcesFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="HostSnmpSystem")
public interface SnmpSystem
extends ManagedObject {
    @readonly
    @name(value="configuration")
    @privilege(value="Global.Settings")
    @versionClass(value=version2.class)
    public void getConfiguration(Future<SnmpConfigSpec> var1);

    @name(value="configuration")
    public SnmpConfigSpec getConfiguration();

    @readonly
    @name(value="limits")
    @privilege(value="Global.Settings")
    @versionClass(value=version2.class)
    public void getLimits(Future<AgentLimits> var1);

    @name(value="limits")
    public AgentLimits getLimits();

    @versionClass(value=version2.class)
    @wsdlName(value="ReconfigureSnmpAgent")
    @privilege(value="Global.Settings")
    @faults(value={"NotFound", "InsufficientResourcesFault"})
    public void reconfigureSnmpAgent(@name(value="spec") @versionClass(value=version2.class) SnmpConfigSpec var1, Future<Void> var2);

    @wsdlName(value="ReconfigureSnmpAgent")
    public void reconfigureSnmpAgent(SnmpConfigSpec var1) throws NotFound, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="SendTestNotification")
    @privilege(value="Global.Settings")
    @faults(value={"NotFound", "InsufficientResourcesFault"})
    public void sendTestNotification(Future<Void> var1);

    @wsdlName(value="SendTestNotification")
    public void sendTestNotification() throws NotFound, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="HostSnmpSystemAgentLimits")
    @data
    @propertyOrder(value={"maxReadOnlyCommunities", "maxTrapDestinations", "maxCommunityLength", "maxBufferSize", "capability"})
    public static class AgentLimits
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int maxReadOnlyCommunities;
        public int maxTrapDestinations;
        public int maxCommunityLength;
        public int maxBufferSize;
        public Capability capability;

        public AgentLimits() {
        }

        public AgentLimits(int n, int n2, int n3, int n4, Capability capability) {
            this.maxReadOnlyCommunities = n;
            this.maxTrapDestinations = n2;
            this.maxCommunityLength = n3;
            this.maxBufferSize = n4;
            this.capability = capability;
        }

        @versionClass(value=version2.class)
        public int getMaxReadOnlyCommunities() {
            return this.maxReadOnlyCommunities;
        }

        @versionClass(value=version2.class)
        public void setMaxReadOnlyCommunities(int n) {
            this.maxReadOnlyCommunities = n;
        }

        @versionClass(value=version2.class)
        public int getMaxTrapDestinations() {
            return this.maxTrapDestinations;
        }

        @versionClass(value=version2.class)
        public void setMaxTrapDestinations(int n) {
            this.maxTrapDestinations = n;
        }

        @versionClass(value=version2.class)
        public int getMaxCommunityLength() {
            return this.maxCommunityLength;
        }

        @versionClass(value=version2.class)
        public void setMaxCommunityLength(int n) {
            this.maxCommunityLength = n;
        }

        @versionClass(value=version2.class)
        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        @versionClass(value=version2.class)
        public void setMaxBufferSize(int n) {
            this.maxBufferSize = n;
        }

        @optional
        @versionClass(value=version5.class)
        public Capability getCapability() {
            return this.capability;
        }

        @optional
        @versionClass(value=version5.class)
        public void setCapability(Capability capability) {
            this.capability = capability;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("(vim.host.AgentLimits) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("maxReadOnlyCommunities = ");
            stringBuilder.append(this.getMaxReadOnlyCommunities());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("maxTrapDestinations = ");
            stringBuilder.append(this.getMaxTrapDestinations());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("maxCommunityLength = ");
            stringBuilder.append(this.getMaxCommunityLength());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("maxBufferSize = ");
            stringBuilder.append(this.getMaxBufferSize());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("capability = ");
            stringBuilder.append((Object)this.getCapability());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version5.class)
        @wsdlName(value="HostSnmpAgentCapability")
        public static enum Capability {
            COMPLETE,
            DIAGNOSTICS,
            CONFIGURATION;

        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="HostSnmpConfigSpec")
    @data
    @propertyOrder(value={"enabled", "port", "readOnlyCommunities", "trapTargets", "option"})
    public static class SnmpConfigSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Boolean enabled;
        public Integer port;
        public String[] readOnlyCommunities;
        public Destination[] trapTargets;
        public KeyValue[] option;

        public SnmpConfigSpec() {
        }

        public SnmpConfigSpec(Boolean bl, Integer n, String[] stringArray, Destination[] destinationArray, KeyValue[] keyValueArray) {
            this.enabled = bl;
            this.port = n;
            this.readOnlyCommunities = stringArray;
            this.trapTargets = destinationArray;
            this.option = keyValueArray;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean isEnabled() {
            return this.enabled;
        }

        @optional
        @versionClass(value=version2.class)
        public Boolean getEnabled() {
            return this.enabled;
        }

        @optional
        @versionClass(value=version2.class)
        public void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        @optional
        @versionClass(value=version2.class)
        public Integer getPort() {
            return this.port;
        }

        @optional
        @versionClass(value=version2.class)
        public void setPort(Integer n) {
            this.port = n;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public String[] getReadOnlyCommunities() {
            return this.readOnlyCommunities;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setReadOnlyCommunities(String[] stringArray) {
            this.readOnlyCommunities = stringArray;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public Destination[] getTrapTargets() {
            return this.trapTargets;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public void setTrapTargets(Destination[] destinationArray) {
            this.trapTargets = destinationArray;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public KeyValue[] getOption() {
            return this.option;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public void setOption(KeyValue[] keyValueArray) {
            this.option = keyValueArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("(vim.host.SnmpConfigSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("enabled = ");
            stringBuilder.append(this.isEnabled());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("port = ");
            stringBuilder.append(this.getPort());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("readOnlyCommunities = ");
            if (this.getReadOnlyCommunities() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(STRING) [\n");
                for (n = 0; n < this.getReadOnlyCommunities().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getReadOnlyCommunities()[n]);
                    if (n < this.getReadOnlyCommunities().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("trapTargets = ");
            if (this.getTrapTargets() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.host.Destination) [\n");
                for (n = 0; n < this.getTrapTargets().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getTrapTargets()[n])), (boolean)true));
                    if (n < this.getTrapTargets().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("option = ");
            if (this.getOption() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.KeyValue) [\n");
                for (n = 0; n < this.getOption().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getOption()[n])), (boolean)true));
                    if (n < this.getOption().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version2.class)
        @wsdlName(value="HostSnmpDestination")
        @data
        @propertyOrder(value={"hostName", "port", "community"})
        public static class Destination
        extends DynamicDataImpl {
            private static final long serialVersionUID = 1L;
            public String hostName;
            public int port;
            public String community;

            public Destination() {
            }

            public Destination(String string, int n, String string2) {
                this.hostName = string;
                this.port = n;
                this.community = string2;
            }

            @versionClass(value=version2.class)
            public String getHostName() {
                return this.hostName;
            }

            @versionClass(value=version2.class)
            public void setHostName(String string) {
                this.hostName = string;
            }

            @versionClass(value=version2.class)
            public int getPort() {
                return this.port;
            }

            @versionClass(value=version2.class)
            public void setPort(int n) {
                this.port = n;
            }

            @versionClass(value=version2.class)
            public String getCommunity() {
                return this.community;
            }

            @versionClass(value=version2.class)
            public void setCommunity(String string) {
                this.community = string;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(200);
                stringBuilder.append("(vim.host.Destination) {\n");
                stringBuilder.append("   ");
                stringBuilder.append("dynamicType = ");
                stringBuilder.append(this.getDynamicType());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("dynamicProperty = ");
                if (this.getDynamicProperty() == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append("(vmodl.DynamicProperty) [\n");
                    for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                        stringBuilder.append("      ");
                        stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                        if (i < this.getDynamicProperty().length - 1) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("   ");
                    stringBuilder.append("]");
                }
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("hostName = ");
                stringBuilder.append(this.getHostName());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("port = ");
                stringBuilder.append(this.getPort());
                stringBuilder.append(",\n");
                stringBuilder.append("   ");
                stringBuilder.append("community = ");
                stringBuilder.append(this.getCommunity());
                stringBuilder.append("\n}");
                return stringBuilder.toString();
            }
        }
    }
}

