/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.version.version10;
import com.vmware.vim.binding.vim.version.version11;
import com.vmware.vim.binding.vim.version.version12;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vim.version.version8;
import com.vmware.vim.binding.vim.version.version9;
import com.vmware.vim.binding.vim.version.versions;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.concurrent.DiagnosticThreadPoolExecutor;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.net.ssl.SSLConfigurationProviderBuilder;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VcVersionDeterminationStrategy;
import com.vmware.vise.vim.commons.VcVersionException;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.ssl.SslUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.commons.vsphere.internal.Config;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VcServiceUtil {
    private static final Log _logger;
    private static final String PRODUCT_ID_EMBEDDED_ESX = "embeddedEsx";
    private static final String PRODUCT_ID_CLASSIC_ESX = "esx";
    public static final String DEFAULT_WSDL_NAMESPACE_OF_VC_VERSIONS;
    public static final String VIM_NAMESPACE = "urn:vim25";
    public static final VmodlVersion VC_VERSION_5_0_PUBLIC;
    public static final VmodlVersion VC_VERSION_5_1_PUBLIC;
    public static final VmodlVersion VC_VERSION_5_5_PUBLIC;
    public static final VmodlVersion VC_VERSION_6_0_PUBLIC;
    public static final VmodlVersion VC_VERSION_6_5_PUBLIC;
    public static final VmodlVersion VC_VERSION_6_6_PUBLIC;
    public static final VmodlVersion VC_VERSION_5_0_INTERNAL;
    public static final VmodlVersion VC_VERSION_5_1_INTERNAL;
    public static final VmodlVersion VC_VERSION_5_5_INTERNAL;
    public static final VmodlVersion VC_VERSION_6_0_INTERNAL;
    public static final VmodlVersion VC_VERSION_6_5_INTERNAL;
    public static final VmodlVersion VC_VERSION_6_6_INTERNAL;
    public static final VmodlVersion VC_VERSION_PUBLIC_INTERNAL;
    public static final VmodlVersion VC_VERSION_STABLE_INTERNAL;
    public static final VmodlVersion VC_VERSION_NEWEST_INTERNAL;
    public static final String VC_VERSION_NEWEST_ID_INTERNAL;
    private static final List<VmodlVersion> KNOWN_PUBLIC_VC_VMODL_VERSIONS;
    private static final List<VmodlVersion> KNOWN_INTERNAL_VC_VMODL_VERSIONS;
    private static final List<VmodlVersion> KNOWN_INTERNAL_STABLE_VC_VMODL_VERSIONS;
    private static final List<VmodlVersion> KNOWN_INTERNAL_UNSTABLE_VC_VMODL_VERSIONS;
    private static final Version VERSION_5_5;
    private static final Version VERSION_6_0;
    private static final Version VERSION_6_1;
    private static final Version VERSION_6_6;
    private static final Version VERSION_6_7;
    private static final Cache<String, Class<?>> VC_VERSION_CACHE_BY_VC_URL;
    private static final XPathExpression XPATH_EXPR_FIND_VIM_NAMESPACE;
    private static final XPathExpression XPATH_EXPR_FIND_API_VERSION;
    private static final AtomicReference<SSLConfigurationProvider> _sslConfigProviderRef;
    private static final DiagnosticThreadPoolExecutor EXECUTOR;

    @Deprecated
    @VisibleForTesting
    static void setDefaultSslConfigProvider(@Nullable SSLConfigurationProvider sSLConfigurationProvider) {
        _sslConfigProviderRef.set(sSLConfigurationProvider);
    }

    @Deprecated
    @Nonnull
    @VisibleForTesting
    static SSLConfigurationProvider getDefaultSslConfigProvider() {
        SSLConfigurationProvider sSLConfigurationProvider = _sslConfigProviderRef.get();
        if (sSLConfigurationProvider == null) {
            sSLConfigurationProvider = SSLConfigurationProviderBuilder.LEGACY_SSL_CONFIGURATION_PROVIDER;
        }
        return sSLConfigurationProvider;
    }

    public static String getServiceUrl(VcService vcService) {
        String string = vcService.getServiceUrl();
        return VcServiceUtil.formatServiceUrl(string);
    }

    public static String formatServiceUrl(String string) {
        int n = string.lastIndexOf("/sdk");
        return n == -1 ? string : string.substring(0, n);
    }

    @Deprecated
    public static HttpClient getSslSecuredHttpClient(VcService vcService) {
        return SslUtil.getHttpClient((String)vcService.getThumbprint());
    }

    public static HttpClient getSslSecuredHttpClient(VcService vcService, SSLConfigurationProvider sSLConfigurationProvider) {
        return new SSLBuilder().sslConfigurationProvider(sSLConfigurationProvider).thumbprint(vcService.getThumbprint()).buildHttpClientIgnoreErrors();
    }

    public static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string) {
        return VcServiceUtil.getServiceEndpoint(string, ServiceDirectory.ServiceProtocol.vimApi, null);
    }

    public static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string, ServiceDirectory.ServiceProtocol serviceProtocol, HttpSession httpSession) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry(httpSession);
        if (linkedVcGroupRegistry == null) {
            return null;
        }
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup == null) {
            return null;
        }
        return linkedVcGroup.getServiceEndpoint(string, serviceProtocol);
    }

    private static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string, ServiceDirectory.ServiceEndpoint[] serviceEndpointArray) throws Exception {
        for (ServiceDirectory.ServiceEndpoint serviceEndpoint : serviceEndpointArray) {
            if (!serviceEndpoint.instanceUuid.equals(string)) continue;
            return serviceEndpoint;
        }
        throw MixedUtil.getRuntimeFault(I18nUtil.getLocalizedString("error.serverNotFound", string));
    }

    public static String getServiceName(String string) {
        ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.getServiceEndpoint(string);
        if (serviceEndpoint != null) {
            return serviceEndpoint.instanceName;
        }
        return null;
    }

    public static Collection<VcService> retrieveServiceNames(@Nonnull LinkedVcGroupRegistry linkedVcGroupRegistry) throws InterruptedException {
        try {
            return VcServiceUtil.retrieveServiceNames(linkedVcGroupRegistry, -1L, null);
        }
        catch (TimeoutException timeoutException) {
            _logger.error((Object)"Timeout while retrieving VC names", (Throwable)timeoutException);
            return Collections.emptyList();
        }
    }

    public static Collection<VcService> retrieveServiceNames(@Nonnull LinkedVcGroupRegistry linkedVcGroupRegistry, long l, @Nullable TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        Validate.notNull((Object)linkedVcGroupRegistry);
        ArrayList<VcService> arrayList = new ArrayList<VcService>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (linkedVcGroup == null) continue;
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (vcService == null) continue;
                arrayList.add(vcService);
            }
        }
        VcServiceUtil.retrieveServiceNames(arrayList, l, timeUnit);
        return arrayList;
    }

    public static void retrieveServiceNames(@Nonnull Collection<VcService> collection) throws InterruptedException {
        try {
            VcServiceUtil.retrieveServiceNames(collection, -1L, null);
        }
        catch (TimeoutException timeoutException) {
            _logger.error((Object)"Timeout while retrieving VC names", (Throwable)timeoutException);
        }
    }

    public static void retrieveServiceNames(@Nonnull Collection<VcService> collection, long l, @Nullable TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        boolean bl;
        Validate.notNull(collection);
        ArrayList<VcService> arrayList = new ArrayList<VcService>();
        for (VcService object2 : collection) {
            if (object2 instanceof VcServiceImpl && ((VcServiceImpl)object2).isThereCachedServiceName()) continue;
            arrayList.add(object2);
            break;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl2 = bl = l > 0L && timeUnit != null;
        if (!bl && arrayList.size() == 1) {
            ((VcService)arrayList.get(0)).getServiceName(false);
            return;
        }
        ArrayList<1> arrayList2 = new ArrayList<1>(collection.size());
        for (VcService vcService : arrayList) {
            if (!VcServiceUtil.isAuthenticated(vcService)) continue;
            final VcService vcService2 = vcService;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    vcService2.getServiceName(false);
                }
            };
            arrayList2.add(runnable);
        }
        if (l > 0L && timeUnit != null) {
            ExecutorUtil.executeTasks(arrayList2, (Executor)EXECUTOR, (long)l, (TimeUnit)timeUnit);
        } else {
            ExecutorUtil.executeTasks(arrayList2, (Executor)EXECUTOR);
        }
    }

    private static boolean isAuthenticated(@Nonnull VcService vcService) {
        try {
            boolean bl = vcService.getConnectionInfo().getConnectionState();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String fetchServiceThumbprint(String string) throws Exception {
        ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.fetchServiceEndpoint(string);
        return serviceEndpoint.sslThumbprint;
    }

    public static ServiceDirectory.ServiceEndpoint fetchServiceEndpoint(String string) throws Exception {
        return VcServiceUtil.fetchServiceEndpoint(string, null);
    }

    private static ServiceDirectory.ServiceEndpoint fetchServiceEndpoint(String string, HttpSession httpSession) throws Exception {
        VcService vcService = VimSessionUtil.getService(string, httpSession);
        ServiceDirectory.ServiceEndpoint[] serviceEndpointArray = vcService.fetchServiceEndpoints();
        return VcServiceUtil.getServiceEndpoint(string, serviceEndpointArray);
    }

    public static ServiceDirectory.ServiceEndpoint[] fetchServiceEndpoints(VcService vcService) {
        ServiceDirectory.ServiceEndpoint[] serviceEndpointArray = vcService.fetchServiceEndpoints();
        return serviceEndpointArray;
    }

    public static boolean isEsxServer(AboutInfo aboutInfo) {
        if (aboutInfo == null) {
            return false;
        }
        return aboutInfo.productLineId.equals(PRODUCT_ID_CLASSIC_ESX) || aboutInfo.productLineId.equals(PRODUCT_ID_EMBEDDED_ESX);
    }

    public static String acquireSessionTicket(VcService vcService, ServiceDirectory.ServiceEndpoint serviceEndpoint) throws Exception {
        if (vcService == null) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.nullService", new String[0]));
        }
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.nullEndpoint", new String[0]));
        }
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject(serviceInstanceContent.getSessionManager());
        return sessionManager.acquireSessionTicket(serviceEndpoint.getKey());
    }

    public static SessionManager.GenericServiceTicket acquireGenericServiceTicket(HttpSession httpSession, String string, String string2) throws Exception {
        if (httpSession == null && (httpSession = SessionUtil.getHttpSession((boolean)false)) == null) {
            _logger.error((Object)"Session is null");
            throw new NotAuthenticatedError();
        }
        String string3 = SessionUtil.getClientId((HttpSession)httpSession);
        if (string3 == null) {
            _logger.error((Object)"cliendId is null");
            throw new NotAuthenticatedError();
        }
        return VcServiceUtil.acquireGenericServiceTicketByClientId(string3, string, string2);
    }

    public static SessionManager.GenericServiceTicket acquireGenericServiceTicketByClientId(String string, String string2, String string3) throws Exception {
        SessionManager.HttpServiceRequestSpec httpServiceRequestSpec = new SessionManager.HttpServiceRequestSpec();
        httpServiceRequestSpec.url = string2.replace("%20", " ");
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId(string);
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string3);
        VcService vcService = linkedVcGroup.getVcService(string3);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObjectByClientId(serviceInstanceContent.getSessionManager(), string);
        SessionManager.GenericServiceTicket genericServiceTicket = sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)httpServiceRequestSpec);
        return genericServiceTicket;
    }

    @Deprecated
    public static boolean isMNnextVcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return version.compareTo(new Version("5.1.0")) >= 0;
    }

    public static boolean isMNNextVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(new Version("5.1.0")) >= 0;
    }

    public static boolean isMNNextVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isMNNextVcOrLater(version);
    }

    public static boolean isMNNextVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isMNNextVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isMNNextVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_1_PUBLIC);
        return bl;
    }

    public static boolean isOPVcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.isOPVcOrLater(version);
    }

    public static boolean isOPVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isOPVcOrLater(version);
    }

    @CheckForNull
    public static Class<?> determineInternalStableVmodlVersionByStringVersion(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"serviceVersion shouldn't be null");
        if (string.equals(VC_VERSION_6_6_INTERNAL.getVersionId()) || string.equals(VC_VERSION_STABLE_INTERNAL.getVersionId()) || string.equals(VC_VERSION_NEWEST_ID_INTERNAL)) {
            return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_STABLE;
        }
        Version version = new Version(string);
        if (VcServiceUtil.is66VcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_STABLE;
        }
        if (VcServiceUtil.is65VcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version11.class;
        }
        if (VcServiceUtil.is60VcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version10.class;
        }
        if (VcServiceUtil.isOPVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version9.class;
        }
        if (VcServiceUtil.isMNNextVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version8.class;
        }
        if (VcServiceUtil.isMNVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version7.class;
        }
        return null;
    }

    @Nullable
    public static Class<?> determineVmodlVersionToUse(@Nonnull String string, @Nullable SSLConfigurationProvider sSLConfigurationProvider, @Nullable String string2, @Nullable String string3) {
        return VcServiceUtil.determineVmodlVersionToUse(string, sSLConfigurationProvider, string2, string3, Config.VC_VERSION_DETERMINATION_STRATEGY, null);
    }

    @Nullable
    @VisibleForTesting
    static Class<?> determineVmodlVersionToUse(final @Nonnull String string, final @Nullable SSLConfigurationProvider sSLConfigurationProvider, final @Nullable String string2, final @Nullable String string3, final @Nullable VcVersionDeterminationStrategy vcVersionDeterminationStrategy, final @Nullable VersionDeterminationCallback versionDeterminationCallback) {
        Validate.notEmpty((String)string, (String)"serviceUrl is empty");
        try {
            Class clazz = (Class)VC_VERSION_CACHE_BY_VC_URL.get((Object)string, new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    Class clazz = null;
                    if (versionDeterminationCallback != null && (clazz = versionDeterminationCallback.provideVmodlVersion()) != null) {
                        return clazz;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Fetching the supported VC versions from VC " + string));
                    }
                    clazz = VcServiceUtil.doDetermineVmodlVersionToUse(string, sSLConfigurationProvider, string2, string3, vcVersionDeterminationStrategy);
                    if (_logger.isDebugEnabled()) {
                        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
                        VmodlVersion vmodlVersion = vmodlVersionMap.getVersion(clazz);
                        _logger.debug((Object)("Determined VMODL version " + (clazz != null ? clazz.getName() : null) + (vmodlVersion != null ? " with ID '" + vmodlVersion.getVersionId() + "'" : "")));
                    }
                    return clazz;
                }
            });
            return clazz;
        }
        catch (Exception exception) {
            if (string3 == null) {
                _logger.error((Object)("Failed to retrieve the VC version for VC " + string), (Throwable)exception);
                return null;
            }
            Class<?> clazz = null;
            try {
                clazz = VcServiceUtil.determineInternalStableVmodlVersionByStringVersion(string3);
            }
            catch (Exception exception2) {
                _logger.error((Object)("Failed to determine the VMODL version by string version: " + string3), (Throwable)exception2);
            }
            if (clazz == null) {
                _logger.warn((Object)("Failed to determine the VMODL version of VC " + string + ") whose string version is \"" + string3 + "\""));
                return null;
            }
            if (!VcServiceUtil.isOPVcOrLater(clazz)) {
                _logger.warn((Object)("The VC version of VC " + string + " is too old (" + string3 + " / " + clazz.getName() + ") and it's not supported"));
                return null;
            }
            VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
            VmodlVersion vmodlVersion = vmodlVersionMap.getVersion(clazz);
            _logger.info((Object)("Because the string VC version is \"" + string3 + "\", will use VMODL version " + clazz.getName() + (vmodlVersion != null ? " with ID '" + vmodlVersion.getVersionId() + "'" : "") + " for VC " + string));
            return clazz;
        }
    }

    @Nonnull
    private static Class<?> doDetermineVmodlVersionToUse(@Nonnull String string, @Nullable SSLConfigurationProvider sSLConfigurationProvider, @Nullable String string2, @Nullable String string3, @Nullable VcVersionDeterminationStrategy vcVersionDeterminationStrategy) throws IOException {
        Validate.notEmpty((String)string, (String)"serviceUrl is empty");
        switch (vcVersionDeterminationStrategy) {
            case PUBLIC_VERSION_KNOWN_TO_CLIENT: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_PUBLIC;
            }
            case STABLE_VERSION_KNOWN_TO_CLIENT: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_STABLE;
            }
            case NEWEST_VERSION_KNOWN_TO_CLIENT: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_NEWEST;
            }
            case GREATEST_COMMON_STABLE_VERSION: 
            case ON_UNRECOGNIZED_VERSION__USE_PUBLIC: 
            case ON_UNRECOGNIZED_VERSION__USE_STABLE: 
            case ON_UNRECOGNIZED_VERSION__USE_NEWEST: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown VC version strategy: " + (Object)((Object)Config.VC_VERSION_DETERMINATION_STRATEGY));
            }
        }
        if (string2 == null) {
            return null;
        }
        if (sSLConfigurationProvider == null) {
            sSLConfigurationProvider = VcServiceUtil.getDefaultSslConfigProvider();
        }
        Class<?> clazz = VcServiceUtil.determineVmodlVersionToUseFromVc(string, sSLConfigurationProvider, string2, vcVersionDeterminationStrategy);
        _logger.info((Object)("Determined the stable internal VMODL version for VC " + string + ": " + clazz.getName() + " with id " + VmomiClientHelper.getVersionIdOfVmodlVersion(clazz)));
        return clazz;
    }

    public static boolean isOPVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_5_5) >= 0;
    }

    public static boolean isOPVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isOPVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isOPVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_5_PUBLIC);
        return bl;
    }

    @Deprecated
    public static boolean is2014VcOrLater(String string) {
        return VcServiceUtil.is60VcOrLater(string);
    }

    public static boolean is60VcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.is60VcOrLater(version);
    }

    @Deprecated
    public static boolean is2014VcOrLaterByVersion(String string) {
        return VcServiceUtil.is60VcOrLaterByVersion(string);
    }

    public static boolean is60VcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.is60VcOrLater(version);
    }

    @Deprecated
    public static boolean is2014VcOrLater(Version version) {
        return VcServiceUtil.is60VcOrLater(version);
    }

    public static boolean is60VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_0) >= 0;
    }

    @Deprecated
    public static boolean is2014VcOrLater(Class<?> clazz) {
        return VcServiceUtil.is60VcOrLater(clazz);
    }

    public static boolean is60VcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.is60VcOrLater(vmodlVersion);
        return bl;
    }

    @Deprecated
    public static boolean is2014VcOrLater(VmodlVersion vmodlVersion) {
        return VcServiceUtil.is60VcOrLater(vmodlVersion);
    }

    public static boolean is60VcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_6_0_PUBLIC);
        return bl;
    }

    public static boolean is65VcOrLaterByServerGuid(String string) {
        return VcServiceUtil.is65VcOrLaterByServerGuid(string, false);
    }

    public static boolean is65VcOrLaterByServerGuid(String string, boolean bl) {
        String string2 = VcServiceUtil.getVersion(string, bl);
        if (string2 == null) {
            return false;
        }
        Version version = new Version(string2);
        return VcServiceUtil.is65VcOrLater(version);
    }

    public static boolean is67VcOrLaterByServerGuid(String string, boolean bl) {
        String string2 = VcServiceUtil.getVersion(string, bl);
        if (string2 == null) {
            return false;
        }
        Version version = new Version(string2);
        return VcServiceUtil.is67VcOrLater(version);
    }

    public static boolean is65VcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.is65VcOrLater(version);
    }

    public static boolean is65VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_1) >= 0;
    }

    public static boolean is67VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_7) >= 0;
    }

    public static boolean is65VcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.is65VcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean is65VcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_6_5_PUBLIC);
        return bl;
    }

    public static boolean is66VcOrLaterByServerGuid(String string) {
        return VcServiceUtil.is66VcOrLaterByServerGuid(string, false);
    }

    public static boolean is66VcOrLaterByServerGuid(String string, boolean bl) {
        String string2 = VcServiceUtil.getVersion(string, bl);
        if (string2 == null) {
            return false;
        }
        Version version = new Version(string2);
        return VcServiceUtil.is66VcOrLater(version);
    }

    public static boolean is66VcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.is66VcOrLater(version);
    }

    public static boolean is66VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_6) >= 0;
    }

    public static boolean is66VcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.is66VcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean is66VcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_6_6_PUBLIC);
        return bl;
    }

    public static boolean areVersionsInSameRelease(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        VmodlVersion vmodlVersion2 = VcServiceUtil.getReleaseVersion(vmodlVersion);
        if (vmodlVersion2 == null) {
            return false;
        }
        String string = vmodlVersion2.getVersionId();
        if (string == null) {
            return false;
        }
        VmodlVersion vmodlVersion3 = VmomiClientHelper.getVmodlVersion(clazz2);
        VmodlVersion vmodlVersion4 = VcServiceUtil.getReleaseVersion(vmodlVersion3);
        if (vmodlVersion4 == null) {
            return false;
        }
        String string2 = vmodlVersion4.getVersionId();
        boolean bl = string.equals(string2);
        return bl;
    }

    public static boolean isKnownVersion(@Nonnull VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"vmodlVersion is null");
        VmodlVersion vmodlVersion2 = VcServiceUtil.getReleaseVersion(vmodlVersion);
        if (vmodlVersion2 == null) {
            return false;
        }
        if (KNOWN_PUBLIC_VC_VMODL_VERSIONS.contains(vmodlVersion2)) {
            return true;
        }
        return KNOWN_INTERNAL_VC_VMODL_VERSIONS.contains(vmodlVersion2);
    }

    @CheckForNull
    private static VmodlVersion getReleaseVersion(@Nonnull VmodlVersion vmodlVersion) {
        LinkedList linkedList = null;
        do {
            Set set;
            String string;
            if (!StringUtil.isNullOrEmpty((String)(string = vmodlVersion.getVersionId()))) {
                try {
                    new Version(string);
                    return vmodlVersion;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            if ((set = vmodlVersion.getParentVersion()) == null || set.size() <= 0) continue;
            linkedList.addAll(set);
        } while ((vmodlVersion = (VmodlVersion)linkedList.poll()) != null);
        return null;
    }

    @Deprecated
    public static boolean isMNVc(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return version.compareTo(new Version("5.0.0")) >= 0 && version.compareTo(new Version("5.1.0")) < 0;
    }

    public static boolean isMNVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(new Version("5.0.0")) >= 0;
    }

    public static boolean isMNVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isMNVcOrLater(version);
    }

    public static boolean isMNVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VmomiClientHelper.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isMNVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isMNVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_0_PUBLIC);
        return bl;
    }

    private static String getVersion(String string) {
        return VcServiceUtil.getVersion(string, false);
    }

    private static String getVersion(String string, boolean bl) {
        VcService vcService;
        if (!StringUtil.isNullOrEmpty((String)string) && (vcService = VimSessionUtil.getService(string)) != null) {
            return vcService.getServiceVersion();
        }
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Invalid guid, no matching VcService found: " + string);
    }

    public static String getWsdlNamespaceOfVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersion is null");
        wsdlName wsdlName2 = clazz.getAnnotation(wsdlName.class);
        if (wsdlName2 == null) {
            throw new IllegalArgumentException("The provided VIM version doesn't contain a @" + wsdlName.class.getSimpleName() + " annotation: " + clazz);
        }
        String string = wsdlName2.value();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The provided VIM version's @" + wsdlName.class.getSimpleName() + " annotation doesn't specify a version number: " + clazz);
        }
        return string;
    }

    public static LoginSpec createVcLoginSpec(@Nonnull ServerInfoEx serverInfoEx) {
        return VcServiceUtil.createVcLoginSpec(serverInfoEx, null);
    }

    public static LoginSpec createVcLoginSpec(@Nonnull ServerInfoEx serverInfoEx, @Nullable SSLConfigurationProvider sSLConfigurationProvider) {
        LoginSpec loginSpec = new LoginSpec();
        loginSpec.ssoDomain = serverInfoEx.ssoDomain;
        loginSpec.endpoints = serverInfoEx.endpoints;
        loginSpec.serviceUrl = serverInfoEx.serviceUrl;
        loginSpec.serviceGuid = serverInfoEx.serviceGuid;
        loginSpec.thumbprint = serverInfoEx.thumbprint;
        loginSpec.sslTrustAnchor = serverInfoEx.sslTrustAnchor;
        loginSpec.vmodlVersion = serverInfoEx.vmodlVersion;
        if (serverInfoEx.vmodlVersion == null) {
            loginSpec.vmodlVersion = VcServiceUtil.determineVmodlVersionToUse(serverInfoEx.serviceUrl, sSLConfigurationProvider, serverInfoEx.thumbprint, serverInfoEx.version);
        }
        return loginSpec;
    }

    @Deprecated
    public static boolean isVc61OrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.isVersion61OrLater(version);
    }

    @Deprecated
    public static boolean isVersion61OrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid version.");
        }
        return version.compareTo(new Version("6.1.0")) >= 0;
    }

    public static ServerInfoEx toServerInfoEx(VcService vcService) throws Exception {
        String string = vcService.getServiceGuid();
        ServiceDirectory.ServiceEndpoint serviceEndpoint = null;
        if (string != null) {
            serviceEndpoint = VcServiceUtil.getServiceEndpoint(string);
        }
        return VcServiceUtil.toServerInfoEx(vcService, serviceEndpoint);
    }

    public static ServerInfoEx toServerInfoEx(@Nonnull VcService vcService, @Nullable ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        LinkedVcGroupRegistry linkedVcGroupRegistry;
        LinkedVcGroup linkedVcGroup;
        ServerInfoEx serverInfoEx = new ServerInfoEx();
        serverInfoEx.serviceGuid = vcService.getServiceGuid();
        String string = URI.create(vcService.getServiceUrl()).getHost();
        serverInfoEx.serviceUrl = MixedUtil.isLocalhost(string) && serviceEndpoint != null ? serviceEndpoint.url : vcService.getServiceUrl();
        VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
        serverInfoEx.serviceInstance = vcService.getServiceInstance()._getRef();
        serverInfoEx.sessionCookie = vcServiceConnectionInfo.getSessionCookie();
        serverInfoEx.thumbprint = vcService.getThumbprint();
        serverInfoEx.errorCode = vcServiceConnectionInfo.getErrorCode();
        if (!vcServiceConnectionInfo.getConnectionState() && "noError".equals(vcServiceConnectionInfo.getErrorCode()) && (linkedVcGroup = (linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry()).getLinkedGroupByServiceUuid(vcService.getServiceGuid())) != null) {
            serverInfoEx.errorCode = VcServiceUtil.getLinkedVcGroupErrorCode(linkedVcGroup);
        }
        serverInfoEx.name = serviceEndpoint != null ? serviceEndpoint.instanceName : string;
        linkedVcGroupRegistry = vcServiceConnectionInfo.getUserSession();
        if (linkedVcGroupRegistry != null) {
            serverInfoEx.sessionKey = ((UserSession)linkedVcGroupRegistry).key;
        }
        if ((linkedVcGroup = vcService.getServiceInstanceContent()) != null) {
            serverInfoEx.content = linkedVcGroup;
            serverInfoEx.version = linkedVcGroup.getAbout().getVersion();
        } else {
            serverInfoEx.version = vcService.getServiceVersion();
        }
        return serverInfoEx;
    }

    private static String getLinkedVcGroupErrorCode(LinkedVcGroup linkedVcGroup) {
        if (linkedVcGroup == null) {
            return "connectError";
        }
        VcService vcService = linkedVcGroup.getStartUpVcService();
        if (vcService == null) {
            return "connectError";
        }
        VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
        String string = vcServiceConnectionInfo.getErrorCode();
        if (!"noError".equals(vcServiceConnectionInfo.getErrorCode())) {
            return string;
        }
        return "connectError";
    }

    @Nonnull
    public static String fetchApiVersionFromVc(@Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull String string, @Nullable String string2) throws IOException {
        String string3;
        String string4 = VcServiceUtil.downloadFileFromVc(sSLConfigurationProvider, string, string2, "/client/clients.xml");
        if (!StringUtil.isNullOrEmpty((String)string4) && !StringUtil.isNullOrWhitespace((String)(string3 = VcServiceUtil.getApiVersionFromClientXml(string4)))) {
            return string3;
        }
        throw new IllegalStateException("Failed to extract the API version from XML:\n" + string4);
    }

    private static String getApiVersionFromClientXml(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        Document document = XMLUtil.parseXml((String)string);
        if (document == null) {
            _logger.error((Object)"Client xml is null.");
            return null;
        }
        try {
            String string2 = (String)XPATH_EXPR_FIND_API_VERSION.evaluate(document, XPathConstants.STRING);
            if (StringUtil.isNullOrWhitespace((String)string2)) {
                return null;
            }
            return string2;
        }
        catch (Exception exception) {
            throw new VcVersionException("Failed to extract the apiVersion", exception);
        }
    }

    private static String downloadFileFromVc(@Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull String string, @Nullable String string2, @Nonnull String string3) throws IOException {
        String string4;
        URIBuilder uRIBuilder;
        URI uRI;
        try {
            uRI = new URI(string);
            uRIBuilder = new URIBuilder().setHost(uRI.getHost());
            int n = uRI.getPort();
            if (n >= 0) {
                uRIBuilder.setPort(n);
            }
            if (string2 == null) {
                uRIBuilder.setScheme("http");
            } else {
                uRIBuilder.setScheme("https");
            }
            uRIBuilder.setPath(string3);
            string4 = uRIBuilder.build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid service URL: " + string, uRISyntaxException);
        }
        try {
            uRI = new SSLBuilder().sslConfigurationProvider(sSLConfigurationProvider);
            if (string2 != null) {
                uRI.thumbprint(string2);
            }
            uRIBuilder = uRI.buildHttpClientIgnoreErrors();
            String string5 = uRIBuilder.executeMethod(string4, null, null);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(string3 + " downloaded successfully from " + string4 + ":\n" + string5));
            }
            return string5;
        }
        catch (Exception exception) {
            throw new IOException("Error when downloading file from " + string4, exception);
        }
    }

    @Nonnull
    private static Class<?> determineVmodlVersionToUseFromVc(@Nonnull String string, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nullable String string2, @Nullable VcVersionDeterminationStrategy vcVersionDeterminationStrategy) throws IOException {
        List<String> list = VcServiceUtil.fetchSupportedVersionIdsFromVc(string, sSLConfigurationProvider, string2);
        Class<?> clazz = VcServiceUtil.findSuitableVmodlVersion(list, vcVersionDeterminationStrategy);
        if (clazz == null) {
            throw new VcVersionException("The VC at URL " + string + " only supports versions " + list + " and neither of these version is supported by the vSphere Client");
        }
        return clazz;
    }

    @Nonnull
    private static List<String> fetchSupportedVersionIdsFromVc(@Nonnull String string, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nullable String string2) {
        try {
            String string3 = VcServiceUtil.downloadFileFromVc(sSLConfigurationProvider, string, string2, "/sdk/vimServiceVersions.xml");
            List<String> list = VcServiceUtil.extractSupportedVersionIdsFromVimServiceVersionsXml(string3);
            return list;
        }
        catch (Exception exception) {
            throw new VcVersionException("Failed to retrieve the supported versions for VC " + string, exception);
        }
    }

    @Nonnull
    private static List<String> extractSupportedVersionIdsFromVimServiceVersionsXml(@Nullable String string) {
        Node node;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return Collections.emptyList();
        }
        Document document = XMLUtil.parseXml((String)string);
        if (document == null) {
            throw new VcVersionException("Failed to parse the vimServiceVersions XML");
        }
        try {
            node = (Node)XPATH_EXPR_FIND_VIM_NAMESPACE.evaluate(document, XPathConstants.NODE);
        }
        catch (Exception exception) {
            throw new VcVersionException("Failed to locate the 'urn:vim25' namespace node", exception);
        }
        if (node == null) {
            throw new VcVersionException("Couldn't find a 'namespace' node for namespace 'urn:vim25'");
        }
        Element element = XMLUtil.getChildTag((Node)node, (String)"version");
        if (element == null) {
            throw new VcVersionException("Couldn't find a 'version' node in namespace 'urn:vim25'");
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string2 = VcServiceUtil.extractVersionIdStringFromVersionNode(element);
        arrayList.add(string2);
        Element element2 = XMLUtil.getChildTag((Node)node, (String)"priorVersions");
        if (element2 == null) {
            throw new VcVersionException("Couldn't find a 'priorVersions' node in namespace 'urn:vim25'");
        }
        List list = XMLUtil.getChildTags((Node)element2, (String)"version");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            element = (Element)list.get(i);
            try {
                String string3 = VcServiceUtil.extractVersionIdStringFromVersionNode(element);
                arrayList.add(string3);
                continue;
            }
            catch (VcVersionException vcVersionException) {
                throw new VcVersionException("Failed to extract a prior version", vcVersionException);
            }
        }
        return arrayList;
    }

    private static String extractVersionIdStringFromVersionNode(Node node) {
        String string = node.getTextContent();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new VcVersionException("A null or whitespace-only version detected");
        }
        return string;
    }

    @CheckForNull
    private static Class<?> findSuitableVmodlVersion(@Nonnull List<String> list, @Nonnull VcVersionDeterminationStrategy vcVersionDeterminationStrategy) {
        assert (vcVersionDeterminationStrategy == VcVersionDeterminationStrategy.GREATEST_COMMON_STABLE_VERSION || vcVersionDeterminationStrategy == VcVersionDeterminationStrategy.ON_UNRECOGNIZED_VERSION__USE_NEWEST || vcVersionDeterminationStrategy == VcVersionDeterminationStrategy.ON_UNRECOGNIZED_VERSION__USE_STABLE || vcVersionDeterminationStrategy == VcVersionDeterminationStrategy.ON_UNRECOGNIZED_VERSION__USE_PUBLIC);
        if (list.isEmpty()) {
            throw new IllegalStateException("vcVersionIds is empty");
        }
        for (String string : list) {
            Class clazz;
            VmodlVersion vmodlVersion = VcServiceUtil.findVmodlVersionByVersionId(KNOWN_INTERNAL_STABLE_VC_VMODL_VERSIONS, string);
            if (vmodlVersion != null) {
                clazz = vmodlVersion.getVersionClass();
                return clazz;
            }
            if (VcServiceUtil.findVmodlVersionByVersionId(KNOWN_INTERNAL_UNSTABLE_VC_VMODL_VERSIONS, string) != null) continue;
            _logger.error((Object)("VMODL mismatch detected. Version ID " + string + " is unknown"));
            switch (vcVersionDeterminationStrategy) {
                case ON_UNRECOGNIZED_VERSION__USE_PUBLIC: {
                    clazz = VC_VERSION_PUBLIC_INTERNAL;
                    break;
                }
                case ON_UNRECOGNIZED_VERSION__USE_STABLE: {
                    clazz = VC_VERSION_STABLE_INTERNAL;
                    break;
                }
                case ON_UNRECOGNIZED_VERSION__USE_NEWEST: {
                    clazz = VC_VERSION_NEWEST_INTERNAL;
                    break;
                }
                default: {
                    clazz = null;
                }
            }
            if (clazz == null) continue;
            _logger.warn((Object)("Version ID '" + string + "' is unrecognized. Returning version: " + clazz));
            return clazz.getVersionClass();
        }
        switch (vcVersionDeterminationStrategy) {
            case ON_UNRECOGNIZED_VERSION__USE_PUBLIC: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_PUBLIC;
            }
            case ON_UNRECOGNIZED_VERSION__USE_STABLE: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_STABLE;
            }
            case ON_UNRECOGNIZED_VERSION__USE_NEWEST: {
                return com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_NEWEST;
            }
        }
        return null;
    }

    @Nullable
    private static VmodlVersion findVmodlVersionByVersionId(@Nonnull List<VmodlVersion> list, @Nonnull String string) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            VmodlVersion vmodlVersion = list.get(i);
            if (!vmodlVersion.getVersionId().equals(string)) continue;
            return vmodlVersion;
        }
        return null;
    }

    @Nullable
    private static VmodlVersion findVmodlVersionByVersionClass(@Nonnull List<VmodlVersion> list, @Nonnull Class<?> clazz) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            VmodlVersion vmodlVersion = list.get(i);
            if (!vmodlVersion.getVersionClass().equals(clazz)) continue;
            return vmodlVersion;
        }
        return null;
    }

    public static String getInfoAboutEndpoints(ServiceEndpointEx[] serviceEndpointExArray) {
        StringBuilder stringBuilder = new StringBuilder(300);
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray) {
            VcServiceUtil.appendInfoAboutVcEndpoint(stringBuilder, serviceEndpointEx);
        }
        return stringBuilder.toString();
    }

    public static String getInfoAboutEndpoints(Collection<? extends ServiceEndpointEx> collection) {
        StringBuilder stringBuilder = new StringBuilder(300);
        for (ServiceEndpointEx serviceEndpointEx : collection) {
            VcServiceUtil.appendInfoAboutVcEndpoint(stringBuilder, serviceEndpointEx);
        }
        return stringBuilder.toString();
    }

    private static void appendInfoAboutVcEndpoint(StringBuilder stringBuilder, ServiceEndpointEx serviceEndpointEx) {
        if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.VC) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(',');
        }
        stringBuilder.append(serviceEndpointEx.getUrl()).append("(").append(serviceEndpointEx.getVcGuid()).append(',').append(serviceEndpointEx.getSsoDomain()).append(')');
    }

    @VisibleForTesting
    static void invalidateVcVersionCache() {
        VC_VERSION_CACHE_BY_VC_URL.invalidateAll();
    }

    static {
        Object object;
        Object object22;
        _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        DEFAULT_WSDL_NAMESPACE_OF_VC_VERSIONS = VcServiceUtil.getWsdlNamespaceOfVmodlVersion(version10.class);
        VERSION_5_5 = new Version("5.5.0");
        VERSION_6_0 = new Version("6.0.0");
        VERSION_6_1 = new Version("6.1.0");
        VERSION_6_6 = new Version("6.6.0");
        VERSION_6_7 = new Version("6.7.0");
        _sslConfigProviderRef = new AtomicReference<Object>(null);
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        for (Object object22 : versions.VIM_VERSIONS_LIST) {
            if (vmodlVersionMap.getVersion((Class)object22) != null) continue;
            vmodlVersionMap.addVersion((Class)object22);
        }
        for (Object object22 : com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSIONS_LIST) {
            if (vmodlVersionMap.getVersion((Class)object22) != null) continue;
            vmodlVersionMap.addVersion((Class)object22);
        }
        VC_VERSION_5_0_PUBLIC = VmomiClientHelper.getVmodlVersion(version7.class);
        VC_VERSION_5_1_PUBLIC = VmomiClientHelper.getVmodlVersion(version8.class);
        VC_VERSION_5_5_PUBLIC = VmomiClientHelper.getVmodlVersion(version9.class);
        VC_VERSION_6_0_PUBLIC = VmomiClientHelper.getVmodlVersion(version10.class);
        VC_VERSION_6_5_PUBLIC = VmomiClientHelper.getVmodlVersion(version11.class);
        VC_VERSION_6_6_PUBLIC = VmomiClientHelper.getVmodlVersion(version12.class);
        VC_VERSION_5_0_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version7.class);
        VC_VERSION_5_1_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version8.class);
        VC_VERSION_5_5_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version9.class);
        VC_VERSION_6_0_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version10.class);
        VC_VERSION_6_5_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version11.class);
        VC_VERSION_6_6_INTERNAL = VmomiClientHelper.getVmodlVersion(com.vmware.vim.binding.vim.version.internal.version12.class);
        VC_VERSION_PUBLIC_INTERNAL = VmomiClientHelper.getVmodlVersion((Class)com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_PUBLIC);
        VC_VERSION_STABLE_INTERNAL = VmomiClientHelper.getVmodlVersion((Class)com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_STABLE);
        VC_VERSION_NEWEST_INTERNAL = VmomiClientHelper.getVmodlVersion((Class)com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSION_NEWEST);
        VC_VERSION_NEWEST_ID_INTERNAL = VC_VERSION_NEWEST_INTERNAL.getVersionId();
        KNOWN_PUBLIC_VC_VMODL_VERSIONS = new ArrayList<VmodlVersion>(versions.VIM_VERSIONS_LIST.size());
        for (Object object22 : versions.VIM_VERSIONS_LIST) {
            try {
                object = VmomiClientHelper.getVmodlVersion((Class)object22);
                KNOWN_PUBLIC_VC_VMODL_VERSIONS.add((VmodlVersion)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExceptionInInitializerError("Problem while building the list of KNOWN_PUBLIC_VC_VMODL_VERSIONS: unrecognized version: " + ((Class)object22).getCanonicalName());
            }
        }
        KNOWN_INTERNAL_UNSTABLE_VC_VMODL_VERSIONS = VC_VERSION_NEWEST_INTERNAL.equals(VC_VERSION_STABLE_INTERNAL) ? Collections.emptyList() : Collections.singletonList(VC_VERSION_NEWEST_INTERNAL);
        KNOWN_INTERNAL_VC_VMODL_VERSIONS = new ArrayList<VmodlVersion>(com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSIONS_LIST.size());
        KNOWN_INTERNAL_STABLE_VC_VMODL_VERSIONS = new ArrayList<VmodlVersion>(com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSIONS_LIST.size() - 1);
        for (Object object22 : com.vmware.vim.binding.vim.version.internal.versions.VIM_VERSIONS_LIST) {
            try {
                object = VmomiClientHelper.getVmodlVersion((Class)object22);
                KNOWN_PUBLIC_VC_VMODL_VERSIONS.add((VmodlVersion)object);
                if (VcServiceUtil.findVmodlVersionByVersionClass(KNOWN_INTERNAL_UNSTABLE_VC_VMODL_VERSIONS, object22) != null) continue;
                KNOWN_INTERNAL_STABLE_VC_VMODL_VERSIONS.add((VmodlVersion)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExceptionInInitializerError("Problem while building the list of KNOWN_INTERNAL_VC_VMODL_VERSIONS: unrecognized version: " + ((Class)object22).getCanonicalName());
            }
        }
        VC_VERSION_CACHE_BY_VC_URL = CacheBuilder.newBuilder().expireAfterWrite(Config.VC_VERSION_CACHE_EXPIRATION_IN_MILLIS, TimeUnit.MILLISECONDS).build();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        object22 = xPathFactory.newXPath();
        object = "/namespaces/namespace[name='urn:vim25']";
        try {
            XPATH_EXPR_FIND_VIM_NAMESPACE = object22.compile((String)object);
        }
        catch (XPathExpressionException xPathExpressionException) {
            _logger.error((Object)("Failed to compile XPath expression: " + (String)object), (Throwable)xPathExpressionException);
            throw new ExceptionInInitializerError(xPathExpressionException);
        }
        object = "/ConfigRoot/clientConnection[1]/apiVersion/text()";
        try {
            XPATH_EXPR_FIND_API_VERSION = object22.compile((String)object);
        }
        catch (XPathExpressionException xPathExpressionException) {
            _logger.error((Object)("Failed to compile XPath expression: " + (String)object), (Throwable)xPathExpressionException);
            throw new ExceptionInInitializerError(xPathExpressionException);
        }
        String string = VcServiceUtil.class.getSimpleName();
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory(string);
        AbstractQueue abstractQueue = Config.VC_SERVICE_UTIL_THREAD_POOL_QUEUE_SIZE == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(Config.VC_SERVICE_UTIL_THREAD_POOL_QUEUE_SIZE);
        EXECUTOR = DiagnosticThreadPoolExecutor.builder((int)0, (int)Config.VC_SERVICE_UTIL_THREAD_POOL_MAX_SIZE, (long)1L, (TimeUnit)TimeUnit.MINUTES, abstractQueue, (ThreadFactory)workerThreadFactory).name(string).queueWaitTimeThreshold(Config.THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS, TimeUnit.NANOSECONDS).delayedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE).rejectedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE).minTimeApartForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS, TimeUnit.NANOSECONDS).build();
        ThreadPoolManager.getInstance().register((ExecutorService)EXECUTOR);
    }

    @VisibleForTesting
    static interface VersionDeterminationCallback {
        @Nullable
        public Class<?> provideVmodlVersion() throws Exception;
    }
}

