/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceEndpointEx
extends ServiceDirectory.ServiceEndpoint {
    private static final Log _logger = LogFactory.getLog(ServiceEndpointEx.class);
    private static final long serialVersionUID = 1L;
    public static final ServiceEndpointEx[] EMPTY_SERVICE_ENDPOINT_EX_ARRAY = new ServiceEndpointEx[0];
    private final SsoDomain _ssoDomain;
    private final String _nodeId;
    private final ServiceEndpointType _endpointType;
    private final String _hostId;
    private final String _host;
    private final String _version;
    private volatile int _cachedHashCode;
    private volatile String _cachedVcGuid;

    @Deprecated
    public ServiceEndpointEx(String string, ServiceEndpointType serviceEndpointType) {
        this(string, serviceEndpointType, null, null, null, null, null, null, null, null, null, null);
    }

    public ServiceEndpointEx(SsoDomain ssoDomain, String string, ServiceEndpointType serviceEndpointType) {
        this(ssoDomain, string, serviceEndpointType, null, null, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    public ServiceEndpointEx(String string, ServiceEndpointType serviceEndpointType, String string2, String string3, String string4, Integer n, String string5, String string6, String string7, String string8) {
        this(string, serviceEndpointType, null, string2, string3, string4, n, string5, string6, null, string7, string8);
    }

    public ServiceEndpointEx(SsoDomain ssoDomain, String string, ServiceEndpointType serviceEndpointType, String string2, String string3, String string4, Integer n, String string5, String string6, String string7, String string8) {
        this(ssoDomain, string, serviceEndpointType, null, string2, string3, string4, n, string5, string6, null, string7, string8);
    }

    @Deprecated
    public ServiceEndpointEx(String string, ServiceEndpointType serviceEndpointType, String string2, String string3, String string4, String string5, Integer n, String string6, String string7, String string8, String string9, String string10) {
        this(SsoDomain.getLocal(), string, serviceEndpointType, string2, string3, string4, string5, n, string6, string7, string8, string9, string10);
    }

    public ServiceEndpointEx(SsoDomain ssoDomain, String string, ServiceEndpointType serviceEndpointType, String string2, String string3, String string4, String string5, Integer n, String string6, String string7, String string8, String string9, String string10) {
        super(string3, string4, string5, n, string6, string7, string9, string10);
        String string11;
        if (ssoDomain == null) {
            throw new IllegalArgumentException("ssoDomain is null");
        }
        if (serviceEndpointType == null) {
            throw new IllegalArgumentException("endpointType is null");
        }
        this._ssoDomain = ssoDomain;
        this._nodeId = string;
        this._endpointType = serviceEndpointType;
        this._hostId = string2;
        try {
            string11 = URI.create(string7).getHost();
        }
        catch (Exception exception) {
            _logger.warn((Object)("Failed to extract the host from url " + string7), (Throwable)exception);
            string11 = null;
        }
        this._host = string11;
        this._version = string8;
    }

    @Deprecated
    public static ServiceEndpointEx buildVcServiceEndpoint(String string, String string2, String string3, String string4, String string5) {
        return ServiceEndpointEx.buildVcServiceEndpoint(string, null, string2, string3, string4, null, string5);
    }

    public static ServiceEndpointEx buildVcServiceEndpoint(SsoDomain ssoDomain, String string, String string2, String string3, String string4, String string5) {
        return ServiceEndpointEx.buildVcServiceEndpoint(ssoDomain, string, null, string2, string3, string4, null, string5);
    }

    @Deprecated
    public static ServiceEndpointEx buildVcServiceEndpoint(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return ServiceEndpointEx.buildVcServiceEndpoint(SsoDomain.getLocal(), string, string2, string3, string4, string5, string6, string7);
    }

    public static ServiceEndpointEx buildVcServiceEndpoint(SsoDomain ssoDomain, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = string3 + "/" + "VIMAPI";
        String string9 = ServiceDirectory.ServiceProtocol.vimApi.name();
        String string10 = ServiceEndpointEx.tryGetCertThumbprint(string7);
        ServiceEndpointEx serviceEndpointEx = new ServiceEndpointEx(ssoDomain, string, ServiceEndpointType.VC, string2, string8, string3, string4, null, string9, string5, string6, string10, string7);
        return serviceEndpointEx;
    }

    @Deprecated
    public static ServiceEndpointEx buildInventoryServiceEndpoint(String string, String string2, String string3, String string4, String string5) {
        return ServiceEndpointEx.buildInventoryServiceEndpoint(string, null, string2, string3, string4, null, string5);
    }

    public static ServiceEndpointEx buildInventoryServiceEndpoint(SsoDomain ssoDomain, String string, String string2, String string3, String string4, String string5) {
        return ServiceEndpointEx.buildInventoryServiceEndpoint(ssoDomain, string, null, string2, string3, string4, null, string5);
    }

    @Deprecated
    public static ServiceEndpointEx buildInventoryServiceEndpoint(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return ServiceEndpointEx.buildInventoryServiceEndpoint(SsoDomain.getLocal(), string, string2, string3, string4, string5, string6, string7);
    }

    public static ServiceEndpointEx buildInventoryServiceEndpoint(SsoDomain ssoDomain, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = string4 + "/" + "VIMWEBSVC";
        String string9 = "VSPHERE-INVENTORY-SERVICE/" + string3;
        String string10 = ServiceDirectory.ServiceProtocol.vimWebServices.name();
        String string11 = ServiceEndpointEx.tryGetCertThumbprint(string7);
        ServiceEndpointEx serviceEndpointEx = new ServiceEndpointEx(ssoDomain, string, ServiceEndpointType.IS, string2, string8, string4, string9, null, string10, string5, string6, string11, string7);
        return serviceEndpointEx;
    }

    public SsoDomain getSsoDomain() {
        return this._ssoDomain;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    @Deprecated
    public String getLduGuid() {
        return this.getNodeId();
    }

    public String getHostId() {
        return this._hostId;
    }

    public String getHost() {
        return this._host;
    }

    public String getVersion() {
        return this._version;
    }

    public ServiceEndpointType getServiceEndpointType() {
        return this._endpointType;
    }

    public void setKey(String string) {
        super.setKey(string);
        this._cachedHashCode = 0;
    }

    public static String getKeySuffix(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException("The serviceEndpoint should not be null");
        }
        String string = serviceEndpoint.getKey();
        if (string == null) {
            throw new IllegalStateException("The 'key' property in the service endpoint is null: " + serviceEndpoint.toString());
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            throw new IllegalStateException("Missing slash in service endpoint key: " + string);
        }
        if (n >= string.length() - 1) {
            throw new IllegalStateException("Empty suffix in service endpoint key: " + string);
        }
        String string2 = string.substring(n + 1);
        return string2;
    }

    private static String getInstanceNamePrefix(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException("The serviceEndpoint should not be null");
        }
        String string = serviceEndpoint.getInstanceName();
        if (string == null) {
            throw new IllegalStateException("The 'instanceName' property in the service endpoint is null: " + serviceEndpoint.toString());
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return null;
        }
        if (n >= string.length() - 1) {
            throw new IllegalStateException("Empty prefix in service endpoint key: " + string);
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    public String getVcGuid() {
        String string;
        if (this._endpointType == ServiceEndpointType.VC) {
            return this.getInstanceUuid();
        }
        if (this._endpointType != ServiceEndpointType.IS) {
            throw new UnsupportedOperationException("VC GUID cannot be determined for endpoints of type " + (Object)((Object)this._endpointType));
        }
        String string2 = this._cachedVcGuid;
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getInstanceName();
        if (string3 == null) {
            throw new IllegalStateException("The 'instanceName' property in the service endpoint is null: " + this.toString());
        }
        int n = string3.lastIndexOf(47);
        if (n < 0) {
            throw new IllegalStateException("Missing slash in service endpoint instanceName: " + string3);
        }
        if (n >= string3.length() - 1) {
            throw new IllegalStateException("Empty suffix in service endpoint instanceName: " + string3);
        }
        this._cachedVcGuid = string = string3.substring(n + 1);
        return string;
    }

    public static ServiceEndpointType determineServiceEndpointType(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        String string = serviceEndpoint.getProtocol();
        String string2 = ServiceEndpointEx.getInstanceNamePrefix(serviceEndpoint);
        if (ServiceDirectory.ServiceProtocol.vimApi.name().equals(string)) {
            return ServiceEndpointType.VC;
        }
        if (ServiceDirectory.ServiceProtocol.vimWebServices.name().equals(string) && "VSPHERE-INVENTORY-SERVICE".equals(string2)) {
            return ServiceEndpointType.IS;
        }
        return ServiceEndpointType.UNKNOWN;
    }

    @Deprecated
    public static ServiceEndpointEx toServiceEndpointEx(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        return ServiceEndpointEx.toServiceEndpointEx(SsoDomain.getLocal(), serviceEndpoint);
    }

    public static ServiceEndpointEx toServiceEndpointEx(SsoDomain ssoDomain, ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        ServiceEndpointType serviceEndpointType = ServiceEndpointEx.determineServiceEndpointType(serviceEndpoint);
        ServiceEndpointEx serviceEndpointEx = new ServiceEndpointEx(ssoDomain, null, serviceEndpointType, serviceEndpoint.key, serviceEndpoint.instanceUuid, serviceEndpoint.instanceName, serviceEndpoint.vcInstanceId, serviceEndpoint.protocol, serviceEndpoint.url, serviceEndpoint.sslThumbprint, serviceEndpoint.certificate);
        return serviceEndpointEx;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ServiceEndpointEx) {
            ServiceEndpointEx serviceEndpointEx = (ServiceEndpointEx)((Object)object);
            String string = this.getKey();
            String string2 = serviceEndpointEx.getKey();
            boolean bl = ObjectUtil.objectsEqual((Object)this._ssoDomain, (Object)serviceEndpointEx._ssoDomain) && ObjectUtil.objectsEqual((Object)this._nodeId, (Object)serviceEndpointEx._nodeId) && this._endpointType == serviceEndpointEx._endpointType && ObjectUtil.objectsEqual((Object)this._hostId, (Object)serviceEndpointEx._hostId) && ObjectUtil.objectsEqual((Object)string, (Object)string2);
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this._cachedHashCode;
        if (n == 0) {
            String string = this.getKey();
            n = 17;
            n = 31 * n + (this._ssoDomain != null ? this._ssoDomain.hashCode() : 0);
            n = 31 * n + (this._nodeId != null ? this._nodeId.hashCode() : 0);
            n = 31 * n + this._endpointType.ordinal();
            n = 31 * n + (this._hostId != null ? this._hostId.hashCode() : 0);
            this._cachedHashCode = n = 31 * n + (string != null ? string.hashCode() : 0);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append(((Object)((Object)this)).getClass().getSimpleName()).append("\n   ").append("ssoDomain: ").append(this._ssoDomain).append("\n   ").append("nodeId: ").append(this._nodeId).append("\n   ").append("serviceEndpointType: ").append((Object)this._endpointType).append("\n   ").append("hostId: ").append(this._hostId).append("\n   ").append("key: ").append(this.getKey()).append("\n   ").append("instanceUuid: ").append(this.getInstanceUuid()).append("\n   ").append("instanceName: ").append(this.getInstanceName()).append("\n   ").append("vcInstanceId: ").append(this.getVcInstanceId()).append("\n   ").append("protocol: ").append(this.getProtocol()).append("\n   ").append("url: ").append(this.getUrl()).append("\n   ").append("sslThumbprint: ").append(this.getSslThumbprint());
        String string = stringBuilder.toString();
        return string;
    }

    private static String tryGetCertThumbprint(String string) {
        String string2;
        try {
            string2 = string == null ? null : CertificateUtil.getThumbprint((String)string);
        }
        catch (Exception exception) {
            string2 = null;
            _logger.error((Object)"Error when computing vc thumbprint from certificate", (Throwable)exception);
        }
        return string2;
    }
}

