/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice.impl;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.version.internal.version9;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.concurrent.DiagnosticThreadPoolExecutor;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VcSessionListener;
import com.vmware.vise.vim.commons.vcservice.CompatibilityException;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.PeerVcConnectionError;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityResult;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.commons.vcservice.impl.VcSessionListenerRegistry;
import com.vmware.vise.vim.commons.vsphere.internal.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinkedVcGroupImpl
implements LinkedVcGroup {
    private static final Integer NOT_AUTHENTICATED = 0;
    private static final Integer AUTHENTICATING = 1;
    private static final Integer LOGGED_IN = 2;
    private static final Integer LOGGED_OUT = 3;
    private static final String VMODL_VERSION_ERROR = "Disabled version URI";
    private final AtomicReference<ServiceEndpointEx[]> _serviceEndPointsRef;
    private final LoginSpec _loginSpec;
    private final NotAuthenticatedCallbackImpl _notAuthenticatedCb;
    private final VcRegistry _vcRegistry;
    private final VcSessionListenerRegistry _vcSessionListenerRegistry;
    @Nullable
    private final ConfigurationService _configurationService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final AtomicInteger _authStatus = new AtomicInteger(0);
    private final List<VcServiceCompatibilityResult> _incompatibleVcs;
    private static final String POOL_NAME = "linkedVcGroup-pool";
    private static final DiagnosticThreadPoolExecutor EXECUTOR;
    private static final AtomicBoolean _alreadyAssignedConfigServiceToExecutor;
    private static final Log _logger;
    private final AtomicInteger _missingVcServiceCounter = new AtomicInteger(0);

    public LinkedVcGroupImpl(@Nonnull LoginSpec loginSpec) throws Exception {
        this(loginSpec, null, null, null);
    }

    public LinkedVcGroupImpl(@Nonnull LoginSpec loginSpec, @Nullable VcServiceCompatibilityChecker vcServiceCompatibilityChecker, @Nullable ConfigurationService configurationService, @Nullable SSLConfigurationProvider sSLConfigurationProvider) throws Exception {
        this(loginSpec, vcServiceCompatibilityChecker, configurationService, sSLConfigurationProvider, null);
    }

    public LinkedVcGroupImpl(@Nonnull LoginSpec loginSpec, @Nullable VcServiceCompatibilityChecker vcServiceCompatibilityChecker, @Nullable ConfigurationService configurationService, @Nullable SSLConfigurationProvider sSLConfigurationProvider, @Nullable Collection<? extends ServiceEndpointEx> collection) throws Exception {
        Object object;
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{loginSpec});
        HashMap<String, VcServiceImpl> hashMap = new HashMap<String, VcServiceImpl>();
        this._vcSessionListenerRegistry = new VcSessionListenerRegistry();
        this._loginSpec = loginSpec;
        this._configurationService = configurationService;
        if (configurationService != null && !_alreadyAssignedConfigServiceToExecutor.getAndSet(true)) {
            EXECUTOR.useConfigurationService(configurationService);
        }
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._notAuthenticatedCb = new NotAuthenticatedCallbackImpl(this._loginSpec);
        VcServiceImpl vcServiceImpl = LinkedVcGroupImpl.createVcService(this._loginSpec, this._notAuthenticatedCb, this._vcSessionListenerRegistry, this._configurationService, this._sslConfigurationProvider);
        if (vcServiceCompatibilityChecker != null && !(bl = ((VcServiceCompatibilityResult)(object = vcServiceCompatibilityChecker.verify(vcServiceImpl))).isCompatible())) {
            String string = ((VcServiceCompatibilityResult)object).getLocalizedErrorMessage();
            String string2 = I18nUtil.getLocalizedString("linkedVcGroup.startupVcServiceIsIncompatible", new String[0]);
            string2 = String.format(string2, string);
            String string3 = vcServiceImpl.getServiceVersion();
            _logger.error((Object)("Startup VC " + vcServiceImpl.getServiceUrl() + " is not compatible: " + ((VcServiceCompatibilityResult)object).getFailure().toString() + (StringUtil.isNullOrWhitespace((String)string3) ? "" : " (version: " + string3 + ")")));
            throw new CompatibilityException(string);
        }
        object = vcServiceImpl.getServiceEndPoints();
        hashMap.put(vcServiceImpl.getServiceGuid(), vcServiceImpl);
        ArrayList<VcServiceCompatibilityResult> arrayList = null;
        List<VcServiceImpl> list = this.fetchPeerServers((ServiceEndpointEx[])object, collection, vcServiceImpl, this._loginSpec, this._notAuthenticatedCb, this._vcSessionListenerRegistry);
        for (VcServiceImpl collection2 : list) {
            VcServiceCompatibilityResult vcServiceCompatibilityResult;
            boolean bl2;
            if (vcServiceCompatibilityChecker != null && !(bl2 = (vcServiceCompatibilityResult = vcServiceCompatibilityChecker.verify(collection2)).isCompatible())) {
                if (arrayList == null) {
                    arrayList = new ArrayList<VcServiceCompatibilityResult>(5);
                }
                arrayList.add(vcServiceCompatibilityResult);
                String string = collection2.getServiceVersion();
                _logger.error((Object)("Peer VC " + collection2.getServiceUrl() + " is not compatible: " + vcServiceCompatibilityResult.getFailure().toString() + (StringUtil.isNullOrWhitespace((String)string) ? "" : " (version: " + string + ")")));
                continue;
            }
            VcServiceImpl vcServiceImpl2 = hashMap.put(collection2.getServiceGuid(), collection2);
            if (vcServiceImpl2 == null) continue;
            _logger.warn((Object)("Overwrote a VcService in initialServiceByServiceGuid. GUID: " + collection2.getServiceGuid() + ", preexisting URL: " + vcServiceImpl2.getServiceUrl() + ", new URL: " + collection2.getServiceUrl()));
        }
        if (arrayList != null) {
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            for (VcServiceCompatibilityResult vcServiceCompatibilityResult : arrayList) {
                arrayList2.add(vcServiceCompatibilityResult.getVcService());
            }
            Collection collection2 = hashMap.values();
            for (VcServiceImpl vcServiceImpl3 : collection2) {
                vcServiceImpl3.removeServiceEndpointsRelatedToVcServices(arrayList2);
            }
            object = vcServiceImpl.getServiceEndPoints();
            this._incompatibleVcs = Collections.unmodifiableList(arrayList);
        } else {
            this._incompatibleVcs = Collections.emptyList();
        }
        this._vcRegistry = new VcRegistry(hashMap);
        this._vcRegistry.setStartupVcService(vcServiceImpl);
        this._notAuthenticatedCb._vcRegistry = this._vcRegistry;
        NotAuthenticatedCallbackImpl.access$102(this._notAuthenticatedCb, (ServiceEndpointEx[])object);
        this._serviceEndPointsRef = new AtomicReference<Object>(object);
    }

    @Override
    public void login() throws Exception {
        boolean bl = this._authStatus.compareAndSet(NOT_AUTHENTICATED, AUTHENTICATING);
        if (!bl) {
            _logger.warn((Object)"invoked login more than once");
            return;
        }
        VcServiceImpl vcServiceImpl = this._vcRegistry.getStartupVcService();
        if (vcServiceImpl == null) {
            throw new IllegalStateException(I18nUtil.getLocalizedString("linkedVcGroup.notInitialized", new String[0]));
        }
        Exception exception = null;
        boolean bl2 = false;
        _logger.info((Object)("Logging into startup VC: " + vcServiceImpl.getServiceUrl()));
        try {
            vcServiceImpl.login();
            bl2 = true;
            _logger.info((Object)("Login successful to start-up VC: " + vcServiceImpl.getServiceUrl()));
        }
        catch (Exception exception2) {
            _logger.warn((Object)"Login to the start-up vc failed, we are now attempting login to other peer servers.", (Throwable)exception2);
            exception = exception2;
        }
        this.loginToPeerServers(vcServiceImpl);
        if (!bl2) {
            Collection<VcServiceImpl> collection = this._vcRegistry.getInitialVcServices();
            for (VcService vcService : collection) {
                VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
                if (!vcServiceConnectionInfo.getConnectionState()) continue;
                this._vcRegistry.setStartupVcService((VcServiceImpl)vcService);
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            throw exception;
        }
        boolean bl3 = this._authStatus.compareAndSet(AUTHENTICATING, LOGGED_IN);
        if (!bl3) {
            throw new IllegalStateException("failure to update login status.");
        }
    }

    @Override
    public boolean supportsLoginByToken() {
        VcServiceImpl vcServiceImpl = this._vcRegistry.getStartupVcService();
        boolean bl = vcServiceImpl.supportsLoginByToken();
        return bl;
    }

    @Override
    public void logout() {
        boolean bl = this._authStatus.compareAndSet(LOGGED_IN, LOGGED_OUT);
        if (!bl) {
            _logger.warn((Object)"Not logged in to this vc group");
            return;
        }
        this._vcRegistry.shutdown();
        List<VcServiceImpl> list = this._vcRegistry.getVcServices();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<1> arrayList = new ArrayList<1>(list.size());
        for (final VcServiceImpl vcServiceImpl : list) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        vcServiceImpl.logout();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"Failed to logout", (Throwable)exception);
                    }
                }

                public String toString() {
                    return LinkedVcGroupImpl.class.getSimpleName() + ":vcService.logout";
                }
            };
            arrayList.add(runnable);
        }
        try {
            ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            _logger.error((Object)"Timed out while waiting for VC logout tasks to complete. Will proceed with the rest of the logout.", (Throwable)timeoutException);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failure occurred in the VC logout tasks.Will proceed with the rest of the logout.", (Throwable)exception);
        }
    }

    @Override
    public Collection<VcService> getVcServices() {
        ArrayList<VcService> arrayList = new ArrayList<VcService>();
        List<VcServiceImpl> list = this._vcRegistry.getVcServices();
        for (VcService vcService : list) {
            VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
            if (!"noError".equals(vcServiceConnectionInfo.getErrorCode())) continue;
            arrayList.add(vcService);
        }
        return arrayList;
    }

    @Override
    public VcService getVcService(String string) {
        VcServiceImpl vcServiceImpl = this._vcRegistry.getVcService(string);
        if (vcServiceImpl == null && _logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("getVcService returned null for: ").append(string);
            if (this._missingVcServiceCounter.getAndIncrement() % 20 == 0) {
                stringBuilder.append("\nVCs in group: ");
                List<VcServiceImpl> list = this._vcRegistry.getVcServices();
                LinkedVcGroupImpl.appendInfoAboutVCs(stringBuilder, list);
                stringBuilder.append('\n').append(ExceptionUtil.getCurrentStackTrace());
            }
            _logger.debug((Object)stringBuilder.toString());
        }
        return vcServiceImpl;
    }

    private static void appendInfoAboutVCs(StringBuilder stringBuilder, Collection<? extends VcService> collection) {
        boolean bl = false;
        for (VcService vcService : collection) {
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            stringBuilder.append(vcService.getServiceUrl()).append('(').append(vcService.getServiceGuid()).append(')');
        }
    }

    @Override
    public VcService getStartUpVcService() {
        VcServiceImpl vcServiceImpl = this._vcRegistry.getStartupVcService();
        return vcServiceImpl;
    }

    @Override
    public ServiceEndpointEx[] getServiceEndPoints() {
        ServiceEndpointEx[] serviceEndpointExArray = this._serviceEndPointsRef.get();
        serviceEndpointExArray = Arrays.copyOf(serviceEndpointExArray, serviceEndpointExArray.length);
        return serviceEndpointExArray;
    }

    @Override
    public ServiceEndpointEx getServiceEndpoint(String string, ServiceDirectory.ServiceProtocol serviceProtocol) {
        ServiceEndpointEx[] serviceEndpointExArray;
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = this._serviceEndPointsRef.get()) {
            if (!serviceEndpointEx.instanceUuid.equals(string) || !serviceEndpointEx.protocol.equals(serviceProtocol.name())) continue;
            return serviceEndpointEx;
        }
        return null;
    }

    private ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string, ServiceEndpointType serviceEndpointType) {
        ServiceEndpointEx[] serviceEndpointExArray;
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = this._serviceEndPointsRef.get()) {
            if (!serviceEndpointEx.instanceUuid.equals(string) || serviceEndpointEx.getServiceEndpointType() != serviceEndpointType) continue;
            return serviceEndpointEx;
        }
        return null;
    }

    @Nonnull
    public Collection<VcServiceCompatibilityResult> getIncompatibleVcs() {
        return this._incompatibleVcs;
    }

    @Override
    public ManagedObject getManagedObject(ManagedObjectReference managedObjectReference) throws Exception {
        Object object;
        VcServiceConnectionInfo vcServiceConnectionInfo;
        if (managedObjectReference == null || StringUtil.isNullOrEmpty((String)managedObjectReference.getValue())) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidMoref", new String[0]));
        }
        if (LOGGED_IN.intValue() != this._authStatus.get()) {
            _logger.warn((Object)"Linked vc group not logged in");
            return null;
        }
        VcServiceImpl vcServiceImpl = this._vcRegistry.getStartupVcService();
        if (StringUtil.isNullOrEmpty((String)managedObjectReference.getServerGuid())) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidMoref", new String[0]));
        }
        String string = managedObjectReference.getServerGuid();
        VcServiceImpl vcServiceImpl2 = this._vcRegistry.getVcService(string);
        if (vcServiceImpl2 == null && string != null && (vcServiceConnectionInfo = this.getServiceEndpoint(string, ServiceEndpointType.VC)) != null) {
            object = this._serviceEndPointsRef.get();
            Callable<VcServiceImpl> callable = this.getInitializeVcTask(vcServiceImpl, (ServiceEndpointEx[])object, (ServiceDirectory.ServiceEndpoint)vcServiceConnectionInfo, this._loginSpec, this._notAuthenticatedCb, this._vcSessionListenerRegistry);
            FutureTask<VcServiceImpl> futureTask = new FutureTask<VcServiceImpl>(callable);
            if ((futureTask = this._vcRegistry.addVcService(string, futureTask)) == null) {
                _logger.warn((Object)"Linked vc group already logged out. Can't create new Vc");
                return null;
            }
            vcServiceImpl2 = futureTask.get();
            if (vcServiceImpl2 == null) {
                throw new PeerVcConnectionError(vcServiceConnectionInfo.getUrl(), null);
            }
            String string2 = "Added VC " + vcServiceImpl2.getServiceUrl() + " (" + vcServiceImpl2.getServiceGuid() + ")";
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(string2 + "\n" + ExceptionUtil.getCurrentStackTrace()));
            } else {
                _logger.info((Object)string2);
            }
        }
        if (!(vcServiceConnectionInfo = vcServiceImpl2.getConnectionInfo()).getConnectionState()) {
            object = this._serviceEndPointsRef.get();
            LinkedVcGroupImpl.loginToPeerService(vcServiceImpl2, vcServiceImpl, this._loginSpec, object);
        }
        object = vcServiceImpl2.getManagedObject(managedObjectReference);
        return object;
    }

    @Override
    public void addVcSessionListener(VcSessionListener vcSessionListener) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vcSessionListener});
        this._vcSessionListenerRegistry.addListener(vcSessionListener);
    }

    @Override
    public boolean removeVcSessionListener(VcSessionListener vcSessionListener) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vcSessionListener});
        return this._vcSessionListenerRegistry.removeListener(vcSessionListener);
    }

    public static VcServiceImpl createVcService(LoginSpec loginSpec, VcServiceImpl.NotAuthenticatedCallback notAuthenticatedCallback, VcSessionListenerRegistry vcSessionListenerRegistry, @Nullable ConfigurationService configurationService, @Nullable SSLConfigurationProvider sSLConfigurationProvider) throws Exception {
        VcServiceImpl vcServiceImpl = null;
        try {
            vcServiceImpl = new VcServiceImpl(loginSpec, notAuthenticatedCallback, vcSessionListenerRegistry, configurationService, sSLConfigurationProvider);
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            if (!StringUtil.isNullOrEmpty((String)string) && string.contains(VMODL_VERSION_ERROR)) {
                loginSpec.vmodlVersion = version9.class;
                vcServiceImpl = new VcServiceImpl(loginSpec, notAuthenticatedCallback, vcSessionListenerRegistry, configurationService, sSLConfigurationProvider);
            }
            throw runtimeException;
        }
        return vcServiceImpl;
    }

    private Callable<VcServiceImpl> getInitializeVcTask(final VcServiceImpl vcServiceImpl, final ServiceEndpointEx[] serviceEndpointExArray, final ServiceDirectory.ServiceEndpoint serviceEndpoint, final LoginSpec loginSpec, final NotAuthenticatedCallbackImpl notAuthenticatedCallbackImpl, final VcSessionListenerRegistry vcSessionListenerRegistry) {
        assert (vcServiceImpl != null);
        assert (serviceEndpointExArray != null);
        assert (serviceEndpoint != null);
        assert (loginSpec != null);
        assert (notAuthenticatedCallbackImpl != null);
        assert (vcSessionListenerRegistry != null);
        Callable<VcServiceImpl> callable = new Callable<VcServiceImpl>(){

            @Override
            public VcServiceImpl call() {
                VcServiceImpl vcServiceImpl2 = null;
                try {
                    vcServiceImpl2 = LinkedVcGroupImpl.this.createPeerService(loginSpec, (ServiceEndpointEx)serviceEndpoint, serviceEndpointExArray, notAuthenticatedCallbackImpl, vcSessionListenerRegistry);
                    LinkedVcGroupImpl.loginToPeerService(vcServiceImpl2, vcServiceImpl, loginSpec, serviceEndpointExArray);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to connect to peer vCenter server - " + serviceEndpoint.url), (Throwable)exception);
                }
                return vcServiceImpl2;
            }

            public String toString() {
                return "InitializeVcTask:" + vcServiceImpl.getServiceUrl();
            }
        };
        return callable;
    }

    private static VcServiceConnectionInfo loginToPeerService(VcServiceImpl vcServiceImpl, VcServiceImpl vcServiceImpl2, LoginSpec loginSpec, ServiceEndpointEx[] serviceEndpointExArray) throws Exception {
        if (LinkedVcGroupImpl.supportsLoginByTicket(vcServiceImpl, vcServiceImpl2) && vcServiceImpl2.getConnectionInfo().getConnectionState() || loginSpec.cloneSessionTicket != null) {
            VcServiceConnectionInfo vcServiceConnectionInfo = LinkedVcGroupImpl.loginToPeerServiceByTicket(vcServiceImpl, vcServiceImpl2, serviceEndpointExArray);
            return vcServiceConnectionInfo;
        }
        VcServiceConnectionInfo vcServiceConnectionInfo = vcServiceImpl.login();
        return vcServiceConnectionInfo;
    }

    private static boolean supportsLoginByTicket(VcServiceImpl vcServiceImpl, VcServiceImpl vcServiceImpl2) {
        return !vcServiceImpl2.supportsLoginByToken() && !vcServiceImpl.supportsLoginByToken();
    }

    private static VcServiceConnectionInfo loginToPeerServiceByTicket(VcServiceImpl vcServiceImpl, VcServiceImpl vcServiceImpl2, ServiceEndpointEx[] serviceEndpointExArray) throws Exception {
        ManagedObjectReference managedObjectReference = vcServiceImpl2.getServiceInstanceContent().getSessionManager();
        SessionManager sessionManager = (SessionManager)vcServiceImpl2.getManagedObject(managedObjectReference);
        String string = LinkedVcGroupImpl.getServiceKey(vcServiceImpl.getServiceGuid(), serviceEndpointExArray);
        _logger.debug((Object)("Calling sessionManager.acquireSessionTicket on server - " + vcServiceImpl.getServiceUrl()));
        String string2 = sessionManager.acquireSessionTicket(string);
        _logger.debug((Object)("sessionManager.acquireSessionTicket call complete on server - " + vcServiceImpl.getServiceUrl()));
        VcServiceConnectionInfo vcServiceConnectionInfo = vcServiceImpl.loginBySessionTicket(string2);
        return vcServiceConnectionInfo;
    }

    private static String getServiceKey(String string, ServiceEndpointEx[] serviceEndpointExArray) {
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray) {
            if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.VC || !serviceEndpointEx.instanceUuid.equals(string)) continue;
            return serviceEndpointEx.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VcServiceImpl> fetchPeerServers(final ServiceEndpointEx[] serviceEndpointExArray, Collection<? extends ServiceEndpointEx> collection, VcServiceImpl vcServiceImpl, final LoginSpec loginSpec, final VcServiceImpl.NotAuthenticatedCallback notAuthenticatedCallback, final VcSessionListenerRegistry vcSessionListenerRegistry) throws Exception {
        _logger.info((Object)("Processing peer vc servers - " + vcServiceImpl.getServiceUrl()));
        String string = vcServiceImpl.getServiceGuid();
        final ReentrantLock reentrantLock = new ReentrantLock();
        final ArrayList arrayList = new ArrayList();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        ArrayList<3> arrayList2 = new ArrayList<3>(serviceEndpointExArray.length);
        for (int i = 0; i < serviceEndpointExArray.length; ++i) {
            final ServiceEndpointEx serviceEndpointEx = serviceEndpointExArray[i];
            if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.VC || serviceEndpointEx.getInstanceUuid().equals(string) || collection != null && collection.contains((Object)serviceEndpointEx)) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        VcServiceImpl vcServiceImpl = LinkedVcGroupImpl.this.createPeerService(loginSpec, serviceEndpointEx, serviceEndpointExArray, notAuthenticatedCallback, vcSessionListenerRegistry);
                        boolean bl = false;
                        reentrantLock.lock();
                        try {
                            if (atomicBoolean.get()) {
                                arrayList.add(vcServiceImpl);
                            } else {
                                bl = true;
                            }
                        }
                        finally {
                            reentrantLock.unlock();
                        }
                        if (bl) {
                            _logger.warn((Object)("The created peer VcService will be discarded because it is no longer needed: " + loginSpec.serviceUrl));
                            vcServiceImpl.logout();
                        }
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Failed to connect to peer vCenter server - " + serviceEndpointEx.url), (Throwable)exception);
                    }
                }

                public String toString() {
                    return "LinkedVcGroupImpl.createPeerService:" + serviceEndpointEx.getUrl();
                }
            };
            arrayList2.add(runnable);
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            try {
                ExecutorUtil.executeTasks(arrayList2, (Executor)EXECUTOR, (long)2L, (TimeUnit)TimeUnit.MINUTES);
                _logger.info((Object)("Peer vc servers processed successfully - " + vcServiceImpl.getServiceUrl()));
            }
            catch (TimeoutException timeoutException) {
                _logger.info((Object)("Timed out while waiting for peer VC servers to be processed. Will proceed only with the VCs that were proceesed. (" + vcServiceImpl.getServiceUrl() + ")"));
            }
            finally {
                arrayList2 = null;
            }
        }
        ArrayList<VcServiceImpl> arrayList3 = new ArrayList<VcServiceImpl>();
        reentrantLock.lock();
        try {
            atomicBoolean.set(false);
            arrayList3.addAll(arrayList);
            arrayList.clear();
        }
        finally {
            reentrantLock.unlock();
        }
        LinkedVcGroupImpl.logVcServiceUrls("Peer VC servers:", arrayList3);
        return arrayList3;
    }

    private static void logVcServiceUrls(String string, List<? extends VcService> list) {
        if (list == null) {
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(200);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(" [");
        for (VcService vcService : list) {
            String string2;
            String string3 = string2 = vcService != null ? vcService.getServiceUrl() : null;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
            bl = true;
        }
        stringBuilder.append(']');
        _logger.info((Object)stringBuilder.toString());
    }

    private void loginToPeerServers(final VcServiceImpl vcServiceImpl) {
        ServiceEndpointEx[] serviceEndpointExArray = this._serviceEndPointsRef.get();
        if (serviceEndpointExArray.length == 1) {
            _logger.info((Object)"This is not a linked vc setup");
            return;
        }
        _logger.info((Object)("Login to peer vc servers for startup VC " + vcServiceImpl.getServiceUrl()));
        Collection<VcServiceImpl> collection = this._vcRegistry.getInitialVcServices();
        ArrayList<4> arrayList = null;
        if (collection.size() > 0) {
            arrayList = new ArrayList<4>(collection.size() - 1);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (final VcServiceImpl vcServiceImpl2 : collection) {
                if (vcServiceImpl2 == null) {
                    _logger.warn((Object)"A null peerService encountered. Ignoring it.");
                    continue;
                }
                if (vcServiceImpl2 == vcServiceImpl) continue;
                String string = vcServiceImpl2.getServiceUrl();
                linkedList.add(string);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServiceEndpointEx[] serviceEndpointExArray = (ServiceEndpointEx[])LinkedVcGroupImpl.this._serviceEndPointsRef.get();
                            LinkedVcGroupImpl.loginToPeerService(vcServiceImpl2, vcServiceImpl, LinkedVcGroupImpl.this._loginSpec, serviceEndpointExArray);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)("Failed to login to peer vCenter server - " + vcServiceImpl2.getServiceUrl()), (Throwable)exception);
                        }
                    }

                    public String toString() {
                        return "LinkedVcGroupImpl.loginToPeerService:" + vcServiceImpl2.getServiceUrl();
                    }
                };
                arrayList.add(runnable);
            }
            _logger.info((Object)("Peer vc servers for " + vcServiceImpl.getServiceUrl() + ":\n" + linkedList));
        }
        if (arrayList != null && arrayList.size() > 0) {
            try {
                ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR, (long)2L, (TimeUnit)TimeUnit.MINUTES);
                _logger.info((Object)("Login to peer vc servers completed successfully - " + vcServiceImpl.getServiceUrl()));
            }
            catch (TimeoutException timeoutException) {
                _logger.error((Object)("Timed out while waiting to login to the peer VC servers. Will proceed anyway. (" + vcServiceImpl.getServiceUrl() + ")"));
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when logging in to the peer servers", (Throwable)exception);
            }
        } else {
            _logger.info((Object)"There are no peers");
        }
        this._loginSpec.userName = null;
        this._loginSpec.password = null;
    }

    private VcServiceImpl createPeerService(LoginSpec loginSpec, ServiceEndpointEx serviceEndpointEx, ServiceEndpointEx[] serviceEndpointExArray, VcServiceImpl.NotAuthenticatedCallback notAuthenticatedCallback, VcSessionListenerRegistry vcSessionListenerRegistry) throws Exception {
        if (serviceEndpointEx == null) {
            throw new Exception(I18nUtil.getLocalizedString("error.nullEndpoint", new String[0]));
        }
        _logger.info((Object)("Creating peer vc service - " + serviceEndpointEx.url));
        LoginSpec loginSpec2 = LinkedVcGroupImpl.createLoginSpec(loginSpec, serviceEndpointEx, serviceEndpointExArray, this._sslConfigurationProvider);
        VcServiceImpl vcServiceImpl = LinkedVcGroupImpl.createVcService(loginSpec2, notAuthenticatedCallback, vcSessionListenerRegistry, this._configurationService, this._sslConfigurationProvider);
        _logger.info((Object)("Peer vc service created successfully - " + serviceEndpointEx.url));
        return vcServiceImpl;
    }

    private static LoginSpec createLoginSpec(LoginSpec loginSpec, ServiceEndpointEx serviceEndpointEx, ServiceEndpointEx[] serviceEndpointExArray, SSLConfigurationProvider sSLConfigurationProvider) {
        LoginSpec loginSpec2 = new LoginSpec();
        loginSpec2.userName = loginSpec.userName;
        loginSpec2.password = loginSpec.password;
        loginSpec2.base64SspiToken = loginSpec.base64SspiToken;
        loginSpec2.locale = loginSpec.locale;
        loginSpec2.token = loginSpec.token;
        loginSpec2.tokenProvider = loginSpec.tokenProvider;
        loginSpec2.privateKey = loginSpec.privateKey;
        loginSpec2.ssoDomain = serviceEndpointEx.getSsoDomain();
        loginSpec2.serviceUrl = serviceEndpointEx.url;
        loginSpec2.serviceGuid = serviceEndpointEx.instanceUuid;
        loginSpec2.thumbprint = serviceEndpointEx.sslThumbprint;
        loginSpec2.endpoints = serviceEndpointExArray;
        String string = serviceEndpointEx.getVersion();
        String string2 = serviceEndpointEx.getUrl();
        String string3 = serviceEndpointEx.getVcGuid();
        Class clazz = VcServiceUtil.determineVmodlVersionToUse(string2, sSLConfigurationProvider, serviceEndpointEx.sslThumbprint, string);
        if (clazz == null) {
            _logger.warn((Object)("Failed to determine the VMODL version of VC " + string2 + " (" + string3 + ") whose string version is \"" + string + "\""));
        } else if (!VcServiceUtil.isOPVcOrLater(clazz)) {
            _logger.warn((Object)("The VC version of VC " + string2 + " is too old (" + string + " / " + clazz.getName() + ") and it's not supported"));
        }
        if (clazz != loginSpec.vmodlVersion && versions.VIM_VERSION_NEWEST.equals(loginSpec.vmodlVersion) && !versions.VIM_VERSION_NEWEST.equals(clazz) && VcServiceUtil.areVersionsInSameRelease(clazz, versions.VIM_VERSION_NEWEST)) {
            clazz = versions.VIM_VERSION_NEWEST;
        }
        loginSpec2.vmodlVersion = clazz;
        return loginSpec2;
    }

    static {
        _alreadyAssignedConfigServiceToExecutor = new AtomicBoolean(false);
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory(POOL_NAME);
        SynchronousQueue synchronousQueue = new SynchronousQueue(true);
        EXECUTOR = DiagnosticThreadPoolExecutor.builder((int)0, (int)300, (long)1L, (TimeUnit)TimeUnit.MINUTES, synchronousQueue, (ThreadFactory)workerThreadFactory).name(POOL_NAME).queueWaitTimeThreshold(Config.THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS, TimeUnit.NANOSECONDS).delayedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE).rejectedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE).minTimeApartForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS, TimeUnit.NANOSECONDS).build();
        ThreadPoolManager.getInstance().register((ExecutorService)EXECUTOR);
        _logger = LogFactory.getLog(LinkedVcGroupImpl.class);
    }

    private static class VcRegistry {
        private final Map<String, VcServiceImpl> _initialServiceByServiceGuid;
        private final Map<String, FutureTask<VcServiceImpl>> _dynamicServiceByServiceGuid = new HashMap<String, FutureTask<VcServiceImpl>>();
        private volatile VcServiceImpl _startUpVcService;
        private boolean _acceptNewServices = true;

        VcRegistry(Map<String, VcServiceImpl> map) {
            assert (map != null);
            this._initialServiceByServiceGuid = Collections.unmodifiableMap(map);
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("Created VC registry: ");
            Collection<VcServiceImpl> collection = this._initialServiceByServiceGuid.values();
            if (collection.size() > 0) {
                LinkedVcGroupImpl.appendInfoAboutVCs(stringBuilder, collection);
            } else {
                stringBuilder.append("[empty]");
            }
            _logger.info((Object)stringBuilder.toString());
        }

        Collection<VcServiceImpl> getInitialVcServices() {
            Collection<VcServiceImpl> collection = this._initialServiceByServiceGuid.values();
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<VcServiceImpl> getVcServices() {
            ArrayList<VcServiceImpl> arrayList = new ArrayList<VcServiceImpl>(this._initialServiceByServiceGuid.values());
            ArrayList<FutureTask<VcServiceImpl>> arrayList2 = null;
            Map<String, FutureTask<VcServiceImpl>> map = this._dynamicServiceByServiceGuid;
            synchronized (map) {
                arrayList2 = new ArrayList<FutureTask<VcServiceImpl>>(this._dynamicServiceByServiceGuid.values());
            }
            for (FutureTask futureTask : arrayList2) {
                VcServiceImpl vcServiceImpl = VcRegistry.getService(futureTask);
                if (vcServiceImpl == null) continue;
                arrayList.add(vcServiceImpl);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        VcServiceImpl getVcService(String string) {
            VcServiceImpl vcServiceImpl = this._initialServiceByServiceGuid.get(string);
            if (vcServiceImpl != null) {
                return vcServiceImpl;
            }
            Map<String, FutureTask<VcServiceImpl>> map = this._dynamicServiceByServiceGuid;
            synchronized (map) {
                FutureTask<VcServiceImpl> futureTask = this._dynamicServiceByServiceGuid.get(string);
                vcServiceImpl = VcRegistry.getService(futureTask);
                return vcServiceImpl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FutureTask<VcServiceImpl> addVcService(String string, FutureTask<VcServiceImpl> futureTask) {
            Map<String, FutureTask<VcServiceImpl>> map = this._dynamicServiceByServiceGuid;
            synchronized (map) {
                if (!this._acceptNewServices) {
                    return null;
                }
                FutureTask<VcServiceImpl> futureTask2 = this._dynamicServiceByServiceGuid.get(string);
                if (futureTask2 != null) {
                    return futureTask2;
                }
                this._dynamicServiceByServiceGuid.put(string, futureTask);
            }
            futureTask.run();
            return futureTask;
        }

        void setStartupVcService(VcServiceImpl vcServiceImpl) {
            this._startUpVcService = vcServiceImpl;
        }

        VcServiceImpl getStartupVcService() {
            return this._startUpVcService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            Map<String, FutureTask<VcServiceImpl>> map = this._dynamicServiceByServiceGuid;
            synchronized (map) {
                this._acceptNewServices = false;
            }
        }

        @CheckForNull
        private static VcServiceImpl getService(FutureTask<VcServiceImpl> futureTask) {
            if (futureTask == null) {
                return null;
            }
            try {
                VcServiceImpl vcServiceImpl = futureTask.get();
                return vcServiceImpl;
            }
            catch (Exception exception) {
                _logger.error((Object)("Error while getting vc service from future." + exception.toString()));
                return null;
            }
        }
    }

    private static class NotAuthenticatedCallbackImpl
    implements VcServiceImpl.NotAuthenticatedCallback {
        private final LoginSpec _loginSpec;
        private volatile VcRegistry _vcRegistry;
        private volatile ServiceEndpointEx[] _serviceEndPoints;

        NotAuthenticatedCallbackImpl(LoginSpec loginSpec) {
            this._loginSpec = loginSpec;
        }

        @Override
        public boolean retry(VcServiceImpl vcServiceImpl) {
            VcServiceConnectionInfo vcServiceConnectionInfo = null;
            VcRegistry vcRegistry = this._vcRegistry;
            if (vcRegistry == null) {
                _logger.warn((Object)"retry failed because vcRegistry was not set.");
                return false;
            }
            VcServiceImpl vcServiceImpl2 = vcRegistry.getStartupVcService();
            if (vcServiceImpl2 == null) {
                _logger.warn((Object)"retry failed because startupVcService was not set.");
                return false;
            }
            ServiceEndpointEx[] serviceEndpointExArray = this._serviceEndPoints;
            if (serviceEndpointExArray == null) {
                _logger.warn((Object)"retry failed because service endpoints were not set.");
                return false;
            }
            try {
                vcServiceConnectionInfo = NotAuthenticatedCallbackImpl.isStartupVcService(vcServiceImpl, vcServiceImpl2) ? vcServiceImpl.login() : LinkedVcGroupImpl.loginToPeerService(vcServiceImpl, vcServiceImpl2, this._loginSpec, serviceEndpointExArray);
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to login", (Throwable)exception);
            }
            boolean bl = vcServiceConnectionInfo.getConnectionState();
            return bl;
        }

        private static boolean isStartupVcService(VcServiceImpl vcServiceImpl, VcServiceImpl vcServiceImpl2) {
            return vcServiceImpl2 == vcServiceImpl;
        }

        static /* synthetic */ ServiceEndpointEx[] access$102(NotAuthenticatedCallbackImpl notAuthenticatedCallbackImpl, ServiceEndpointEx[] serviceEndpointExArray) {
            notAuthenticatedCallbackImpl._serviceEndPoints = serviceEndpointExArray;
            return serviceEndpointExArray;
        }
    }
}

