/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi.request;

import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingRequestContextProvider
implements RequestContextProvider {
    private static final Log _logger = LogFactory.getLog(DelegatingRequestContextProvider.class);
    protected final List<ManagedObjectContextHandler> handlers;

    public DelegatingRequestContextProvider(ManagedObjectContextHandler ... managedObjectContextHandlerArray) {
        this.handlers = new CopyOnWriteArrayList<ManagedObjectContextHandler>(managedObjectContextHandlerArray);
    }

    public List<ManagedObjectContextHandler> getHandlers() {
        return this.handlers;
    }

    public RequestContext getRequestContext(InvocationContext invocationContext) {
        RequestContextImpl requestContextImpl = new RequestContextImpl();
        for (ManagedObjectContextHandler managedObjectContextHandler : this.handlers) {
            try {
                managedObjectContextHandler.handle(requestContextImpl, invocationContext);
            }
            catch (Exception exception) {
                if (!_logger.isWarnEnabled()) continue;
                String string = invocationContext.getMethod().getName();
                String string2 = invocationContext.getMoRef().getType();
                _logger.warn((Object)("Failed to generate RequestContext for " + string2 + "#" + string), (Throwable)exception);
            }
        }
        return requestContextImpl;
    }
}

