/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vsphere.internal;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.Timeout;
import com.vmware.vise.vim.commons.VcVersionDeterminationStrategy;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Config {
    private static final Log _logger;
    private static final String CONFIG_FILE_NAME = "vim-commons-vsphere.properties";
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_VC;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_VC;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VC;
    public static final long VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS;
    public static final Timeout VMOMI_VC_CLIENT_PERMIT_RELEASE_TIMEOUT_MS;
    public static final long VC_VERSION_CACHE_EXPIRATION_IN_MILLIS;
    public static final SharedHttpConfigPool.IoMode VC_VMOMI_HTTP_CLIENT_IO_MODE;
    public static final long THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE;
    public static final long THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS;
    public static final VcVersionDeterminationStrategy VC_VERSION_DETERMINATION_STRATEGY;
    public static final int VC_SERVICE_UTIL_THREAD_POOL_MAX_SIZE;
    public static final int VC_SERVICE_UTIL_THREAD_POOL_QUEUE_SIZE;

    static {
        VcVersionDeterminationStrategy vcVersionDeterminationStrategy;
        SharedHttpConfigPool.IoMode ioMode;
        _logger = LogFactory.getLog(Config.class);
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        VMOMI_HTTP_CONNECTION_POOL_SIZE_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.connection.pool.size.vc", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.socket.timeout.vc", (int)120000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.socket.connection.timeout.vc", (int)10000);
        VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.vc.invocation.time.threshold", (int)10000);
        long l = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.commons.vmomi.vc.client.permit.release.timeout", (long)5000L);
        Timeout timeout = l <= 0L ? Timeout.INFINITE : Timeout.valueOf((long)l);
        VMOMI_VC_CLIENT_PERMIT_RELEASE_TIMEOUT_MS = timeout;
        VC_VERSION_CACHE_EXPIRATION_IN_MILLIS = PropertyUtil.getLongProperty((Properties)properties, (String)"vc.version.cache.expiration", (long)600000L);
        String string = PropertyUtil.getStringProperty((Properties)properties, (String)"vim.commons.vc.vmomi.http.client.io.mode", (String)SharedHttpConfigPool.IoMode.NON_BLOCKING_IO.name());
        try {
            ioMode = SharedHttpConfigPool.IoMode.valueOf((String)string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Invalid value for \"vim.commons.vc.vmomi.http.client.io.mode\" using the default " + SharedHttpConfigPool.IoMode.NON_BLOCKING_IO.name()), (Throwable)exception);
            ioMode = SharedHttpConfigPool.IoMode.NON_BLOCKING_IO;
        }
        VC_VMOMI_HTTP_CLIENT_IO_MODE = ioMode;
        THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.queueWaitTimeThreshold", (long)5000L));
        THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.delayedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.rejectedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.diagnostics.minTimeApart", (long)60000L));
        String string2 = PropertyUtil.getStringProperty((Properties)properties, (String)"vc.version.determinationStrategy", null);
        if (string2 == null) {
            vcVersionDeterminationStrategy = VcVersionDeterminationStrategy.GREATEST_COMMON_STABLE_VERSION;
        } else {
            try {
                vcVersionDeterminationStrategy = VcVersionDeterminationStrategy.valueOf(string2);
            }
            catch (Exception exception) {
                vcVersionDeterminationStrategy = VcVersionDeterminationStrategy.GREATEST_COMMON_STABLE_VERSION;
                _logger.error((Object)("Unknown version determination value: " + string2 + ". Will use " + (Object)((Object)vcVersionDeterminationStrategy)));
            }
        }
        VC_VERSION_DETERMINATION_STRATEGY = vcVersionDeterminationStrategy;
        VC_SERVICE_UTIL_THREAD_POOL_MAX_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"VcServiceUtil.threadPool.maxSize", (int)100);
        VC_SERVICE_UTIL_THREAD_POOL_QUEUE_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"VcServiceUtil.threadPool.queueSize", (int)0);
    }
}

