/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.TagDefinitions;
import com.vmware.cis.tagging.TagModel;
import com.vmware.cis.tagging.TagProvider;
import com.vmware.cis.tagging.TagTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TagApiInterface
extends ApiInterfaceSkeleton {
    private TagProvider impl;

    public TagApiInterface() {
        this((Class<? extends TagProvider>)null);
    }

    public TagApiInterface(Class<? extends TagProvider> clazz) {
        this((TagProvider)TagApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.TagImpl", TagProvider.class));
    }

    public TagApiInterface(TagProvider tagProvider) {
        super("com.vmware.cis.tagging.tag");
        Validate.notNull((Object)tagProvider);
        this.impl = tagProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ListUsedTagsApiMethod());
        this.registerMethod((ApiMethod)new ListTagsForCategoryApiMethod());
        this.registerMethod((ApiMethod)new AddToUsedByApiMethod());
        this.registerMethod((ApiMethod)new RemoveFromUsedByApiMethod());
        this.registerMethod((ApiMethod)new RevokePropagatingPermissionsApiMethod());
    }

    private class RevokePropagatingPermissionsApiMethod
    extends ApiMethodSkeleton {
        public RevokePropagatingPermissionsApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "revoke_propagating_permissions", TagDefinitions.__revokePropagatingPermissionsInput, TagDefinitions.__revokePropagatingPermissionsOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__revokePropagatingPermissionsInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagApiInterface.this.impl.revokePropagatingPermissions(string, (AsyncContext<Void>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__revokePropagatingPermissionsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class RemoveFromUsedByApiMethod
    extends ApiMethodSkeleton {
        public RemoveFromUsedByApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "remove_from_used_by", TagDefinitions.__removeFromUsedByInput, TagDefinitions.__removeFromUsedByOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__removeFromUsedByInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            TagApiInterface.this.impl.removeFromUsedBy(string, string2, (AsyncContext<Void>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__removeFromUsedByOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AddToUsedByApiMethod
    extends ApiMethodSkeleton {
        public AddToUsedByApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "add_to_used_by", TagDefinitions.__addToUsedByInput, TagDefinitions.__addToUsedByOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__addToUsedByInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            TagApiInterface.this.impl.addToUsedBy(string, string2, (AsyncContext<Void>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__addToUsedByOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListTagsForCategoryApiMethod
    extends ApiMethodSkeleton {
        public ListTagsForCategoryApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "list_tags_for_category", TagDefinitions.__listTagsForCategoryInput, TagDefinitions.__listTagsForCategoryOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__listTagsForCategoryInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            TagApiInterface.this.impl.listTagsForCategory(string, (AsyncContext<List<String>>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__listTagsForCategoryOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListUsedTagsApiMethod
    extends ApiMethodSkeleton {
        public ListUsedTagsApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "list_used_tags", TagDefinitions.__listUsedTagsInput, TagDefinitions.__listUsedTagsOutput, TagApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__listUsedTagsInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("used_by_entity");
            TagApiInterface.this.impl.listUsedTags(string, (AsyncContext<List<String>>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__listUsedTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "list", TagDefinitions.__listInput, TagDefinitions.__listOutput, TagApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            TagApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "delete", TagDefinitions.__deleteInput, TagDefinitions.__deleteOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__deleteInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagApiInterface.this.impl.delete(string, (AsyncContext<Void>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "update", TagDefinitions.__updateInput, TagDefinitions.__updateOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__updateInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagTypes.UpdateSpec updateSpec = (TagTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            TagApiInterface.this.impl.update(string, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "get", TagDefinitions.__getInput, TagDefinitions.__getOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__getInput, TagApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagApiInterface.this.impl.get(string, (AsyncContext<TagModel>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(TagApiInterface.this.getIdentifier(), "create", TagDefinitions.__createInput, TagDefinitions.__createOutput, TagApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__createInput, TagApiInterface.this.getTypeConverter());
            TagTypes.CreateSpec createSpec = (TagTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            TagApiInterface.this.impl.create(createSpec, (AsyncContext<String>)new AsyncContextImpl(TagApiInterface.this.getTypeConverter(), TagDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

