/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.node;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.node.CRFolderNode;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CRFileNode
extends CRNode {
    private final Long _modifyTime;
    private final List<CRFileRevision> _revisions;

    public CRFileNode(Long id, String nodeName, String nodePath, Date created, CRFolderNode parentNode, List<CRFileRevision> revs, Set<CRAccessControl> acls) {
        super(id, nodeName, nodePath, created, parentNode, acls);
        this._revisions = revs;
        this._modifyTime = null;
    }

    @Override
    public String getNodeType() {
        return "FILE";
    }

    public Date getModifyTime() {
        if (this._modifyTime == null) {
            return null;
        }
        Date result = new Date(this._modifyTime);
        return result;
    }

    public CRFileRevision getLatestRevision() {
        CRFileRevision rev = null;
        if (this._revisions != null && this._revisions.size() > 0) {
            rev = this._revisions.get(this._revisions.size() - 1);
        }
        return rev;
    }

    public List<CRFileRevision> getRevisions() {
        return this._revisions;
    }

    public CRFileRevision getRevision(int number) {
        CRFileRevision rev = null;
        if (this._revisions != null && this._revisions.size() > number) {
            rev = this._revisions.get(number);
        }
        return rev;
    }
}

