/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupListDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String DVPG_VLAN_LABEL = "portgroupVlanLabelDerived";
    private static final String DVPG_VM_LENGTH_LABEL = "vmLengthLabelDerived";
    private static final String DVPG_PORT_BINDING_LABEL = "portBindingLabelDerived";
    private static final String DVPG_AUTO_EXPAND = "config.autoExpand";
    private static final String DVPG_TYPE = "config.type";
    private static final String DVPG_VM_LENGTH = "vm._length";
    private static final String DVPG_VLAN = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan";
    private static final String DVPG_IS_PVLAN_PRESENT = "dvpgIsPvlanPresent";
    private static final String DVPG_PVLAN_TYPE = "dvpgPvlanType";
    private static final String DVPG_PVLAN_PRIMARY_ID = "dvpgPvlanPrimaryId";
    private static final String DVPG_PVLAN_SECONDARY_ID = "dvpgPvlanSecondaryId";
    private static Log _logger = LogFactory.getLog(DvPortgroupListDerivedPropertyProviderAdapter.class);

    public DvPortgroupListDerivedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = DistributedVirtualPortgroup.class.getSimpleName();
        typeInfo.properties = new String[]{DVPG_VLAN_LABEL, DVPG_VM_LENGTH_LABEL, DVPG_PORT_BINDING_LABEL};
        DerivedPropertyInfo vlanDerivedPropertyInfo = new DerivedPropertyInfo();
        vlanDerivedPropertyInfo.propertyName = DVPG_VLAN_LABEL;
        vlanDerivedPropertyInfo.sourcePropertyNames = new String[]{DVPG_VLAN, DVPG_IS_PVLAN_PRESENT, DVPG_PVLAN_TYPE, DVPG_PVLAN_PRIMARY_ID, DVPG_PVLAN_SECONDARY_ID};
        DerivedPropertyInfo vmLengthPropertyInfo = new DerivedPropertyInfo();
        vmLengthPropertyInfo.propertyName = DVPG_VM_LENGTH_LABEL;
        vmLengthPropertyInfo.sourcePropertyNames = new String[]{DVPG_VM_LENGTH};
        DerivedPropertyInfo portBindingPropertyInfo = new DerivedPropertyInfo();
        portBindingPropertyInfo.propertyName = DVPG_PORT_BINDING_LABEL;
        portBindingPropertyInfo.sourcePropertyNames = new String[]{DVPG_TYPE, DVPG_AUTO_EXPAND};
        typeInfo.derivedProperties = new DerivedPropertyInfo[]{vlanDerivedPropertyInfo, vmLengthPropertyInfo, portBindingPropertyInfo};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        if (ArrayUtil.isNullOrEmpty((Object[])objects)) {
            return null;
        }
        Set<String> requestedProperties = this.getRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        if (sourcePropertyValues != null) {
            for (Object object : objects) {
                Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(object);
                if (sourcePropertyValuesMap == null) continue;
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = object;
                LinkedList<PropertyValue> resultProperties = new LinkedList<PropertyValue>();
                if (requestedProperties.contains(DVPG_VLAN_LABEL)) {
                    String vlanLabel = this.getVlanLabel(sourcePropertyValuesMap);
                    resultProperties.add(this.createPropertyValue(DVPG_VLAN_LABEL, resultItem.resourceObject, vlanLabel));
                }
                if (requestedProperties.contains(DVPG_VM_LENGTH_LABEL)) {
                    String vmLengthLabel = this.getVmLengthLabel(sourcePropertyValuesMap);
                    resultProperties.add(this.createPropertyValue(DVPG_VM_LENGTH_LABEL, resultItem.resourceObject, vmLengthLabel));
                }
                if (requestedProperties.contains(DVPG_PORT_BINDING_LABEL)) {
                    String portBindingLabel = this.getPortBindingLabel(sourcePropertyValuesMap);
                    resultProperties.add(this.createPropertyValue(DVPG_PORT_BINDING_LABEL, resultItem.resourceObject, portBindingLabel));
                }
                resultItem.properties = resultProperties.toArray(new PropertyValue[resultProperties.size()]);
                resultItems.add(resultItem);
            }
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private String getVlanLabel(Map<String, Object> sourcePropertyValuesMap) {
        VmwareDistributedVirtualSwitch.VlanSpec vlanSpec = (VmwareDistributedVirtualSwitch.VlanSpec)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_VLAN);
        String pvlanType = (String)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_PVLAN_TYPE);
        Integer primaryPvlanId = (Integer)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_PVLAN_PRIMARY_ID);
        Integer secondaryPvlanId = (Integer)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_PVLAN_SECONDARY_ID);
        String vlanLabel = NetworkStringUtil.getString("na");
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec;
            vlanLabel = String.format(NetworkStringUtil.getString("dvPortGroup.list.vlan.access"), vlanIdSpec.vlanId);
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            VmwareDistributedVirtualSwitch.TrunkVlanSpec vlanTrunkSpec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec;
            vlanLabel = String.format(NetworkStringUtil.getString("dvPortGroup.list.vlan.trunk"), DvPortgroupListDerivedPropertyProviderAdapter.formatVlanTrunkRange(vlanTrunkSpec.vlanId));
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanSpec pvlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)vlanSpec;
            vlanLabel = DvPortgroupListDerivedPropertyProviderAdapter.formatPvlanEntry(pvlanType, primaryPvlanId, secondaryPvlanId, NetworkStringUtil.getString("dvPortGroup.list.pvlan.format"));
        }
        return vlanLabel;
    }

    private String getVmLengthLabel(Map<String, Object> sourcePropertyValuesMap) {
        Integer vmLengthLabel = (Integer)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_VM_LENGTH);
        return vmLengthLabel != null ? vmLengthLabel.toString() : null;
    }

    private String getPortBindingLabel(Map<String, Object> sourcePropertyValuesMap) {
        String portBinding = (String)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_TYPE);
        Boolean autoExpand = (Boolean)DvPortgroupListDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, DVPG_AUTO_EXPAND);
        return DvPortgroupListDerivedPropertyProviderAdapter.formatPortGroupType(portBinding, autoExpand);
    }

    private static String formatVlanTrunkRange(NumericRange[] vlanTrunkRange) {
        StringBuilder vlanId = new StringBuilder();
        if (!ArrayUtil.isNullOrEmpty((Object[])vlanTrunkRange)) {
            for (int i = 0; i < vlanTrunkRange.length; ++i) {
                NumericRange nr = vlanTrunkRange[i];
                if (nr != null) {
                    if (nr.start == nr.end) {
                        vlanId.append(nr.start);
                    } else {
                        vlanId.append(nr.start);
                        vlanId.append("-");
                        vlanId.append(nr.end);
                    }
                } else {
                    _logger.warn((Object)"Null NumericRange detected!");
                }
                if (i >= vlanTrunkRange.length - 1) continue;
                vlanId.append(", ");
            }
        }
        return vlanId.toString();
    }

    private static String formatPortGroupType(String portBinding, Boolean isElastic) {
        if (StringUtil.isNullOrEmpty((String)portBinding)) {
            return NetworkStringUtil.getString("na");
        }
        String portBindingLabel = null;
        switch (DistributedVirtualPortgroup.PortgroupType.valueOf((String)portBinding)) {
            case earlyBinding: {
                if (isElastic != null && isElastic.booleanValue()) {
                    portBindingLabel = NetworkStringUtil.getString("dvPortGroup.portBinding.staticElastic");
                    break;
                }
                portBindingLabel = NetworkStringUtil.getString("dvPortGroup.portBinding.static");
                break;
            }
            case ephemeral: {
                portBindingLabel = NetworkStringUtil.getString("dvPortGroup.portBinding.ephemeral");
                break;
            }
            case lateBinding: {
                portBindingLabel = NetworkStringUtil.getString("dvPortGroup.portBinding.dynamic");
                break;
            }
            default: {
                portBindingLabel = NetworkStringUtil.getString("noData");
            }
        }
        return portBindingLabel;
    }

    public static String formatPvlanEntry(String pvlanType, Integer primaryVlanId, Integer secondaryVlanId, String formatString) {
        String pvlanLabel = null;
        switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)pvlanType)) {
            case promiscuous: {
                pvlanLabel = String.format(formatString, NetworkStringUtil.getString("dvPortGroup.pvlan.promiscuous"), primaryVlanId, secondaryVlanId);
                break;
            }
            case isolated: {
                pvlanLabel = String.format(formatString, NetworkStringUtil.getString("dvPortGroup.pvlan.isolated"), primaryVlanId, secondaryVlanId);
                break;
            }
            case community: {
                pvlanLabel = String.format(formatString, NetworkStringUtil.getString("dvPortGroup.pvlan.community"), primaryVlanId, secondaryVlanId);
                break;
            }
            default: {
                pvlanLabel = NetworkStringUtil.getString("na");
            }
        }
        return pvlanLabel;
    }

    private Set<String> getRequestedProperties(PropertyRequestSpec propertyRequestSpec) {
        HashSet<String> requestedProperties = new HashSet<String>();
        if (!ArrayUtil.isNullOrEmpty((Object[])propertyRequestSpec.properties)) {
            for (PropertySpec propertySpec : propertyRequestSpec.properties) {
                if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames)) continue;
                for (String propertyName : propertySpec.propertyNames) {
                    requestedProperties.add(propertyName);
                }
            }
        }
        return requestedProperties;
    }

    private PropertyValue createPropertyValue(String propertyName, Object resourceObject, String value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = propertyName;
        propertyValue.resourceObject = resourceObject;
        propertyValue.value = value;
        return propertyValue;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }
}

