/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupNameSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupTrunkVlanSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupSettingsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DvPortgroupSettingsMutationProvider.class);
    private static final String UTF_8 = "UTF-8";
    private static final Integer DVPG_MAX_LENGTH_BYTES = 214;
    private static final String DVPG_NAME_EXISTS_PROP = "portGroupNameExists";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public DvPortgroupSettingsMutationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public ValidationResult validate(ManagedObjectReference dvpgRef, DvPortgroupNameSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dvpgRef;
        if (spec.name == null) {
            _logger.error((Object)"The name of the distributed port group is not providedin DvPortgroupEditSpec");
            return validationResult;
        }
        byte[] byteArray = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name).getBytes(UTF_8);
        if (byteArray != null && byteArray.length > DVPG_MAX_LENGTH_BYTES) {
            validationResult.result = NetworkStringUtil.getString("dvpg.properties.name.tooLong");
            return validationResult;
        }
        try {
            Boolean dvpgNameExists = (Boolean)NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, dvpgRef, DVPG_NAME_EXISTS_PROP, spec.name);
            if (dvpgNameExists.booleanValue()) {
                validationResult.result = NetworkStringUtil.getString("dvpg.properties.name.exists");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to retrieve portgroupNameExists property: " + ex.getMessage()), (Throwable)ex);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference dvpgRef, DvPortgroupTrunkVlanSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dvpgRef;
        if (spec.numericRanges == null) {
            _logger.error((Object)"The trunk VLAN numeric ranges of the distributed port group are not provided in the DvPortgroupTrunkVlanSpec");
            return validationResult;
        }
        validationResult.result = NumericRangeUtil.fromString(spec.numericRanges);
        return validationResult;
    }
}

