/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.addvnics;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.PortConnection;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.IpRouteConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.DvpgAddVnicsSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostConfigManagerData;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostVnicIpModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgVnicsIpSettingsModel;
import com.vmware.vsphere.client.modules.api.network.VmkernelSettingsSpec;
import com.vmware.vsphere.client.network.host.api.spec.AddVirtualNicCommandSpec;
import com.vmware.vsphere.client.network.host.api.spec.SetVirtualNicServiceCommandSpec;
import com.vmware.vsphere.client.network.host.api.spec.SetVirtualNicVsanServiceCommandSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DvpgAddVnicsMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;
    private final QueryBindingService _queryBindingService;

    public DvpgAddVnicsMutationProvider(MutationService mutationService, QueryBindingService queryBindingService) {
        this._mutationService = mutationService;
        this._queryBindingService = queryBindingService;
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgAddVnicsSpec spec) {
        Map<ManagedObjectReference, VirtualNic.Specification> hostToVnicSpecMap = this.buildHostToVnicSpecMap(spec);
        Collection hostsData = this._queryBindingService.prepare(DvpgHostConfigManagerData.class).fetch(hostToVnicSpecMap.keySet());
        DummyCommandSpec commandSpec = new DummyCommandSpec();
        commandSpec.mor = dvpgRef;
        ArrayList<AddVirtualNicCommandSpec> addVnicCommandSpecs = new ArrayList<AddVirtualNicCommandSpec>();
        for (DvpgHostConfigManagerData hostData : hostsData) {
            ManagedObjectReference hostRef = (ManagedObjectReference)hostData.provider;
            VirtualNic.Specification vnicSpec = hostToVnicSpecMap.get(hostRef);
            AddVirtualNicCommandSpec addVnicCommandSpec = this.createAddVnicCommandSpec(hostData.networkSystemRef, vnicSpec);
            if (spec.netStackInstanceKey == null || spec.netStackInstanceKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.name())) {
                this.createVnicServiceCommandSpecs((BaseCommandSpec)addVnicCommandSpec, hostData.vnicManagerRef, hostData.vsanSystemRef, spec.vnicSettingsSpec);
            }
            addVnicCommandSpecs.add(addVnicCommandSpec);
        }
        commandSpec.dependentSpecs = addVnicCommandSpecs.toArray(new BaseCommandSpec[addVnicCommandSpecs.size()]);
        return this._mutationService.apply((Object)dvpgRef, (Object)commandSpec);
    }

    private AddVirtualNicCommandSpec createAddVnicCommandSpec(ManagedObjectReference networkSystemReference, VirtualNic.Specification vnicSpec) {
        AddVirtualNicCommandSpec spec = new AddVirtualNicCommandSpec();
        spec.networkSystemReference = networkSystemReference;
        spec.vnicSpec = vnicSpec;
        spec.isServiceConsole = false;
        return spec;
    }

    private void createVnicServiceCommandSpecs(BaseCommandSpec parentCommandSpec, ManagedObjectReference vnicManagerRef, ManagedObjectReference vsanSystemRef, VmkernelSettingsSpec vnicSettingsSpec) {
        if (parentCommandSpec == null || vnicSettingsSpec == null) {
            return;
        }
        BaseCommandSpec commandSpec = parentCommandSpec;
        if (vnicManagerRef != null) {
            if (vnicSettingsSpec.isVmotionEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.vmotion));
            }
            if (vnicSettingsSpec.isFtEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.faultToleranceLogging));
            }
            if (vnicSettingsSpec.isHaEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.management));
            }
            if (vnicSettingsSpec.isVRTrafficEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.vSphereReplication));
            }
            if (vnicSettingsSpec.isVrNfcTrafficEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.vSphereReplicationNFC));
            }
            if (vnicSettingsSpec.isProvisioningNfcTrafficEnabled) {
                commandSpec = this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicServiceCommandSpec(vnicManagerRef, vnicSettingsSpec.vnicDeviceName, VirtualNicManager.NicType.vSphereProvisioning));
            }
        }
        if (vsanSystemRef != null && vnicSettingsSpec.isVsanEnabled) {
            this.appendCommandSpec(commandSpec, (BaseCommandSpec)this.createVnicVsanServiceCommandSpec(vsanSystemRef, vnicSettingsSpec.vnicDeviceName));
        }
    }

    private BaseCommandSpec appendCommandSpec(BaseCommandSpec parentSpec, BaseCommandSpec childSpec) {
        if (parentSpec == null || childSpec == null) {
            return null;
        }
        parentSpec.dependentSpecs = new BaseCommandSpec[]{childSpec};
        return childSpec;
    }

    private Map<ManagedObjectReference, VirtualNic.Specification> buildHostToVnicSpecMap(DvpgAddVnicsSpec addVnicSpec) {
        HashMap<ManagedObjectReference, VirtualNic.Specification> hostToVnicSpecMap = new HashMap<ManagedObjectReference, VirtualNic.Specification>();
        if (addVnicSpec == null || ArrayUtil.isNullOrEmpty((Object[])addVnicSpec.vnicIpSpecs)) {
            return hostToVnicSpecMap;
        }
        for (DvpgHostVnicIpModel vnicIpSpec : addVnicSpec.vnicIpSpecs) {
            VirtualNic.Specification vnicSpec = this.createVnicSpec(addVnicSpec.portgroupKey, addVnicSpec.switchUuid, addVnicSpec.netStackInstanceKey, addVnicSpec.mtu, addVnicSpec.ipSettingsSpec, vnicIpSpec);
            hostToVnicSpecMap.put(vnicIpSpec.hostRef, vnicSpec);
        }
        return hostToVnicSpecMap;
    }

    private VirtualNic.Specification createVnicSpec(String portgroupKey, String switchUuid, String netStackInstanceKey, int mtu, DvpgVnicsIpSettingsModel ipSettingsSpec, DvpgHostVnicIpModel hostVnicIpSpec) {
        VirtualNic.Specification spec = new VirtualNic.Specification();
        spec.distributedVirtualPort = new PortConnection();
        spec.distributedVirtualPort.portgroupKey = portgroupKey;
        spec.distributedVirtualPort.switchUuid = switchUuid;
        spec.mtu = mtu;
        spec.netStackInstanceKey = netStackInstanceKey;
        if (hostVnicIpSpec != null) {
            spec.ip = this.createIpConfig(ipSettingsSpec, hostVnicIpSpec);
            spec.ipRouteSpec = this.createIpRouteSpec(ipSettingsSpec);
        }
        return spec;
    }

    private SetVirtualNicServiceCommandSpec createVnicServiceCommandSpec(ManagedObjectReference vnicManager, String vnicName, VirtualNicManager.NicType vnicType) {
        SetVirtualNicServiceCommandSpec spec = new SetVirtualNicServiceCommandSpec();
        spec.virtualNicManagerReference = vnicManager;
        spec.virtualNetworkAdapterName = vnicName;
        spec.nicType = vnicType;
        spec.enable = true;
        return spec;
    }

    private SetVirtualNicVsanServiceCommandSpec createVnicVsanServiceCommandSpec(ManagedObjectReference vsanSystem, String vnicName) {
        SetVirtualNicVsanServiceCommandSpec spec = new SetVirtualNicVsanServiceCommandSpec();
        spec.vsanSystemReference = vsanSystem;
        spec.virtualNetworkAdapterName = vnicName;
        spec.enable = true;
        return spec;
    }

    private IpConfig createIpConfig(DvpgVnicsIpSettingsModel ipSettingsSpec, DvpgHostVnicIpModel hostVnicIpSpec) {
        IpConfig ipConfig = new IpConfig();
        if (ipSettingsSpec.ipv4Enabled) {
            ipConfig.dhcp = ipSettingsSpec.dhcpEnabled;
            if (!ipSettingsSpec.dhcpEnabled && hostVnicIpSpec != null) {
                ipConfig.ipAddress = hostVnicIpSpec.ipAddress;
                ipConfig.subnetMask = hostVnicIpSpec.subnetMask;
            }
        }
        if (ipSettingsSpec.ipv6Enabled) {
            ipConfig.ipV6Config = new IpConfig.IpV6AddressConfiguration();
            ipConfig.ipV6Config.dhcpV6Enabled = ipSettingsSpec.dhcpV6Enabled;
            ipConfig.ipV6Config.autoConfigurationEnabled = ipSettingsSpec.autoConfigurationEnabled;
            if (ipSettingsSpec.staticIpv6Enabled && hostVnicIpSpec != null && !StringUtil.isNullOrEmpty((String)hostVnicIpSpec.ipv6Address)) {
                IpConfig.IpV6Address ipv6Address = new IpConfig.IpV6Address();
                ipv6Address.ipAddress = hostVnicIpSpec.ipv6Address;
                ipv6Address.prefixLength = hostVnicIpSpec.prefixLength;
                ipConfig.ipV6Config.ipV6Address = new IpConfig.IpV6Address[]{ipv6Address};
            }
        }
        return ipConfig;
    }

    private VirtualNic.IpRouteSpec createIpRouteSpec(DvpgVnicsIpSettingsModel ipSettingsSpec) {
        if ("doNotConfig".equals(ipSettingsSpec.defaultGatewayType)) {
            if ("doNotConfig".equals(ipSettingsSpec.ipV6DefaultGatewayType)) {
                return null;
            }
        }
        VirtualNic.IpRouteSpec ipRouteSpec = new VirtualNic.IpRouteSpec();
        ipRouteSpec.ipRouteConfig = new IpRouteConfig();
        if ("manually".equals(ipSettingsSpec.defaultGatewayType)) {
            ipRouteSpec.ipRouteConfig.defaultGateway = ipSettingsSpec.defaultGateway;
        }
        if ("manually".equals(ipSettingsSpec.ipV6DefaultGatewayType)) {
            ipRouteSpec.ipRouteConfig.ipV6DefaultGateway = ipSettingsSpec.ipV6DefaultGateway;
        }
        return ipRouteSpec;
    }
}

