/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.addvnics;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgAddVnicsData;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostInfoModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostVnicServiceModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostVnicServicesData;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostVnicsData;
import com.vmware.vsphere.client.h5.network.dvportgroup.addvnics.model.DvpgHostVnicsSettingsModel;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackItem;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicUtils;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class DvpgAddVnicsPropertyProvider
implements PropertyProviderBean {
    private static final int DEFAULT_MTU = 1500;
    private QueryBindingService _queryBindingService;

    public DvpgAddVnicsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="addvnics", property="hostVnicsSettingsModel")
    public DvpgHostVnicsSettingsModel getHostVnicsSettingsModel(ManagedObjectReference dvpgRef, ManagedObjectReference[] hostRefs) {
        DvpgHostVnicsSettingsModel vnicsSettingsModel = new DvpgHostVnicsSettingsModel();
        DvpgAddVnicsData dvpgData = (DvpgAddVnicsData)((Object)this._queryBindingService.prepare(DvpgAddVnicsData.class).fetch((Object)dvpgRef));
        vnicsSettingsModel.dvpgKey = dvpgData.key;
        vnicsSettingsModel.networkLabel = MixedUtil.unescapeVimEntityNameSpecialChars((String)NetworkStringUtil.getString("addVnics.networkLabelFormat", dvpgData.name, dvpgData.dvsName));
        vnicsSettingsModel.dvsUuid = dvpgData.switchUuid;
        vnicsSettingsModel.isDvsMtuAvailable = true;
        if (vnicsSettingsModel.isDvsMtuAvailable) {
            vnicsSettingsModel.mtu = dvpgData.dvsMaxMtu;
            vnicsSettingsModel.mtuSelectedType = vnicsSettingsModel.SWITCH_MTU;
        } else {
            vnicsSettingsModel.mtu = 1500;
            vnicsSettingsModel.mtuSelectedType = vnicsSettingsModel.CUSTOM_MTU;
        }
        Collection hostsVnicsData = this._queryBindingService.prepare(DvpgHostVnicsData.class).fetch(Arrays.asList(hostRefs));
        ArrayList<NetStackInstance> supportedByAllHostsNetStacks = null;
        if (this.isMultiNetStackSupportedByAllHosts(hostsVnicsData)) {
            supportedByAllHostsNetStacks = this.getSupportedByAllHostsNetStacks(hostsVnicsData);
        }
        vnicsSettingsModel.netStackItems = this.getNetStackItems(supportedByAllHostsNetStacks);
        vnicsSettingsModel.selectedNetStackKey = vnicsSettingsModel.netStackItems.get((int)0).key;
        DvpgHostVnicServicesData vnicsServicesData = new DvpgHostVnicServicesData();
        for (DvpgHostVnicsData hostVnicsData : hostsVnicsData) {
            if (vnicsSettingsModel.isVmotionVnicAvailOnDefaultStack && !this.isServiceAvailableOnDefaultStack(VirtualNicManager.NicType.vmotion, hostVnicsData)) {
                vnicsSettingsModel.isVmotionVnicAvailOnDefaultStack = false;
            }
            if (vnicsSettingsModel.isProvVnicAvailOnDefaultStack && !this.isServiceAvailableOnDefaultStack(VirtualNicManager.NicType.vSphereProvisioning, hostVnicsData)) {
                vnicsSettingsModel.isProvVnicAvailOnDefaultStack = false;
            }
            if (!hostVnicsData.gatewayOnNicSupported) {
                vnicsSettingsModel.gatewayOnNicSupported = false;
            }
            if (hostVnicsData.netStackData != null) {
                NetStackData netStackData = hostVnicsData.netStackData;
                if (!netStackData.ipv6Enabled) {
                    vnicsSettingsModel.isIpv6Enabled = false;
                    vnicsSettingsModel.ipv6IncompatibleHosts.add(this.createHostInfo(hostVnicsData));
                }
                if (!netStackData.multipleNetworkStackInstanceSupported) {
                    vnicsSettingsModel.multipleNetStackSupported = false;
                    vnicsSettingsModel.multipleNetStackIncompatibleHosts.add(this.createHostInfo(hostVnicsData));
                }
            }
            if (hostVnicsData.hostVnicFeatures == null) continue;
            if (!hostVnicsData.hostVnicFeatures.isProvisioningNfcTrafficSupported) {
                vnicsServicesData.isProvisioningNfcTrafficSupported = false;
                vnicsServicesData.provisioningNfsIncompatibleHosts.add(this.createHostInfo(hostVnicsData));
            }
            if (!hostVnicsData.hostVnicFeatures.isVsanSupported) {
                vnicsServicesData.isVsanSupported = false;
                vnicsServicesData.vsanTrafficIncompatibleHosts.add(this.createHostInfo(hostVnicsData));
            }
            if (!hostVnicsData.hostVnicFeatures.isVrTrafficSupported) {
                vnicsServicesData.isVrTrafficSupported = false;
                vnicsServicesData.vrTrafficIncompatibleHosts.add(this.createHostInfo(hostVnicsData));
            }
            if (hostVnicsData.hostVnicFeatures.isVrNfcTrafficSupported) continue;
            vnicsServicesData.isVrNfcTrafficSupported = false;
            vnicsServicesData.vrNfcTrafficIncompatibleHosts.add(this.createHostInfo(hostVnicsData));
        }
        vnicsSettingsModel.supportedServices = this.getSupportedServices(vnicsServicesData);
        return vnicsSettingsModel;
    }

    private ArrayList<DvpgHostVnicServiceModel> getSupportedServices(DvpgHostVnicServicesData vnicsServicesData) {
        ArrayList<DvpgHostVnicServiceModel> supportedServices = new ArrayList<DvpgHostVnicServiceModel>();
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.vmotion.name(), NetworkStringUtil.getString("addVnics.services.vMotion"), true, null));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.vSphereProvisioning.name(), NetworkStringUtil.getString("addVnics.services.provisioningNfcTraffic"), vnicsServicesData.isProvisioningNfcTrafficSupported, vnicsServicesData.provisioningNfsIncompatibleHosts));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.faultToleranceLogging.name(), NetworkStringUtil.getString("addVnics.services.ftLogging"), true, null));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.management.name(), NetworkStringUtil.getString("addVnics.services.mngTraffic"), true, null));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.vSphereReplication.name(), NetworkStringUtil.getString("addVnics.services.vrTraffic"), vnicsServicesData.isVrTrafficSupported, vnicsServicesData.vrTrafficIncompatibleHosts));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.vSphereReplicationNFC.name(), NetworkStringUtil.getString("addVnics.services.vrNfcTraffic"), vnicsServicesData.isVrNfcTrafficSupported, vnicsServicesData.vrNfcTrafficIncompatibleHosts));
        supportedServices.add(this.createVnicServiceModel(VirtualNicManager.NicType.vsan.name(), NetworkStringUtil.getString("addVnics.services.vsan"), vnicsServicesData.isVsanSupported, vnicsServicesData.vsanTrafficIncompatibleHosts));
        return supportedServices;
    }

    private DvpgHostVnicServiceModel createVnicServiceModel(String key, String name, boolean isSupported, ArrayList<DvpgHostInfoModel> incompatibleHosts) {
        DvpgHostVnicServiceModel serviceModel = new DvpgHostVnicServiceModel();
        serviceModel.key = key;
        serviceModel.name = name;
        serviceModel.isSupported = isSupported;
        if (incompatibleHosts != null) {
            serviceModel.incompatibleHosts = incompatibleHosts;
        }
        return serviceModel;
    }

    private ArrayList<NetStackItem> getNetStackItems(ArrayList<NetStackInstance> supportedByAllHostNetStackInstances) {
        ArrayList<NetStackItem> netStackItems = new ArrayList<NetStackItem>();
        if (!ArrayUtil.isNullOrEmpty(supportedByAllHostNetStackInstances)) {
            for (NetStackInstance netStackInstance : supportedByAllHostNetStackInstances) {
                if (StringUtil.isNullOrEmpty((String)netStackInstance.key)) continue;
                NetStackItem netStackItem = new NetStackItem();
                netStackItem.name = NetStackUtil.getNetStackInstanceName(netStackInstance);
                netStackItem.key = netStackInstance.key;
                netStackItem.isSystemStack = NetStackUtil.isSystemStackKeyValue(netStackInstance.key);
                if (NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) {
                    netStackItems.add(0, netStackItem);
                    continue;
                }
                netStackItems.add(netStackItem);
            }
        } else {
            NetStackItem defaultNetStackItem = new NetStackItem();
            defaultNetStackItem.isSystemStack = true;
            defaultNetStackItem.key = NetStackInstance.SystemStackKey.defaultTcpipStack.toString();
            defaultNetStackItem.name = NetworkStringUtil.getString("NetStackInstance.defaultStackName");
            netStackItems.add(defaultNetStackItem);
        }
        return netStackItems;
    }

    private boolean isMultiNetStackSupportedByAllHosts(Collection<DvpgHostVnicsData> hostsVnicsData) {
        for (DvpgHostVnicsData hostVnicsData : hostsVnicsData) {
            if (hostVnicsData.netStackData != null && hostVnicsData.netStackData.multipleNetworkStackInstanceSupported) continue;
            return false;
        }
        return true;
    }

    private ArrayList<NetStackInstance> getSupportedByAllHostsNetStacks(Collection<DvpgHostVnicsData> hostsVnicsData) {
        NetStackInstance[] netStackInstances;
        DvpgHostVnicsData firstHostVnicData = hostsVnicsData.iterator().next();
        if (firstHostVnicData == null || firstHostVnicData.netStackData == null || ArrayUtil.isNullOrEmpty((Object[])firstHostVnicData.netStackData.netStackInstances)) {
            return null;
        }
        HashMap<String, NetStackInstance> netStackKeyToInstanceMap = new HashMap<String, NetStackInstance>();
        for (NetStackInstance netStackInstance : netStackInstances = firstHostVnicData.netStackData.netStackInstances) {
            netStackKeyToInstanceMap.put(netStackInstance.key, netStackInstance);
        }
        ArrayList<String> supportedNetStackKeys = this.getNetStackInstanceKeys(netStackInstances);
        for (DvpgHostVnicsData hostVnicsData : hostsVnicsData) {
            NetStackData netStackData = hostVnicsData.netStackData;
            if (netStackData == null || ArrayUtil.isNullOrEmpty((Object[])netStackData.netStackInstances)) {
                return null;
            }
            ArrayList<String> netStackInstanceKeys = this.getNetStackInstanceKeys(netStackData.netStackInstances);
            supportedNetStackKeys.retainAll(netStackInstanceKeys);
        }
        ArrayList<NetStackInstance> supportedNetStackInstances = new ArrayList<NetStackInstance>();
        for (String netStackKey : supportedNetStackKeys) {
            supportedNetStackInstances.add((NetStackInstance)netStackKeyToInstanceMap.get(netStackKey));
        }
        return supportedNetStackInstances;
    }

    private ArrayList<String> getNetStackInstanceKeys(NetStackInstance[] netStackInstances) {
        ArrayList<String> netStackInstanceKeys = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])netStackInstances)) {
            return netStackInstanceKeys;
        }
        for (NetStackInstance netStackInstance : netStackInstances) {
            netStackInstanceKeys.add(netStackInstance.key);
        }
        return netStackInstanceKeys;
    }

    private DvpgHostInfoModel createHostInfo(DvpgHostVnicsData hostData) {
        DvpgHostInfoModel hostInfoModel = new DvpgHostInfoModel();
        hostInfoModel.hostName = hostData.name;
        hostInfoModel.hostRef = (ManagedObjectReference)hostData.provider;
        return hostInfoModel;
    }

    private boolean isServiceAvailableOnDefaultStack(VirtualNicManager.NicType serviceType, DvpgHostVnicsData hostVnicsData) {
        NetStackInstance.SystemStackKey netStack = null;
        switch (serviceType) {
            case vmotion: {
                netStack = NetStackInstance.SystemStackKey.vmotion;
                break;
            }
            case vSphereProvisioning: {
                netStack = NetStackInstance.SystemStackKey.vSphereProvisioning;
            }
        }
        return netStack == null || hostVnicsData.netStackData.netStackInstanceRuntimeInfo == null || !VnicUtils.isNetStackInUse(netStack.name(), hostVnicsData.netStackData.netStackInstanceRuntimeInfo);
    }
}

