/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.create;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.CreateDvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupActionData;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupPoliciesModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupPolicyData;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupProperties;
import com.vmware.vsphere.client.h5.network.dvportgroup.create.model.CreateDvPortgroupPropertiesData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;

public class CreateDvPortgroupPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private static final String CREATE_DVPG_METHOD = "AddDVPortgroup_Task";
    private static final String CREATE_DVPG_PRIVILEGE = "DVPortgroup.Create";

    public CreateDvPortgroupPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="createdvpg", property="settingsdata")
    public CreateDvPortgroupProperties getDvPortgroupProperties(ManagedObjectReference dvsRef) {
        CreateDvPortgroupPropertiesData dvPortgroupPropertiesData = (CreateDvPortgroupPropertiesData)this._queryBindingService.prepare(CreateDvPortgroupPropertiesData.class).fetch((Object)dvsRef);
        return CreateDvPortgroupParser.getCreateDvPortgroupProperties(dvPortgroupPropertiesData);
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="createdvpg", property="createDvpgActionAvailabilityErrors")
    public String[] getCreateDvpgActionAvailabilityErrors(ManagedObjectReference dvsRef) {
        ArrayList<String> errors = new ArrayList<String>();
        CreateDvPortgroupActionData dvpgActiondata = (CreateDvPortgroupActionData)this._queryBindingService.prepare(CreateDvPortgroupActionData.class).fetch((Object)dvsRef);
        if (!dvpgActiondata.dvsOperationSupported.booleanValue() || !AuthorizationUtil.isOperationAllowed((String[])new String[]{CREATE_DVPG_METHOD}, (String[])dvpgActiondata.disabledMethod)) {
            errors.add(NetworkStringUtil.getString("dvpg.create.nameAndLocation.noOpSupportedError"));
        }
        if (!AuthorizationUtil.isPrivilegeGranted((String[])new String[]{CREATE_DVPG_PRIVILEGE}, (String[])dvpgActiondata.grantedPrivileges)) {
            errors.add(NetworkStringUtil.getString("dvpg.create.nameAndLocation.noPrivilegeError"));
        }
        return errors.toArray(new String[errors.size()]);
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="createdvpg", property="policiesModel")
    public CreateDvPortgroupPoliciesModel getCreateDvpgPoliciesModel(ManagedObjectReference dvsRef) {
        CreateDvPortgroupPolicyData createDvPortgroupPolicyData = (CreateDvPortgroupPolicyData)this._queryBindingService.prepare(CreateDvPortgroupPolicyData.class).fetch((Object)dvsRef);
        CreateDvPortgroupPoliciesModel createDvPortgroupPoliciesModel = new CreateDvPortgroupPoliciesModel();
        createDvPortgroupPoliciesModel.securityPolicyModel = DvPortgroupPolicyParser.getSecurityPolicyModel(createDvPortgroupPolicyData.defaultPortConfig);
        createDvPortgroupPoliciesModel.failoverPolicyModel = DvPortgroupPolicyParser.getTeamingAndFailoverPolicy(createDvPortgroupPolicyData.defaultPortConfig, createDvPortgroupPolicyData.uplinkPortNames, createDvPortgroupPolicyData.lacpGroupConfigs, createDvPortgroupPolicyData.loadBalancingModes);
        createDvPortgroupPoliciesModel.trafficShapingPolicyModel = DvPortgroupPolicyParser.getTrafficShapingPolicies(createDvPortgroupPolicyData.defaultPortConfig);
        createDvPortgroupPoliciesModel.monitoringPolicyModel = DvPortgroupPolicyParser.getIpfixPolicy(createDvPortgroupPolicyData.defaultPortConfig, createDvPortgroupPolicyData.ipfixCapability);
        createDvPortgroupPoliciesModel.miscPolicyModel = DvPortgroupPolicyParser.getPortBlockedPolicyModel(createDvPortgroupPolicyData.defaultPortConfig);
        return createDvPortgroupPoliciesModel;
    }
}

