/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.IntExpression;
import com.vmware.vim.binding.vim.IpAddress;
import com.vmware.vim.binding.vim.IpRange;
import com.vmware.vim.binding.vim.MacAddress;
import com.vmware.vim.binding.vim.MacRange;
import com.vmware.vim.binding.vim.NegatableExpression;
import com.vmware.vim.binding.vim.SingleIp;
import com.vmware.vim.binding.vim.SingleMac;
import com.vmware.vim.binding.vim.StringExpression;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.TrafficRule;
import com.vmware.vim.binding.vim.dvs.TrafficRuleset;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgEditRuleSequenceSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterRule;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrafficFilterModel;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class DvpgTrafficFilterParser {
    public static final String GENERIC_TRAFFIC_FILTER_RULESET_AGENT = "dvfilter-generic-vmware";
    public static final String DIVIDER = ",&emsp;";
    public static final String IPV6_ADDRESS_GROUP_SEPARATOR = ":";
    public static final int IPV4_PROTOCOL_HEX_VALUE = 2048;
    public static final int IPV6_PROTOCOL_HEX_VALUE = 34525;
    public static final int ARP_PROTOCOL_HEX_VALUE = 2054;
    public static final int ICMP_PROTOCOL_VALUE = 1;
    public static final int ICMP6_PROTOCOL_VALUE = 58;
    public static final int TCP_PROTOCOL_VALUE = 6;
    public static final int UDP_PROTOCOL_VALUE = 17;
    public static final int ANY_IP_PREFIX = 0;

    public static DvpgTrafficFilterModel getTrafficFilterPolicy(DistributedVirtualPort.FilterPolicy trafficFilterPolicy) {
        DvpgTrafficFilterModel trafficFilterModel = new DvpgTrafficFilterModel();
        if (trafficFilterPolicy == null || ArrayUtil.isNullOrEmpty((Object[])trafficFilterPolicy.filterConfig)) {
            return trafficFilterModel;
        }
        for (DistributedVirtualPort.FilterConfig filterConfig : trafficFilterPolicy.filterConfig) {
            if (filterConfig == null || filterConfig.agentName == null || !filterConfig.agentName.equals(GENERIC_TRAFFIC_FILTER_RULESET_AGENT) || !(filterConfig instanceof DistributedVirtualPort.TrafficFilterConfig)) continue;
            DistributedVirtualPort.TrafficFilterConfig trafficFilterConfig = (DistributedVirtualPort.TrafficFilterConfig)filterConfig;
            if (trafficFilterConfig.trafficRuleset == null) {
                return trafficFilterModel;
            }
            boolean bl = trafficFilterModel.isTrafficRulesetEnabled = trafficFilterConfig.trafficRuleset.enabled != null && trafficFilterConfig.trafficRuleset.enabled != false;
            if (trafficFilterConfig.trafficRuleset.rules == null) {
                trafficFilterModel.rules = new DvpgTrafficFilterRule[0];
                return trafficFilterModel;
            }
            ArrayList<DvpgTrafficFilterRule> trafficFilterRules = new ArrayList<DvpgTrafficFilterRule>();
            for (TrafficRule trafficRule : trafficFilterConfig.trafficRuleset.rules) {
                DvpgTrafficFilterRule rule = new DvpgTrafficFilterRule();
                rule.key = trafficRule.key;
                rule.sequence = trafficRule.sequence;
                rule.name = trafficRule.description;
                rule.action = DvpgTrafficFilterParser.getLocalizedRuleActionName(trafficRule.action);
                rule.direction = DvpgTrafficFilterParser.getLocalizedRuleDirection(trafficRule.direction);
                rule.qualifiers = DvpgTrafficFilterParser.getSortedTrafficQualifiersDetails(trafficRule.qualifier);
                rule.qualifierTypeLabels = DvpgTrafficFilterParser.getTrafficQualifierTypeLabels(rule.qualifiers);
                trafficFilterRules.add(rule);
            }
            if (trafficFilterRules.size() > 1) {
                Collections.sort(trafficFilterRules, new Comparator<DvpgTrafficFilterRule>(){

                    @Override
                    public int compare(DvpgTrafficFilterRule rule1, DvpgTrafficFilterRule rule2) {
                        return rule1.sequence.compareTo(rule2.sequence);
                    }
                });
            }
            int displaySequence = 1;
            for (DvpgTrafficFilterRule trafficFilterRule : trafficFilterRules) {
                trafficFilterRule.displaySequence = displaySequence;
                ++displaySequence;
            }
            trafficFilterModel.rules = trafficFilterRules.toArray(new DvpgTrafficFilterRule[trafficFilterRules.size()]);
        }
        return trafficFilterModel;
    }

    public static DvsPortTrafficFilterModel getTrafficFilterPolicyForPort(DistributedVirtualPort.FilterPolicy trafficFilterPolicy, boolean isTrafficFilterOverrideEnabled) {
        DvpgTrafficFilterModel trafficFilterModel = DvpgTrafficFilterParser.getTrafficFilterPolicy(trafficFilterPolicy);
        DvsPortTrafficFilterModel portTrafficFilterModel = new DvsPortTrafficFilterModel();
        portTrafficFilterModel.rules = trafficFilterModel.rules;
        portTrafficFilterModel.isTrafficRulesetEnabled = trafficFilterModel.isTrafficRulesetEnabled;
        portTrafficFilterModel.isTrafficRulesetOverrideEnabled = isTrafficFilterOverrideEnabled;
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(trafficFilterPolicy);
        if (existingFilterConfig != null) {
            portTrafficFilterModel.isTrafficRulesetOverwritten = !existingFilterConfig.inherited;
        }
        return portTrafficFilterModel;
    }

    public static boolean areTrafficRulesAvailable(DistributedVirtualPort.FilterPolicy trafficFilterPolicy) {
        return !ArrayUtil.isNullOrEmpty((Object[])DvpgTrafficFilterParser.getTrafficRules(trafficFilterPolicy));
    }

    public static TrafficRule[] getTrafficRules(DistributedVirtualPort.FilterPolicy trafficFilterPolicy) {
        if (trafficFilterPolicy == null || ArrayUtil.isNullOrEmpty((Object[])trafficFilterPolicy.filterConfig)) {
            return null;
        }
        for (DistributedVirtualPort.FilterConfig filterConfig : trafficFilterPolicy.filterConfig) {
            if (filterConfig == null || filterConfig.agentName == null || !filterConfig.agentName.equals(GENERIC_TRAFFIC_FILTER_RULESET_AGENT) || !(filterConfig instanceof DistributedVirtualPort.TrafficFilterConfig)) continue;
            DistributedVirtualPort.TrafficFilterConfig trafficFilterConfig = (DistributedVirtualPort.TrafficFilterConfig)filterConfig;
            if (trafficFilterConfig.trafficRuleset == null) {
                return null;
            }
            return trafficFilterConfig.trafficRuleset.rules;
        }
        return null;
    }

    public static boolean getIsTrafficRulesetEnabled(DistributedVirtualPort.FilterPolicy trafficFilterPolicy) {
        if (trafficFilterPolicy == null || ArrayUtil.isNullOrEmpty((Object[])trafficFilterPolicy.filterConfig)) {
            return false;
        }
        for (DistributedVirtualPort.FilterConfig filterConfig : trafficFilterPolicy.filterConfig) {
            if (filterConfig == null || filterConfig.agentName == null || !filterConfig.agentName.equals(GENERIC_TRAFFIC_FILTER_RULESET_AGENT) || !(filterConfig instanceof DistributedVirtualPort.TrafficFilterConfig)) continue;
            DistributedVirtualPort.TrafficFilterConfig trafficFilterConfig = (DistributedVirtualPort.TrafficFilterConfig)filterConfig;
            if (trafficFilterConfig.trafficRuleset == null) {
                return false;
            }
            return trafficFilterConfig.trafficRuleset.enabled;
        }
        return false;
    }

    public static void resetTrafficRulesKeys(TrafficRule[] trafficRules) {
        if (ArrayUtil.isNullOrEmpty((Object[])trafficRules)) {
            return;
        }
        for (TrafficRule trafficRule : trafficRules) {
            trafficRule.key = null;
        }
    }

    public static DistributedVirtualPort.TrafficFilterConfigSpec createGenericFilterConfigSpec(String key, String operation, TrafficRuleset ruleSet) {
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = new DistributedVirtualPort.TrafficFilterConfigSpec();
        filterConfigSpec.key = key;
        filterConfigSpec.operation = operation;
        filterConfigSpec.agentName = GENERIC_TRAFFIC_FILTER_RULESET_AGENT;
        filterConfigSpec.inherited = false;
        filterConfigSpec.trafficRuleset = ruleSet;
        return filterConfigSpec;
    }

    public static int getGenericFilterConfigIndex(DistributedVirtualPort.FilterConfig[] filterConfigs) {
        if (ArrayUtil.isNullOrEmpty((Object[])filterConfigs)) {
            return -1;
        }
        for (int i = 0; i < filterConfigs.length; ++i) {
            if (!filterConfigs[i].agentName.equals(GENERIC_TRAFFIC_FILTER_RULESET_AGENT)) continue;
            return i;
        }
        return -1;
    }

    public static TrafficRule[] addTrafficRuleToExistingRules(TrafficRule[] existingRules, TrafficRule newRule) {
        if (newRule == null) {
            return existingRules;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])existingRules)) {
            return new TrafficRule[]{newRule};
        }
        ArrayList<TrafficRule> rules = new ArrayList<TrafficRule>();
        rules.addAll(Arrays.asList(existingRules));
        rules.add(newRule);
        return rules.toArray(new TrafficRule[rules.size()]);
    }

    public static TrafficRule[] editTrafficRuleInExistingRules(TrafficRule[] existingRules, TrafficRule editedRule) {
        if (editedRule == null || ArrayUtil.isNullOrEmpty((Object[])existingRules)) {
            return existingRules;
        }
        for (int i = 0; i < existingRules.length; ++i) {
            if (!existingRules[i].key.equals(editedRule.key)) continue;
            existingRules[i] = editedRule;
            break;
        }
        return existingRules;
    }

    public static TrafficRule[] removeTrafficRuleFromExistingRules(TrafficRule[] existingRules, String removedRuleKey) {
        if (StringUtil.isNullOrEmpty((String)removedRuleKey) || ArrayUtil.isNullOrEmpty((Object[])existingRules)) {
            return existingRules;
        }
        ArrayList<TrafficRule> rules = new ArrayList<TrafficRule>();
        rules.addAll(Arrays.asList(existingRules));
        Iterator ruleIterator = rules.iterator();
        while (ruleIterator.hasNext()) {
            TrafficRule rule = (TrafficRule)ruleIterator.next();
            if (rule == null || !rule.key.equals(removedRuleKey)) continue;
            ruleIterator.remove();
            break;
        }
        return rules.toArray(new TrafficRule[rules.size()]);
    }

    public static TrafficRule[] updateRulesSequence(TrafficRule[] existingRules, DvpgEditRuleSequenceSpec[] modifiedRuleSpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])modifiedRuleSpecs) || ArrayUtil.isNullOrEmpty((Object[])existingRules)) {
            return existingRules;
        }
        HashMap<String, Integer> ruleKeyToSequence = new HashMap<String, Integer>();
        for (DvpgEditRuleSequenceSpec dvpgEditRuleSequenceSpec : modifiedRuleSpecs) {
            ruleKeyToSequence.put(dvpgEditRuleSequenceSpec.ruleKey, dvpgEditRuleSequenceSpec.sequence);
        }
        for (DvpgEditRuleSequenceSpec dvpgEditRuleSequenceSpec : existingRules) {
            if (ruleKeyToSequence.get(((TrafficRule)dvpgEditRuleSequenceSpec).key) == null) continue;
            ((TrafficRule)dvpgEditRuleSequenceSpec).sequence = (Integer)ruleKeyToSequence.get(((TrafficRule)dvpgEditRuleSequenceSpec).key);
        }
        return existingRules;
    }

    public static String getLocalizedRuleActionName(TrafficRule.Action action) {
        String actionName = null;
        if (action == null) {
            return actionName;
        }
        if (action instanceof TrafficRule.AcceptAction) {
            actionName = NetworkStringUtil.getString("trafficFilter.rulesList.allow");
        } else if (action instanceof TrafficRule.DropAction) {
            actionName = NetworkStringUtil.getString("trafficFilter.rulesList.drop");
        } else if (action instanceof TrafficRule.UpdateTagAction) {
            TrafficRule.UpdateTagAction updateTagAction = (TrafficRule.UpdateTagAction)action;
            actionName = updateTagAction.qosTag != null && updateTagAction.dscpTag != null ? NetworkStringUtil.getString("trafficFilter.rulesList.tagBoth", updateTagAction.qosTag.toString(), updateTagAction.dscpTag.toString()) : (updateTagAction.qosTag != null ? NetworkStringUtil.getString("trafficFilter.rulesList.tagCos", updateTagAction.qosTag.toString()) : (updateTagAction.dscpTag != null ? NetworkStringUtil.getString("trafficFilter.rulesList.tagDscp", updateTagAction.dscpTag.toString()) : NetworkStringUtil.getString("trafficFilter.rulesList.tag")));
        } else {
            actionName = NetworkStringUtil.getString("trafficFilter.rulesList.unsupported");
        }
        return actionName;
    }

    public static String getLocalizedRuleDirection(String direction) {
        if (direction == null) {
            return null;
        }
        if (direction.equals(TrafficRule.RuleDirectionType.both.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.direction.ingressEgress");
        }
        if (direction.equals(TrafficRule.RuleDirectionType.incomingPackets.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.direction.egress");
        }
        if (direction.equals(TrafficRule.RuleDirectionType.outgoingPackets.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.direction.ingress");
        }
        return null;
    }

    public static String[] getTrafficQualifierTypeLabels(String[] qualifierDetails) {
        ArrayList<String> qualifierTypeLabels = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])qualifierDetails)) {
            return new String[0];
        }
        for (String qualifierDetail : qualifierDetails) {
            if (qualifierDetail.startsWith(NetworkStringUtil.getString("trafficFilter.rulesList.ip"))) {
                qualifierTypeLabels.add(NetworkStringUtil.getString("trafficFilter.rulesList.ipLabel"));
                continue;
            }
            if (qualifierDetail.startsWith(NetworkStringUtil.getString("trafficFilter.rulesList.mac"))) {
                qualifierTypeLabels.add(NetworkStringUtil.getString("trafficFilter.rulesList.macLabel"));
                continue;
            }
            if (!qualifierDetail.startsWith(NetworkStringUtil.getString("trafficFilter.rulesList.infrastructureTraffic"))) continue;
            qualifierTypeLabels.add(NetworkStringUtil.getString("trafficFilter.rulesList.systemTrafficLabel"));
        }
        return qualifierTypeLabels.toArray(new String[qualifierTypeLabels.size()]);
    }

    public static String[] getSortedTrafficQualifiersDetails(TrafficRule.Qualifier[] qualifiers) {
        ArrayList<String> trafficRuleQualifiers = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])qualifiers)) {
            return new String[0];
        }
        String ipQualifierDetails = null;
        String macQualifierDetails = null;
        String systemQualifierDetails = null;
        for (TrafficRule.Qualifier qualifier : qualifiers) {
            String qualifierDetails = DvpgTrafficFilterParser.getLocalizedQualifierDetails(qualifier);
            if (qualifierDetails == null) continue;
            if (qualifier instanceof TrafficRule.IpQualifier) {
                ipQualifierDetails = qualifierDetails;
                continue;
            }
            if (qualifier instanceof TrafficRule.MacQualifier) {
                macQualifierDetails = qualifierDetails;
                continue;
            }
            if (!(qualifier instanceof TrafficRule.SystemTrafficQualifier)) continue;
            systemQualifierDetails = qualifierDetails;
        }
        if (ipQualifierDetails != null) {
            trafficRuleQualifiers.add(ipQualifierDetails);
        }
        if (macQualifierDetails != null) {
            trafficRuleQualifiers.add(macQualifierDetails);
        }
        if (systemQualifierDetails != null) {
            trafficRuleQualifiers.add(systemQualifierDetails);
        }
        return trafficRuleQualifiers.toArray(new String[trafficRuleQualifiers.size()]);
    }

    public static String getLocalizedQualifierDetails(TrafficRule.Qualifier qualifier) {
        if (qualifier == null) {
            return null;
        }
        StringBuilder qualifierDetailsBuilder = new StringBuilder();
        ArrayList<String> details = new ArrayList<String>();
        String qualifierProtocol = null;
        String sourceAddress = null;
        String destinationAddress = null;
        String sourcePort = null;
        String destinationPort = null;
        String vlan = null;
        String qualifierType = DvpgTrafficFilterParser.getQualifierType(qualifier);
        if (qualifier instanceof TrafficRule.SystemTrafficQualifier) {
            qualifierType = qualifierType + DIVIDER + DvpgTrafficFilterParser.getLocalizedSystemTrafficTypeExpression(((TrafficRule.SystemTrafficQualifier)qualifier).typeOfSystemTraffic);
        } else {
            qualifierProtocol = DvpgTrafficFilterParser.getLocalizedQualifierProtocol(qualifier);
            if (qualifier instanceof TrafficRule.IpQualifier) {
                TrafficRule.IpQualifier ipQualifier = (TrafficRule.IpQualifier)qualifier;
                sourceAddress = DvpgTrafficFilterParser.getFormattedIpAddress(ipQualifier.sourceAddress);
                destinationAddress = DvpgTrafficFilterParser.getFormattedIpAddress(ipQualifier.destinationAddress);
                destinationPort = DvpgTrafficFilterParser.getFormattedPort(ipQualifier.destinationIpPort, ipQualifier.protocol);
                sourcePort = DvpgTrafficFilterParser.getFormattedPort(ipQualifier.sourceIpPort, ipQualifier.protocol);
            } else if (qualifier instanceof TrafficRule.MacQualifier) {
                TrafficRule.MacQualifier macQualifier = (TrafficRule.MacQualifier)qualifier;
                sourceAddress = DvpgTrafficFilterParser.getFormattedMacAddress(macQualifier.sourceAddress);
                destinationAddress = DvpgTrafficFilterParser.getFormattedMacAddress(macQualifier.destinationAddress);
                vlan = DvpgTrafficFilterParser.getLocalizedVlan(macQualifier.vlanId);
            }
        }
        if (qualifierType != null) {
            details.add(qualifierType);
        }
        if (qualifierProtocol != null) {
            details.add(qualifierProtocol);
        }
        if (sourcePort != null) {
            details.add(NetworkStringUtil.getString("trafficFilter.rulesList.sourcePort", sourcePort));
        }
        if (destinationPort != null) {
            details.add(NetworkStringUtil.getString("trafficFilter.rulesList.destinationPort", destinationPort));
        }
        if (vlan != null) {
            details.add(NetworkStringUtil.getString("trafficFilter.rulesList.vlan", vlan));
        }
        if (sourceAddress != null) {
            details.add(NetworkStringUtil.getString("trafficFilter.rulesList.source", sourceAddress));
        }
        if (destinationAddress != null) {
            details.add(NetworkStringUtil.getString("trafficFilter.rulesList.destination", destinationAddress));
        }
        if (details.size() > 0) {
            for (int i = 0; i < details.size() - 1; ++i) {
                qualifierDetailsBuilder.append((String)details.get(i));
                qualifierDetailsBuilder.append(DIVIDER);
            }
            qualifierDetailsBuilder.append((String)details.get(details.size() - 1));
            return qualifierDetailsBuilder.toString();
        }
        return null;
    }

    public static String getQualifierType(TrafficRule.Qualifier qualifier) {
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof TrafficRule.MacQualifier) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.mac");
        }
        if (qualifier instanceof TrafficRule.SystemTrafficQualifier) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.infrastructureTraffic");
        }
        if (qualifier instanceof TrafficRule.IpQualifier) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.ip");
        }
        return null;
    }

    public static String getLocalizedQualifierProtocol(TrafficRule.Qualifier qualifier) {
        String protocol = null;
        if (qualifier == null) {
            return protocol;
        }
        if (qualifier instanceof TrafficRule.MacQualifier) {
            protocol = NetworkStringUtil.getString("trafficFilter.rulesList.macQualifierProtocol", DvpgTrafficFilterParser.getLocalizedMacProtocol((TrafficRule.MacQualifier)qualifier));
        } else if (qualifier instanceof TrafficRule.IpQualifier) {
            protocol = NetworkStringUtil.getString("trafficFilter.rulesList.ipQualifierProtocol", DvpgTrafficFilterParser.getLocalizedIpProtocol((TrafficRule.IpQualifier)qualifier));
        }
        return protocol;
    }

    public static String getLocalizedMacProtocol(TrafficRule.MacQualifier macQualifier) {
        String localizedMacProtocol;
        if (macQualifier == null) {
            return null;
        }
        IntExpression macProtocol = macQualifier.protocol;
        if (macProtocol == null || macProtocol.value == null) {
            localizedMacProtocol = NetworkStringUtil.getString("trafficFilter.rulesList.any");
        } else {
            localizedMacProtocol = DvpgTrafficFilterParser.getHexRepresentation(macProtocol.value);
            switch (macProtocol.value) {
                case 2054: {
                    localizedMacProtocol = NetworkStringUtil.getString("trafficFilter.rulesList.arpFormat", DvpgTrafficFilterParser.getHexRepresentation(2054));
                    break;
                }
                case 2048: {
                    localizedMacProtocol = NetworkStringUtil.getString("trafficFilter.rulesList.ipv4Format", DvpgTrafficFilterParser.getHexRepresentation(2048));
                    break;
                }
                case 34525: {
                    localizedMacProtocol = NetworkStringUtil.getString("trafficFilter.rulesList.ipv6Format", DvpgTrafficFilterParser.getHexRepresentation(34525));
                }
            }
            if (DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)macProtocol)) {
                localizedMacProtocol = NetworkStringUtil.getString("trafficFilter.rulesList.negatedProtocol", localizedMacProtocol);
            }
        }
        return localizedMacProtocol;
    }

    public static String getLocalizedIpProtocol(TrafficRule.IpQualifier ipQualifier) {
        if (ipQualifier == null) {
            return null;
        }
        IntExpression ipProtocol = ipQualifier.protocol;
        if (ipProtocol == null) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.any");
        }
        String ipProtocolString = ipProtocol.value.toString();
        switch (ipProtocol.value) {
            case 1: {
                ipProtocolString = NetworkStringUtil.getString("trafficFilter.rulesList.icmp", String.valueOf(1));
                break;
            }
            case 6: {
                ipProtocolString = NetworkStringUtil.getString("trafficFilter.rulesList.tcp", String.valueOf(6));
                break;
            }
            case 17: {
                ipProtocolString = NetworkStringUtil.getString("trafficFilter.rulesList.udp", String.valueOf(17));
                break;
            }
            case 58: {
                ipProtocolString = NetworkStringUtil.getString("trafficFilter.rulesList.icmp6", String.valueOf(58));
            }
        }
        if (DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)ipProtocol)) {
            ipProtocolString = NetworkStringUtil.getString("trafficFilter.rulesList.negatedProtocol", ipProtocolString);
        }
        return ipProtocolString;
    }

    public static String getLocalizedVlan(IntExpression vlanId) {
        if (vlanId == null) {
            return null;
        }
        String vlanString = vlanId.value.toString();
        if (DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)vlanId)) {
            vlanString = NetworkStringUtil.getString("trafficFilter.rulesList.negatedVlan", vlanString);
        }
        return vlanString;
    }

    public static String getLocalizedSystemTrafficTypeExpression(StringExpression systemTrafficExpression) {
        String trafficTypeString = null;
        if (systemTrafficExpression != null && !StringUtil.isNullOrEmpty((String)systemTrafficExpression.value)) {
            trafficTypeString = DvpgTrafficFilterParser.getLocalizedSystemTrafficType(systemTrafficExpression.value);
            if (DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)systemTrafficExpression) && !StringUtil.isNullOrEmpty((String)trafficTypeString)) {
                trafficTypeString = NetworkStringUtil.getString("trafficFilter.rulesList.negatedInfrastructureTraffic", trafficTypeString);
            }
        }
        return trafficTypeString;
    }

    public static String getLocalizedSystemTrafficType(String trafficType) {
        if (trafficType == null) {
            return null;
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.faultTolerance.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.faultTolerance");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.hbr.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.hbr");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.iSCSI.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.iscsi");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.management.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.management");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.nfs.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.nfs");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.virtualMachine.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.vm");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.vmotion.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.vMotion");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.vsan.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.vsan");
        }
        if (trafficType.equals(DistributedVirtualSwitch.HostInfrastructureTrafficClass.vdp.name())) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.vdp");
        }
        return null;
    }

    public static String getFormattedIpAddress(IpAddress ipAddress) {
        String resultAddress = null;
        boolean isNegated = DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)ipAddress);
        if (ipAddress instanceof SingleIp) {
            SingleIp singleIp = (SingleIp)ipAddress;
            String string = resultAddress = !StringUtil.isNullOrEmpty((String)singleIp.address) ? singleIp.address : null;
            if (isNegated && !StringUtil.isNullOrEmpty((String)resultAddress)) {
                resultAddress = NetworkStringUtil.getString("trafficFilter.rulesList.negatedAddress", resultAddress);
            }
        } else if (ipAddress instanceof IpRange) {
            IpRange ipRange = (IpRange)ipAddress;
            if (ipRange.addressPrefix.contains(IPV6_ADDRESS_GROUP_SEPARATOR) && ipRange.prefixLength == 0 && !isNegated) {
                resultAddress = NetworkStringUtil.getString("trafficFilter.rulesList.any.ipv6");
            } else if (IpUtil.isIpv4Valid(ipRange.addressPrefix) && ipRange.prefixLength == 0 && !isNegated) {
                resultAddress = NetworkStringUtil.getString("trafficFilter.rulesList.any.ipv4");
            } else if (ipRange.addressPrefix != null && ipRange.prefixLength != null) {
                String addressFormat = isNegated ? "trafficFilter.rulesList.negatedWildcard" : "trafficFilter.rulesList.matchesWildcard";
                resultAddress = NetworkStringUtil.getString(addressFormat, ipRange.addressPrefix, ipRange.prefixLength.toString());
            }
        }
        return resultAddress;
    }

    public static String getFormattedMacAddress(MacAddress macAddress) {
        if (macAddress == null) {
            return null;
        }
        String resultAddress = null;
        boolean isNegated = DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)macAddress);
        if (macAddress instanceof SingleMac) {
            SingleMac singleMac = (SingleMac)macAddress;
            String string = resultAddress = singleMac.address != null ? singleMac.address : null;
            if (isNegated && !StringUtil.isNullOrEmpty((String)resultAddress)) {
                resultAddress = NetworkStringUtil.getString("trafficFilter.rulesList.negatedAddress", resultAddress);
            }
        } else if (macAddress instanceof MacRange) {
            MacRange macRange = (MacRange)macAddress;
            if (!StringUtil.isNullOrEmpty((String)macRange.address)) {
                if (!StringUtil.isNullOrEmpty((String)macRange.mask)) {
                    String wildcardFormat = isNegated ? "trafficFilter.rulesList.negatedWildcard" : "trafficFilter.rulesList.matchesWildcard";
                    resultAddress = NetworkStringUtil.getString(wildcardFormat, macRange.address, macRange.mask);
                } else {
                    resultAddress = isNegated ? NetworkStringUtil.getString("trafficFilter.rulesList.negatedAddress", macRange.address) : macRange.address;
                }
            }
        }
        return resultAddress;
    }

    public static String getFormattedPort(TrafficRule.IpPort port, IntExpression protocol) {
        String resultPort = null;
        boolean isTcpOrUdp = DvpgTrafficFilterParser.isTcpOrUdpProtocolExpression(protocol);
        boolean isNegated = DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)port);
        if (!isTcpOrUdp) {
            return null;
        }
        if (port instanceof TrafficRule.SingleIpPort) {
            TrafficRule.SingleIpPort singlePort = (TrafficRule.SingleIpPort)port;
            resultPort = Integer.toString(singlePort.portNumber);
            if (isNegated) {
                resultPort = NetworkStringUtil.getString("trafficFilter.rulesList.negatedPort", resultPort);
            }
        } else if (port instanceof TrafficRule.IpPortRange) {
            TrafficRule.IpPortRange portRange = (TrafficRule.IpPortRange)port;
            String rangeFormat = isNegated ? "trafficFilter.rulesList.negatedPortRange" : "trafficFilter.rulesList.portRangeFormat";
            resultPort = NetworkStringUtil.getString(rangeFormat, Integer.toString(portRange.startPortNumber), Integer.toString(portRange.endPortNumber));
        }
        return resultPort;
    }

    public static String getHexRepresentation(Integer value) {
        if (value == null) {
            return NetworkStringUtil.getString("trafficFilter.rulesList.noData");
        }
        String hexValue = Integer.toHexString(value).toUpperCase();
        while (hexValue.length() < 4) {
            hexValue = "0" + hexValue;
        }
        return hexValue;
    }

    private static boolean isTcpOrUdpProtocolExpression(IntExpression protocol) {
        return protocol != null && !DvpgTrafficFilterParser.isExpressionNegated((NegatableExpression)protocol) && (protocol.value == 6 || protocol.value == 17);
    }

    private static boolean isExpressionNegated(NegatableExpression expression) {
        return expression != null && expression.negate != null && expression.negate != false;
    }
}

