/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListGroupingItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListHostItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListPnicItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvPortgroupModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostUplinkData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostPnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.util.DvsHostNicModelComparator;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DvsAddHostPnicParser {
    private static final String ON_THIS_SWITCH_ID = "-onThisSwitch-";
    private static final String ON_OTHER_SWITCHES_ID = "-onOtherSwitches-";

    public static DvsAddHostHierarchicalListItem[] parseHostPnics(Collection<DvsHostPnicModel> hostPnicDataObjects, DistributedVirtualPort[] uplinkPorts, DvsAddHostUplinkData dvsAddHostUplinkData, boolean areMemberHosts) {
        if (hostPnicDataObjects == null) {
            return null;
        }
        DvsHostPnicModel[] dvsHostPnicModels = hostPnicDataObjects.toArray(new DvsHostPnicModel[hostPnicDataObjects.size()]);
        Map<String, String> uplinkPortgroupKeyToName = DvsAddHostPnicParser.createUplinkPortgroupKeyToNameMap(dvsAddHostUplinkData);
        Map<String, DistributedVirtualPort> uplinkPortsMap = DvsAddHostPnicParser.createUplinkPortsMap(uplinkPorts);
        String dvsUuid = dvsAddHostUplinkData != null ? dvsAddHostUplinkData.uuid : null;
        DvsAddHostPnicParser.sortHostsAndPnics(dvsHostPnicModels);
        ArrayList<DvsAddHostHierarchicalListItem> result = new ArrayList<DvsAddHostHierarchicalListItem>();
        for (DvsHostPnicModel hostPnicModel : dvsHostPnicModels) {
            DvsAddHostHierarchicalListHostItem hostItem = DvsAddHostPnicParser.createHostItem(hostPnicModel, areMemberHosts);
            if (hostItem == null) continue;
            result.add(hostItem);
            DvsAddHostHierarchicalListGroupingItem onThisSwitch = DvsAddHostPnicParser.createGroupingItem(hostItem.id, true);
            DvsAddHostHierarchicalListGroupingItem onOtherSwitches = DvsAddHostPnicParser.createGroupingItem(hostItem.id, false);
            result.add(onThisSwitch);
            result.add(onOtherSwitches);
            if (ArrayUtil.isNullOrEmpty((Object[])hostPnicModel.pnics)) continue;
            Map<String, DataObject> pnicToSwitchMap = DvsAddHostPnicParser.createPnicToVswitchMap(hostPnicModel.proxySwitches, hostPnicModel.vswitches);
            for (PhysicalNic pnic : hostPnicModel.pnics) {
                DvsAddHostHierarchicalListPnicItem pnicItem = DvsAddHostPnicParser.createPnicItem(pnic, hostPnicModel.opaqueSwitches, pnicToSwitchMap, onOtherSwitches.id, onThisSwitch.id, (ManagedObjectReference)hostPnicModel.provider, dvsUuid, uplinkPortgroupKeyToName, uplinkPortsMap);
                if (pnicItem == null) continue;
                result.add(pnicItem);
            }
        }
        return result.toArray(new DvsAddHostHierarchicalListItem[result.size()]);
    }

    private static void sortHostsAndPnics(DvsHostPnicModel[] hostPnicModels) {
        Arrays.sort(hostPnicModels, new DvsHostNicModelComparator());
        for (DvsHostPnicModel hostPnicModel : hostPnicModels) {
            if (hostPnicModel == null) continue;
            DvsAddHostPnicParser.sortPnics(hostPnicModel.pnics);
        }
    }

    private static void sortPnics(PhysicalNic[] pnics) {
        if (ArrayUtil.isNullOrEmpty((Object[])pnics)) {
            return;
        }
        Arrays.sort(pnics, new Comparator<PhysicalNic>(){

            @Override
            public int compare(PhysicalNic pnic1, PhysicalNic pnic2) {
                if (pnic1 == null) {
                    return -1;
                }
                if (pnic2 == null) {
                    return 1;
                }
                String pnic1Device = pnic1.device;
                String pnic2Device = pnic2.device;
                return NetworkUtil.compareNicDevices(pnic1Device, pnic2Device, "vmnic");
            }
        });
    }

    private static DvsAddHostHierarchicalListPnicItem createPnicItem(PhysicalNic pnic, OpaqueSwitch[] opaqueSwitches, Map<String, DataObject> pnicToVSwitchMap, String onOtherSwitchesId, String onThisSwitchId, ManagedObjectReference hostRef, String dvsUuid, Map<String, String> uplinkPortgroupKeyToName, Map<String, DistributedVirtualPort> uplinkPortsMap) {
        if (pnic == null || NetworkUtil.isPnicAttachedToOvs(pnic, opaqueSwitches) || StringUtil.isNullOrEmpty((String)pnic.device) || StringUtil.isNullOrEmpty((String)pnic.key)) {
            return null;
        }
        DataObject vSwitch = pnicToVSwitchMap.get(pnic.key);
        String inUseBySwitch = NetworkStringUtil.getString("na");
        boolean isStandardSwitch = false;
        boolean isAssigned = false;
        String parentId = onOtherSwitchesId;
        String uplinkPortgroupName = NetworkStringUtil.getString("na");
        String uplinkPortgroupKey = null;
        String uplink = NetworkStringUtil.getString("na");
        if (vSwitch instanceof HostProxySwitch) {
            HostProxySwitch hpSwitch = (HostProxySwitch)vSwitch;
            inUseBySwitch = hpSwitch.dvsName;
            isAssigned = true;
            if (!StringUtil.isNullOrEmpty((String)dvsUuid) && dvsUuid.equals(hpSwitch.dvsUuid)) {
                parentId = onThisSwitchId;
                HostMember.PnicSpec pnicSpec = DvsAddHostPnicParser.getPnicSpec(hpSwitch, pnic);
                if (pnicSpec != null) {
                    DistributedVirtualPort port;
                    uplinkPortgroupKey = pnicSpec.uplinkPortgroupKey;
                    String pgName = uplinkPortgroupKeyToName.get(uplinkPortgroupKey);
                    if (!StringUtil.isNullOrEmpty((String)pgName)) {
                        uplinkPortgroupName = pgName;
                    }
                    if ((port = uplinkPortsMap.get(pnicSpec.uplinkPortKey)) != null && port.config != null && !StringUtil.isNullOrEmpty((String)port.config.name)) {
                        uplink = port.config.name;
                    }
                }
            }
        } else if (vSwitch instanceof VirtualSwitch) {
            VirtualSwitch virtualSwitch = (VirtualSwitch)vSwitch;
            inUseBySwitch = virtualSwitch.name;
            isAssigned = true;
            isStandardSwitch = true;
        }
        DvsAddHostHierarchicalListPnicItem pnicItem = new DvsAddHostHierarchicalListPnicItem(pnic.device, parentId + pnic.key, parentId, onThisSwitchId, onOtherSwitchesId, pnic.device, inUseBySwitch, isStandardSwitch, isAssigned, hostRef);
        pnicItem.uplink = uplink;
        pnicItem.uplinkPortgroup = new DvPortgroupModel();
        pnicItem.uplinkPortgroup.name = uplinkPortgroupName;
        pnicItem.uplinkPortgroup.key = uplinkPortgroupKey;
        return pnicItem;
    }

    private static HostMember.PnicSpec getPnicSpec(HostProxySwitch hostProxySwitch, PhysicalNic physicalNic) {
        HostProxySwitch.Specification hostProxySwitchSpec = hostProxySwitch.spec;
        if (hostProxySwitchSpec != null && hostProxySwitchSpec.backing instanceof HostMember.PnicBacking) {
            HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)hostProxySwitchSpec.backing;
            if (!ArrayUtil.isNullOrEmpty((Object[])pnicBacking.pnicSpec)) {
                for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                    if (pnicSpec == null || pnicSpec.pnicDevice == null || !pnicSpec.pnicDevice.equals(physicalNic.device)) continue;
                    return pnicSpec;
                }
            }
        }
        return null;
    }

    private static DvsAddHostHierarchicalListGroupingItem createGroupingItem(String parentId, boolean onThisSwitch) {
        String id = parentId + (onThisSwitch ? ON_THIS_SWITCH_ID : ON_OTHER_SWITCHES_ID);
        DvsAddHostHierarchicalListGroupingItem groupingItem = new DvsAddHostHierarchicalListGroupingItem(onThisSwitch, id, parentId);
        return groupingItem;
    }

    private static DvsAddHostHierarchicalListHostItem createHostItem(DvsHostPnicModel hostPnicModel, boolean isMemberHost) {
        if (hostPnicModel == null || hostPnicModel.provider == null || !(hostPnicModel.provider instanceof ManagedObjectReference) || StringUtil.isNullOrEmpty((String)hostPnicModel.name)) {
            return null;
        }
        DvsAddHostHierarchicalListHostItem hostItem = new DvsAddHostHierarchicalListHostItem(hostPnicModel.name, hostPnicModel.provider.toString(), null, (ManagedObjectReference)hostPnicModel.provider, isMemberHost);
        return hostItem;
    }

    private static Map<String, String> createUplinkPortgroupKeyToNameMap(DvsAddHostUplinkData dvsAddHostUplinkData) {
        HashMap<String, String> keyToNameMap = new HashMap<String, String>();
        if (dvsAddHostUplinkData != null && !ArrayUtil.isNullOrEmpty((Object[])dvsAddHostUplinkData.uplinkPortgroups)) {
            for (DvPortgroupModel dvPortgroupModel : dvsAddHostUplinkData.uplinkPortgroups) {
                if (dvPortgroupModel == null || StringUtil.isNullOrEmpty((String)dvPortgroupModel.key)) continue;
                keyToNameMap.put(dvPortgroupModel.key, dvPortgroupModel.name);
            }
        }
        return keyToNameMap;
    }

    private static Map<String, DistributedVirtualPort> createUplinkPortsMap(DistributedVirtualPort[] uplinkPorts) {
        HashMap<String, DistributedVirtualPort> result = new HashMap<String, DistributedVirtualPort>();
        if (!ArrayUtil.isNullOrEmpty((Object[])uplinkPorts)) {
            for (DistributedVirtualPort port : uplinkPorts) {
                if (port == null || StringUtil.isNullOrEmpty((String)port.key)) continue;
                result.put(port.key, port);
            }
        }
        return result;
    }

    private static Map<String, DataObject> createPnicToVswitchMap(HostProxySwitch[] proxySwitches, VirtualSwitch[] virtualSwitches) {
        HashMap<String, DataObject> result = new HashMap<String, DataObject>();
        if (proxySwitches != null) {
            for (HostProxySwitch hostProxySwitch : proxySwitches) {
                if (hostProxySwitch == null || hostProxySwitch.pnic == null) continue;
                for (String pnicKey : hostProxySwitch.pnic) {
                    if (StringUtil.isNullOrEmpty((String)pnicKey)) continue;
                    result.put(pnicKey, (DataObject)hostProxySwitch);
                }
            }
        }
        if (virtualSwitches != null) {
            for (HostProxySwitch hostProxySwitch : virtualSwitches) {
                if (hostProxySwitch == null || hostProxySwitch.pnic == null) continue;
                for (String pnicKey : hostProxySwitch.pnic) {
                    if (StringUtil.isNullOrEmpty((String)pnicKey)) continue;
                    result.put(pnicKey, (DataObject)hostProxySwitch);
                }
            }
        }
        return result;
    }
}

