/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostPnicParser;
import com.vmware.vsphere.client.h5.network.dvs.addhost.hierarchicalList.DvsAddHostHierarchicalListItem;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostUplinkData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostPnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostsSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsAddHostPnicPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DvsAddHostPnicPropertyProvider.class);
    private final QueryBindingService _queryBindingService;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public DvsAddHostPnicPropertyProvider(QueryBindingService queryBindingService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryBindingService = queryBindingService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsAddHost", property="hostPnicData")
    public DvsAddHostHierarchicalListItem[] getHostPnicData(ManagedObjectReference dvsRef, DvsHostsSpec dvshostsSpec) {
        Collection dvsHostPnicModels = this._queryBindingService.prepare(DvsHostPnicModel.class).fetch(Arrays.asList(dvshostsSpec.hosts));
        DistributedVirtualPort[] ports = null;
        DvsAddHostUplinkData dvsAddHostUplinkData = null;
        if (dvshostsSpec.areMemberHosts) {
            PortCriteria portCriteria = new PortCriteria();
            portCriteria.uplinkPort = true;
            try {
                ports = (DistributedVirtualPort[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, dvsRef, "ports", portCriteria);
            }
            catch (Exception e) {
                _logger.debug((Object)("Unable to retrieve uplink ports: " + e.getLocalizedMessage()));
            }
            dvsAddHostUplinkData = (DvsAddHostUplinkData)this._queryBindingService.prepare(DvsAddHostUplinkData.class).fetch((Object)dvsRef);
        }
        return DvsAddHostPnicParser.parseHostPnics(dvsHostPnicModels, ports, dvsAddHostUplinkData, dvshostsSpec.areMemberHosts);
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsAddHost", property="uplinkData")
    public DvsAddHostUplinkData getDvsUplinkData(ManagedObjectReference dvsRef) {
        return (DvsAddHostUplinkData)this._queryBindingService.prepare(DvsAddHostUplinkData.class).fetch((Object)dvsRef);
    }
}

