/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.HostListItemData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.DvsHostMemberModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class HostListItemHelper {
    private static final Map<String, String> vdsStateEnumToMessageKeyMap = new HashMap<String, String>();
    private static final Map<String, String> hostConnectionStateToMessageKeyMap = new HashMap<String, String>();
    private static final Map<String, String> vdsStateEnumToIconMap = new HashMap<String, String>();

    public List<HostListItemData> createHostListItems(Collection<DvsHostMemberModel> dvsHostMemberModels) {
        Validate.notNull(dvsHostMemberModels);
        ArrayList<HostListItemData> hostListItems = new ArrayList<HostListItemData>();
        for (DvsHostMemberModel dvsHostMemberModel : dvsHostMemberModels) {
            hostListItems.add(this.getHostListItemData(dvsHostMemberModel));
        }
        Collections.sort(hostListItems, new Comparator<HostListItemData>(){

            @Override
            public int compare(HostListItemData first, HostListItemData second) {
                return ObjectUtil.compare((Comparable)((Object)first.hostName), (Comparable)((Object)second.hostName));
            }
        });
        return hostListItems;
    }

    public List<HostListItemData> createOutOfSyncHostListItems(Collection<DvsHostMemberModel> dvsHostMemberModels, HostMember.RuntimeInfo[] hostMemberRuntimeInfos) {
        Validate.notNull(dvsHostMemberModels);
        ArrayList<HostListItemData> hostListItems = new ArrayList<HostListItemData>();
        if (hostMemberRuntimeInfos != null) {
            for (DvsHostMemberModel dvsHostMemberModel : dvsHostMemberModels) {
                HostMember.RuntimeInfo hostMemberRuntimeInfo = null;
                for (HostMember.RuntimeInfo info : hostMemberRuntimeInfos) {
                    if (!dvsHostMemberModel.hostRef.equals((Object)info.host)) continue;
                    hostMemberRuntimeInfo = info;
                    break;
                }
                if (hostMemberRuntimeInfo == null || !NetworkStringUtil.getString("HostListItemData.DvsConnectionState.OutOfSync").equals(this.getVdsState(hostMemberRuntimeInfo))) continue;
                HostListItemData hostListItemData = this.getHostListItemData(dvsHostMemberModel);
                hostListItemData.vdsState = NetworkStringUtil.getString("HostListItemData.DvsConnectionState.OutOfSync");
                hostListItemData.vdsStateIcon = vdsStateEnumToIconMap.get(HostMember.HostComponentState.outOfSync.name());
                hostListItems.add(hostListItemData);
            }
        }
        Collections.sort(hostListItems, new Comparator<HostListItemData>(){

            @Override
            public int compare(HostListItemData first, HostListItemData second) {
                return ObjectUtil.compare((Comparable)((Object)first.hostName), (Comparable)((Object)second.hostName));
            }
        });
        return hostListItems;
    }

    public void addVdsStateToItem(HostListItemData hostListItemData, HostMember.RuntimeInfo[] hostMemberRuntimeInfos) {
        HostMember.RuntimeInfo hostMemberRuntimeInfo = null;
        if (hostMemberRuntimeInfos != null) {
            for (HostMember.RuntimeInfo info : hostMemberRuntimeInfos) {
                if (!hostListItemData.hostRef.equals((Object)info.host)) continue;
                hostMemberRuntimeInfo = info;
                break;
            }
            if (hostMemberRuntimeInfo != null) {
                hostListItemData.vdsState = this.getVdsState(hostMemberRuntimeInfo);
                hostListItemData.vdsStateIcon = this.getVdsStateIcon(hostMemberRuntimeInfo);
            }
        }
    }

    private HostListItemData getHostListItemData(DvsHostMemberModel dvsHostMemberModel) {
        HostListItemData hostListItemData = new HostListItemData();
        hostListItemData.hostName = dvsHostMemberModel.hostName;
        hostListItemData.clusterName = dvsHostMemberModel.clusterName;
        hostListItemData.connectionState = dvsHostMemberModel.hostConnectionState;
        hostListItemData.hostRef = dvsHostMemberModel.hostRef;
        hostListItemData.hostIconId = dvsHostMemberModel.primaryIconId;
        hostListItemData.connectionStateLabel = this.getConnectionStateLabel(dvsHostMemberModel);
        return hostListItemData;
    }

    private String getConnectionStateLabel(DvsHostMemberModel hostMemberInfo) {
        String connectionStateLabel = NetworkStringUtil.getString("HostListItemData.noData");
        if (HostSystem.PowerState.standBy.equals((Object)hostMemberInfo.hostPowerState)) {
            connectionStateLabel = NetworkStringUtil.getString("HostListItemData.HostState.Standby");
        } else {
            if (hostMemberInfo.hostConnectionState != null) {
                connectionStateLabel = NetworkStringUtil.getString(hostConnectionStateToMessageKeyMap.get(hostMemberInfo.hostConnectionState.name()));
            }
            if (hostMemberInfo.isHostInMaintenance) {
                connectionStateLabel = NetworkStringUtil.getString("HostListItemData.HostState.MaintenanceMode", connectionStateLabel);
            }
        }
        return connectionStateLabel;
    }

    private String getVdsState(HostMember.RuntimeInfo runtimeInfo) {
        String vdsState = null;
        String vdsStateMessageKey = vdsStateEnumToMessageKeyMap.get(runtimeInfo.status);
        if (vdsStateMessageKey != null) {
            vdsState = NetworkStringUtil.getString(vdsStateMessageKey);
        }
        return vdsState;
    }

    private String getVdsStateIcon(HostMember.RuntimeInfo hostMemberInfo) {
        return vdsStateEnumToIconMap.get(hostMemberInfo.status);
    }

    static {
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.disconnected.name(), "HostListItemData.DvsConnectionState.Disconnected");
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.down.name(), "HostListItemData.DvsConnectionState.Down");
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.up.name(), "HostListItemData.DvsConnectionState.Up");
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.warning.name(), "HostListItemData.DvsConnectionState.Warning");
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.outOfSync.name(), "HostListItemData.DvsConnectionState.OutOfSync");
        vdsStateEnumToMessageKeyMap.put(HostMember.HostComponentState.pending.name(), "HostListItemData.DvsConnectionState.pending");
        hostConnectionStateToMessageKeyMap.put(HostSystem.ConnectionState.disconnected.name(), "HostListItemData.HostState.Disconnected");
        hostConnectionStateToMessageKeyMap.put(HostSystem.ConnectionState.connected.name(), "HostListItemData.HostState.Connected");
        hostConnectionStateToMessageKeyMap.put(HostSystem.ConnectionState.notResponding.name(), "HostListItemData.HostState.NotResponding");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.disconnected.name(), "statusUnknown");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.down.name(), "statusRed");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.up.name(), "statusGreen");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.warning.name(), "statusYellow");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.outOfSync.name(), "statusYellow");
        vdsStateEnumToIconMap.put(HostMember.HostComponentState.pending.name(), "statusUnknown");
    }
}

