/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.healthcheck;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckDetailsItemData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckPnicBindingData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class DvsHealthCheckDetailsDataParser {
    private static final String ICON_GREEN = "vsphere-icon-status-ok";
    private static final String ICON_YELLOW = "vsphere-icon-status-warning";
    private static final String ICON_GRAY = "vsphere-icon-status-unknown";
    private Map<String, String> _ipHashStatusMap;
    private Map<String, Map<String, String>> _hostNamePortKeyPnicMap;
    private Map<String, Map<String, String>> _hostNamePortKeyUplinkMap;
    private String _hostName;
    private ManagedObjectReference _hostMor;
    private List<DvsHealthCheckDetailsItemData> _dvsHealthCheckDetailsItemDataList = new ArrayList<DvsHealthCheckDetailsItemData>();

    public DvsHealthCheckDetailsDataParser(Map<String, Map<String, String>> hostNamePortKeyPnicMap, Map<String, Map<String, String>> hostNamePortKeyUplinkMap) {
        this.initIpHashStatusMap();
        this._hostNamePortKeyPnicMap = hostNamePortKeyPnicMap;
        this._hostNamePortKeyUplinkMap = hostNamePortKeyUplinkMap;
    }

    public void setHost(String hostName, ManagedObjectReference hostMor) {
        this._hostName = hostName;
        this._hostMor = hostMor;
    }

    public List<DvsHealthCheckDetailsItemData> getDvsHealthCheckVlanItemDataList() {
        return this._dvsHealthCheckDetailsItemDataList;
    }

    public void addVlanHealthCheckDetails(VmwareDistributedVirtualSwitch.VlanHealthCheckResult healthCheckResult) throws Exception {
        DvsHealthCheckPnicBindingData healthCheckPnicsBindingData = this.formatPnicAndUplinkInfo(healthCheckResult.uplinkPortKey);
        DvsHealthCheckDetailsItemData healthCheckTrunkedVlanItemData = this.formatVlanTrunkedInfo(healthCheckPnicsBindingData, healthCheckResult);
        DvsHealthCheckDetailsItemData healthCheckUnrunkedVlanItemData = this.formatVlanUntrunkedInfo(healthCheckPnicsBindingData, healthCheckResult);
        if (healthCheckTrunkedVlanItemData != null) {
            this._dvsHealthCheckDetailsItemDataList.add(healthCheckTrunkedVlanItemData);
        }
        if (healthCheckUnrunkedVlanItemData != null) {
            this._dvsHealthCheckDetailsItemDataList.add(healthCheckUnrunkedVlanItemData);
        }
    }

    public void addMtuHealthCheckDetails(VmwareDistributedVirtualSwitch.MtuHealthCheckResult healthCheckResult) throws Exception {
        DvsHealthCheckPnicBindingData healthCheckPnicsBindingData = this.formatPnicAndUplinkInfo(healthCheckResult.uplinkPortKey);
        DvsHealthCheckDetailsItemData healthCheckMtuVlanSupportedItemData = this.formatMtuVlanSupportedInfo(healthCheckPnicsBindingData, healthCheckResult);
        DvsHealthCheckDetailsItemData healthCheckMtuVlanNotSupportedItemData = this.formatMtuVlanNotSupportedInfo(healthCheckPnicsBindingData, healthCheckResult);
        if (healthCheckMtuVlanSupportedItemData != null) {
            this._dvsHealthCheckDetailsItemDataList.add(healthCheckMtuVlanSupportedItemData);
        }
        if (healthCheckMtuVlanNotSupportedItemData != null) {
            this._dvsHealthCheckDetailsItemDataList.add(healthCheckMtuVlanNotSupportedItemData);
        }
    }

    public void addIpHashHealthCheckDetails(VmwareDistributedVirtualSwitch.TeamingHealthCheckResult healthCheckResult) {
        DvsHealthCheckDetailsItemData dvsHealthCheckIpHashItemData = new DvsHealthCheckDetailsItemData();
        dvsHealthCheckIpHashItemData.hostName = this._hostName;
        dvsHealthCheckIpHashItemData.hostMor = this._hostMor;
        if (healthCheckResult != null && healthCheckResult.teamingStatus != null) {
            dvsHealthCheckIpHashItemData.ipHashDetails = this._ipHashStatusMap.get(healthCheckResult.teamingStatus);
            boolean ipHashMismatch = healthCheckResult.teamingStatus.equals(VmwareDistributedVirtualSwitch.TeamingMatchStatus.iphashMismatch.name());
            boolean nonIphashMismatch = healthCheckResult.teamingStatus.equals(VmwareDistributedVirtualSwitch.TeamingMatchStatus.nonIphashMismatch.name());
            if (ipHashMismatch || nonIphashMismatch) {
                dvsHealthCheckIpHashItemData.teamingStatus = NetworkStringUtil.getString("dvs.healthCheck.status.warning");
                dvsHealthCheckIpHashItemData.teamingStatusIcon = ICON_YELLOW;
            } else {
                dvsHealthCheckIpHashItemData.teamingStatus = NetworkStringUtil.getString("dvs.healthCheck.status.normal");
                dvsHealthCheckIpHashItemData.teamingStatusIcon = ICON_GREEN;
            }
        } else {
            dvsHealthCheckIpHashItemData.teamingStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
            dvsHealthCheckIpHashItemData.ipHashDetails = NetworkStringUtil.getString("na");
            dvsHealthCheckIpHashItemData.teamingStatusIcon = ICON_GRAY;
        }
        this._dvsHealthCheckDetailsItemDataList.add(dvsHealthCheckIpHashItemData);
    }

    private void initIpHashStatusMap() {
        this._ipHashStatusMap = new HashMap<String, String>();
        this._ipHashStatusMap.put(VmwareDistributedVirtualSwitch.TeamingMatchStatus.iphashMatch.name(), NetworkStringUtil.getString("dvs.healthCheck.teaming.status.iphashMatch"));
        this._ipHashStatusMap.put(VmwareDistributedVirtualSwitch.TeamingMatchStatus.iphashMismatch.name(), NetworkStringUtil.getString("dvs.healthCheck.teaming.status.iphashMismatch"));
        this._ipHashStatusMap.put(VmwareDistributedVirtualSwitch.TeamingMatchStatus.nonIphashMatch.name(), NetworkStringUtil.getString("dvs.healthCheck.teaming.status.nonIphashMatch"));
        this._ipHashStatusMap.put(VmwareDistributedVirtualSwitch.TeamingMatchStatus.nonIphashMismatch.name(), NetworkStringUtil.getString("dvs.healthCheck.teaming.status.nonIphashMismatch"));
    }

    private DvsHealthCheckPnicBindingData formatPnicAndUplinkInfo(String uplinkPortKey) throws Exception {
        DvsHealthCheckPnicBindingData healthCheckPnicBindingItemData = null;
        for (Map.Entry<String, Map<String, String>> entry : this._hostNamePortKeyPnicMap.entrySet()) {
            Map<String, String> uplinkPnicMap;
            if (!entry.getKey().equals(this._hostName) || !(uplinkPnicMap = entry.getValue()).keySet().contains(uplinkPortKey)) continue;
            healthCheckPnicBindingItemData = new DvsHealthCheckPnicBindingData();
            healthCheckPnicBindingItemData.hostName = this._hostName;
            healthCheckPnicBindingItemData.hostMor = this._hostMor;
            healthCheckPnicBindingItemData.pnicName = uplinkPnicMap.get(uplinkPortKey);
        }
        if (healthCheckPnicBindingItemData == null) {
            return null;
        }
        for (Map.Entry<String, Map<String, String>> entry : this._hostNamePortKeyUplinkMap.entrySet()) {
            Map<String, String> uplinkKeyNameMap;
            if (!entry.getKey().equals(this._hostName) || !(uplinkKeyNameMap = entry.getValue()).keySet().contains(uplinkPortKey)) continue;
            healthCheckPnicBindingItemData.uplinkName = uplinkKeyNameMap.get(uplinkPortKey);
        }
        return healthCheckPnicBindingItemData;
    }

    private DvsHealthCheckDetailsItemData formatVlanTrunkedInfo(DvsHealthCheckPnicBindingData healthCheckPnicBindingData, VmwareDistributedVirtualSwitch.VlanHealthCheckResult healthCheckResult) {
        if (healthCheckPnicBindingData == null) {
            return null;
        }
        DvsHealthCheckDetailsItemData healthCheckVlanItemDataToFormat = null;
        Object[] trunkedVlan = healthCheckResult.trunkedVlan;
        if (ArrayUtils.isNotEmpty((Object[])trunkedVlan)) {
            healthCheckVlanItemDataToFormat = this.fillVlanTrunkItemData(healthCheckPnicBindingData, (NumericRange[])trunkedVlan);
            healthCheckVlanItemDataToFormat.vlanStatus = NetworkStringUtil.getString("dvs.healthCheck.status.supported");
            healthCheckVlanItemDataToFormat.vlanStatusIcon = ICON_GREEN;
        }
        return healthCheckVlanItemDataToFormat;
    }

    private DvsHealthCheckDetailsItemData formatVlanUntrunkedInfo(DvsHealthCheckPnicBindingData healthCheckPnicBindingData, VmwareDistributedVirtualSwitch.VlanHealthCheckResult healthCheckResult) {
        if (healthCheckPnicBindingData == null) {
            return null;
        }
        DvsHealthCheckDetailsItemData healthCheckVlanItemDataToFormat = null;
        Object[] untrunkedVlan = healthCheckResult.untrunkedVlan;
        if (ArrayUtils.isNotEmpty((Object[])untrunkedVlan)) {
            healthCheckVlanItemDataToFormat = this.fillVlanTrunkItemData(healthCheckPnicBindingData, (NumericRange[])untrunkedVlan);
            healthCheckVlanItemDataToFormat.vlanStatus = NetworkStringUtil.getString("dvs.healthCheck.status.notSupported");
            healthCheckVlanItemDataToFormat.vlanStatusIcon = ICON_YELLOW;
        }
        return healthCheckVlanItemDataToFormat;
    }

    private DvsHealthCheckDetailsItemData formatMtuVlanNotSupportedInfo(DvsHealthCheckPnicBindingData healthCheckPnicBindingData, VmwareDistributedVirtualSwitch.MtuHealthCheckResult healthCheckResult) {
        if (healthCheckPnicBindingData == null) {
            return null;
        }
        DvsHealthCheckDetailsItemData healthCheckVlanItemDataToFormat = null;
        Object[] vlanNotSupportSwitchMtu = healthCheckResult.vlanNotSupportSwitchMtu;
        if (ArrayUtils.isNotEmpty((Object[])vlanNotSupportSwitchMtu)) {
            healthCheckVlanItemDataToFormat = this.fillVlanTrunkItemData(healthCheckPnicBindingData, (NumericRange[])vlanNotSupportSwitchMtu);
            healthCheckVlanItemDataToFormat.mtuStatus = NetworkStringUtil.getString("dvs.healthCheck.status.notSupported");
            healthCheckVlanItemDataToFormat.mtuStatusIcon = ICON_YELLOW;
        }
        return healthCheckVlanItemDataToFormat;
    }

    private DvsHealthCheckDetailsItemData formatMtuVlanSupportedInfo(DvsHealthCheckPnicBindingData healthCheckPnicBindingData, VmwareDistributedVirtualSwitch.MtuHealthCheckResult healthCheckResult) {
        if (healthCheckPnicBindingData == null) {
            return null;
        }
        DvsHealthCheckDetailsItemData healthCheckVlanItemDataToFormat = null;
        Object[] vlanSupportSwitchMtu = healthCheckResult.vlanSupportSwitchMtu;
        if (ArrayUtils.isNotEmpty((Object[])vlanSupportSwitchMtu)) {
            healthCheckVlanItemDataToFormat = this.fillVlanTrunkItemData(healthCheckPnicBindingData, (NumericRange[])vlanSupportSwitchMtu);
            healthCheckVlanItemDataToFormat.mtuStatus = NetworkStringUtil.getString("dvs.healthCheck.status.supported");
            healthCheckVlanItemDataToFormat.mtuStatusIcon = ICON_GREEN;
        }
        return healthCheckVlanItemDataToFormat;
    }

    private DvsHealthCheckDetailsItemData fillVlanTrunkItemData(DvsHealthCheckPnicBindingData healthCheckPnicBindingData, NumericRange[] vlanNummericRange) {
        DvsHealthCheckDetailsItemData healthCheckVlanItemDataToFormat = new DvsHealthCheckDetailsItemData();
        healthCheckVlanItemDataToFormat.hostName = healthCheckPnicBindingData.hostName;
        healthCheckVlanItemDataToFormat.hostMor = healthCheckPnicBindingData.hostMor;
        healthCheckVlanItemDataToFormat.pnicName = healthCheckPnicBindingData.pnicName;
        healthCheckVlanItemDataToFormat.uplinkName = healthCheckPnicBindingData.uplinkName;
        healthCheckVlanItemDataToFormat.vlanTrunk = NumericRangeUtil.asString(vlanNummericRange);
        return healthCheckVlanItemDataToFormat;
    }
}

