/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.imports;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvPortgroupQueryRestoreSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvPortgroupRestoreInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvPortgroupRestoreInfoWrapperSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvpgImportInfoWrapperSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvpgRestoreSectionRepresentationSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsImportInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsImportInfoWrapperSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsImportPortgroupSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsImportPortgroupWrapperSpec;
import com.vmware.vsphere.client.h5.network.dvs.imports.DvpgImportParser;
import com.vmware.vsphere.client.h5.network.dvs.imports.DvpgRestoreParser;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsImportPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DvsImportPropertyProvider.class);
    private static final String SWITCH_IMPORT_INFO = "switchImportInfo";
    private static final String PORTGROUP_IMPORT_INFO = "portgroupImportInfo";
    private static final String PORTGROUP_RESTORE_INFO = "configSpecDifferences";
    private static final String PORTGROUP_RESTORE_PARENT = "config.distributedVirtualSwitch";
    private static final String PORTGROUP_RESTORE_DVS_LAGS = "config.lacpGroupConfig";
    private static final String PORTGROUP_RESTORE_DVS_UPLINKS = "config.uplinkPortPolicy.uplinkPortName";
    private static final String DVS_PVLAN_MAP_ENTRIES = "config.pvlanConfig";
    private final QueryService _queryService;

    public DvsImportPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"Folder", "Datacenter", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="switchImportInfoWrapper")
    public DvsImportInfoWrapperSpec getSwitchImportInfoWrapper(ManagedObjectReference targetRef, byte[] data2) {
        DvsImportInfoSpec dvsImportInfoSpec;
        String error;
        block4: {
            error = null;
            dvsImportInfoSpec = null;
            try {
                ResourceItem resultItem;
                ResultSet result = this._queryService.select(new String[]{SWITCH_IMPORT_INFO}).from(new String[]{targetRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("switchImportInfo/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)data2), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetRef)}).fetch();
                if (!result.getItems().isEmpty() && (resultItem = (ResourceItem)result.getItems().get(0)) != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
                    dvsImportInfoSpec = (DvsImportInfoSpec)resultItem.getPropertyValues().get(0);
                    if (!StringUtil.isNullOrEmpty((String)dvsImportInfoSpec.annotation)) {
                        dvsImportInfoSpec.annotation = DvsImportPropertyProvider.normalizeNewLines(dvsImportInfoSpec.annotation);
                    }
                }
            }
            catch (Exception e) {
                if (e.getCause() == null || StringUtil.isNullOrEmpty((String)e.getCause().getLocalizedMessage())) break block4;
                error = e.getCause().getLocalizedMessage();
            }
        }
        DvsImportInfoWrapperSpec dvsImportInfoWrapperSpec = new DvsImportInfoWrapperSpec();
        dvsImportInfoWrapperSpec.error = error;
        dvsImportInfoWrapperSpec.dvsImportInfoSpec = dvsImportInfoSpec;
        return dvsImportInfoWrapperSpec;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvpg", property="dvpgImportInfoWrapper")
    public DvpgImportInfoWrapperSpec getDvpgImportInfoWrapper(ManagedObjectReference targetRef, byte[] data2) {
        DvpgImportInfoWrapperSpec dvpgImportInfoWrapperSpec;
        DvsImportPortgroupWrapperSpec dvsImportPortgroupWrapperSpec;
        String error;
        block5: {
            error = null;
            dvsImportPortgroupWrapperSpec = null;
            dvpgImportInfoWrapperSpec = new DvpgImportInfoWrapperSpec();
            try {
                ResourceItem resultItem;
                ResultSet result = this._queryService.select(new String[]{PORTGROUP_IMPORT_INFO}).from(new String[]{targetRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("portgroupImportInfo/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)data2), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetRef)}).fetch();
                if (!result.getItems().isEmpty() && (resultItem = (ResourceItem)result.getItems().get(0)) != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
                    DvsImportPortgroupSpec dvsImportPortgroupSpec = (DvsImportPortgroupSpec)resultItem.getPropertyValues().get(0);
                    dvsImportPortgroupWrapperSpec = new DvsImportPortgroupWrapperSpec();
                    dvsImportPortgroupWrapperSpec.dvsImportPortgroupSpec = dvsImportPortgroupSpec;
                    dvsImportPortgroupWrapperSpec.vlanLabel = DvpgImportParser.getFormattedVlanValue(dvsImportPortgroupWrapperSpec.dvsImportPortgroupSpec);
                }
            }
            catch (Exception e) {
                if (e instanceof DataException && ((DataException)e).rootCause instanceof ManagedObjectNotFound) {
                    error = NetworkStringUtil.getString("dvPortGroup.import.filePage.dvsNotFound");
                }
                if (e.getCause() == null || StringUtil.isNullOrEmpty((String)e.getCause().getLocalizedMessage())) break block5;
                error = String.format(NetworkStringUtil.getString("dvPortGroup.import.filePage.internalError"), e.getCause().getLocalizedMessage());
            }
        }
        if (error == null && dvsImportPortgroupWrapperSpec != null) {
            error = DvpgImportParser.getDvpgError(dvsImportPortgroupWrapperSpec.dvsImportPortgroupSpec);
        }
        dvpgImportInfoWrapperSpec.error = error;
        dvpgImportInfoWrapperSpec.dvsImportPortgroupWrapperSpec = dvsImportPortgroupWrapperSpec;
        return dvpgImportInfoWrapperSpec;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpg", property="dvpgRestoreInfoWrapper")
    public DvPortgroupRestoreInfoWrapperSpec getDvpgRestoreInfoWrapper(ManagedObjectReference targetRef, DvPortgroupQueryRestoreSpec restoreSpec) {
        DvPortgroupRestoreInfoWrapperSpec dvPortgroupRestoreInfoWrapperSpec = new DvPortgroupRestoreInfoWrapperSpec();
        try {
            ResourceItem resultItem;
            ResultSet result = this._queryService.select(new String[]{PORTGROUP_RESTORE_INFO, PORTGROUP_RESTORE_PARENT}).from(new String[]{targetRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("configSpecDifferences/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)restoreSpec), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetRef)}).fetch();
            if (!result.getItems().isEmpty() && (resultItem = (ResourceItem)result.getItems().get(0)) != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
                DvPortgroupRestoreInfoSpec queryResultValue = (DvPortgroupRestoreInfoSpec)resultItem.getPropertyValues().get(0);
                if (queryResultValue.typeDifference) {
                    dvPortgroupRestoreInfoWrapperSpec.error = NetworkStringUtil.getString("dvpg.restore.selectPage.typeError");
                } else if (queryResultValue.portGroupNotFound) {
                    dvPortgroupRestoreInfoWrapperSpec.error = NetworkStringUtil.getString("dvpg.restore.selectPage.pgNotFoundInBackup");
                } else if (queryResultValue.configSpecDiff == null) {
                    dvPortgroupRestoreInfoWrapperSpec.error = restoreSpec.fromMemory ? NetworkStringUtil.getString("dvpg.restore.selectPage.noConfig") : NetworkStringUtil.getString("dvpg.restore.selectPage.noDiff");
                } else {
                    ArrayList<DvpgRestoreSectionRepresentationSpec> sections = new ArrayList<DvpgRestoreSectionRepresentationSpec>();
                    sections.add(DvpgRestoreParser.getBaseLabels(queryResultValue.configSpecDiff, queryResultValue.currentConfig, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)queryResultValue.dvsDefaultPortConfig));
                    if (queryResultValue.configSpecDiff.defaultPortConfig != null) {
                        if (queryResultValue.configSpecDiff.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy || queryResultValue.currentConfig.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
                            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmspec = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)queryResultValue.configSpecDiff.defaultPortConfig;
                            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vminfo = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)queryResultValue.currentConfig.defaultPortConfig;
                            queryResultValue.configSpecDiff.defaultPortConfig = DvpgRestoreParser.mergePolicies(vmspec, vminfo);
                        }
                        ManagedObjectReference dvsMor = (ManagedObjectReference)resultItem.getPropertyValues().get(1);
                        boolean hasPvlanConfig = queryResultValue.configSpecDiff.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy && ((VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)queryResultValue.configSpecDiff.defaultPortConfig).vlan instanceof VmwareDistributedVirtualSwitch.PvlanSpec;
                        ResultSet dvsConfigResult = hasPvlanConfig ? this._queryService.select(new String[]{PORTGROUP_RESTORE_DVS_LAGS, PORTGROUP_RESTORE_DVS_UPLINKS, DVS_PVLAN_MAP_ENTRIES}).from(new String[]{targetRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch() : this._queryService.select(new String[]{PORTGROUP_RESTORE_DVS_LAGS, PORTGROUP_RESTORE_DVS_UPLINKS}).from(new String[]{targetRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
                        List<String> dvsUplinks = new ArrayList<String>();
                        ArrayList<String> dvsLags = new ArrayList<String>();
                        VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntries = null;
                        if (!dvsConfigResult.getItems().isEmpty()) {
                            ResourceItem dvsPvlanConfigItems;
                            ResourceItem dvsConfigItems = (ResourceItem)dvsConfigResult.getItems().get(0);
                            if (dvsConfigItems != null && dvsConfigItems.getPropertyValues() != null && !dvsConfigItems.getPropertyValues().isEmpty()) {
                                String[] configItems;
                                VmwareDistributedVirtualSwitch.LacpGroupConfig[] lags = (VmwareDistributedVirtualSwitch.LacpGroupConfig[])dvsConfigItems.getPropertyValues().get(0);
                                if (lags != null) {
                                    for (VmwareDistributedVirtualSwitch.LacpGroupConfig lag : lags) {
                                        dvsLags.add(lag.name);
                                    }
                                }
                                if ((configItems = (String[])dvsConfigItems.getPropertyValues().get(1)) != null) {
                                    dvsUplinks = Arrays.asList((String[])dvsConfigItems.getPropertyValues().get(1));
                                }
                            }
                            if (hasPvlanConfig && (dvsPvlanConfigItems = (ResourceItem)dvsConfigResult.getItems().get(0)) != null && dvsPvlanConfigItems.getPropertyValues() != null && !dvsPvlanConfigItems.getPropertyValues().isEmpty()) {
                                pvlanMapEntries = (VmwareDistributedVirtualSwitch.PvlanMapEntry[])dvsPvlanConfigItems.getPropertyValues().get(2);
                            }
                        }
                        sections.addAll(this.setPoliciesLabels(queryResultValue.dvsDefaultPortConfig, queryResultValue.configSpecDiff, queryResultValue.currentConfig, dvsUplinks, dvsLags, pvlanMapEntries));
                    }
                    if (queryResultValue.configSpecDiff.policy != null) {
                        DvpgRestoreSectionRepresentationSpec policyMap = DvpgRestoreParser.getDisplayPolicyMap(queryResultValue.configSpecDiff.policy, queryResultValue.currentConfig.policy);
                        if (policyMap.sectionSettings.size() > 0) {
                            sections.add(policyMap);
                        }
                    }
                    dvPortgroupRestoreInfoWrapperSpec.dvpgRestoreSectionRepresentationSpec = sections;
                    dvPortgroupRestoreInfoWrapperSpec.dvPortgroupRestoreInfoSpec = queryResultValue;
                }
            }
        }
        catch (Exception e) {
            dvPortgroupRestoreInfoWrapperSpec.error = e instanceof DataException && ((DataException)e).rootCause instanceof ManagedObjectNotFound ? NetworkStringUtil.getString("dvpg.restore.selectPage.pgNotFound") : String.format(NetworkStringUtil.getString("dvpg.restore.selectPage.internalError"), e.getCause().getLocalizedMessage());
        }
        return dvPortgroupRestoreInfoWrapperSpec;
    }

    private List<DvpgRestoreSectionRepresentationSpec> setPoliciesLabels(DistributedVirtualPort.Setting dvsDefaultPortConfig, DistributedVirtualPortgroup.ConfigSpec configSpecDiff, DistributedVirtualPortgroup.ConfigInfo info, List<String> dvsUplinks, List<String> dvsLags, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntries) {
        ArrayList<DvpgRestoreSectionRepresentationSpec> result = new ArrayList<DvpgRestoreSectionRepresentationSpec>();
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmspec = null;
        if (configSpecDiff.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            vmspec = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)configSpecDiff.defaultPortConfig;
        }
        if (vmspec != null && vmspec.securityPolicy != null) {
            result.add(DvpgRestoreParser.getSecurityPolicyLabels(vmspec.securityPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (configSpecDiff.defaultPortConfig.inShapingPolicy != null) {
            result.add(DvpgRestoreParser.displayShapingPolicy(true, configSpecDiff.defaultPortConfig.inShapingPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (configSpecDiff.defaultPortConfig.outShapingPolicy != null) {
            result.add(DvpgRestoreParser.displayShapingPolicy(false, configSpecDiff.defaultPortConfig.outShapingPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (vmspec != null && vmspec.vlan != null) {
            result.add(DvpgRestoreParser.displayVlanPolicy(vmspec.vlan, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig, pvlanMapEntries));
        }
        if (vmspec != null && vmspec.uplinkTeamingPolicy != null) {
            result.add(DvpgRestoreParser.displayUplinkTeamingPolicy(vmspec.uplinkTeamingPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig, dvsUplinks, dvsLags));
        }
        if (vmspec != null && vmspec.ipfixEnabled != null) {
            result.add(DvpgRestoreParser.displayIpfixPolicy(vmspec.ipfixEnabled, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (vmspec != null && vmspec.filterPolicy != null) {
            result.add(DvpgRestoreParser.displayFilterPolicy(vmspec.filterPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
            result.add(DvpgRestoreParser.displayTrafficFilterPolicy(vmspec.filterPolicy, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (configSpecDiff.defaultPortConfig.blocked != null) {
            result.add(DvpgRestoreParser.displayPortBlockingPolicy(configSpecDiff.defaultPortConfig.blocked, (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvsDefaultPortConfig));
        }
        if (vmspec != null && vmspec.txUplink != null) {
            result.add(DvpgRestoreParser.displayTxUplinkPolicy());
        }
        return result;
    }

    private static String normalizeNewLines(String string) {
        String result = string.replace("\r\n", "\n");
        result = result.replace("\r", "\n");
        return result;
    }
}

