/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.ports;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.StringPolicy;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vsphere.client.h5.network.dvportgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupPortProperties;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortFailoverPolicyModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortPropertiesModel;
import com.vmware.vsphere.client.h5.network.util.DvsPortsUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DvsPortEditParser {
    public static DvsPortEditData getPortEditData(DvsPortEditQueryBinding dvsPortEditQueryBinding, ResultSet resultSet, ManagedObjectReference dvsMor) {
        DvsPortEditData portEditData = new DvsPortEditData();
        if (resultSet != null && resultSet.items != null) {
            portEditData = DvsPortsUtil.parsePortEditData(resultSet.items[0]);
        }
        if (dvsPortEditQueryBinding != null) {
            portEditData.isUplink = dvsPortEditQueryBinding.isUplink;
            portEditData.switchName = dvsPortEditQueryBinding.dvsName;
            portEditData.dvPortgroupPortProperties = new DvPortgroupPortProperties();
            DvPortgroupPolicyParser.setAdvancedPortPolicies(dvsPortEditQueryBinding.policy, dvsPortEditQueryBinding.isUplink, dvsPortEditQueryBinding.dvsCapability, dvsPortEditQueryBinding.niocVersion, portEditData.dvPortgroupPortProperties);
            if (dvsPortEditQueryBinding.networkResourcePool != null && portEditData.properties.selectedResourcePool != null && portEditData.dvPortgroupPortProperties.networkResourcePoolOverrideAllowed != null) {
                portEditData.properties.networkResourcePools = DvsPortEditParser.setNetworkResourcePools(dvsPortEditQueryBinding);
                portEditData.properties.selectedResourcePool.name = DvPortgroupParser.getVmVnicNetworkResourcePoolNameForNiocV2(portEditData.properties.selectedResourcePool.key, dvsPortEditQueryBinding.networkResourcePool);
            }
            if (portEditData.vlanPolicy != null) {
                portEditData.vlanPolicy.pvlanConfig = dvsPortEditQueryBinding.pvlanConfig;
                portEditData.vlanPolicy.isUplink = dvsPortEditQueryBinding.isUplink;
            }
            if (portEditData.properties != null) {
                portEditData.isLag = DvsPortEditParser.getIsLagPort(dvsPortEditQueryBinding.lacpGroupConfigs, portEditData.properties.name);
            }
            if (portEditData.monitoringPolicy != null && dvsPortEditQueryBinding.dvsCapability != null && dvsPortEditQueryBinding.dvsCapability.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability) {
                VmwareDistributedVirtualSwitch.FeatureCapability capability = (VmwareDistributedVirtualSwitch.FeatureCapability)dvsPortEditQueryBinding.dvsCapability.featuresSupported;
                portEditData.monitoringPolicy.ipfixSupported = capability.ipfixSupported != null && capability.ipfixSupported != false;
            }
            portEditData.failoverPolicy = DvsPortEditParser.getTeamingAndFailoverPolicy(portEditData.uplinkPortTeamingPolicy, dvsPortEditQueryBinding.uplinkNames, dvsPortEditQueryBinding.lacpGroupConfigs, dvsPortEditQueryBinding.loadBalancingModes);
        }
        portEditData.switchRef = dvsMor;
        return portEditData;
    }

    private static DvsPortPropertiesModel.NetworkResourcePoolData[] setNetworkResourcePools(DvsPortEditQueryBinding dvsPortEditQueryBinding) {
        ArrayList<DvsPortPropertiesModel.NetworkResourcePoolData> networkResourcePools = new ArrayList<DvsPortPropertiesModel.NetworkResourcePoolData>();
        if (ArrayUtils.isNotEmpty((Object[])dvsPortEditQueryBinding.networkResourcePool)) {
            for (NetworkResourcePool networkResourcePool : dvsPortEditQueryBinding.networkResourcePool) {
                if (networkResourcePool == null || networkResourcePool.key == null || NetworkUtil.isSystemNetworkResourcePool(networkResourcePool.key)) continue;
                DvsPortPropertiesModel.NetworkResourcePoolData resuoucePool = new DvsPortPropertiesModel.NetworkResourcePoolData();
                resuoucePool.name = networkResourcePool.name;
                resuoucePool.key = networkResourcePool.key;
                networkResourcePools.add(resuoucePool);
            }
        }
        if (networkResourcePools.size() > 1) {
            Collections.sort(networkResourcePools, new Comparator<DvsPortPropertiesModel.NetworkResourcePoolData>(){

                @Override
                public int compare(DvsPortPropertiesModel.NetworkResourcePoolData nrp1, DvsPortPropertiesModel.NetworkResourcePoolData nrp2) {
                    return nrp1.name.compareToIgnoreCase(nrp2.name);
                }
            });
        }
        DvsPortPropertiesModel.NetworkResourcePoolData defaultResourcePool = new DvsPortPropertiesModel.NetworkResourcePoolData();
        defaultResourcePool.key = "-1";
        defaultResourcePool.name = NetworkStringUtil.getString("dvpg.policy.iorm.pool.none");
        networkResourcePools.add(0, defaultResourcePool);
        return networkResourcePools.toArray(new DvsPortPropertiesModel.NetworkResourcePoolData[networkResourcePools.size()]);
    }

    private static DvsPortFailoverPolicyModel getTeamingAndFailoverPolicy(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy uplinkTeamingPolicy, String[] uplinkPortNames, VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs, String[] loadBalancingModes) {
        DvsPortFailoverPolicyModel failoverPolicyModel = new DvsPortFailoverPolicyModel();
        failoverPolicyModel.overrideOptions = new DvsPortFailoverPolicyModel.OverrideOptions();
        if (uplinkTeamingPolicy == null) {
            return failoverPolicyModel;
        }
        StringPolicy loadBalancing = uplinkTeamingPolicy.getPolicy();
        if (loadBalancing != null) {
            failoverPolicyModel.loadBalancing = loadBalancing.getValue();
            boolean bl = failoverPolicyModel.overrideOptions.loadBalancing = !loadBalancing.inherited;
        }
        if (uplinkTeamingPolicy.failureCriteria != null) {
            VmwareDistributedVirtualSwitch.FailureCriteria criteria = uplinkTeamingPolicy.failureCriteria;
            if (criteria.checkBeacon != null) {
                failoverPolicyModel.beaconProbing = criteria.checkBeacon.value;
                boolean bl = failoverPolicyModel.overrideOptions.beaconProbing = !criteria.checkBeacon.inherited;
            }
        }
        if (uplinkTeamingPolicy.notifySwitches != null) {
            failoverPolicyModel.notifySwitches = uplinkTeamingPolicy.notifySwitches.value;
            boolean bl = failoverPolicyModel.overrideOptions.notifySwitches = !uplinkTeamingPolicy.notifySwitches.inherited;
        }
        if (uplinkTeamingPolicy.rollingOrder != null) {
            failoverPolicyModel.rollingOrder = uplinkTeamingPolicy.rollingOrder.value;
            boolean bl = failoverPolicyModel.overrideOptions.rollingOrder = !uplinkTeamingPolicy.rollingOrder.inherited;
        }
        if (uplinkTeamingPolicy.uplinkPortOrder != null) {
            failoverPolicyModel.overrideOptions.failoverOrder = !uplinkTeamingPolicy.uplinkPortOrder.inherited;
            failoverPolicyModel.failoverOrder = DvPortgroupPolicyParser.getFailoverOrderPolicy(uplinkTeamingPolicy, uplinkPortNames, lacpGroupConfigs);
        }
        if (StringUtils.isEmpty((String)failoverPolicyModel.loadBalancing)) {
            failoverPolicyModel.loadBalancing = DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_srcid.toString();
        }
        failoverPolicyModel.loadBalancingModes = loadBalancingModes;
        return failoverPolicyModel;
    }

    private static boolean getIsLagPort(VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs, String portName) {
        if (lacpGroupConfigs != null && lacpGroupConfigs.length > 0 && !StringUtils.isEmpty((String)portName)) {
            for (VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig : lacpGroupConfigs) {
                if (lacpGroupConfig == null || ArrayUtils.isEmpty((Object[])lacpGroupConfig.uplinkName)) continue;
                for (String lagName : lacpGroupConfig.uplinkName) {
                    if (!portName.equals(lagName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

