/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.ports;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.PortStatistics;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvsPortsStatisticsSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgTrafficRuleModel;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsPolicyData;
import com.vmware.vsphere.client.h5.network.dvs.ports.DvsPortEditParser;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortEditQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortPoliciesData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrafficFilterFeatureData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrafficFilterModel;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortTrunkVlanSpec;
import com.vmware.vsphere.client.h5.network.model.DvsPortData;
import com.vmware.vsphere.client.h5.network.model.DvsPortsListData;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.util.DvsPortsUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DvsPortsPropertyProvider
implements PropertyProviderBean {
    private final QueryExecutor _queryExecutor;
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private static final String DVPG_TRAFFIC_FILTER_OVERRIDE_ALLOWED = "config.policy.trafficFilterOverrideAllowed";
    private static final String DVPG_DVS_PROPERTY = "config.distributedVirtualSwitch";
    private static final String KEY_PROPERTY = "key";

    public DvsPortsPropertyProvider(QueryExecutor queryExecutor, QueryService queryService, QueryBindingService queryBindingService) {
        this._queryExecutor = queryExecutor;
        this._queryService = queryService;
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsports", property="portsViewData")
    public DvsPortsListData getPortsViewData(ManagedObjectReference dvsMor) throws Exception {
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsQuerySpec(dvsMor));
        ArrayList<DvsPortData> ports = new ArrayList<DvsPortData>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                ports.add(DvsPortsUtil.parsePortsData(item));
            }
        }
        DvsPortTrafficFilterFeatureData trafficFilterData = (DvsPortTrafficFilterFeatureData)((Object)this._queryBindingService.prepare(DvsPortTrafficFilterFeatureData.class).fetch((Object)dvsMor));
        DvsPortsListData data2 = new DvsPortsListData();
        data2.dvsMor = dvsMor;
        data2.portTrafficFilterSupported = trafficFilterData.trafficFilterSupported != null && trafficFilterData.trafficFilterSupported != false;
        data2.ports = DvsPortsUtil.sortDvsPortsData(ports);
        return data2;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsport", property="portPoliciesData")
    public HostNetworkDetailsData.PortPolicy getPortPoliciesData(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        com.vmware.vise.data.query.ResultSet portSettingResultSet;
        ResultSet isDvpgUpLinkResultSet;
        String portgroupKey = portParams.get("portgroupKey");
        String dvsPortKey = portParams.get("portId");
        DvsPortPoliciesData dvsPortPoliciesData = new DvsPortPoliciesData();
        if (dvsMor != null && !StringUtils.isEmpty((String)portgroupKey) && (isDvpgUpLinkResultSet = this._queryService.select(new String[]{"isUplinkPortgroup"}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DVPG_DVS_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor), new PropertyPredicate(KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)portgroupKey)}).fetch()) != null && isDvpgUpLinkResultSet.getItems() != null) {
            ResourceItem isDvpgUplinkItem = (ResourceItem)isDvpgUpLinkResultSet.getItems().get(0);
            dvsPortPoliciesData.isUplink = (Boolean)isDvpgUplinkItem.getPropertyValues().get(0);
        }
        if ((portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsPoliciesQuerySpec(dvsMor, dvsPortKey))) != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)item.properties[0].value;
                dvsPortPoliciesData.portSetting = configInfo.setting;
            }
        }
        dvsPortPoliciesData.dvsPolicyData = (DvsPolicyData)this._queryBindingService.prepare(DvsPolicyData.class).fetch((Object)dvsMor);
        HostNetworkDetailsData.PortPolicy portPolicy = DvPortgroupParser.getPortPolicy(dvsPortPoliciesData);
        return portPolicy;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpgports", property="refreshedPortsData")
    public DvsPortsStatisticsSpec getDvpgRefreshedStatistics(ManagedObjectReference dvpgMor, Map<String, String> portParams) throws Exception {
        ManagedObjectReference dvs = this.getDvs(dvpgMor);
        if (dvs != null) {
            return this.getRefreshedStatistics(dvs, portParams);
        }
        return null;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsports", property="refreshedPortsData")
    public DvsPortsStatisticsSpec getRefreshedStatistics(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        String[] portIds = new String[]{portParams.get("portId")};
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsMor);
        dvs.refreshPortState(portIds);
        return this.getPortStatisticsData(dvsMor, portParams);
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="dvpgport", property="portStatisticsData")
    public DvsPortsStatisticsSpec getDvpgPortStatisticsData(ManagedObjectReference dvpgMor, Map<String, String> portParams) throws Exception {
        ManagedObjectReference dvs = this.getDvs(dvpgMor);
        if (dvs != null) {
            return this.getPortStatisticsData(dvs, portParams);
        }
        return null;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsport", property="portStatisticsData")
    public DvsPortsStatisticsSpec getPortStatisticsData(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        String dvsPortKey = portParams.get("portId");
        com.vmware.vise.data.query.ResultSet portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsStatisticsQuerySpec(dvsMor, dvsPortKey));
        DvsPortsStatisticsSpec configInfo = new DvsPortsStatisticsSpec(NetworkStringUtil.getString("na"));
        if (portSettingResultSet != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                DistributedVirtualPort.State state;
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties) || (state = (DistributedVirtualPort.State)item.properties[0].value) == null) continue;
                PortStatistics statistics = ((DistributedVirtualPort.State)item.properties[0].value).stats;
                configInfo.bytesInUnicast = this.getPortStatisticTrafficValue(statistics.bytesInUnicast);
                configInfo.bytesOutUnicast = this.getPortStatisticTrafficValue(statistics.bytesOutUnicast);
                configInfo.bytesInMulticast = this.getPortStatisticTrafficValue(statistics.bytesInMulticast);
                configInfo.bytesOutMulticast = this.getPortStatisticTrafficValue(statistics.bytesOutMulticast);
                configInfo.bytesInBroadcast = this.getPortStatisticTrafficValue(statistics.bytesInBroadcast);
                configInfo.bytesOutBroadcast = this.getPortStatisticTrafficValue(statistics.bytesOutBroadcast);
                configInfo.packetsInBroadcast = this.getPortStatisticPackageValue(statistics.packetsInBroadcast);
                configInfo.packetsOutBroadcast = this.getPortStatisticPackageValue(statistics.packetsOutBroadcast);
                configInfo.packetsInUnicast = this.getPortStatisticPackageValue(statistics.packetsInUnicast);
                configInfo.packetsOutUnicast = this.getPortStatisticPackageValue(statistics.packetsOutUnicast);
                configInfo.packetsInDropped = this.getPortStatisticPackageValue(statistics.packetsInDropped);
                configInfo.packetsOutDropped = this.getPortStatisticPackageValue(statistics.packetsOutDropped);
                configInfo.packetsInMulticast = this.getPortStatisticPackageValue(statistics.packetsInMulticast);
                configInfo.packetsOutMulticast = this.getPortStatisticPackageValue(statistics.packetsOutMulticast);
                configInfo.packetsInException = this.getPortStatisticPackageValue(statistics.packetsInException);
                configInfo.packetsOutException = this.getPortStatisticPackageValue(statistics.packetsOutException);
            }
        }
        return configInfo;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsport", property="portTrafficFilterData")
    public DvsPortTrafficFilterModel getDvsPortTrafficFilterData(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        String dvpgKey = portParams.get("portgroupKey");
        String portId = portParams.get("portId");
        ManagedObjectReference dvpgRef = this.getPortDistributedPortGroup(dvsMor, dvpgKey);
        boolean isTrafficFilterOverrideEnabled = this.getIsDvpgTrafficFilterOverrideAllowed(dvpgRef);
        DistributedVirtualPort.FilterPolicy filterPolicy = this.getTrafficFilterPolicy(dvsMor, portId);
        DvsPortTrafficFilterModel portTrafficFilterModel = DvpgTrafficFilterParser.getTrafficFilterPolicyForPort(filterPolicy, isTrafficFilterOverrideEnabled);
        return portTrafficFilterModel;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsport", property="portEditTrafficRuleData")
    public DvpgTrafficRuleModel getEditDvsPortTrafficFilterData(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        String portId = portParams.get("portId");
        String ruleKey = portParams.get("ruleKey");
        DistributedVirtualPort.FilterPolicy filterPolicy = this.getTrafficFilterPolicy(dvsMor, portId);
        return DvpgTrafficRuleModelBuilder.getTrafficRuleModelByKey(filterPolicy, ruleKey);
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsports", property="portEditData")
    public DvsPortEditData getPortEditData(ManagedObjectReference dvsMor, Map<String, String> portParams) throws Exception {
        String portgroupKey = portParams.get("portgroupKey");
        String dvsPortKey = portParams.get("portId");
        ManagedObjectReference dvpgMor = this.getPortDistributedPortGroup(dvsMor, portgroupKey);
        DvsPortEditQueryBinding dvsPortEditQueryBinding = null;
        if (dvpgMor != null) {
            dvsPortEditQueryBinding = (DvsPortEditQueryBinding)this._queryBindingService.prepare(DvsPortEditQueryBinding.class).fetch((Object)dvpgMor);
        }
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortEditQuerySpec(dvsMor, dvsPortKey));
        return DvsPortEditParser.getPortEditData(dvsPortEditQueryBinding, resultSet, dvsMor);
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsport", property="vlanTrunkRanges")
    public NumericRange[] getVlanTrunkRanges(ManagedObjectReference dvsMor, DvsPortTrunkVlanSpec spec) throws Exception {
        if (spec == null || spec.numericRanges == null) {
            return null;
        }
        return NumericRangeUtil.fromString(spec.numericRanges);
    }

    private ManagedObjectReference getPortDistributedPortGroup(ManagedObjectReference dvsMor, String dvpgKey) {
        if (dvsMor == null || StringUtils.isEmpty((String)dvpgKey)) {
            return null;
        }
        ResultSet resultSet = this._queryService.select(new String[0]).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DVPG_DVS_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor), new PropertyPredicate(KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgKey)}).fetch();
        if (resultSet != null && CollectionUtils.isNotEmpty((Collection)resultSet.getItems())) {
            return (ManagedObjectReference)((ResourceItem)resultSet.getItems().get(0)).getKey();
        }
        return null;
    }

    private boolean getIsDvpgTrafficFilterOverrideAllowed(ManagedObjectReference dvpgRef) {
        if (dvpgRef == null) {
            return false;
        }
        ResultSet resultSet = this._queryService.select(new String[]{DVPG_TRAFFIC_FILTER_OVERRIDE_ALLOWED}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgRef)}).fetch();
        if (resultSet != null && CollectionUtils.isNotEmpty((Collection)resultSet.getItems())) {
            ResourceItem dvpgResultSetItems = (ResourceItem)resultSet.getItems().get(0);
            return (Boolean)dvpgResultSetItems.getPropertyValues().get(0);
        }
        return false;
    }

    private DistributedVirtualPort.FilterPolicy getTrafficFilterPolicy(ManagedObjectReference dvsMor, String portId) throws Exception {
        com.vmware.vise.data.query.ResultSet portSettingResultSet = this._queryExecutor.getData(DvsPortsUtil.buildDvsPortsPoliciesQuerySpec(dvsMor, portId));
        DistributedVirtualPort.FilterPolicy filterPolicy = null;
        if (portSettingResultSet != null && portSettingResultSet.items != null) {
            for (ResultItem item : portSettingResultSet.items) {
                if (item == null || ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                DistributedVirtualPort.ConfigInfo configInfo = (DistributedVirtualPort.ConfigInfo)item.properties[0].value;
                filterPolicy = configInfo.setting.filterPolicy;
            }
        }
        return filterPolicy;
    }

    private String getPortStatisticTrafficValue(long value) {
        return FormatUtil.getDataSizeFormatted((Number)value, (int)2, (long)1L, (long)0x100000L, (boolean)true);
    }

    private String getPortStatisticPackageValue(long value) {
        return String.format("%,d", value);
    }

    private ManagedObjectReference getDvs(ManagedObjectReference dvpgMor) {
        ResourceItem resultItem;
        ResultSet dvsResultSet = this._queryService.select(new String[]{DVPG_DVS_PROPERTY}).from(new String[]{dvpgMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgMor)}).fetch();
        if (!dvsResultSet.getItems().isEmpty() && (resultItem = (ResourceItem)dvsResultSet.getItems().get(0)) != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
            return (ManagedObjectReference)resultItem.getPropertyValues().get(0);
        }
        return null;
    }
}

