/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@type(value="NetworkResourcePool,VmwareDistributedVirtualSwitch")
public class DvsNetworkResourcePoolsDataAdapter
implements DataProviderAdapter {
    private static final String DVS_TYPE = "VmwareDistributedVirtualSwitch";
    private static final String NRP_TYPE = "NetworkResourcePool";
    private static final String RELATION = "nrp";
    private static final String NETWORK_RESOURCE_POOLS_PROPERTY = "config.vmVnicNetworkResourcePool";
    private static final String NAME_PROPERTY = "name";
    private static final String PRIMARY_ICON_ID_PROPERTY = "primaryIconId";
    private static final String RESOURCE_POOL_ICON = "vsphere-icon-resource-pool";
    private static final String UNDERSCORE_DELIMITER = "_";
    private static final String COLON_DELIMITER = ":";
    private static final String NRP_URN_FORMAT = "urn:nrp:NetworkResourcePool:%s:%s";
    private static final String SWITCH_IDENTIFIER_FORMAT = "%s_%s";
    private final QueryService _queryService;
    private final VimObjectReferenceService _objRefService;

    public DvsNetworkResourcePoolsDataAdapter(QueryService queryService, VimObjectReferenceService objRefService) {
        this._queryService = queryService;
        this._objRefService = objRefService;
    }

    public Response getData(RequestSpec request) {
        if (request.querySpec == null) {
            throw new IllegalArgumentException("Query spec cannot be null");
        }
        ArrayList<com.vmware.vise.data.query.ResultSet> results = new ArrayList<com.vmware.vise.data.query.ResultSet>(request.querySpec.length);
        for (QuerySpec qs : request.querySpec) {
            results.add(this.processQuery(qs));
        }
        Response response = new Response();
        response.resultSet = results.toArray(new com.vmware.vise.data.query.ResultSet[results.size()]);
        return response;
    }

    private com.vmware.vise.data.query.ResultSet processQuery(QuerySpec qs) {
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        if (this.validateQuerySpec(qs)) {
            if (qs.resourceSpec.constraint instanceof ObjectIdentityConstraint) {
                resultItems.addAll(Arrays.asList(this.createResultForIdentityConstraint((ObjectIdentityConstraint)qs.resourceSpec.constraint)));
            } else if (qs.resourceSpec.constraint instanceof RelationalConstraint) {
                resultItems.addAll(Arrays.asList(this.createResultForRelationalConstraint((RelationalConstraint)qs.resourceSpec.constraint)));
            }
        }
        com.vmware.vise.data.query.ResultSet rs = new com.vmware.vise.data.query.ResultSet();
        rs.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return rs;
    }

    private boolean validateQuerySpec(QuerySpec qs) {
        return qs != null && qs.resourceSpec != null && this.validateConstraint(qs.resourceSpec.constraint);
    }

    private boolean validateConstraint(Constraint c) {
        return c != null && (c instanceof RelationalConstraint && this.isSupportedRelation((RelationalConstraint)c) || c instanceof ObjectIdentityConstraint);
    }

    private boolean isSupportedRelation(RelationalConstraint rc) {
        if (rc.targetType == null || !(rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            return false;
        }
        Object sourceDvs = ((ObjectIdentityConstraint)rc.constraintOnRelatedObject).target;
        String sourceType = this._objRefService.getResourceObjectType(sourceDvs);
        return DVS_TYPE.equals(sourceType) && NRP_TYPE.equals(rc.targetType) && RELATION.equals(rc.relation);
    }

    private boolean validateUri(String urn) {
        String[] parts = urn.split(COLON_DELIMITER);
        return parts.length == 5 && parts[4].contains(UNDERSCORE_DELIMITER);
    }

    private ResultItem[] createResultForRelationalConstraint(RelationalConstraint constraint) {
        VmVnicNetworkResourcePool[] resourcePools;
        ObjectIdentityConstraint identityConstraint = (ObjectIdentityConstraint)constraint.constraintOnRelatedObject;
        ManagedObjectReference dvsMor = (ManagedObjectReference)identityConstraint.target;
        ResultSet queryServiceResult = this._queryService.select(new String[]{NETWORK_RESOURCE_POOLS_PROPERTY}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        List resourceItems = queryServiceResult.getItems();
        if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (resourcePools = (VmVnicNetworkResourcePool[])((ResourceItem)resourceItems.get(0)).get(NETWORK_RESOURCE_POOLS_PROPERTY)) != null) {
            for (VmVnicNetworkResourcePool resourcePool : resourcePools) {
                resultItems.add(this.createResultItem(resourcePool, dvsMor));
            }
        }
        return resultItems.toArray(new ResultItem[resultItems.size()]);
    }

    private ResultItem[] createResultForIdentityConstraint(ObjectIdentityConstraint constraint) {
        Object resourceObject = constraint.target;
        if (resourceObject instanceof URI && this.validateUri(resourceObject.toString())) {
            VmVnicNetworkResourcePool[] resourcePools;
            String[] urnParts = resourceObject.toString().split(COLON_DELIMITER);
            String switchIdentifier = urnParts[3];
            String key = null;
            String serverUid = null;
            if (switchIdentifier.contains(UNDERSCORE_DELIMITER)) {
                String[] identifierParts = switchIdentifier.split(UNDERSCORE_DELIMITER);
                serverUid = identifierParts[0];
                key = identifierParts[1];
            }
            ManagedObjectReference dvsMor = new ManagedObjectReference(DVS_TYPE, key, serverUid);
            ResultSet queryServiceResult = this._queryService.select(new String[]{NETWORK_RESOURCE_POOLS_PROPERTY}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
            List resourceItems = queryServiceResult.getItems();
            if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (resourcePools = (VmVnicNetworkResourcePool[])((ResourceItem)resourceItems.get(0)).get(NETWORK_RESOURCE_POOLS_PROPERTY)) != null) {
                for (VmVnicNetworkResourcePool resourcePool : resourcePools) {
                    if (!resourcePool.key.equals(urnParts[4])) continue;
                    return new ResultItem[]{this.createResultItem(resourcePool, dvsMor)};
                }
            }
        }
        return new ResultItem[0];
    }

    private ResultItem createResultItem(VmVnicNetworkResourcePool resourcePool, ManagedObjectReference switchMor) {
        String switchIdentifier = String.format(SWITCH_IDENTIFIER_FORMAT, switchMor.getServerGuid(), switchMor.getValue());
        ResultItem ri = new ResultItem();
        ri.resourceObject = URI.create(String.format(NRP_URN_FORMAT, switchIdentifier, resourcePool.key));
        PropertyValue name = new PropertyValue();
        name.resourceObject = ri.resourceObject;
        name.propertyName = NAME_PROPERTY;
        name.value = resourcePool.name;
        PropertyValue icon = new PropertyValue();
        icon.resourceObject = ri.resourceObject;
        icon.propertyName = PRIMARY_ICON_ID_PROPERTY;
        icon.value = RESOURCE_POOL_ICON;
        ri.properties = new PropertyValue[]{name, icon};
        return ri;
    }
}

