/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.info.DvsResControlStatistics;
import com.vmware.vsphere.client.dvs.api.spec.DvsVmResControlSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmResControlSpec;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolPortgroupsListData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolPortgroupsListItemData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolVmsListData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolVmsListItemData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolsData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolsListData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolsListItemData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolsMeterData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolsOverviewData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DvsNetworkResourcePoolsPropertyProvider
implements PropertyProviderBean {
    private static final String NETWORK_RESOURCE_POOLS_PROPERTY = "config.vmVnicNetworkResourcePool";
    private static final String RES_CONTROL_STATS_PROPERTY = "resControlStatistics";
    private static final String RES_CONTROL_VMS_PROPERTY = "resourceControlVms";
    private static final String NRP_KEY_PROPERTY = "config.vmVnicNetworkResourcePoolKey";
    private static final String NUM_VMS_PROPERTY = "vmLengthLabelDerived";
    private static final String NUM_PORTS_PROPERTY = "config.numPorts";
    private static final String PG_NAME_PROPERTY = "config.name";
    private static final String IP_POOL_PROPERTY = "summary.ipPoolName";
    private static final String VLAN_LABEL_PROPERTY = "portgroupVlanLabelDerived";
    private static final String PORT_BINDING_LABEL_PROPERTY = "portBindingLabelDerived";
    private final QueryService _queryService;
    private final QueryExecutor _queryExecutor;

    public DvsNetworkResourcePoolsPropertyProvider(QueryService queryService, QueryExecutor queryExecutor) {
        this._queryService = queryService;
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolsListData")
    public DvsNetworkResourcePoolsListData getNetworkResourcePoolsListData(ManagedObjectReference dvsMor) {
        VmVnicNetworkResourcePool[] resourcePools;
        ResultSet resultSet = this._queryService.select(new String[]{NETWORK_RESOURCE_POOLS_PROPERTY}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        ArrayList<DvsNetworkResourcePoolsListItemData> listItems = new ArrayList<DvsNetworkResourcePoolsListItemData>();
        List resourceItems = resultSet.getItems();
        if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (resourcePools = (VmVnicNetworkResourcePool[])((ResourceItem)resourceItems.get(0)).get(NETWORK_RESOURCE_POOLS_PROPERTY)) != null) {
            for (VmVnicNetworkResourcePool resourcePool : resourcePools) {
                DvsNetworkResourcePoolsListItemData listItemData = new DvsNetworkResourcePoolsListItemData();
                listItemData.name = resourcePool.name;
                listItemData.key = resourcePool.key;
                listItemData.configVersion = resourcePool.configVersion;
                if (resourcePool.allocationInfo != null) {
                    listItemData.reservation = resourcePool.allocationInfo.reservationQuota;
                }
                listItems.add(listItemData);
            }
        }
        DvsNetworkResourcePoolsListData listData = new DvsNetworkResourcePoolsListData();
        listData.listItems = listItems.toArray(new DvsNetworkResourcePoolsListItemData[listItems.size()]);
        return listData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolsData")
    public DvsNetworkResourcePoolsData getNetworkResourcePoolsData(ManagedObjectReference dvsMor) {
        DvsResControlStatistics stats;
        ResultSet resultSet = this._queryService.select(new String[]{RES_CONTROL_STATS_PROPERTY}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        DvsNetworkResourcePoolsData data2 = new DvsNetworkResourcePoolsData();
        data2.meterData = new DvsNetworkResourcePoolsMeterData();
        data2.overviewData = new DvsNetworkResourcePoolsOverviewData();
        List resourceItems = resultSet.getItems();
        if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (stats = (DvsResControlStatistics)((ResourceItem)resourceItems.get(0)).get(RES_CONTROL_STATS_PROPERTY)) != null) {
            Long totalAvailable;
            data2.overviewData.capacity = stats.totalPnicBandwidth;
            data2.overviewData.vmTrafficReservation = stats.reservedVmTrafficBandwidth;
            Long resPoolReserved = stats.reservedVmVnicPoolBandwidth;
            Long vmReserved = stats.aggregatedVmBandwidthReservation;
            Long totalReserved = resPoolReserved + vmReserved;
            data2.meterData.configuredReservation = totalAvailable = Long.valueOf(stats.totalVmVnicPoolBandwidth);
            data2.meterData.grantedQuota = resPoolReserved;
            data2.meterData.vmReservation = vmReserved;
            data2.meterData.unusedQuota = totalReserved > totalAvailable ? 0L : totalAvailable - totalReserved;
        }
        return data2;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolPortgroupsListData")
    public DvsNetworkResourcePoolPortgroupsListData getNetworkResourcePoolPortgroupsListData(ManagedObjectReference dvsMor, String resourcePoolKey) throws Exception {
        if (resourcePoolKey == null) {
            throw new IllegalArgumentException("Resource pool key cannot be null");
        }
        DvsNetworkResourcePoolPortgroupsListData data2 = new DvsNetworkResourcePoolPortgroupsListData();
        ArrayList<DvsNetworkResourcePoolPortgroupsListItemData> items = new ArrayList<DvsNetworkResourcePoolPortgroupsListItemData>();
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(this.buildPortgroupsListQuerySpec(dvsMor, resourcePoolKey));
        if (resultSet != null && !ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            for (ResultItem ri : resultSet.items) {
                if (ri == null || ri.properties == null) continue;
                items.add(this.parsePortgroupsListResultItem(ri));
            }
        }
        data2.listItems = items.toArray(new DvsNetworkResourcePoolPortgroupsListItemData[items.size()]);
        return data2;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolVmsListData")
    public DvsNetworkResourcePoolVmsListData getNetworkResourcePoolVmsListData(ManagedObjectReference dvsMor, String resourcePoolKey) {
        DvsVmResControlSpec dvsVmResControlSpec;
        ResultSet resultSet = this._queryService.select(new String[]{RES_CONTROL_VMS_PROPERTY}).from(new String[]{dvsMor.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("resourceControlVms/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)resourcePoolKey), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        DvsNetworkResourcePoolVmsListData data2 = new DvsNetworkResourcePoolVmsListData();
        ArrayList<DvsNetworkResourcePoolVmsListItemData> listItems = new ArrayList<DvsNetworkResourcePoolVmsListItemData>();
        List resourceItems = resultSet.getItems();
        if (!CollectionUtil.isNullOrEmpty((Collection)resourceItems) && (dvsVmResControlSpec = (DvsVmResControlSpec)((ResourceItem)resourceItems.get(0)).get(RES_CONTROL_VMS_PROPERTY)) != null && dvsVmResControlSpec.vmResControlSpec != null) {
            for (VmResControlSpec vmResControlSpec : dvsVmResControlSpec.vmResControlSpec) {
                listItems.add(this.buildVmsListItem(vmResControlSpec));
            }
        }
        data2.listItems = listItems.toArray(new DvsNetworkResourcePoolVmsListItemData[listItems.size()]);
        return data2;
    }

    private DvsNetworkResourcePoolVmsListItemData buildVmsListItem(VmResControlSpec vmResControlSpec) {
        DvsNetworkResourcePoolVmsListItemData listItem = new DvsNetworkResourcePoolVmsListItemData();
        listItem.name = vmResControlSpec.name;
        listItem.primaryIconId = vmResControlSpec.primaryIconId;
        listItem.networkAdapter = vmResControlSpec.networkAdapterName;
        listItem.vmRef = vmResControlSpec.vmRef;
        listItem.deviceKey = vmResControlSpec.deviceKey;
        if (vmResControlSpec.resourceAllocation != null) {
            listItem.reservation = vmResControlSpec.resourceAllocation.reservation;
            listItem.limit = vmResControlSpec.resourceAllocation.limit;
            if (vmResControlSpec.resourceAllocation.share != null) {
                listItem.sharesValue = vmResControlSpec.resourceAllocation.share.shares;
                if (vmResControlSpec.resourceAllocation.share.level != null) {
                    listItem.sharesLevel = vmResControlSpec.resourceAllocation.share.level.name();
                }
            }
        }
        return listItem;
    }

    private QuerySpec buildPortgroupsListQuerySpec(ManagedObjectReference dvsMor, String resourcePoolKey) {
        QuerySpec querySpec = new QuerySpec();
        RelationalConstraint dvsConstraint = new RelationalConstraint();
        dvsConstraint.targetType = "DistributedVirtualPortgroup";
        dvsConstraint.relation = "portgroup";
        dvsConstraint.hasInverseRelation = true;
        ObjectIdentityConstraint dvsIdentityConstraint = new ObjectIdentityConstraint();
        dvsIdentityConstraint.target = dvsMor;
        dvsIdentityConstraint.targetType = dvsMor.getType();
        dvsConstraint.constraintOnRelatedObject = dvsIdentityConstraint;
        PropertyConstraint nrpConstraint = new PropertyConstraint();
        nrpConstraint.targetType = "DistributedVirtualPortgroup";
        nrpConstraint.propertyName = NRP_KEY_PROPERTY;
        nrpConstraint.comparator = Comparator.EQUALS;
        nrpConstraint.comparableValue = resourcePoolKey;
        CompositeConstraint constraint = new CompositeConstraint();
        constraint.conjoiner = Conjoiner.AND;
        constraint.nestedConstraints = new Constraint[]{dvsConstraint, nrpConstraint};
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        PropertySpec portgroupPropertiesSpec = new PropertySpec();
        portgroupPropertiesSpec.propertyNames = new String[]{NUM_VMS_PROPERTY, NUM_PORTS_PROPERTY, PG_NAME_PROPERTY, IP_POOL_PROPERTY, PORT_BINDING_LABEL_PROPERTY, VLAN_LABEL_PROPERTY};
        resourceSpec.propertySpecs = new PropertySpec[]{portgroupPropertiesSpec};
        querySpec.resourceSpec = resourceSpec;
        querySpec.name = "networkResourcePoolPortgroupsListQuery";
        return querySpec;
    }

    private DvsNetworkResourcePoolPortgroupsListItemData parsePortgroupsListResultItem(ResultItem ri) {
        DvsNetworkResourcePoolPortgroupsListItemData itemData = new DvsNetworkResourcePoolPortgroupsListItemData();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (PropertyValue prop : ri.properties) {
            properties.put(prop.propertyName, prop.value);
        }
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "config.name": {
                    String rawName = (String)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(PG_NAME_PROPERTY, properties);
                    itemData.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)rawName);
                    break;
                }
                case "summary.ipPoolName": {
                    itemData.networkProtocolProfile = (String)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(IP_POOL_PROPERTY, properties);
                }
                case "portgroupVlanLabelDerived": {
                    itemData.vlan = (String)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(VLAN_LABEL_PROPERTY, properties);
                    break;
                }
                case "portBindingLabelDerived": {
                    itemData.portBinding = (String)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(PORT_BINDING_LABEL_PROPERTY, properties);
                    break;
                }
                case "config.numPorts": {
                    Integer numPorts = (Integer)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(NUM_PORTS_PROPERTY, properties);
                    if (numPorts == null) break;
                    itemData.numPorts = numPorts.toString();
                    break;
                }
                case "vmLengthLabelDerived": {
                    itemData.numVms = (String)DvsNetworkResourcePoolsPropertyProvider.getPropertyValue(NUM_VMS_PROPERTY, properties);
                }
            }
        }
        itemData.pgRef = ri.resourceObject instanceof ManagedObjectReference ? (ManagedObjectReference)ri.resourceObject : null;
        return itemData;
    }

    private static <T> T getPropertyValue(String key, Map<String, Object> properties) {
        Object value = properties.get(key);
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

