/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.upgrade;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vsphere.client.dvs.api.spec.DvsApplyProductSpecCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsResControlUpgradeSpec;
import com.vmware.vsphere.client.dvs.api.spec.LacpUpgradeSpec;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.DvsUpgradeSpecBuilder;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.DvsUpgradeWizardSpec;

public class DvsUpgradeMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;

    public DvsUpgradeMutationProvider(MutationService mutationService) {
        this._mutationService = mutationService;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsUpgradeWizardSpec spec) {
        DvsUpgradeSpecBuilder specBuilder = new DvsUpgradeSpecBuilder();
        DvsApplyProductSpecCommandSpec commandSpec = specBuilder.buildDvsUpgradeCommandSpec(dvsRef, spec);
        OperationResult dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)commandSpec);
        if (spec.explicitNiocUpgrade && dvsUpgradeResult.error == null) {
            DvsResControlUpgradeSpec niocUpgradeSpec = new DvsResControlUpgradeSpec();
            niocUpgradeSpec.migrateShares = spec.migrateShares;
            dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)niocUpgradeSpec);
        }
        if (spec.explicitLacpUpgrade && dvsUpgradeResult.error == null) {
            LacpUpgradeSpec lacpUpgradeSpec = new LacpUpgradeSpec();
            lacpUpgradeSpec.lag = spec.lag;
            dvsUpgradeResult = this._mutationService.apply((Object)dvsRef, (Object)lacpUpgradeSpec);
            return dvsUpgradeResult;
        }
        return dvsUpgradeResult;
    }
}

