/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.virtualswitch;

import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.EditStandardSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.EditStandardSwitchDialogData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualStandardSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPoliciesData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.StandardSwitchPropertiesData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.spec.VirtualSwitchIdSpec;
import com.vmware.vsphere.client.h5.network.model.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.model.NetworkPolicyData;
import com.vmware.vsphere.client.h5.network.util.NetworkPolicyUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.HostNetworkCapability;
import org.apache.commons.lang.Validate;

public class HostVirtualSwitchParser {
    public static EditStandardSwitchDialogData getEditDialogData(EditStandardSwitchData data2, VirtualSwitchIdSpec switchIdSpec) {
        EditStandardSwitchDialogData dialogData = new EditStandardSwitchDialogData();
        if (data2 != null && data2.hostPnicDetailsData != null) {
            VirtualSwitch virtualSwitch = HostVirtualSwitchParser.getVirtualSwitch(data2.hostPnicDetailsData.vSwitches, switchIdSpec);
            dialogData.propertiesData = HostVirtualSwitchParser.buildVirtualSwitchProperties(data2.hostNetworkCapability, virtualSwitch);
            if (virtualSwitch != null && virtualSwitch.spec != null) {
                dialogData.securityPolicies = NetworkPolicyUtil.getSecurityPolicies(virtualSwitch.spec.policy, null);
                dialogData.trafficShapingPolicies = NetworkPolicyUtil.getTrafficShapingPolicies(virtualSwitch.spec.policy, null);
                dialogData.teamingAndFailover = NetworkPolicyUtil.getTeamingAndFailoverPolicies(virtualSwitch.spec.policy, null, virtualSwitch, data2.nicTeamingPolicy, data2.hostPnicDetailsData);
            }
            if (dialogData.propertiesData.numberOfPorts != null) {
                dialogData.propertiesData.showRestartWarning = data2.hostNetworkCapability.vssPortChangeRebootRequired;
                dialogData.propertiesData.availableNumberOfPorts = NetworkUtil.calculateAvailablePortsCountByNetworkInfo(data2.hostNetworkCapability, data2.hostPnicDetailsData.vSwitches, data2.proxySwitches);
            }
        }
        return dialogData;
    }

    public static StandardSwitchPropertiesData getPropertiesViewData(HostVirtualStandardSwitchData data2, VirtualSwitchIdSpec switchIdSpec) {
        if (data2 != null) {
            VirtualSwitch virtualSwitch = HostVirtualSwitchParser.getVirtualSwitch(data2.standardSwitches, switchIdSpec);
            return HostVirtualSwitchParser.buildVirtualSwitchProperties(data2.hostNetworkCapability, virtualSwitch);
        }
        return null;
    }

    public static HostNetworkDetailsData.PortPolicy getPoliciesViewData(HostVirtualSwitchPoliciesData data2, VirtualSwitchIdSpec switchIdSpec) {
        if (data2 == null) {
            return null;
        }
        for (VirtualSwitch standardSwitch : data2.standardSwitches) {
            if (!switchIdSpec.match(standardSwitch)) continue;
            return NetworkUtil.getPortPolicy(standardSwitch, data2.pnics);
        }
        return null;
    }

    public static VirtualSwitch.Specification buildVSwitchSpec(VirtualSwitch virtualSwitch, EditStandardSwitchDialogData dialogData) {
        Validate.notNull((Object)virtualSwitch);
        Validate.notNull((Object)virtualSwitch.spec);
        Validate.notNull((Object)dialogData);
        Validate.notNull((Object)dialogData.propertiesData);
        Validate.notNull((Object)dialogData.securityPolicies);
        Validate.notNull((Object)dialogData.trafficShapingPolicies);
        Validate.notNull((Object)dialogData.teamingAndFailover);
        HostVirtualSwitchParser.updateGeneralProperties(virtualSwitch.spec, dialogData);
        HostVirtualSwitchParser.updateSecurityPolicy(virtualSwitch.spec, dialogData.securityPolicies);
        HostVirtualSwitchParser.updateTrafficShapingPolicy(virtualSwitch.spec, dialogData.trafficShapingPolicies);
        HostVirtualSwitchParser.updateTeamingAndFailoverPolicy(virtualSwitch.spec, dialogData.teamingAndFailover);
        return virtualSwitch.spec;
    }

    private static void updateSecurityPolicy(VirtualSwitch.Specification spec, NetworkPolicyData.SecurityPolicies securityPolicy) {
        if (spec.policy == null) {
            spec.policy = new NetworkPolicy();
        }
        if (spec.policy.security == null) {
            spec.policy.security = new NetworkPolicy.SecurityPolicy();
        }
        spec.policy.security.allowPromiscuous = securityPolicy.allowPromiscuousMode;
        spec.policy.security.macChanges = securityPolicy.macChanges;
        spec.policy.security.forgedTransmits = securityPolicy.forgedTransmits;
    }

    private static void updateTrafficShapingPolicy(VirtualSwitch.Specification spec, NetworkPolicyData.TrafficShapingPolicies trafficShapingPolocy) {
        if (spec.policy == null) {
            spec.policy = new NetworkPolicy();
        }
        if (spec.policy.shapingPolicy == null) {
            spec.policy.shapingPolicy = new NetworkPolicy.TrafficShapingPolicy();
        }
        spec.policy.shapingPolicy.enabled = trafficShapingPolocy.enabled;
        if (trafficShapingPolocy.enabled) {
            spec.policy.shapingPolicy.averageBandwidth = trafficShapingPolocy.averageBandwidth * FormatUtil.KBPS;
            spec.policy.shapingPolicy.peakBandwidth = trafficShapingPolocy.peakBandwidth * FormatUtil.KBPS;
            spec.policy.shapingPolicy.burstSize = trafficShapingPolocy.burstSize * 1024L;
        }
    }

    private static void updateGeneralProperties(VirtualSwitch.Specification spec, EditStandardSwitchDialogData dialogData) {
        spec.mtu = dialogData.propertiesData.mtu;
        if (dialogData.propertiesData.numberOfPorts != null) {
            spec.numPorts = dialogData.propertiesData.numberOfPorts;
        }
    }

    private static void updateTeamingAndFailoverPolicy(VirtualSwitch.Specification spec, NetworkPolicyData.TeamingAndFailover teamingAndFailover) {
        if (spec.policy == null) {
            spec.policy = new NetworkPolicy();
        }
        if (spec.policy.nicTeaming == null) {
            spec.policy.nicTeaming = new NetworkPolicy.NicTeamingPolicy();
        }
        if (spec.policy.nicTeaming.failureCriteria == null) {
            spec.policy.nicTeaming.failureCriteria = new NetworkPolicy.NicFailureCriteria();
        }
        if (teamingAndFailover.pnics != null) {
            if (spec.policy.nicTeaming.nicOrder == null) {
                spec.policy.nicTeaming.nicOrder = new NetworkPolicy.NicOrderPolicy();
            }
            spec.policy.nicTeaming.nicOrder.activeNic = teamingAndFailover.pnics.active.toArray(new String[0]);
            spec.policy.nicTeaming.nicOrder.standbyNic = teamingAndFailover.pnics.standby.toArray(new String[0]);
        }
        spec.policy.nicTeaming.policy = teamingAndFailover.loadBalancing;
        spec.policy.nicTeaming.rollingOrder = teamingAndFailover.rollingOrder;
        spec.policy.nicTeaming.notifySwitches = teamingAndFailover.notifySwitches;
        spec.policy.nicTeaming.failureCriteria.checkBeacon = teamingAndFailover.checkBeacon;
    }

    private static StandardSwitchPropertiesData buildVirtualSwitchProperties(HostNetworkCapability hostNetworkCapability, VirtualSwitch standardSwitch) {
        StandardSwitchPropertiesData result = null;
        if (standardSwitch != null) {
            boolean hostVersionBefore55 = hostNetworkCapability != null && !hostNetworkCapability.proxySwitchAutoScaleSupported;
            result = new StandardSwitchPropertiesData();
            result.name = standardSwitch.name;
            result.mtu = standardSwitch.mtu;
            if (hostVersionBefore55) {
                result.numberOfPorts = standardSwitch.spec.numPorts;
                result.showRestartWarning = standardSwitch.numPorts != standardSwitch.spec.numPorts;
            }
        }
        return result;
    }

    private static VirtualSwitch getVirtualSwitch(VirtualSwitch[] virtualSwitches, VirtualSwitchIdSpec vSwitchIdSpec) {
        if (virtualSwitches == null || vSwitchIdSpec == null) {
            return null;
        }
        for (VirtualSwitch virtualSwitch : virtualSwitches) {
            if (!vSwitchIdSpec.match(virtualSwitch)) continue;
            return virtualSwitch;
        }
        return null;
    }
}

