/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicUtils;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingData;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingInfo;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.PnicBindingDataItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VnicSettingsPropertyProvider
implements PropertyProviderBean {
    public static final String SUMMARY_PROP = "summary";
    public static final String OPAQUE_NETWORK_PROP = "config/network/opaqueNetwork";
    public static final String OPAQUE_SWITCH_PROP = "config/network/opaqueSwitch";
    public static final String HOST_PNICS_PROP = "config/network/pnic";
    private QueryBindingService _queryBindingService;
    private QueryExecutor _queryExecutor;
    private QueryService _queryService;

    public VnicSettingsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryExecutor queryExecutor, QueryServiceFactory queryServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryExecutor = queryExecutor;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="vnic", property="portgroupMtuData")
    public Object getPortgroupMtuData(ManagedObjectReference portGroupRef) throws Exception {
        PropertyValue[] result = this._queryExecutor.getPropertyForRelatedObjects((Object)portGroupRef, "dvs", VmwareDistributedVirtualSwitch.class.getSimpleName(), "config[@type='VMwareDVSConfigInfo'].maxMtu");
        if (result != null && result.length == 1) {
            return result[0].value;
        }
        return null;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdapterIpRouting")
    public HostVnicIpRoutingInfo getVirtualAdapterIpRouting(ManagedObjectReference hostRef, String selectedNetStackKey) {
        HostVnicIpRoutingInfo ipRoutingInfo = new HostVnicIpRoutingInfo();
        HostVnicIpRoutingData ipRoutingData = this.fetchHostIpRoutingInfo(hostRef);
        if (ipRoutingData == null) {
            return ipRoutingInfo;
        }
        if (ipRoutingData.isTcpIpStackSupported) {
            NetStackInstance selectedNetStackInstance = null;
            if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.netStackInstances)) {
                for (NetStackInstance netStackInstance : ipRoutingData.netStackInstances) {
                    if (selectedNetStackKey == null || !selectedNetStackKey.equals(netStackInstance.key)) continue;
                    selectedNetStackInstance = netStackInstance;
                    break;
                }
                if (selectedNetStackInstance != null) {
                    if (selectedNetStackInstance.ipRouteConfig != null) {
                        ipRoutingInfo.ipv4DefaultGateway = selectedNetStackInstance.ipRouteConfig.defaultGateway;
                        ipRoutingInfo.ipv6DefaultGateway = selectedNetStackInstance.ipRouteConfig.ipV6DefaultGateway;
                    }
                    if (selectedNetStackInstance.dnsConfig != null) {
                        ipRoutingInfo.dnsAddresses = selectedNetStackInstance.dnsConfig.address;
                    }
                }
            }
        } else {
            if (ipRoutingData.ipRouteConfig != null) {
                ipRoutingInfo.ipv4DefaultGateway = ipRoutingData.ipRouteConfig.defaultGateway;
                ipRoutingInfo.ipv6DefaultGateway = ipRoutingData.ipRouteConfig.ipV6DefaultGateway;
            }
            if (ipRoutingData.dnsConfig != null) {
                ipRoutingInfo.dnsAddresses = ipRoutingData.dnsConfig.address;
            }
        }
        HashMap<String, Set<String>> hostIpv6Addresses = new HashMap<String, Set<String>>();
        if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.consoleVnic)) {
            hostIpv6Addresses.putAll(VnicUtils.getHostIpAddresses(ipRoutingData.consoleVnic));
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])ipRoutingData.vnic)) {
            hostIpv6Addresses.putAll(VnicUtils.getHostIpAddresses(ipRoutingData.vnic));
        }
        if (hostIpv6Addresses.size() > 0) {
            ipRoutingInfo.hostIpv6Addresses = hostIpv6Addresses;
        }
        ipRoutingInfo.isGatewayFeatureSupported = ipRoutingData.isGatewayFeatureSupported;
        return ipRoutingInfo;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="availablePnicsForBindingBySummary")
    public PnicBindingDataItem[] getAvailablePnicsForBindingBySummary(ManagedObjectReference hostRef, Map<String, String> properies) {
        OpaqueNetwork.Summary opaqueNetworkSummary = new OpaqueNetwork.Summary();
        opaqueNetworkSummary.opaqueNetworkId = properies.get("opaqueNetworkId");
        opaqueNetworkSummary.opaqueNetworkType = properies.get("opaqueNetworkType");
        return this.getAvailablePnics(hostRef, opaqueNetworkSummary);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="availablePnicsForBinding")
    public PnicBindingDataItem[] getAvailablePnicsForBinding(ManagedObjectReference hostRef, ManagedObjectReference opaqueNetworkRef) {
        OpaqueNetwork.Summary opaqueNetworkSummary = (OpaqueNetwork.Summary)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)opaqueNetworkRef, (String)SUMMARY_PROP);
        return this.getAvailablePnics(hostRef, opaqueNetworkSummary);
    }

    private PnicBindingDataItem[] getAvailablePnics(ManagedObjectReference hostRef, OpaqueNetwork.Summary opaqueNetworkSummary) {
        Map hostProperties = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)hostRef, (String[])new String[]{OPAQUE_NETWORK_PROP, OPAQUE_SWITCH_PROP, HOST_PNICS_PROP});
        OpaqueSwitch[] opaqueSwitches = (OpaqueSwitch[])hostProperties.get(OPAQUE_SWITCH_PROP);
        OpaqueNetworkInfo[] opaqueNetworkInfos = (OpaqueNetworkInfo[])hostProperties.get(OPAQUE_NETWORK_PROP);
        PhysicalNic[] hostPhysicalNics = (PhysicalNic[])hostProperties.get(HOST_PNICS_PROP);
        OpaqueNetworkInfo selectedOpaqueNetwork = DvsAddHostWizardUtil.getOpaqueNetworkByTypeAndId(opaqueNetworkInfos, opaqueNetworkSummary);
        if (selectedOpaqueNetwork == null) {
            return new PnicBindingDataItem[0];
        }
        OpaqueSwitch matchingOpaqueSwitch = DvsAddHostWizardUtil.getOpaqueSwitchByOpaqueNetwork(selectedOpaqueNetwork, opaqueSwitches);
        if (matchingOpaqueSwitch == null) {
            return new PnicBindingDataItem[0];
        }
        String[] switchPnicIds = matchingOpaqueSwitch.pnic;
        if (switchPnicIds == null || hostPhysicalNics == null) {
            return new PnicBindingDataItem[0];
        }
        ArrayList<PnicBindingDataItem> pnicItems = new ArrayList<PnicBindingDataItem>();
        for (String pnicId : switchPnicIds) {
            for (PhysicalNic pnic : hostPhysicalNics) {
                if (!pnicId.equals(pnic.key)) continue;
                PnicBindingDataItem pnicBindingDataItem = new PnicBindingDataItem();
                pnicBindingDataItem.device = pnic.device;
                pnicBindingDataItem.pnicId = pnic.key;
                pnicItems.add(pnicBindingDataItem);
            }
        }
        Collections.sort(pnicItems, new Comparator<PnicBindingDataItem>(){

            @Override
            public int compare(PnicBindingDataItem o1, PnicBindingDataItem o2) {
                return o1.device.compareTo(o2.device);
            }
        });
        return pnicItems.toArray(new PnicBindingDataItem[pnicItems.size()]);
    }

    private HostVnicIpRoutingData fetchHostIpRoutingInfo(ManagedObjectReference hostRef) {
        return (HostVnicIpRoutingData)((Object)this._queryBindingService.prepare(HostVnicIpRoutingData.class).fetch((Object)hostRef));
    }
}

