/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.model;

import com.vmware.vim.binding.vim.host.IpRouteConfig;
import com.vmware.vise.core.model.annotation.Dto;
import java.util.ArrayList;
import java.util.List;

@Dto
public class HostNetworkDetailsData {
    public boolean dvPortgroup;
    public String device = "";
    public String networkLabel = "";
    public String pinnedPnic = "";
    public boolean showVlanId = false;
    public int vlanId;
    public boolean showNetworkStack = false;
    public String networkStack;
    public EnabledServices enabledServices;
    public String mac;
    public Integer mtu;
    public IpProperties ipProperties;
    public PortPolicy portPolicy;

    @Dto
    public static class PortPolicy {
        public Security security;
        public TrafficShaping trafficShaping;
        public TrafficShaping inTrafficShaping;
        public TrafficShaping outTrafficShaping;
        public Vlan vlan;
        public Boolean monitoring;
        public Boolean blocked;
        public Boolean basicLacpAvailable;
        public TeamingAndFailover teamingAndFailover;
        public Lacp lacp;

        @Dto
        public static class Lacp {
            public String mode;
            public Boolean enable;
        }

        @Dto
        public static class TeamingAndFailover {
            public String loadBalancing;
            public boolean failureDetection;
            public boolean notifySwitches;
            public boolean failback;
            public List<String> activeAdapters = new ArrayList<String>();
            public List<String> standByAdapters = new ArrayList<String>();
            public List<String> unusedAdapters = new ArrayList<String>();
        }

        @Dto
        public static class Vlan {
            public String type;
            public String value;
        }

        @Dto
        public static class TrafficShaping {
            public Boolean enabled;
            public String averageBandwidthSummary;
            public String peakBandwidthSummary;
            public String burstSizeSummary;
        }

        @Dto
        public static class Security {
            public boolean allowPromiscuous;
            public boolean forgedTransmits;
            public boolean macChanges;
        }
    }

    @Dto
    public static class IpProperties {
        public boolean hasIpv4Settings = false;
        public boolean ipv4DhcpEnabled = false;
        public String ipv4Address;
        public String subnetMask;
        public String ipv4DefaultGateway;
        public String[] dnsServers;
        public boolean hasIpv6Settings = false;
        public boolean ipv6DhcpEnabled = false;
        public boolean ipv6AutoConfigEnabled = false;
        public String[] formattedIpv6Addresses;
        public String ipv6DefaultGateway;
        public boolean shouldShowDnsServers = false;

        public void initDefaultGateways(IpRouteConfig ipRouteConfig) {
            if (ipRouteConfig != null) {
                this.ipv4DefaultGateway = ipRouteConfig.defaultGateway;
                this.ipv6DefaultGateway = ipRouteConfig.ipV6DefaultGateway;
            }
        }
    }

    @Dto
    public static class EnabledServices {
        public boolean isVmotionEnabled = false;
        public boolean isFtEnabled = false;
        public boolean isProvisioningNfcTrafficEnabled = false;
        public boolean isManagementTrafficEnabled = false;
        public boolean isVrTrafficEnabled = false;
        public boolean isVrNfcTrafficEnabled = false;
        public boolean isVsanEnabled = false;
        public boolean isVsanWitnessTrafficEnabled = false;
    }
}

