/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.moveto;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.moveto.MoveService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MoveNetworkPropertyProvider {
    private static final String DC_PROPERTY = "dc";
    private final QueryService queryService;
    private final MoveService moveService;

    public MoveNetworkPropertyProvider(MoveService moveService, QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
        this.moveService = moveService;
    }

    @PropertyProvider(value="Network/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailable(Collection<ManagedObjectReference> networkRefs) {
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, networkRefs));
        ResultSet resultSet = this.queryService.select(new String[]{"@modelKey", DC_PROPERTY}).from(new String[]{Network.class.getSimpleName()}).where(LogicalOperator.AND, filter).fetch();
        boolean areNetworksFromOneDc = this.moveService.areObjectsFromOneDc(resultSet.getItems());
        return new ArrayList<Boolean>(Collections.nCopies(networkRefs.size(), areNetworksFromOneDc));
    }
}

