/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.SwitchDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.switchdiagram.SwitchDiagramBuilderBase;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SwitchDiagramPortgroupVmsBuilderImpl
extends SwitchDiagramBuilderBase
implements SwitchDiagramPortgroupVmsBuilder {
    private static final String UNBOUND_VM_KEY_PREFIX = "UNB_";
    private SwitchDiagramSpec _switchDiagramSpec;
    private String _dvsUuid;
    private String _portgroupKey;
    private Set<SwitchDiagramVmSpec> _portgroupVms = new HashSet<SwitchDiagramVmSpec>();
    private Map<ManagedObjectReference, SwitchDiagramVmSpec> _vmMap = new HashMap<ManagedObjectReference, SwitchDiagramVmSpec>();
    private Map<String, DistributedVirtualPort> _portsMap = new HashMap<String, DistributedVirtualPort>();

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String portgroupKey) {
        if (switchDiagramSpec == null) {
            throw new IllegalArgumentException("switchDiagramSpec cannot be null");
        }
        if (switchDiagramSpec.dvsSpec == null) {
            throw new IllegalArgumentException("dvsSpec cannot be null");
        }
        if (StringUtil.isNullOrEmpty((String)dvsUuid)) {
            throw new IllegalArgumentException("dvsUuid cannot be null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)portgroupKey)) {
            throw new IllegalArgumentException("portgroupKey cannot be null or empty");
        }
        this._switchDiagramSpec = switchDiagramSpec;
        this._dvsUuid = dvsUuid;
        this._portgroupKey = portgroupKey;
    }

    public PortGroupModel buildPortgroupVmsModel() {
        int usedPorts;
        PortGroupModel portGroupModel = new PortGroupModel();
        this.initializeVmsMap();
        this.initializePortsMap();
        int vmsCount = !ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.vms) ? this._switchDiagramSpec.dvsSpec.vms.length : 0;
        portGroupModel.usedPorts = usedPorts = this.addVirtualMachines(portGroupModel, this._portgroupKey, this._switchDiagramSpec.nonUplinkPorts, vmsCount);
        return portGroupModel;
    }

    private void initializeVmsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.vms)) {
            for (SwitchDiagramVmSpec vmSpec : this._switchDiagramSpec.dvsSpec.vms) {
                if (StringUtil.isNullOrEmpty((String)vmSpec.name)) continue;
                this._vmMap.put(vmSpec.provider, vmSpec);
                Set<String> portgroupKeys = this.getAssignedDvPortgroupKeys(vmSpec);
                if (!portgroupKeys.contains(this._portgroupKey)) continue;
                this._portgroupVms.add(vmSpec);
            }
        }
    }

    private void initializePortsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.nonUplinkPorts)) {
            for (DistributedVirtualPort distributedVirtualPort : this._switchDiagramSpec.nonUplinkPorts) {
                if (distributedVirtualPort == null || StringUtil.isNullOrEmpty((String)distributedVirtualPort.key)) continue;
                this._portsMap.put(distributedVirtualPort.key, distributedVirtualPort);
            }
        }
    }

    private Set<String> getAssignedDvPortgroupKeys(SwitchDiagramVmSpec switchDiagramVmSpec) {
        HashSet<String> portgroups = new HashSet<String>();
        if (switchDiagramVmSpec != null && switchDiagramVmSpec.devices != null) {
            for (VirtualDevice virtualDevice : switchDiagramVmSpec.devices) {
                if (virtualDevice.backing == null || !(virtualDevice.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo backing = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)virtualDevice.backing;
                if (backing.port == null) continue;
                if (!StringUtil.isNullOrEmpty((String)backing.port.portgroupKey) && !portgroups.contains(backing.port.portgroupKey)) {
                    portgroups.add(backing.port.portgroupKey);
                    continue;
                }
                if (!StringUtil.isNullOrEmpty((String)backing.port.portgroupKey) || StringUtil.isNullOrEmpty((String)backing.port.portKey) || portgroups.contains("DistributedVirtualPortGroup-Standalone")) continue;
                portgroups.add("DistributedVirtualPortGroup-Standalone");
            }
        }
        return portgroups;
    }

    private int addVirtualMachines(PortGroupModel portGroupModel, String portgroupKey, DistributedVirtualPort[] ports, int vmsCount) {
        int vmnicsCount = 0;
        HashMap<ManagedObjectReference, List<PortModel>> vmToPortModelMap = new HashMap<ManagedObjectReference, List<PortModel>>();
        if (!ArrayUtil.isNullOrEmpty((Object[])ports)) {
            for (DistributedVirtualPort port : ports) {
                if (port.connectee == null || port.connectee.connectedEntity == null || !VirtualMachine.class.getSimpleName().equals(port.connectee.connectedEntity.getType())) continue;
                ManagedObjectReference connectedVm = port.connectee.connectedEntity;
                int connectedDevicesCount = 0;
                VirtualDevice device = null;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo backing = null;
                SwitchDiagramVmSpec vmSpec = this._vmMap.get(connectedVm);
                if (vmSpec != null) {
                    boolean isSecondaryVm;
                    boolean bl = isSecondaryVm = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
                    if (isSecondaryVm) continue;
                    if (!ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) {
                        for (VirtualDevice vd : vmSpec.devices) {
                            if (vd.backing == null || !(vd.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                            VirtualEthernetCard.DistributedVirtualPortBackingInfo deviceBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vd.backing;
                            if (!deviceBacking.port.switchUuid.equals(this._dvsUuid) || (!StringUtil.isNullOrEmpty((String)portgroupKey) || !StringUtil.isNullOrEmpty((String)deviceBacking.port.portgroupKey)) && !portgroupKey.equals(deviceBacking.port.portgroupKey)) continue;
                            ++connectedDevicesCount;
                            if (!Objects.equals(deviceBacking.port.portKey, port.key)) continue;
                            device = vd;
                            backing = deviceBacking;
                        }
                    }
                }
                if (connectedDevicesCount <= 0 || device == null) continue;
                PortModel portModel = new PortModel();
                portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
                portModel.title = this.getVmTitle(vmSpec);
                if (port.key != null) {
                    portModel.id = port.key;
                }
                if (vmSpec != null && vmSpec.connectionState != null && vmSpec.connectionState == VirtualMachine.ConnectionState.orphaned) {
                    portModel.isOrphanedVm = true;
                }
                portModel.vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
                portModel.powerState = vmSpec.powerState;
                portModel.portStatus = PortStatus.NA;
                if (connectedDevicesCount > 1) {
                    portModel.macAddress = SwitchDiagramUtil.getMacAddress(port, device);
                }
                portModel.portStatus = this.getPortConnectionStatus(port);
                portGroupModel.vmVnics.add(portModel);
                portModel.host = vmSpec.host;
                portModel.activeUplinkPorts = this.getActiveUplinkPorts(backing);
                this.mapVmToPortView(connectedVm, portModel, vmToPortModelMap);
                ++vmnicsCount;
            }
        }
        this.addUnboundVirtualMachines(portGroupModel, portgroupKey, vmToPortModelMap);
        this.processPortViewsMacAddress(vmToPortModelMap);
        portGroupModel.virtualMachinesCount = vmsCount > 0 ? vmsCount : vmToPortModelMap.size();
        return vmnicsCount;
    }

    private String getVmTitle(SwitchDiagramVmSpec vmSpec) {
        if (vmSpec == null) {
            return null;
        }
        boolean showSecondaryText = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
        String vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
        if (showSecondaryText) {
            vmName = vmName + NetworkStringUtil.getString("SwitchDiagram.secondaryText");
        }
        return vmName;
    }

    private void mapVmToPortView(ManagedObjectReference vm, PortModel portModel, Map<ManagedObjectReference, List<PortModel>> vmToPortView) {
        List<PortModel> vmPortModels = vmToPortView.get(vm);
        if (vmPortModels == null) {
            vmPortModels = new ArrayList<PortModel>();
            vmToPortView.put(vm, vmPortModels);
        }
        vmPortModels.add(portModel);
    }

    private void addUnboundVirtualMachines(PortGroupModel portGroupModel, String portGroupKey, Map<ManagedObjectReference, List<PortModel>> vmToPortViewMap) {
        if (StringUtil.isNullOrEmpty((String)portGroupKey)) {
            portGroupKey = "DistributedVirtualPortGroup-Standalone";
        }
        if (!this._portgroupVms.isEmpty()) {
            for (SwitchDiagramVmSpec switchDiagramVmSpec : this._portgroupVms) {
                boolean isSecondaryVm = switchDiagramVmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(switchDiagramVmSpec.ftInfo.role);
                if (isSecondaryVm || ArrayUtil.isNullOrEmpty((Object[])switchDiagramVmSpec.devices)) continue;
                for (VirtualDevice virtualDevice : switchDiagramVmSpec.devices) {
                    boolean isStandalone;
                    if (virtualDevice.backing == null || !(virtualDevice.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                    VirtualEthernetCard.DistributedVirtualPortBackingInfo backing = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)virtualDevice.backing;
                    boolean isConnectedToDvs = this._dvsUuid.equals(backing.port.switchUuid);
                    boolean isConnectedToDvPg = portGroupKey.equals(backing.port.portgroupKey);
                    boolean isEmptyPort = StringUtil.isNullOrEmpty((String)backing.port.portKey);
                    boolean bl = isStandalone = StringUtil.isNullOrEmpty((String)backing.port.portgroupKey) && "DistributedVirtualPortGroup-Standalone".equals(portGroupKey) && !isEmptyPort;
                    if (!isConnectedToDvs || !isConnectedToDvPg || !isEmptyPort) continue;
                    PortModel portModel = new PortModel();
                    portModel.title = this.getVmTitle(switchDiagramVmSpec);
                    portGroupModel.vmVnics.add(portModel);
                    portModel.id = UNBOUND_VM_KEY_PREFIX + switchDiagramVmSpec.provider + virtualDevice.key;
                    if (switchDiagramVmSpec.connectionState != null && switchDiagramVmSpec.connectionState == VirtualMachine.ConnectionState.orphaned) {
                        portModel.isOrphanedVm = true;
                    }
                    portModel.portStatus = PortStatus.NA;
                    portModel.vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)switchDiagramVmSpec.name);
                    portModel.powerState = switchDiagramVmSpec.powerState;
                    portModel.host = switchDiagramVmSpec.host;
                    portModel.activeUplinkPorts = this.getActiveUplinkPorts(backing);
                    this.mapVmToPortView(switchDiagramVmSpec.provider, portModel, vmToPortViewMap);
                }
            }
        }
    }

    private String[] getActiveUplinkPorts(VirtualEthernetCard.DistributedVirtualPortBackingInfo portBackingInfo) {
        DistributedVirtualPort dvPort;
        String[] result = null;
        if (portBackingInfo != null && portBackingInfo.port != null && !StringUtil.isNullOrEmpty((String)portBackingInfo.port.portKey) && (dvPort = this._portsMap.get(portBackingInfo.port.portKey)) != null && dvPort.config != null && dvPort.config.setting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy policy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPort.config.setting;
            if (policy.uplinkTeamingPolicy != null && policy.uplinkTeamingPolicy.uplinkPortOrder != null) {
                result = policy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort;
            }
        }
        return result;
    }

    private void processPortViewsMacAddress(Map<ManagedObjectReference, List<PortModel>> vmToPortModelMap) {
        for (Map.Entry<ManagedObjectReference, List<PortModel>> entry : vmToPortModelMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (PortModel portModel : entry.getValue()) {
                if (portModel.macAddress != null || portModel.virtualDevice == null) continue;
                portModel.macAddress = SwitchDiagramUtil.getMacAddress(null, portModel.virtualDevice);
            }
        }
    }
}

