/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram.util;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.VlanType;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramDvsSpec;
import java.util.Objects;

public final class SwitchDiagramUtil {
    private static final String EMPTY_MAC_ADDRESS = "00:00:00:00:00:00";
    private static final String EMPTY_STRING = "";

    public static String getIpInfo(VirtualNic virtualNic, boolean returnTextForDynamicSettings) {
        if (virtualNic == null) {
            return null;
        }
        String ipInfo = IpUtil.extractIpAddress(virtualNic);
        if (StringUtil.isNullOrEmpty((String)ipInfo) && returnTextForDynamicSettings) {
            boolean isDynamic = false;
            if (virtualNic.spec != null && virtualNic.spec.ip != null) {
                if (virtualNic.spec.ip.dhcp) {
                    isDynamic = true;
                } else if (virtualNic.spec.ip.ipV6Config != null) {
                    if (virtualNic.spec.ip.ipV6Config.autoConfigurationEnabled.booleanValue()) {
                        isDynamic = true;
                    } else if (virtualNic.spec.ip.ipV6Config.dhcpV6Enabled.booleanValue()) {
                        isDynamic = true;
                    }
                }
            }
            if (isDynamic) {
                ipInfo = NetworkStringUtil.getString("SwitchDiagram.obtainAutomatically");
            }
        }
        return ipInfo;
    }

    public static String getMacAddress(DistributedVirtualPort port, VirtualDevice device) {
        String macAddress = EMPTY_STRING;
        if (port != null && port.state != null && port.state.runtimeInfo != null && !StringUtil.isNullOrEmpty((String)port.state.runtimeInfo.macAddress) && !Objects.equals(port.state.runtimeInfo.macAddress, EMPTY_MAC_ADDRESS)) {
            macAddress = port.state.runtimeInfo.macAddress;
        } else if (device instanceof VirtualEthernetCard && !StringUtil.isNullOrEmpty((String)((VirtualEthernetCard)device).macAddress)) {
            macAddress = ((VirtualEthernetCard)device).macAddress;
        }
        return macAddress;
    }

    public static VlanType getVlanType(VmwareDistributedVirtualSwitch.VlanSpec vlan) {
        VlanType result = VlanType.NA;
        if (vlan != null) {
            result = VlanType.NONE;
            if (vlan instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
                result = ((VmwareDistributedVirtualSwitch.VlanIdSpec)vlan).vlanId > 0 ? VlanType.VLAN : VlanType.NONE;
            } else if (vlan instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
                result = VlanType.VLAN_TRUNKING;
            } else if (vlan instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
                result = VlanType.PVLAN;
            }
        }
        return result;
    }

    public static String[] getUplinkPolicyNames(SwitchDiagramDvsSpec switchDiagramDvsSpec) {
        String[] result = new String[]{};
        if (switchDiagramDvsSpec == null || switchDiagramDvsSpec.config == null) {
            return result;
        }
        if (switchDiagramDvsSpec.config.uplinkPortPolicy instanceof DistributedVirtualSwitch.NameArrayUplinkPortPolicy) {
            DistributedVirtualSwitch.NameArrayUplinkPortPolicy uplinkPortNames = (DistributedVirtualSwitch.NameArrayUplinkPortPolicy)switchDiagramDvsSpec.config.uplinkPortPolicy;
            if (!ArrayUtil.isNullOrEmpty((Object[])uplinkPortNames.uplinkPortName)) {
                result = uplinkPortNames.uplinkPortName;
            }
        }
        return result;
    }

    public static String getVlanString(VlanType vlanType) {
        String vlan = EMPTY_STRING;
        switch (vlanType) {
            case VLAN: 
            case NONE: {
                vlan = NetworkStringUtil.getString("SwitchDiagram.vlanIdText");
                break;
            }
            case VLAN_TRUNKING: {
                vlan = NetworkStringUtil.getString("SwitchDiagram.vlanTrunkRangeText");
                break;
            }
            case PVLAN: {
                vlan = NetworkStringUtil.getString("SwitchDiagram.privateVlanText");
                break;
            }
            case NA: {
                vlan = EMPTY_STRING;
            }
        }
        return vlan;
    }

    public static String getPvlanPortType(String pvlanPortType) {
        String result = EMPTY_STRING;
        if (Objects.equals(pvlanPortType, VmwareDistributedVirtualSwitch.PvlanPortType.promiscuous.name())) {
            result = NetworkStringUtil.getString("SwitchDiagram.pvlanPortType.promiscuous");
        } else if (Objects.equals(pvlanPortType, VmwareDistributedVirtualSwitch.PvlanPortType.isolated.name())) {
            result = NetworkStringUtil.getString("SwitchDiagram.pvlanPortType.isolated");
        } else if (Objects.equals(pvlanPortType, VmwareDistributedVirtualSwitch.PvlanPortType.community.name())) {
            result = NetworkStringUtil.getString("SwitchDiagram.pvlanPortType.community");
        }
        return result;
    }
}

