/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.vm.migrate;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.vm.migrate.MigrateVmNetworkingParser;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkingProperties;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.VmNetworkProperties;
import com.vmware.vsphere.client.h5.network.vm.migrate.specs.MigrateVmPropertySpec;
import com.vmware.vsphere.client.network.vm.api.spec.DisconnectedVmVnicsSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections4.map.HashedMap;

public class MigrateVmNetworkingPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private static final String DISCONNECTED_VMS_PROPERTY = "disconnectedVms";
    private static final String IS_PRIMARY_OR_NORMAL_VM_PROPERTY = "isNormalVMOrPrimaryFTVM";
    private static final String VM_NETWORK_PROPERTY = "network";
    private static final String HOST_NETWORK_PROPERTY = "network";
    private static final String VM_CONNECTION_STATE_PROPERTY = "runtime.connectionState";

    public MigrateVmNetworkingPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup", "Network", "OpaqueNetwork"}, propertyNamespace="migratevms", property="vmsNetworkProperties")
    public MigrateVmNetworkingProperties getVmsNetworkProperties(ManagedObjectReference destinationNetworkRef, MigrateVmPropertySpec spec) {
        MigrateVmNetworkingProperties properties = new MigrateVmNetworkingProperties();
        ManagedObjectReference sourceNetworkRef = spec.sourceNetworkRef;
        ArrayList<ManagedObjectReference> networkRefs = new ArrayList<ManagedObjectReference>();
        networkRefs.add(destinationNetworkRef);
        if (sourceNetworkRef != null) {
            networkRefs.add(sourceNetworkRef);
        }
        Collection vmNetworkDataModels = this._queryBindingService.prepare(MigrateVmNetworkData.class).fetch(networkRefs);
        VmNetworkProperties sourceNetworkData = null;
        for (MigrateVmNetworkData vmNetworkDataModel : vmNetworkDataModels) {
            VmNetworkProperties sourceVmNetwork;
            ManagedObjectReference networkRef = (ManagedObjectReference)vmNetworkDataModel.provider;
            if (networkRef.equals((Object)destinationNetworkRef)) {
                VmNetworkProperties destinationVmNetwork;
                properties.destinationNetwork = destinationVmNetwork = MigrateVmNetworkingParser.createVmNetworkData(vmNetworkDataModel);
                continue;
            }
            if (sourceNetworkRef == null || !networkRef.equals((Object)sourceNetworkRef)) continue;
            sourceNetworkData = sourceVmNetwork = MigrateVmNetworkingParser.createVmNetworkData(vmNetworkDataModel);
        }
        ResultSet hostResult = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("network", PropertyPredicate.ComparisonOperator.EQUAL, (Object)destinationNetworkRef)}).fetch();
        HashSet<String> hostUids = new HashSet<String>();
        for (ResourceItem item : hostResult.getItems()) {
            ManagedObjectReference hostRef = (ManagedObjectReference)item.getKey();
            hostUids.add(ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef));
        }
        ArrayList<MigrateVmNetworkingProperties.VmListItem> vmListItems = new ArrayList<MigrateVmNetworkingProperties.VmListItem>();
        Collection<MigrateVmData> vmDataModels = sourceNetworkRef != null ? this.getConnectedVmsData(sourceNetworkRef) : this.getDisconnectedVmsData(spec.datacenterRef);
        for (MigrateVmData vmDataModel : vmDataModels) {
            ArrayList<MigrateVmNetworkingProperties.VmListItem> vmItems = MigrateVmNetworkingParser.createVmListItems(vmDataModel, sourceNetworkRef, sourceNetworkData, hostUids);
            vmListItems.addAll(vmItems);
        }
        if (!vmListItems.isEmpty()) {
            MigrateVmNetworkingProperties.VmListItem allVmsItem = new MigrateVmNetworkingProperties.VmListItem();
            allVmsItem.name = NetworkStringUtil.getString("migrateVmNetworking.allVirtualMachines");
            allVmsItem.id = "1";
            vmListItems.add(0, allVmsItem);
        }
        properties.vmListItems = vmListItems.toArray(new MigrateVmNetworkingProperties.VmListItem[vmListItems.size()]);
        return properties;
    }

    private Collection<MigrateVmData> getConnectedVmsData(ManagedObjectReference sourceNetworkRef) {
        ResultSet vmResult = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("network", PropertyPredicate.ComparisonOperator.EQUAL, (Object)sourceNetworkRef), new PropertyPredicate(IS_PRIMARY_OR_NORMAL_VM_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true), new PropertyPredicate(VM_CONNECTION_STATE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)VirtualMachine.ConnectionState.connected)}).fetch();
        ArrayList<ManagedObjectReference> vmRefs = new ArrayList<ManagedObjectReference>();
        for (ResourceItem item : vmResult.getItems()) {
            vmRefs.add((ManagedObjectReference)item.getKey());
        }
        Collection vmDataModels = this._queryBindingService.prepare(MigrateVmData.class).fetch(vmRefs);
        return vmDataModels;
    }

    private Collection<MigrateVmData> getDisconnectedVmsData(ManagedObjectReference dcRef) {
        ResourceItem resultItem;
        DisconnectedVmVnicsSpec[] vmSpecs;
        ResultSet resultSet = this._queryService.select(new String[]{DISCONNECTED_VMS_PROPERTY}).from(new String[]{dcRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dcRef)}).fetch();
        HashedMap vmVnicsMap = new HashedMap();
        if (!resultSet.getItems().isEmpty() && (vmSpecs = (DisconnectedVmVnicsSpec[])(resultItem = (ResourceItem)resultSet.getItems().get(0)).get(DISCONNECTED_VMS_PROPERTY)) != null) {
            for (DisconnectedVmVnicsSpec vmSpec : vmSpecs) {
                if (ArrayUtil.isNullOrEmpty((Object[])vmSpec.vnics)) continue;
                vmVnicsMap.put(vmSpec.vmRef, vmSpec.vnics);
            }
        }
        Collection vmDataModels = this._queryBindingService.prepare(MigrateVmData.class).fetch(vmVnicsMap.keySet());
        for (MigrateVmData vmData : vmDataModels) {
            vmData.virtualDevices = (VirtualDevice[])vmVnicsMap.get(vmData.provider);
        }
        return vmDataModels;
    }
}

