/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vsphere.client.hostprofile.data.h5.ClusterHostProfileHostBaseData;
import com.vmware.vsphere.client.hostprofile.data.h5.model.H5HostComplianceData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;

@QueryBinding(value="HostSystem")
public class ClusterHostProfileHostData
extends ClusterHostProfileHostBaseData {
    @Property(value="HostSystem/remediationState")
    private transient HostSystem.RemediationState remediationState;
    @Property(value="HostSystem/complianceCheckState")
    private transient HostSystem.ComplianceCheckState complianceCheckState;
    @Property(value="HostSystem/answerFileValidationState")
    private transient AnswerFileStatusResult answerFileValidationState;

    @Override
    public boolean getCustomizationRequired() {
        return this.answerFileValidationState != null && ProfileManager.AnswerFileStatus.invalid.name().equals(this.answerFileValidationState.getStatus());
    }

    @Override
    public H5HostComplianceData getComplianceResult() {
        return HostProfileComplianceDataUtil.getHostProfileComplianceData(this.remediationState, this.complianceCheckState);
    }

    public boolean getIsHpRelatedOperationRunning() {
        return HostProfileComplianceDataUtil.getIsHpRelatedOperationRunning(this.remediationState, this.complianceCheckState);
    }

    public boolean getIsHostStateValid() {
        boolean isStatusRunning = this.getIsHpRelatedOperationRunning();
        boolean customizationRequired = this.getCustomizationRequired();
        boolean isHostConnected = this.isHostConnected();
        return isHostConnected && !customizationRequired && !isStatusRunning && this.getHostMor() != null;
    }

    private boolean isHostConnected() {
        return HostSystem.ConnectionState.connected == this.connectionState;
    }
}

