/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures;

import com.vmware.vsphere.client.hostprofile.data.ComplianceFailureValue;
import com.vmware.vsphere.client.hostprofile.data.ComplianceFailuresByCategory;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailureElement;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailureEntity;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailureGroup;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailuresFlatData;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.IdGenerator;
import java.util.ArrayList;
import java.util.List;

public class ComplianceFailureFactory {
    private final IdGenerator idGen = new IdGenerator();

    public List<ComplianceFailureEntity> getComplianceFailureEntities(ComplianceFailuresByCategory[] complianceFailuresByCategories) {
        ArrayList<ComplianceFailureEntity> failureGroupList = new ArrayList<ComplianceFailureEntity>();
        for (ComplianceFailuresByCategory currentCategory : complianceFailuresByCategories) {
            List<ComplianceFailureEntity> currentList = this.getComplianceFailureEntities(currentCategory);
            failureGroupList.addAll(currentList);
        }
        return failureGroupList;
    }

    public List<ComplianceFailuresFlatData> getFlatComplianceFailures(ComplianceFailuresByCategory[] complianceFailuresByCategories) {
        ArrayList<ComplianceFailuresFlatData> failureGroupList = new ArrayList<ComplianceFailuresFlatData>();
        for (ComplianceFailuresByCategory currentCategory : complianceFailuresByCategories) {
            List<ComplianceFailuresFlatData> currentList = this.getComplianceFlatFailureEntities(currentCategory);
            failureGroupList.addAll(currentList);
        }
        return failureGroupList;
    }

    private List<ComplianceFailuresFlatData> getComplianceFlatFailureEntities(ComplianceFailuresByCategory currentCategory) {
        ArrayList<ComplianceFailuresFlatData> currentList = new ArrayList<ComplianceFailuresFlatData>();
        String category = currentCategory.category;
        for (ComplianceFailureValue complianceFailure : currentCategory.complianceFailures) {
            ComplianceFailuresFlatData currentFailure = new ComplianceFailuresFlatData(category, complianceFailure.failureMessage, complianceFailure.hostValue, complianceFailure.parameterName, complianceFailure.profileInstance, complianceFailure.profileValue);
            currentList.add(currentFailure);
        }
        return currentList;
    }

    private List<ComplianceFailureEntity> getComplianceFailureEntities(ComplianceFailuresByCategory currentCategory) {
        ArrayList<ComplianceFailureEntity> currentList = new ArrayList<ComplianceFailureEntity>();
        ComplianceFailureGroup group = this.getComplianceFailureGroup(currentCategory);
        currentList.add(group);
        List<ComplianceFailureElement> failuresForCurrentCategory = this.createFailures(currentCategory);
        currentList.addAll(failuresForCurrentCategory);
        return currentList;
    }

    private ComplianceFailureGroup getComplianceFailureGroup(ComplianceFailuresByCategory currentCategory) {
        String categoryName = currentCategory.category;
        return new ComplianceFailureGroup(this.idGen.incrementAndGetId(), categoryName);
    }

    private List<ComplianceFailureElement> createFailures(ComplianceFailuresByCategory category) {
        int parentId = this.idGen.getCurrentId();
        ArrayList<ComplianceFailureElement> failures = new ArrayList<ComplianceFailureElement>();
        for (ComplianceFailureValue failureValue : category.complianceFailures) {
            int failureId = this.idGen.incrementAndGetId();
            ComplianceFailureElement currentElement = new ComplianceFailureElement(failureId, parentId, failureValue.parameterName, failureValue.hostValue, failureValue.profileValue, failureValue.failureMessage);
            failures.add(currentElement);
        }
        return failures;
    }
}

