/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.hostprofile.data.h5.model.HostProfileComplianceBaseData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;

@QueryBinding(value="HostSystem")
public class RemediateHostDataModel
extends HostProfileComplianceBaseData {
    @Property(value="HostSystem/name")
    public String hostName;
    @Property(value="HostSystem/primaryIconId")
    public String hostPrimaryIconId;
    @Property(value="HostSystem/answerFileValidationState")
    public AnswerFileStatusResult answerFileValidationState;
    @Property(value="HostSystem/answerFileValidationStateCheck")
    public boolean answerFileValidationStateCheck;
    @Property(value="HostSystem/runtime/connectionState")
    public HostSystem.ConnectionState connectionState;
    @Property(value="HostSystem/hp")
    public ManagedObjectReference hp;
    @Property(value="HostSystem/precheckRemediationResult")
    public ProfileManager.ApplyHostConfigSpec precheckRemediationResult;
    @Property(value="HostSystem/cluster")
    public ManagedObjectReference clusterRef;
    @Relationship(value={"HostSystem/cluster"})
    @Property(value="ClusterComputeResource/name")
    public String clusterName;

    public boolean getCustomizationRequired() {
        ManagedObjectReference ref = this.getHostMor();
        if (VcServiceUtil.is66VcOrLaterByServerGuid((String)ref.getServerGuid())) {
            return this.answerFileValidationState != null && HostProfileComplianceDataUtil.getAreHostCustomizationsRequired(this.answerFileValidationState.getStatus());
        }
        return this.answerFileValidationStateCheck;
    }

    public boolean getIsHostStateValid() {
        boolean isStatusRunning = this.getIsHpRelatedOperationRunning();
        boolean customizationRequired = this.getCustomizationRequired();
        boolean isHostConnected = this.isHostConnected();
        return HostProfileComplianceDataUtil.getIsHostStateValid(isStatusRunning, customizationRequired, isHostConnected, this.hp);
    }

    public boolean getIsHpRelatedOperationRunning() {
        ManagedObjectReference ref = this.getHostMor();
        return VcServiceUtil.is66VcOrLaterByServerGuid((String)ref.getServerGuid()) && HostProfileComplianceDataUtil.getIsHpRelatedOperationRunning(this.remediationState, this.complianceCheckState);
    }

    private boolean isHostConnected() {
        return HostProfileComplianceDataUtil.isHostConnected(this.connectionState);
    }
}

