/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.h5.HostProfileData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class H5HostProfilePropertyProvider {
    private final QueryService _queryService;

    public H5HostProfilePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ClusterComputeResource/rootFolderHostProfiles")
    public List<HostProfileData[]> getRootFolderHostProfiles(Collection<ManagedObjectReference> entities) throws Exception {
        if (CollectionUtil.isNullOrEmpty(entities) || entities.size() > 1) {
            throw new IllegalArgumentException("Supply a single entity!");
        }
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", "name", "config.annotation"}).from(new String[]{HostProfile.class.getSimpleName()}).where("serverGuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)entities.iterator().next().getServerGuid()).fetch();
        List res = resultSet.getItems();
        HostProfileData[] hostProfileData = new HostProfileData[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            HostProfileData currentHostProfileData = new HostProfileData();
            currentHostProfileData.provider = ((ResourceItem)res.get(i)).get("@modelKey");
            currentHostProfileData.name = (String)((ResourceItem)res.get(i)).get("name");
            currentHostProfileData.description = (String)((ResourceItem)res.get(i)).get("config.annotation");
            hostProfileData[i] = currentHostProfileData;
        }
        return Collections.singletonList(hostProfileData);
    }

    @PropertyProvider(value="HostSystem/answerFileValidationStateCheck")
    public boolean getAnswerFileValidationStateCheck(ManagedObjectReference object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("Illegal input host managed object reference");
        }
        ProfileManager profileManager = HostProfileUtils.getProfileManager(object.getServerGuid());
        AnswerFileStatusResult[] answerFileStatusResults = profileManager.queryAnswerFileStatus(new ManagedObjectReference[]{object});
        if (answerFileStatusResults == null || answerFileStatusResults.length == 0) {
            return false;
        }
        return ProfileManager.AnswerFileStatus.invalid.name().equals(answerFileStatusResults[0].status);
    }
}

