/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.PasswordField;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationSetting;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCustomizationsSettingsService {
    private static final Log logger = LogFactory.getLog(HostCustomizationsSettingsService.class);

    List<HostCustomizationSetting> createHostCustomizationSettingsData(PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMapBeforeImport, Map<ManagedObjectReference, String> hostEntityNameMap) {
        ArrayList<HostCustomizationSetting> resultList = new ArrayList<HostCustomizationSetting>();
        if (hostEntityNameMap == null || userInputMap == null || policiesMetadata == null || relevantProfilePaths == null) {
            return resultList;
        }
        if (userInputMapBeforeImport == null) {
            userInputMapBeforeImport = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        }
        for (ManagedObjectReference host : hostEntityNameMap.keySet()) {
            List<HostCustomizationSetting> settings;
            DeferredPolicyOptionParameter[] deferredParameters = userInputMap.get(host);
            DeferredPolicyOptionParameter[] deferredParametersBeforeImport = userInputMapBeforeImport.get(host);
            String hostName = hostEntityNameMap.get(host);
            if (deferredParameters != null) {
                settings = this.createHostCustomizationSettings(host, hostName, policiesMetadata, relevantProfilePaths, deferredParameters, deferredParametersBeforeImport);
                resultList.addAll(settings);
                continue;
            }
            if (userInputMapBeforeImport != null) {
                logger.warn((Object)("Can not extract imported deferred host settings on " + hostName));
                settings = this.createHostCustomizationSettings(host, hostName, policiesMetadata, relevantProfilePaths, deferredParametersBeforeImport, null);
                resultList.addAll(settings);
                continue;
            }
            logger.warn((Object)("Host customizations are null for host: " + hostName));
        }
        return resultList;
    }

    DeferredPolicyOptionParameter[] createDeferredPolicyOptionParameter(HostCustomizationSetting[] rowsData, String hostName) {
        if (rowsData == null) {
            return null;
        }
        HashMap inputPathParams = new HashMap();
        HashMap<String, ProfilePropertyPath> profilePropertyPathMap = new HashMap<String, ProfilePropertyPath>();
        for (HostCustomizationSetting setting : rowsData) {
            if (hostName == null || !hostName.equals(setting.hostName)) continue;
            Object parameterValue = HostProfileUtils.convertResourceFWTypeValue(setting.valueType, setting.value);
            setting.parameter.setValue(parameterValue);
            String key = this.buildProfilePropertyPathKey(setting.inputPath);
            if (!inputPathParams.containsKey(key)) {
                ArrayList<KeyAnyValue> currentInputPathParameters = new ArrayList<KeyAnyValue>();
                currentInputPathParameters.add(setting.parameter);
                inputPathParams.put(key, currentInputPathParameters);
                profilePropertyPathMap.put(key, setting.inputPath);
                continue;
            }
            ((List)inputPathParams.get(key)).add(setting.parameter);
        }
        ArrayList<DeferredPolicyOptionParameter> result = new ArrayList<DeferredPolicyOptionParameter>();
        for (String profilePropertyPathKey : inputPathParams.keySet()) {
            ProfilePropertyPath path = (ProfilePropertyPath)profilePropertyPathMap.get(profilePropertyPathKey);
            List keyAnyValuesList = (List)inputPathParams.get(profilePropertyPathKey);
            KeyAnyValue[] keyAnyValues = keyAnyValuesList.toArray(new KeyAnyValue[keyAnyValuesList.size()]);
            DeferredPolicyOptionParameter settingDeferredParam = new DeferredPolicyOptionParameter(path, keyAnyValues);
            result.add(settingDeferredParam);
        }
        return result.isEmpty() ? null : result.toArray(new DeferredPolicyOptionParameter[result.size()]);
    }

    private String buildProfilePropertyPathKey(ProfilePropertyPath inputPath) {
        return String.format("%s.%s.%s", inputPath.getProfilePath(), inputPath.getPolicyId(), inputPath.getParameterId());
    }

    private List<HostCustomizationSetting> createHostCustomizationSettings(ManagedObjectReference host, String hostName, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] deferredParameters, DeferredPolicyOptionParameter[] deferredParametersBeforeImport) {
        ArrayList<HostCustomizationSetting> resultList = new ArrayList<HostCustomizationSetting>();
        if (deferredParameters == null || deferredParameters.length == 0) {
            return resultList;
        }
        Map<String, Map<String, Object>> deferredParametersBeforeImportSearchMap = this.createDeferredParametersSearchMap(deferredParametersBeforeImport);
        for (DeferredPolicyOptionParameter param : deferredParameters) {
            String relevantProfilePath;
            PolicyMetadata metadata = HostCustomizationsUtil.getPolicyMetadata(policiesMetadata, param);
            if (metadata == null || (relevantProfilePath = HostCustomizationsUtil.extractRelevantPath(relevantProfilePaths, param.getInputPath().profilePath)) == null) continue;
            PolicyMetadata localizedPolicyMetadata = HostProfileUtils.getLocalizedPolicyMetadata(metadata);
            relevantProfilePath = String.format("%s > %s", relevantProfilePath, localizedPolicyMetadata.id.label);
            Map<String, Object> profilePathDeferredParametersByKeyBeforeImport = deferredParametersBeforeImportSearchMap.get(param.getInputPath().profilePath);
            for (KeyAnyValue keyValue : param.parameter) {
                ParameterMetadata userInputParameter = HostCustomizationsUtil.getParameterMetadata(metadata.possibleOption, keyValue.getKey());
                if (userInputParameter == null) continue;
                boolean isValueUpdated = false;
                if (deferredParametersBeforeImport != null) {
                    Object parameterValueBeforeImport = null;
                    if (profilePathDeferredParametersByKeyBeforeImport != null) {
                        parameterValueBeforeImport = profilePathDeferredParametersByKeyBeforeImport.get(keyValue.getKey());
                    }
                    isValueUpdated = this.isDeferredParameterValueUpdated(parameterValueBeforeImport, this.getKeyValue(keyValue));
                }
                HostCustomizationSetting setting = this.createHostCustomizationSettings(userInputParameter, keyValue, host, hostName, relevantProfilePath, param.inputPath, isValueUpdated);
                resultList.add(setting);
            }
        }
        return resultList;
    }

    private HostCustomizationSetting createHostCustomizationSettings(ParameterMetadata userInputParameter, KeyAnyValue keyValue, ManagedObjectReference host, String hostName, String relevantProfilePath, ProfilePropertyPath inputPath, boolean isValueUpdated) {
        HostCustomizationSetting setting = new HostCustomizationSetting();
        ParameterMetadata localizedParameterMetadata = HostProfileUtils.getLocalizedParameterMetadata(userInputParameter);
        Boolean isRequired = !userInputParameter.isOptional();
        String requiredColumnValue = userInputParameter.isOptional() ? HostProfileUtils.getLocalizedString("deferredSettings.column.valueNotRequired") : HostProfileUtils.getLocalizedString("deferredSettings.column.valueRequired");
        setting.value = this.getKeyValue(keyValue);
        setting.valueType = HostProfileUtils.getResourceFWType(userInputParameter.getType().getName(), keyValue.getValue());
        setting.name = (isValueUpdated ? "* " : "") + localizedParameterMetadata.id.label;
        setting.description = relevantProfilePath;
        setting.hostMor = host;
        setting.hostName = hostName;
        setting.requiredValue = requiredColumnValue;
        setting.isRequired = isRequired;
        setting.inputPath = this.buildFullInputPath(inputPath, keyValue);
        setting.parameter = keyValue;
        return setting;
    }

    private ProfilePropertyPath buildFullInputPath(ProfilePropertyPath inputPath, KeyAnyValue parameter) {
        ProfilePropertyPath fullInputPath = new ProfilePropertyPath();
        fullInputPath.policyId = inputPath.policyId;
        fullInputPath.profilePath = inputPath.profilePath;
        fullInputPath.parameterId = parameter.getKey();
        return fullInputPath;
    }

    private String getKeyValue(KeyAnyValue keyValue) {
        Object returnValue = keyValue.getValue();
        if (returnValue instanceof PasswordField) {
            returnValue = ((PasswordField)returnValue).getValue();
        }
        return returnValue == null ? null : returnValue.toString();
    }

    private boolean isDeferredParameterValueUpdated(Object oldValue, Object newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    private Map<String, Map<String, Object>> createDeferredParametersSearchMap(DeferredPolicyOptionParameter[] deferredSettings) {
        HashMap<String, Map<String, Object>> deferredParameters = new HashMap<String, Map<String, Object>>();
        if (deferredSettings == null || deferredSettings.length == 0) {
            return deferredParameters;
        }
        for (DeferredPolicyOptionParameter param : deferredSettings) {
            String profilePath = param.getInputPath().profilePath;
            HashMap<String, String> parameterValuesByKey = (HashMap<String, String>)deferredParameters.get(profilePath);
            if (parameterValuesByKey == null) {
                parameterValuesByKey = new HashMap<String, String>();
                deferredParameters.put(profilePath, parameterValuesByKey);
            }
            for (KeyAnyValue keyValue : param.parameter) {
                parameterValuesByKey.put(keyValue.getKey(), this.getKeyValue(keyValue));
            }
        }
        return deferredParameters;
    }
}

