/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.hostprofile.data.h5.model.H5HostComplianceData;
import java.util.Calendar;

public class HostProfileComplianceDataUtil {
    private static final String REMEDIATION_STATE_READY = HostSystem.RemediationState.State.remediationReady.name();

    public static boolean getIsHpRelatedOperationRunning(HostSystem.RemediationState remediationState, HostSystem.ComplianceCheckState complianceCheckState) {
        boolean isComplianceCheckRunning = complianceCheckState != null && ComplianceResult.Status.running.name().equals(complianceCheckState.getState());
        boolean isPrecheckRunning = remediationState != null && HostSystem.RemediationState.State.precheckRemediationRunning.name().equals(remediationState.getState());
        boolean isRemediationRunning = remediationState != null && HostSystem.RemediationState.State.remediationRunning.name().equals(remediationState.getState());
        return isComplianceCheckRunning || isPrecheckRunning || isRemediationRunning;
    }

    public static H5HostComplianceData getHostProfileComplianceData(HostSystem.RemediationState remediationState, HostSystem.ComplianceCheckState complianceCheckState) {
        String complianceStatusToSet = null;
        Calendar checkTimeToSet = null;
        if (remediationState != null) {
            String currentRemediationState = HostProfileComplianceDataUtil.getRemediationState(remediationState);
            Calendar currentRemediationCheckTime = HostProfileComplianceDataUtil.getRemediationStateOperationTime(remediationState);
            long currentRemediationCheckTimeInMillis = HostProfileComplianceDataUtil.getRemediationOperationTimeInMillis(remediationState);
            if (complianceCheckState != null) {
                boolean isRemedationCheckTimeLessThanComplianceCheckTime;
                String currentComplianceCheckState = HostProfileComplianceDataUtil.getComplianceCheckState(complianceCheckState);
                Calendar currentComplianceCheckStateTime = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTime(complianceCheckState);
                long currentComplianceCheckStateTimeInMillis = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTimeInMillis(complianceCheckState);
                boolean isRemediationReady = REMEDIATION_STATE_READY.equals(currentRemediationState);
                boolean bl = isRemedationCheckTimeLessThanComplianceCheckTime = currentRemediationCheckTimeInMillis < currentComplianceCheckStateTimeInMillis;
                if (isRemediationReady || isRemedationCheckTimeLessThanComplianceCheckTime) {
                    complianceStatusToSet = currentComplianceCheckState;
                    checkTimeToSet = currentComplianceCheckStateTime;
                } else {
                    complianceStatusToSet = currentRemediationState;
                    checkTimeToSet = currentRemediationCheckTime;
                }
            } else if (!REMEDIATION_STATE_READY.equals(currentRemediationState)) {
                complianceStatusToSet = currentRemediationState;
                checkTimeToSet = currentRemediationCheckTime;
            }
        } else if (complianceCheckState != null) {
            complianceStatusToSet = HostProfileComplianceDataUtil.getComplianceCheckState(complianceCheckState);
            checkTimeToSet = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTime(complianceCheckState);
        }
        H5HostComplianceData hostComplianceData = new H5HostComplianceData(complianceStatusToSet, checkTimeToSet);
        return hostComplianceData;
    }

    public static boolean isHostConnected(HostSystem.ConnectionState connectionState) {
        return HostSystem.ConnectionState.connected == connectionState;
    }

    public static boolean getAreHostCustomizationsRequired(String answerFileValidationStatus) {
        return ProfileManager.AnswerFileStatus.invalid.name().equals(answerFileValidationStatus);
    }

    public static boolean getIsHostStateValid(boolean isStatusRunning, boolean customizationRequired, boolean isHostConnected, ManagedObjectReference hp) {
        return isHostConnected && !customizationRequired && !isStatusRunning && hp != null;
    }

    private static String getRemediationState(HostSystem.RemediationState remediationState) {
        return remediationState.getState();
    }

    private static Calendar getRemediationStateOperationTime(HostSystem.RemediationState remediationState) {
        return remediationState.getOperationTime();
    }

    private static long getRemediationOperationTimeInMillis(HostSystem.RemediationState remediationState) {
        return remediationState.getOperationTime().getTimeInMillis();
    }

    private static String getComplianceCheckState(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getState();
    }

    private static Calendar getComplianceCheckStateCheckTime(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getCheckTime();
    }

    private static long getComplianceCheckStateCheckTimeInMillis(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getCheckTime().getTimeInMillis();
    }
}

