/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRRuntimeException;
import com.vmware.vim.zeppelin.cr.fs.impl.Permission;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRIOException;
import com.vmware.vim.zeppelin.cr.fs.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;

class AuthUtils {
    AuthUtils() {
    }

    static String aclsToString(Collection<CRAccessControl> acls) {
        if (acls == null) {
            return "";
        }
        EnumMap<Permission, Grantees> privileges = new EnumMap<Permission, Grantees>(Permission.class);
        for (CRAccessControl acl : acls) {
            CRUser user;
            Permission permission = Permission.parsePermission(acl.getPermission());
            Grantees grantees = (Grantees)privileges.get((Object)permission);
            if (grantees == null) {
                grantees = new Grantees();
                privileges.put(permission, grantees);
            }
            Set granteeSet = (user = acl.getUser()).isGroup() ? grantees.groups : grantees.users;
            granteeSet.add(user.getName());
        }
        StringBuilder sb = new StringBuilder(100);
        for (Permission permission : Permission.values()) {
            String sGroups;
            Grantees grantees = (Grantees)privileges.get((Object)permission);
            if (grantees == null || grantees.users.isEmpty() && grantees.groups.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("\u0001");
            }
            sb.append(permission.getShortDescription()).append("\u0002");
            String sUsers = StringUtils.toString(grantees.users, "\u0003");
            if (!StringUtils.isBlank(sUsers)) {
                sb.append(sUsers);
            }
            if (StringUtils.isBlank(sGroups = StringUtils.toString(grantees.groups, "\u0003"))) continue;
            sb.append("\u0002").append(sGroups);
        }
        return sb.toString();
    }

    private static void namesToACLs(Permission permission, String str, boolean isGroup, Set<CRAccessControl> acls) {
        String[] names;
        for (String name : names = str.split("\u0003")) {
            if (StringUtils.isBlank(name)) continue;
            CRUser user = new CRUser(name, isGroup);
            CRAccessControl ac = new CRAccessControl(user, permission.getIntValue());
            acls.add(ac);
        }
    }

    static Set<CRAccessControl> stringToACLs(String str) {
        if (StringUtils.isBlank(str)) {
            return Collections.emptySet();
        }
        try {
            String[] strPerms;
            HashSet<CRAccessControl> acls = new HashSet<CRAccessControl>();
            for (String strPerm : strPerms = str.split("\u0001")) {
                if (StringUtils.isBlank(strPerm)) continue;
                String[] permComponents = strPerm.split("\u0002");
                if (permComponents.length < 2) {
                    throw new CRRuntimeException("Invalid permissions. At least a permission descriptor and users should be specified [" + strPerm + "]");
                }
                String permDescriptor = permComponents[0];
                Permission permission = Permission.parsePermission(permDescriptor);
                String sUsers = permComponents[1];
                String sGroups = null;
                if (permComponents.length > 2) {
                    sGroups = permComponents[2];
                }
                if (!StringUtils.isBlank(sUsers)) {
                    AuthUtils.namesToACLs(permission, sUsers, false, acls);
                }
                if (StringUtils.isBlank(sGroups)) continue;
                AuthUtils.namesToACLs(permission, sGroups, true, acls);
            }
            return acls;
        }
        catch (Exception e) {
            throw new CRIOException("Failed to extract the file's privileges: " + str + " (" + StringUtils.toCharacterCodes(str) + ")", e);
        }
    }

    private static void appendHumanReadableStringFor(CRAccessControl acl, StringBuilder sb) {
        if (acl == null) {
            sb.append("[null]");
        } else {
            CRUser user = acl.getUser();
            sb.append("[ACL: user: ").append(user.getName()).append(", group: ").append(user.isGroup()).append(", permission: ").append(Permission.parsePermission(acl.getPermission()).getDescription()).append(']');
        }
    }

    public static String getHumanReadableStringFor(CRAccessControl acl) {
        StringBuilder sb = new StringBuilder();
        AuthUtils.appendHumanReadableStringFor(acl, sb);
        return sb.toString();
    }

    public static String getHumanReadableStringFor(Collection<CRAccessControl> acls) {
        if (acls == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1000);
        for (CRAccessControl acl : acls) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            AuthUtils.appendHumanReadableStringFor(acl, sb);
        }
        return sb.toString();
    }

    public static String getSortedHumanReadableStringFor(Set<CRAccessControl> acls) {
        if (acls == null) {
            return null;
        }
        Comparator<CRAccessControl> comp = new Comparator<CRAccessControl>(){

            @Override
            public int compare(CRAccessControl acl1, CRAccessControl acl2) {
                if (acl1 == null) {
                    return -1;
                }
                if (acl2 == null) {
                    return 1;
                }
                int c = acl1.getUser().getName().compareTo(acl2.getUser().getName());
                if (c != 0) {
                    return c;
                }
                c = Boolean.valueOf(acl1.getUser().isGroup()).compareTo(acl2.getUser().isGroup());
                if (c != 0) {
                    return c;
                }
                return Integer.valueOf(acl1.getPermission()).compareTo(acl2.getPermission());
            }
        };
        ArrayList<CRAccessControl> listACLs = new ArrayList<CRAccessControl>(acls);
        Collections.sort(listACLs, comp);
        return AuthUtils.getHumanReadableStringFor(listACLs);
    }

    private static class Grantees {
        private final Set<String> users = new HashSet<String>();
        private final Set<String> groups = new HashSet<String>();

        private Grantees() {
        }
    }
}

