/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.PermissionDefinitions;
import com.vmware.cis.authz.PermissionSyncProvider;
import com.vmware.cis.authz.PermissionTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class PermissionSyncApiInterface
extends ApiInterfaceSkeleton {
    private PermissionSyncProvider impl;

    public PermissionSyncApiInterface() {
        this((Class<? extends PermissionSyncProvider>)null);
    }

    public PermissionSyncApiInterface(Class<? extends PermissionSyncProvider> clazz) {
        this((PermissionSyncProvider)PermissionSyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.PermissionImpl", PermissionSyncProvider.class));
    }

    public PermissionSyncApiInterface(PermissionSyncProvider permissionSyncProvider) {
        super("com.vmware.cis.authz.permission");
        Validate.notNull((Object)permissionSyncProvider);
        this.impl = permissionSyncProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new QueryApiMethod());
        this.registerMethod((ApiMethod)new ListDetailApiMethod());
        this.registerMethod((ApiMethod)new QueryDetailApiMethod());
    }

    private class QueryDetailApiMethod
    extends ApiMethodSkeleton {
        public QueryDetailApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "query_detail", PermissionDefinitions.__queryDetailInput, PermissionDefinitions.__queryDetailOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__queryDetailInput, PermissionSyncApiInterface.this.getTypeConverter());
            PermissionTypes.QuerySpec querySpec = (PermissionTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi(PermissionSyncApiInterface.this.impl.queryDetail(querySpec, invocationContext), PermissionDefinitions.__queryDetailOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListDetailApiMethod
    extends ApiMethodSkeleton {
        public ListDetailApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "list_detail", PermissionDefinitions.__listDetailInput, PermissionDefinitions.__listDetailOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi(PermissionSyncApiInterface.this.impl.listDetail(invocationContext), PermissionDefinitions.__listDetailOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class QueryApiMethod
    extends ApiMethodSkeleton {
        public QueryApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "query", PermissionDefinitions.__queryInput, PermissionDefinitions.__queryOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__queryInput, PermissionSyncApiInterface.this.getTypeConverter());
            PermissionTypes.QuerySpec querySpec = (PermissionTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi(PermissionSyncApiInterface.this.impl.query(querySpec, invocationContext), PermissionDefinitions.__queryOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "list", PermissionDefinitions.__listInput, PermissionDefinitions.__listOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi(PermissionSyncApiInterface.this.impl.list(invocationContext), PermissionDefinitions.__listOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "delete", PermissionDefinitions.__deleteInput, PermissionDefinitions.__deleteOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__deleteInput, PermissionSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                PermissionSyncApiInterface.this.impl.delete(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "update", PermissionDefinitions.__updateInput, PermissionDefinitions.__updateOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__updateInput, PermissionSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PermissionTypes.UpdateSpec updateSpec = (PermissionTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            try {
                PermissionSyncApiInterface.this.impl.update(string, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "get", PermissionDefinitions.__getInput, PermissionDefinitions.__getOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__getInput, PermissionSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)PermissionSyncApiInterface.this.impl.get(string, invocationContext), PermissionDefinitions.__getOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(PermissionSyncApiInterface.this.getIdentifier(), "create", PermissionDefinitions.__createInput, PermissionDefinitions.__createOutput, PermissionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__createInput, PermissionSyncApiInterface.this.getTypeConverter());
            PermissionTypes.CreateSpec createSpec = (PermissionTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PermissionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)PermissionSyncApiInterface.this.impl.create(createSpec, invocationContext), PermissionDefinitions.__createOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

